/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalSliderUI
extends BasicSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super(null);
    }

    public void installUI(JComponent jComponent) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = (Integer)UIManager.get("Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(jComponent);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        Object object = jComponent.getClientProperty("JSlider.isFilled");
        if (object != null) {
            this.filledSlider = (Boolean)object;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new MetalPropertyListener();
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        } else {
            vertThumbIcon.paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void paintTrack(Graphics graphics) {
        ColorUIResource colorUIResource = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean bl = MetalUtils.isLeftToRight(this.slider);
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n2 = n4 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
        } else {
            if (bl) {
                n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n = this.getThumbOverhang();
                n3 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n4 = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(n, n2, n3 - n - 1, n4 - n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n + 1, n4, n3, n4);
            graphics.drawLine(n3, n2 + 1, n3, n4);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(n + 1, n2 + 1, n3 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 2);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(n, n2, n3 - n - 1, n4 - n2 - 1);
        }
        if (this.filledSlider) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (this.slider.getOrientation() == 0) {
                n5 = this.thumbRect.x + this.thumbRect.width / 2;
                n5 -= this.trackRect.x;
                n6 = !this.slider.isEnabled() ? n2 : n2 + 1;
                int n10 = n8 = !this.slider.isEnabled() ? n4 - 1 : n4 - 2;
                if (!this.drawInverted()) {
                    n7 = !this.slider.isEnabled() ? n : n + 1;
                    n9 = n5;
                } else {
                    n7 = n5;
                    n9 = !this.slider.isEnabled() ? n3 - 1 : n3 - 2;
                }
            } else {
                n5 = this.thumbRect.y + this.thumbRect.height / 2;
                n5 -= this.trackRect.y;
                n7 = !this.slider.isEnabled() ? n : n + 1;
                int n11 = n9 = !this.slider.isEnabled() ? n3 - 1 : n3 - 2;
                if (!this.drawInverted()) {
                    n6 = n5;
                    n8 = !this.slider.isEnabled() ? n4 - 1 : n4 - 2;
                } else {
                    n6 = !this.slider.isEnabled() ? n2 : n2 + 1;
                    n8 = n5;
                }
            }
            if (this.slider.isEnabled()) {
                graphics.setColor(this.slider.getBackground());
                graphics.drawLine(n7, n6, n9, n6);
                graphics.drawLine(n7, n6, n7, n8);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n7 + 1, n6 + 1, n9 - n7, n8 - n6);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n7, n6, n9 - n7, n4 - n2);
            }
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    public void paintFocus(Graphics graphics) {
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = 16;
            dimension.height = 15;
        } else {
            dimension.width = 15;
            dimension.height = 16;
        }
        return dimension;
    }

    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? tickLength + 4 + 1 : tickLength + 4 + 3;
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return 5;
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByUnit(n);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + (tickLength - 1));
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + tickLength / 2, n);
        } else {
            graphics.drawLine(0, n, tickLength / 2, n);
        }
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + tickLength, n);
        } else {
            graphics.drawLine(0, n, tickLength, n);
        }
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
            super(MetalSliderUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("JSlider.isFilled")) {
                MetalSliderUI.this.filledSlider = propertyChangeEvent.getNewValue() != null ? (Boolean)propertyChangeEvent.getNewValue() : false;
            }
        }
    }
}

