/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    int buttonsWidth = 0;
    MetalBumps activeBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl());
    MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
    MetalBumps paletteBumps;

    public MetalInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.font"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
    }

    protected void createButtons() {
        super.createButtons();
        Boolean bl = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.putClientProperty("paintActive", bl);
        this.iconButton.setBorder(handyEmptyBorder);
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.putClientProperty("paintActive", bl);
        this.maxButton.setBorder(handyEmptyBorder);
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.putClientProperty("paintActive", bl);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new MetalTitlePaneLayout();
    }

    private JInternalFrame getFrame() {
        return this.frame;
    }

    private JButton getIconButton() {
        return this.iconButton;
    }

    private JButton getCloseButton() {
        return this.closeButton;
    }

    private JButton getMaxButton() {
        return this.maxButton;
    }

    public void paintPalette(Graphics graphics) {
        boolean bl = MetalUtils.isLeftToRight(this.frame);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        int n3 = bl ? 4 : this.buttonsWidth + 4;
        int n4 = n - this.buttonsWidth - 8;
        int n5 = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(n4, n5);
        this.paletteBumps.paintIcon(this, graphics, n3, 2);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        MetalBumps metalBumps;
        ColorUIResource colorUIResource;
        ColorUIResource colorUIResource2;
        ColorUIResource colorUIResource3;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = MetalUtils.isLeftToRight(this.frame);
        boolean bl2 = this.frame.isSelected();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (bl2) {
            colorUIResource3 = MetalLookAndFeel.getWindowTitleBackground();
            colorUIResource2 = MetalLookAndFeel.getWindowTitleForeground();
            colorUIResource = MetalLookAndFeel.getPrimaryControlDarkShadow();
            metalBumps = this.activeBumps;
        } else {
            colorUIResource3 = MetalLookAndFeel.getWindowTitleInactiveBackground();
            colorUIResource2 = MetalLookAndFeel.getWindowTitleInactiveForeground();
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            metalBumps = this.inactiveBumps;
        }
        graphics.setColor(colorUIResource3);
        graphics.fillRect(0, 0, n5, n6);
        graphics.setColor(colorUIResource);
        graphics.drawLine(0, n6 - 1, n5, n6 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n5 - 1, 0, n5 - 1, 0);
        int n7 = 0;
        int n8 = bl ? 5 : n5 - 5;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl) {
                n8 -= icon.getIconWidth();
            }
            n4 = n6 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n8, n4);
            n8 += bl ? icon.getIconWidth() + 5 : -5;
        }
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n3 = fontMetrics.getHeight();
            n7 = fontMetrics.stringWidth(string);
            graphics.setColor(colorUIResource2);
            n2 = (n6 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            if (!bl) {
                n8 -= n7;
            }
            String string2 = "...";
            int n9 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            Rectangle rectangle = graphics.getClip().getBounds();
            int n10 = this.getWidth();
            int n11 = n7;
            n10 -= bl ? this.buttonsWidth + 5 : -(this.buttonsWidth + 5);
            if (bl) {
                if (n10 > n8 + 5) {
                    n10 -= 5;
                }
                if (n10 < n8) {
                    n10 = n8;
                }
            } else {
                if (n10 < n8 - 5) {
                    n10 += 5;
                }
                if (n10 > n8) {
                    n10 = n8;
                }
            }
            int n12 = n10;
            if ((n12 -= bl ? n8 : -n8) <= n8 && string.length() > 0) {
                string = string2;
                n11 = n9;
            } else if (n11 > n12) {
                String string3 = bl ? string.concat(string2) : string2.concat(string);
                int n13 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                int n14 = (int)((float)n12 / (float)n13 * (float)string3.length() + 1.0f);
                while (n13 > n12 && !string3.equals(string2)) {
                    string3 = string.substring(0, --n14 - string2.length());
                    string3 = bl ? string3.concat(string2) : string2.concat(string3);
                    n13 = SwingUtilities.computeStringWidth(fontMetrics, string3);
                }
                string = string3;
                graphics.setClip(rectangle.x, rectangle.y, n10, rectangle.height);
            }
            graphics.drawString(string, n8, n2);
            if (n11 > n12 && n12 > n8) {
                graphics.setClip(rectangle);
            }
            n8 += bl ? n7 + 5 : -5;
        }
        if (bl) {
            n = n5 - this.buttonsWidth - n8 - 5;
            n4 = n8;
        } else {
            n = n8 - this.buttonsWidth - 5;
            n4 = this.buttonsWidth + 5;
        }
        n3 = 3;
        n2 = this.getHeight() - 2 * n3;
        metalBumps.setBumpArea(n, n2);
        metalBumps.paintIcon(this, graphics, n4, n3);
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    class MetalTitlePaneLayout
    implements LayoutManager {
        MetalTitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.getPreferredSize(container);
        }

        public Dimension getPreferredSize(Container container) {
            return new Dimension(container.getSize().width, this.computeHeight());
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        protected int computeHeight() {
            if (MetalInternalFrameTitlePane.this.isPalette) {
                return MetalInternalFrameTitlePane.this.paletteTitleHeight;
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(MetalInternalFrameTitlePane.this.getFont());
            int n = fontMetrics.getHeight();
            n += 7;
            Icon icon = MetalInternalFrameTitlePane.this.getFrame().getFrameIcon();
            int n2 = 0;
            if (icon != null) {
                n2 = icon.getIconHeight();
            }
            int n3 = Math.max(n, n2 += 5);
            return n3;
        }

        public void layoutContainer(Container container) {
            JButton jButton;
            int n;
            JInternalFrame jInternalFrame = MetalInternalFrameTitlePane.this.getFrame();
            boolean bl = MetalUtils.isLeftToRight(jInternalFrame);
            int n2 = MetalInternalFrameTitlePane.this.getWidth();
            int n3 = bl ? n2 : 0;
            int n4 = 2;
            JButton jButton2 = MetalInternalFrameTitlePane.this.getCloseButton();
            int n5 = jButton2.getIcon().getIconHeight();
            int n6 = jButton2.getIcon().getIconWidth();
            if (jInternalFrame.isClosable()) {
                if (MetalInternalFrameTitlePane.this.isPalette) {
                    n = 3;
                    jButton2.setBounds(n3 += bl ? -n - (n6 + 2) : n, n4, n6 + 2, MetalInternalFrameTitlePane.this.getHeight() - 4);
                    if (!bl) {
                        n3 += n6 + 2;
                    }
                } else {
                    n = 4;
                    jButton2.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                    if (!bl) {
                        n3 += n6;
                    }
                }
            }
            if (jInternalFrame.isMaximizable() && !MetalInternalFrameTitlePane.this.isPalette) {
                jButton = MetalInternalFrameTitlePane.this.getMaxButton();
                n = jInternalFrame.isClosable() ? 10 : 4;
                jButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
            if (jInternalFrame.isIconifiable() && !MetalInternalFrameTitlePane.this.isPalette) {
                jButton = MetalInternalFrameTitlePane.this.getIconButton();
                n = jInternalFrame.isMaximizable() ? 2 : (jInternalFrame.isClosable() ? 10 : 4);
                jButton.setBounds(n3 += bl ? -n - n6 : n, n4, n6, n5);
                if (!bl) {
                    n3 += n6;
                }
            }
            MetalInternalFrameTitlePane.this.buttonsWidth = bl ? n2 - n3 : n3;
        }
    }

    class MetalPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        MetalPropertyChangeHandler() {
            super(MetalInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                MetalInternalFrameTitlePane.this.getIconButton().putClientProperty("paintActive", bl);
                MetalInternalFrameTitlePane.this.getCloseButton().putClientProperty("paintActive", bl);
                MetalInternalFrameTitlePane.this.getMaxButton().putClientProperty("paintActive", bl);
                MetalInternalFrameTitlePane.this.repaint();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

