/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.basic.ComplexWrappedAreaView;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.awt.font.Bidi;

class ComplexFieldView
extends View {
    TextLayout layout;
    Font cacheFont;
    FontRenderContext cacheFRC;
    boolean defaultIsLTR = !Boolean.FALSE.equals(this.getDocument().getProperty("ltr orientation"));
    boolean contextual = Boolean.TRUE.equals(this.getDocument().getProperty("contextual line direction"));
    final int HPAD = 4;
    static final FontRenderContext defaultFRC = new FontRenderContext(null, false, false);

    ComplexFieldView(Element element) {
        super(element);
    }

    public float getPreferredSpan(int n) {
        TextLayout textLayout = this.getLayout(null);
        switch (n) {
            case 0: {
                return textLayout.getAdvance() + 8.0f;
            }
            case 1: {
                return textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public void paint(Graphics graphics, Shape shape) {
        Object object;
        Shape shape2 = this.adjustAllocation(shape);
        TextLayout textLayout = this.getLayout(graphics);
        Rectangle rectangle = (Rectangle)shape2;
        float f = (float)rectangle.getX();
        float f2 = (float)rectangle.getY() + textLayout.getAscent();
        int n = this.getStartOffset();
        int n2 = Math.min(this.getDocument().getLength(), this.getEndOffset());
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        try {
            object = (LayeredHighlighter)jTextComponent.getHighlighter();
            if (object != null) {
                ((LayeredHighlighter)object).paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, this);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        object = (Graphics2D)graphics;
        Color color = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        ((Graphics)object).setColor(color);
        ((Graphics2D)object).translate(f, f2);
        textLayout.draw((Graphics2D)object, 0.0f, 0.0f);
        int n3 = jTextComponent.getSelectionStart();
        int n4 = jTextComponent.getSelectionEnd();
        if (n3 != n4) {
            Color color2;
            Color color3 = color2 = jTextComponent.getCaret().isSelectionVisible() ? jTextComponent.getSelectedTextColor() : color;
            if (!color2.equals(color) && n3 < n2 && n4 > n) {
                Shape shape3 = ((Graphics)object).getClip();
                ((Graphics)object).setClip(textLayout.getLogicalHighlightShape(n3 - n, n4 - n));
                ((Graphics)object).setColor(color2);
                textLayout.draw((Graphics2D)object, 0.0f, 0.0f);
                ((Graphics)object).setClip(shape3);
            }
        }
        ((Graphics2D)object).translate(-f, -f2);
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        boolean bl = false;
        switch (n2) {
            case 1: 
            case 5: {
                break;
            }
            case 3: 
            case 7: {
                boolean bl2;
                TextLayout textLayout = this.getLayout(null);
                boolean bl3 = textLayout.isLeftToRight();
                boolean bl4 = n2 == 3;
                boolean bl5 = bl2 = bl3 == bl4;
                if (n == -1) {
                    if (bl2) {
                        n = this.getStartOffset();
                        break;
                    }
                    n = Math.min(this.getDocument().getLength(), this.getEndOffset());
                    break;
                }
                boolean bl6 = bias != Position.Bias.Backward;
                TextHitInfo textHitInfo = bl6 ? TextHitInfo.afterOffset(n) : TextHitInfo.beforeOffset(n);
                TextHitInfo textHitInfo2 = textLayout.getVisualOtherHit(textHitInfo);
                int n3 = n;
                boolean bl7 = bl6;
                boolean bl8 = (textLayout.getCharacterLevel(textHitInfo.getCharIndex()) & 1) == 0;
                int n4 = textHitInfo2.getInsertionIndex();
                boolean bl9 = textHitInfo2.isLeadingEdge();
                if (n3 != n4 && bl7 != bl8 == bl4) {
                    n = n4;
                    bl = bl9;
                    break;
                }
                TextHitInfo textHitInfo3 = textHitInfo = bl4 ? textLayout.getNextRightHit(textHitInfo) : textLayout.getNextLeftHit(textHitInfo);
                if (textHitInfo != null) {
                    textHitInfo2 = textLayout.getVisualOtherHit(textHitInfo);
                    n3 = textHitInfo.getInsertionIndex();
                    bl7 = textHitInfo.isLeadingEdge();
                    bl8 = (textLayout.getCharacterLevel(textHitInfo.getCharIndex()) & 1) == 0;
                    n4 = textHitInfo2.getInsertionIndex();
                    bl9 = textHitInfo2.isLeadingEdge();
                    if (n3 != n4 && bl7 != bl8 != bl4) {
                        n = n4;
                        bl = bl9;
                        break;
                    }
                    n = n3;
                    bl = bl7;
                    break;
                }
                if (bl2) {
                    n = Math.min(this.getDocument().getLength(), this.getEndOffset());
                    break;
                }
                n = this.getStartOffset();
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        biasArray[0] = bl ? Position.Bias.Forward : Position.Bias.Backward;
        return n;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        TextLayout textLayout = this.getLayout(null);
        boolean bl = bias != Position.Bias.Backward;
        TextHitInfo textHitInfo = bl ? TextHitInfo.afterOffset(n) : TextHitInfo.beforeOffset(n);
        try {
            Rectangle2D rectangle2D = textLayout.getCaretShape(textHitInfo).getBounds2D();
            Rectangle2D rectangle2D2 = shape2.getBounds2D();
            rectangle2D2.setRect(rectangle2D.getX() + rectangle2D2.getX(), rectangle2D.getY() + rectangle2D2.getY() + (double)textLayout.getAscent(), rectangle2D.getWidth(), rectangle2D.getHeight());
            return rectangle2D2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Rectangle2D rectangle2D = shape2.getBounds2D();
            return rectangle2D;
        }
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        TextLayout textLayout = this.getLayout(null);
        int n3 = this.getStartOffset();
        Shape shape3 = textLayout.getLogicalHighlightShape(n - n3, n2 - n3);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY() + (double)textLayout.getAscent());
        return affineTransform.createTransformedShape(shape3);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Shape shape2 = this.adjustAllocation(shape);
        TextLayout textLayout = this.getLayout(null);
        boolean bl = textLayout.isLeftToRight();
        Rectangle2D rectangle2D = shape2.getBounds2D();
        int n = -1;
        boolean bl2 = false;
        if (!((double)f2 < rectangle2D.getY())) {
            if ((double)f2 > rectangle2D.getMaxY()) {
                n = -2;
            } else if ((double)f < rectangle2D.getMinX()) {
                n = bl ? -1 : -2;
            } else if ((double)f > rectangle2D.getMaxX()) {
                n = bl ? -2 : -1;
            } else {
                f = (float)((double)f - rectangle2D.getX());
                f2 = (float)((double)f2 - (rectangle2D.getY() + (double)textLayout.getAscent()));
                TextHitInfo textHitInfo = textLayout.hitTestChar(f, f2);
                n = textHitInfo.getInsertionIndex();
                bl2 = textHitInfo.isLeadingEdge();
            }
        }
        switch (n) {
            case -1: {
                n = this.getStartOffset();
                biasArray[0] = Position.Bias.Backward;
                return n;
            }
            case -2: {
                n = Math.min(this.getDocument().getLength(), this.getEndOffset());
                biasArray[0] = Position.Bias.Forward;
                return n;
            }
        }
        biasArray[0] = bl2 ? Position.Bias.Forward : Position.Bias.Backward;
        return this.getStartOffset() + n;
    }

    private TextLayout getLayout(Graphics graphics) {
        FontRenderContext fontRenderContext;
        Container container = this.getContainer();
        Font font = container.getFont();
        FontRenderContext fontRenderContext2 = fontRenderContext = graphics == null ? defaultFRC : ((Graphics2D)graphics).getFontRenderContext();
        if (this.layout == null || !font.equals(this.cacheFont) || fontRenderContext != null && !fontRenderContext.equals(this.cacheFRC)) {
            this.cacheFont = font;
            this.cacheFRC = fontRenderContext;
            Document document = this.getDocument();
            Element element = this.getElement();
            HashMap hashMap = new HashMap();
            hashMap.put(TextAttribute.FONT, this.cacheFont);
            boolean bl = this.defaultIsLTR;
            if (this.contextual) {
                int n = element.getStartOffset();
                int n2 = element.getEndOffset();
                n2 = Math.min(n2, document.getLength());
                try {
                    char[] cArray = document.getText(n, n2 - n).toCharArray();
                    bl = Bidi.defaultIsLTR(cArray, 0, cArray.length, this.defaultIsLTR);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            hashMap.put(TextAttribute.RUN_DIRECTION, bl ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL);
            AttributedCharacterIterator attributedCharacterIterator = ComplexWrappedAreaView.getElementACI(element, hashMap);
            this.layout = new TextLayout(attributedCharacterIterator, fontRenderContext);
        }
        return this.layout;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layout = null;
        Container container = this.getContainer();
        if (container.isShowing()) {
            this.preferenceChanged(this, true, false);
            container.repaint();
        }
        this.updateVisibilityModel();
    }

    void updateVisibilityModel() {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            JTextField jTextField = (JTextField)container;
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = (int)this.getPreferredSpan(0);
            int n2 = boundedRangeModel.getExtent();
            int n3 = Math.max(n, n2);
            n2 = n2 == 0 ? n3 : n2;
            int n4 = n3 - n2;
            int n5 = boundedRangeModel.getValue();
            if (n5 + n2 > n3) {
                n5 = n3 - n2;
            }
            n4 = Math.max(0, Math.min(n4, n5));
            boundedRangeModel.setRangeProperties(n4, n2, 0, n3, false);
        }
    }

    protected Shape adjustAllocation(Shape shape) {
        if (shape != null) {
            Container container;
            Rectangle rectangle = shape.getBounds();
            int n = (int)this.getPreferredSpan(1);
            int n2 = (int)this.getPreferredSpan(0);
            if (rectangle.height != n) {
                int n3 = rectangle.height - n;
                rectangle.y += n3 / 2;
                rectangle.height -= n3;
            }
            if ((container = this.getContainer()) instanceof JTextField) {
                int n4;
                JTextField jTextField = (JTextField)container;
                BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                int n5 = Math.max(n2, rectangle.width);
                int n6 = boundedRangeModel.getValue();
                if (n6 + (n4 = Math.min(n5, rectangle.width - 1)) > n5) {
                    n6 = n5 - n4;
                }
                boundedRangeModel.setRangeProperties(n6, n4, boundedRangeModel.getMinimum(), n5, false);
                if (n2 < rectangle.width) {
                    int n7 = rectangle.width - 1 - n2;
                    int n8 = ((JTextField)container).getHorizontalAlignment();
                    if (n8 == 10 || n8 == 11) {
                        boolean bl;
                        boolean bl2 = bl = this.contextual ? this.getLayout(null).isLeftToRight() : container.getComponentOrientation().isLeftToRight();
                        n8 = n8 == 10 ? (bl ? 2 : 4) : (bl ? 4 : 2);
                    }
                    switch (n8) {
                        case 0: {
                            rectangle.x += n7 / 2;
                            rectangle.width -= n7;
                            break;
                        }
                        case 4: {
                            rectangle.x += n7;
                            rectangle.width -= n7;
                        }
                    }
                } else {
                    rectangle.width = n2;
                    rectangle.x -= boundedRangeModel.getValue();
                }
            }
            rectangle.x += 4;
            rectangle.width -= 8;
            return rectangle;
        }
        return null;
    }
}

