/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;

public class BasicListUI
extends ListUI {
    protected JList list = null;
    protected CellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int[] cellHeights = null;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || listModel.getSize() == 0) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = this.convertYToRow(rectangle2.y);
        int n2 = this.convertYToRow(rectangle2.y + rectangle2.height - 1);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = listModel.getSize() - 1;
        }
        if ((rectangle = this.getCellBounds(this.list, n, n)) == null) {
            return;
        }
        int n3 = this.list.getLeadSelectionIndex();
        int n4 = n;
        while (n4 <= n2) {
            rectangle.height = this.getRowHeight(n4);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.paintCell(graphics, n4, rectangle, listCellRenderer, listModel, listSelectionModel, n3);
            rectangle.y += rectangle.height;
            ++n4;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        int n2 = this.cellWidth + insets.left + insets.right;
        int n3 = this.convertRowToY(n) + this.getRowHeight(n) + insets.bottom;
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectedIndex();
        if (n + 1 < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(++n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(this.list, actionMap);
        }
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            return (InputMap)UIManager.get("List.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("List.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("List.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectPreviousRow", new IncrementLeadSelectionAction("selectPreviousRow", 1, -1));
        actionMapUIResource.put("selectPreviousRowExtendSelection", new IncrementLeadSelectionAction("selectPreviousRowExtendSelection", 2, -1));
        actionMapUIResource.put("selectNextRow", new IncrementLeadSelectionAction("selectNextRow", 1, 1));
        actionMapUIResource.put("selectNextRowExtendSelection", new IncrementLeadSelectionAction("selectNextRowExtendSelection", 2, 1));
        actionMapUIResource.put("selectFirstRow", new HomeAction("selectFirstRow", 1));
        actionMapUIResource.put("selectFirstRowExtendSelection", new HomeAction("selectFirstRowExtendSelection", 2));
        actionMapUIResource.put("selectLastRow", new EndAction("selctLastRow", 1));
        actionMapUIResource.put("selectLastRowExtendSelection", new EndAction("selectLastRowExtendSelection", 2));
        actionMapUIResource.put("scrollUp", new PageUpAction("scrollUp", 1));
        actionMapUIResource.put("scrollUpExtendSelection", new PageUpAction("scrollUpExtendSelection", 2));
        actionMapUIResource.put("scrollDown", new PageDownAction("scrollDown", 1));
        actionMapUIResource.put("scrollDownExtendSelection", new PageDownAction("scrollDownExtendSelection", 2));
        actionMapUIResource.put("selectAll", new SelectAllAction("selectAll"));
        actionMapUIResource.put("clearSelection", new ClearSelectionAction("clearSelection"));
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
    }

    protected void installListeners() {
        ListSelectionModel listSelectionModel;
        this.focusListener = this.createFocusListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.listSelectionListener = this.createListSelectionListener();
        this.listDataListener = this.createListDataListener();
        this.list.addFocusListener(this.focusListener);
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionListener);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel listSelectionModel;
        this.list.removeFocusListener(this.focusListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.removeListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        }
        this.focusListener = null;
        this.mouseInputListener = null;
        this.listSelectionListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
    }

    protected void installDefaults() {
        Color color;
        Color color2;
        this.list.setLayout(null);
        LookAndFeel.installBorder(this.list, "List.border");
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        if (this.list.getCellRenderer() == null) {
            this.list.setCellRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
        }
        if ((color2 = this.list.getSelectionBackground()) == null || color2 instanceof UIResource) {
            this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        }
        if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
            this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        }
    }

    protected void uninstallDefaults() {
        if (this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(null);
        }
    }

    public void installUI(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.rendererPane = new CellRendererPane();
        this.list.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.cellHeight = -1;
        this.cellWidth = -1;
        this.cellHeights = null;
        this.list.remove(this.rendererPane);
        this.rendererPane = null;
        this.list = null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertYToRow(point.y);
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        int n2 = this.convertRowToY(n);
        return n2 == -1 ? null : new Point(0, n2);
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = this.convertRowToY(n3);
        int n6 = this.convertRowToY(n4);
        if (n5 == -1 || n6 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n7 = insets.left;
        int n8 = n5;
        int n9 = jList.getWidth() - (insets.left + insets.right);
        int n10 = n6 + this.getRowHeight(n4) - n5;
        return new Rectangle(n7, n8, n9, n10);
    }

    protected int getRowHeight(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        return this.cellHeights == null ? this.cellHeight : (n < this.cellHeights.length ? this.cellHeights[n] : -1);
    }

    protected int convertYToRow(int n) {
        int n2 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (n2 <= 0) {
            return -1;
        }
        if (this.cellHeights == null) {
            int n3 = this.cellHeight == 0 ? 0 : (n - insets.top) / this.cellHeight;
            return n3 < 0 || n3 >= n2 ? -1 : n3;
        }
        if (n2 > this.cellHeights.length) {
            return -1;
        }
        int n4 = insets.top;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            if (n >= n4 && n < n4 + this.cellHeights[n6]) {
                return n5;
            }
            n4 += this.cellHeights[n6];
            ++n5;
            ++n6;
        }
        return -1;
    }

    protected int convertRowToY(int n) {
        int n2 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.cellHeights == null) {
            return insets.top + this.cellHeight * n;
        }
        if (n >= this.cellHeights.length) {
            return -1;
        }
        int n3 = insets.top;
        int n4 = 0;
        while (n4 < n) {
            n3 += this.cellHeights[n4];
            ++n4;
        }
        return n3;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n4 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                int n5 = 0;
                while (n5 < n4) {
                    Object object = listModel.getElementAt(n5);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n5, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n == -1) {
                        this.cellHeights[n5] = dimension.height;
                    }
                    ++n5;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                int n6 = 0;
                while (n6 < n4) {
                    this.cellHeights[n6] = 0;
                    ++n6;
                }
            }
        }
        this.list.invalidate();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private static class ClearSelectionAction
    extends AbstractAction {
        private ClearSelectionAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            jList.clearSelection();
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        private SelectAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            jList.setSelectionInterval(0, jList.getModel().getSize() - 1);
        }
    }

    private static class PageDownAction
    extends IncrementLeadSelectionAction {
        protected PageDownAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            if (n == -1) {
                n = jList.getModel().getSize() - 1;
            }
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = jList.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                n = jList.locationToIndex(rectangle.getLocation());
                if (n == -1) {
                    n = jList.getModel().getSize() - 1;
                }
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            Rectangle rectangle = jList.getVisibleRect();
            Rectangle rectangle2 = jList.getCellBounds(n, n);
            rectangle2.y = Math.max(0, rectangle2.y + rectangle2.height - rectangle.height);
            rectangle2.height = rectangle.height;
            jList.scrollRectToVisible(rectangle2);
        }
    }

    private static class PageUpAction
    extends IncrementLeadSelectionAction {
        protected PageUpAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getFirstVisibleIndex();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = jList.getVisibleRect();
                rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                n = jList.locationToIndex(rectangle.getLocation());
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            Rectangle rectangle = jList.getVisibleRect();
            Rectangle rectangle2 = jList.getCellBounds(n, n);
            rectangle2.height = rectangle.height;
            jList.scrollRectToVisible(rectangle2);
        }
    }

    private static class EndAction
    extends IncrementLeadSelectionAction {
        protected EndAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            return jList.getModel().getSize() - 1;
        }
    }

    private static class HomeAction
    extends IncrementLeadSelectionAction {
        protected HomeAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            return 0;
        }
    }

    private static class IncrementLeadSelectionAction
    extends AbstractAction {
        protected int amount;
        protected int selectionType;

        protected IncrementLeadSelectionAction(String string, int n) {
            this(string, n, -1);
        }

        protected IncrementLeadSelectionAction(String string, int n, int n2) {
            super(string);
            this.amount = n2;
            this.selectionType = n;
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getLeadSelectionIndex();
            int n2 = jList.getModel().getSize();
            if (n == -1) {
                if (n2 > 0) {
                    n = this.amount > 0 ? 0 : n2 - 1;
                }
            } else {
                n += this.amount;
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            jList.ensureIndexIsVisible(n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            int n = this.getNextIndex(jList);
            if (n >= 0 && n < jList.getModel().getSize()) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (this.selectionType == 2) {
                    int n2 = listSelectionModel.getAnchorSelectionIndex();
                    if (n2 == -1) {
                        n2 = n;
                    }
                    jList.setSelectionInterval(n2, n);
                    listSelectionModel.setAnchorSelectionIndex(n2);
                    listSelectionModel.setLeadSelectionIndex(n);
                } else if (this.selectionType == 1) {
                    jList.setSelectedIndex(n);
                } else {
                    listSelectionModel.setLeadSelectionIndex(n);
                }
                this.ensureIndexIsVisible(jList, n);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                if (listModel != null) {
                    listModel.removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (listModel2 != null) {
                    listModel2.addListDataListener(BasicListUI.this.listDataListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                if (listSelectionModel2 != null) {
                    listSelectionModel2.addListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string.equals("font")) {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
                BasicListUI.this.redrawList();
            } else if (string.equals("prototypeCellValue")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
                BasicListUI.this.redrawList();
            } else if (string.equals("fixedCellHeight")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
                BasicListUI.this.redrawList();
            } else if (string.equals("fixedCellWidth")) {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
                BasicListUI.this.redrawList();
            } else if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string.equals("selectionForeground")) {
                BasicListUI.this.list.repaint();
            } else if (string.equals("selectionBackground")) {
                BasicListUI.this.list.repaint();
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n, true);
            }
            int n3 = Math.max(0, BasicListUI.this.convertRowToY(n));
            int n4 = BasicListUI.this.list.getHeight() - n3;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint(0, n3, BasicListUI.this.list.getWidth(), n4);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(0, BasicListUI.this.convertRowToY(n));
            int n3 = BasicListUI.this.list.getHeight() - n2;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint(0, n2, BasicListUI.this.list.getWidth(), n3);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            BasicListUI.this.redrawList();
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicListUI.this.maybeUpdateLayoutState();
            int n = BasicListUI.this.convertRowToY(listSelectionEvent.getFirstIndex());
            int n2 = BasicListUI.this.convertRowToY(listSelectionEvent.getLastIndex());
            if (n == -1 || n2 == -1) {
                BasicListUI.this.list.repaint(0, 0, BasicListUI.this.list.getWidth(), BasicListUI.this.list.getHeight());
            } else {
                BasicListUI.this.list.repaint(0, n, BasicListUI.this.list.getWidth(), (n2 += BasicListUI.this.getRowHeight(listSelectionEvent.getLastIndex())) - n);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = BasicListUI.this.list.getLeadSelectionIndex();
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel.getLeadSelectionIndex() == -1) {
                listSelectionModel.setAnchorSelectionIndex(0);
                listSelectionModel.setLeadSelectionIndex(0);
                listSelectionModel.clearSelection();
            }
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicListUI.this.list.isEnabled()) {
                return;
            }
            if (!BasicListUI.this.list.hasFocus()) {
                BasicListUI.this.list.requestFocus();
            }
            if ((n = BasicListUI.this.convertYToRow(mouseEvent.getY())) != -1) {
                BasicListUI.this.list.setValueIsAdjusting(true);
                int n2 = BasicListUI.this.list.getAnchorSelectionIndex();
                if (mouseEvent.isControlDown()) {
                    if (BasicListUI.this.list.isSelectedIndex(n)) {
                        BasicListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        BasicListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown() && n2 != -1) {
                    BasicListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    BasicListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicListUI.this.list.isEnabled()) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = BasicListUI.this.convertYToRow(mouseEvent.getY());
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.scrollRectToVisible(rectangle);
                BasicListUI.this.list.setSelectionInterval(n, n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            BasicListUI.this.list.setValueIsAdjusting(false);
        }
    }
}

