/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class UIDefaults
extends Hashtable {
    private static final Object PENDING = new String("Pending");
    private SwingPropertyChangeSupport changeSupport;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public UIDefaults() {
    }

    public UIDefaults(Object[] objectArray) {
        super(objectArray.length / 2);
        int n = 0;
        while (n < objectArray.length) {
            super.put(objectArray[n], objectArray[n + 1]);
            n += 2;
        }
    }

    public Object get(Object object) {
        Object object2 = super.get(object);
        if (object2 != PENDING && !(object2 instanceof ActiveValue) && !(object2 instanceof LazyValue)) {
            return object2;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            object2 = super.get(object);
            if (object2 == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((object2 = super.get(object)) == PENDING);
                Object object3 = object2;
                return object3;
            }
            if (object2 instanceof LazyValue) {
                super.put(object, PENDING);
            } else if (!(object2 instanceof ActiveValue)) {
                Object object4 = object2;
                return object4;
            }
        }
        if (object2 instanceof LazyValue) {
            UIDefaults uIDefaults2;
            try {
                object2 = ((LazyValue)object2).createValue(this);
                Object var7_8 = null;
                uIDefaults2 = this;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                UIDefaults uIDefaults3 = this;
                synchronized (uIDefaults3) {
                    if (object2 == null) {
                        super.remove(object);
                    } else {
                        super.put(object, object2);
                    }
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (uIDefaults2) {
                if (object2 == null) {
                    super.remove(object);
                } else {
                    super.put(object, object2);
                }
                this.notifyAll();
            }
        }
        object2 = ((ActiveValue)object2).createValue(this);
        return object2;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = object2 == null ? super.remove(object) : super.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    public void putDefaults(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n + 1];
            if (object == null) {
                super.remove(objectArray[n]);
            } else {
                super.put(objectArray[n], object);
            }
            n += 2;
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof String ? (String)object2 : null;
    }

    public int getInt(Object object) {
        Object object2 = this.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            String string = (String)object2;
            int n = 0;
            if (string.length() == 1) {
                n = Character.toUpperCase(string.charAt(0));
            }
            if (n < 65 || n > 90) {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public Insets getInsets(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Dimension getDimension(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Class getUIClass(String string, ClassLoader classLoader) {
        try {
            String string2 = (String)this.get(string);
            Class clazz = (Class)this.get(string2);
            if (clazz == null && (clazz = classLoader == null ? SwingUtilities.loadSystemClass(string2) : classLoader.loadClass(string2)) != null) {
                this.put(string2, clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Class getUIClass(String string) {
        return this.getUIClass(string, null);
    }

    protected void getUIError(String string) {
        System.err.println("UIDefaults.getUI() failed: " + string);
        try {
            throw new Error();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public ComponentUI getUI(JComponent jComponent) {
        Object object = this.get("ClassLoader");
        ClassLoader classLoader = object != null ? (ClassLoader)object : jComponent.getClass().getClassLoader();
        Class clazz = this.getUIClass(jComponent.getUIClassID(), classLoader);
        Object object2 = null;
        if (clazz == null) {
            this.getUIError("no ComponentUI class for: " + jComponent);
        } else {
            try {
                Method method = (Method)this.get(clazz);
                if (method == null) {
                    Class clazz2 = class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = UIDefaults.class$("javax.swing.JComponent")) : class$javax$swing$JComponent;
                    method = clazz.getMethod("createUI", new Class[]{clazz2});
                    this.put(clazz, method);
                }
                object2 = method.invoke(null, new Object[]{jComponent});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getUIError("static createUI() method not found in " + clazz);
            }
            catch (Exception exception) {
                this.getUIError("createUI() failed for " + jComponent + " " + exception);
            }
        }
        return (ComponentUI)object2;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LazyInputMap
    implements LazyValue {
        private Object[] bindings;

        public LazyInputMap(Object[] objectArray) {
            this.bindings = objectArray;
        }

        public Object createValue(UIDefaults uIDefaults) {
            if (this.bindings != null) {
                InputMap inputMap = LookAndFeel.makeInputMap(this.bindings);
                return inputMap;
            }
            return null;
        }
    }

    public static class ProxyLazyValue
    implements LazyValue {
        private String className;
        private String methodName;
        private Object[] args;
        static /* synthetic */ Class class$java$awt$Color;

        public ProxyLazyValue(String string) {
            this.className = string;
        }

        public ProxyLazyValue(String string, String string2) {
            this.className = string;
            this.methodName = string2;
        }

        public ProxyLazyValue(String string, Object[] objectArray) {
            this.className = string;
            this.args = objectArray;
        }

        public ProxyLazyValue(String string, String string2, Object[] objectArray) {
            this.className = string;
            this.methodName = string2;
            this.args = objectArray;
        }

        public Object createValue(UIDefaults uIDefaults) {
            Object object = null;
            try {
                Class clazz = Class.forName(this.className);
                if (this.methodName != null) {
                    Class[] classArray = this.getClassArray(this.args);
                    Method method = clazz.getMethod(this.methodName, classArray);
                    object = method.invoke(clazz, this.args);
                } else {
                    Object[] objectArray = this.getClassArray(this.args);
                    try {
                        Constructor constructor = clazz.getConstructor((Class[])objectArray);
                        object = constructor.newInstance(this.args);
                    }
                    catch (Exception exception) {
                        System.out.println("Problem with constructor " + this.className + " and args " + this.printArgs(this.args) + " : " + " and types " + this.printArgs(objectArray) + " : " + exception);
                        Thread.dumpStack();
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Problem creating " + this.className + " with method " + this.methodName + " and args " + this.printArgs(this.args) + " : " + exception);
                Thread.dumpStack();
            }
            return object;
        }

        private Class[] getClassArray(Object[] objectArray) {
            Class[] classArray = null;
            if (objectArray != null) {
                classArray = new Class[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    classArray[n] = objectArray[n] instanceof Integer ? Integer.TYPE : (objectArray[n] instanceof Boolean ? Boolean.TYPE : (objectArray[n] instanceof ColorUIResource ? (class$java$awt$Color == null ? ProxyLazyValue.class$("java.awt.Color") : class$java$awt$Color) : objectArray[n].getClass()));
                    ++n;
                }
            }
            return classArray;
        }

        private String printArgs(Object[] objectArray) {
            String string = "{";
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length - 1) {
                    string = string.concat(objectArray[n] + ",");
                    ++n;
                }
                string = string.concat(objectArray[objectArray.length - 1] + "}");
            } else {
                string.concat("}");
            }
            return string;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }
}

