/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final String uiClassID = "TableUI";
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected JTableHeader tableHeader;
    protected int rowHeight;
    protected int rowMargin;
    protected Color gridColor;
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected int autoResizeMode;
    protected boolean autoCreateColumnsFromModel;
    protected Dimension preferredViewportSize;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected transient Component editorComp;
    protected transient TableCellEditor cellEditor;
    protected transient int editingColumn;
    protected transient int editingRow;
    protected transient Hashtable defaultRenderersByColumnClass;
    protected transient Hashtable defaultEditorsByColumnClass;
    protected Color selectionForeground;
    protected Color selectionBackground;
    private boolean columnsWereSwapped = false;
    private boolean reentrantCall = false;
    private SizeSequence rowModel;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Boolean;

    public JTable() {
        this(null, null, null);
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        this.setLayout(null);
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
            this.autoCreateColumnsFromModel = true;
        }
        this.setColumnModel(tableColumnModel);
        if (listSelectionModel == null) {
            listSelectionModel = this.createDefaultSelectionModel();
        }
        this.setSelectionModel(listSelectionModel);
        if (tableModel == null) {
            tableModel = this.createDefaultDataModel();
        }
        this.setModel(tableModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public JTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public JTable(final Vector vector, final Vector vector2) {
        this(new AbstractTableModel(){

            public String getColumnName(int n) {
                return vector2.elementAt(n).toString();
            }

            public int getRowCount() {
                return vector.size();
            }

            public int getColumnCount() {
                return vector2.size();
            }

            public Object getValueAt(int n, int n2) {
                return ((Vector)vector.elementAt(n)).elementAt(n2);
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public void setValueAt(Object object, int n, int n2) {
                ((Vector)vector.elementAt(n)).setElementAt(object, n2);
                this.fireTableCellUpdated(n, n2);
            }
        });
    }

    public JTable(final Object[][] objectArray, final Object[] objectArray2) {
        this(new AbstractTableModel(){

            public String getColumnName(int n) {
                return objectArray2[n].toString();
            }

            public int getRowCount() {
                return objectArray.length;
            }

            public int getColumnCount() {
                return objectArray2.length;
            }

            public Object getValueAt(int n, int n2) {
                return objectArray[n][n2];
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public void setValueAt(Object object, int n, int n2) {
                objectArray[n][n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(null);
        }
    }

    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != jTableHeader) {
            JTableHeader jTableHeader2 = this.tableHeader;
            if (jTableHeader2 != null) {
                jTableHeader2.setTable(null);
            }
            this.tableHeader = jTableHeader;
            if (jTableHeader != null) {
                jTableHeader.setTable(this);
            }
            this.firePropertyChange("tableHeader", jTableHeader2, jTableHeader);
        }
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setRowHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.rowModel = null;
        this.resizeAndRepaint();
        this.firePropertyChange("rowHeight", n2, n);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    private SizeSequence getRowModel() {
        if (this.rowModel == null) {
            this.rowModel = new SizeSequence(this.getRowCount(), this.getRowHeight());
        }
        return this.rowModel;
    }

    public void setRowHeight(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.getRowModel().setSize(n, n2);
        this.resizeAndRepaint();
    }

    public int getRowHeight(int n) {
        return this.rowModel == null ? this.getRowHeight() : this.rowModel.getSize(n);
    }

    public void setRowMargin(int n) {
        int n2 = this.rowMargin;
        this.rowMargin = n;
        this.resizeAndRepaint();
        this.firePropertyChange("rowMargin", n2, n);
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.setRowMargin(dimension.height);
        this.getColumnModel().setColumnMargin(dimension.width);
        this.resizeAndRepaint();
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.getColumnModel().getColumnMargin(), this.rowMargin);
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, color);
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setShowGrid(boolean bl) {
        this.setShowHorizontalLines(bl);
        this.setShowVerticalLines(bl);
        this.repaint();
    }

    public void setShowHorizontalLines(boolean bl) {
        boolean bl2 = bl;
        this.showHorizontalLines = bl;
        this.firePropertyChange("showHorizontalLines", bl2, bl);
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl) {
        boolean bl2 = bl;
        this.showVerticalLines = bl;
        this.firePropertyChange("showVerticalLines", bl2, bl);
        this.repaint();
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public void setAutoResizeMode(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4) {
            int n2 = this.autoResizeMode;
            this.autoResizeMode = n;
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            this.firePropertyChange("autoResizeMode", n2, this.autoResizeMode);
        }
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setAutoCreateColumnsFromModel(boolean bl) {
        if (this.autoCreateColumnsFromModel != bl) {
            boolean bl2 = this.autoCreateColumnsFromModel;
            this.autoCreateColumnsFromModel = bl;
            if (bl) {
                this.createDefaultColumnsFromModel();
            }
            this.firePropertyChange("autoCreateColumnsFromModel", bl2, bl);
        }
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            int n = 0;
            while (n < tableModel.getColumnCount()) {
                TableColumn tableColumn = new TableColumn(n);
                this.addColumn(tableColumn);
                ++n;
            }
        }
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer != null) {
            this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
        } else {
            this.defaultRenderersByColumnClass.remove(clazz);
        }
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.defaultRenderersByColumnClass.get(clazz);
        if (object != null) {
            return (TableCellRenderer)object;
        }
        return this.getDefaultRenderer(clazz.getSuperclass());
    }

    public void setDefaultEditor(Class clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor != null) {
            this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
        } else {
            this.defaultEditorsByColumnClass.remove(clazz);
        }
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.defaultEditorsByColumnClass.get(clazz);
        if (object != null) {
            return (TableCellEditor)object;
        }
        return this.getDefaultEditor(clazz.getSuperclass());
    }

    public void setSelectionMode(int n) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n);
        this.getColumnModel().getSelectionModel().setSelectionMode(n);
    }

    public void setRowSelectionAllowed(boolean bl) {
        boolean bl2 = this.rowSelectionAllowed;
        this.rowSelectionAllowed = bl;
        this.firePropertyChange("rowSelectionAllowed", bl2, bl);
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public void setColumnSelectionAllowed(boolean bl) {
        boolean bl2 = this.columnModel.getColumnSelectionAllowed();
        this.columnModel.setColumnSelectionAllowed(bl);
        this.firePropertyChange("columnSelectionAllowed", bl2, bl);
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnModel.getColumnSelectionAllowed();
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.setRowSelectionAllowed(bl);
        this.setColumnSelectionAllowed(bl);
        boolean bl2 = this.cellSelectionEnabled;
        this.cellSelectionEnabled = bl;
        this.firePropertyChange("cellSelectionEnabled", bl2, bl);
    }

    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void selectAll() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    public void clearSelection() {
        this.columnModel.getSelectionModel().clearSelection();
        this.selectionModel.clearSelection();
    }

    private int boundRow(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index out of range");
        }
        return n;
    }

    private int boundColumn(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        return n;
    }

    public void setRowSelectionInterval(int n, int n2) {
        this.selectionModel.setSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void setColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().setSelectionInterval(this.boundColumn(n), this.boundColumn(n2));
    }

    public void addRowSelectionInterval(int n, int n2) {
        this.selectionModel.addSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().addSelectionInterval(this.boundColumn(n), this.boundColumn(n2));
    }

    public void removeRowSelectionInterval(int n, int n2) {
        this.selectionModel.removeSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void removeColumnSelectionInterval(int n, int n2) {
        this.columnModel.getSelectionModel().removeSelectionInterval(this.boundColumn(n), this.boundColumn(n2));
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    public int[] getSelectedRows() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    nArray[n3++] = n4;
                }
                ++n4;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    public int[] getSelectedColumns() {
        return this.columnModel.getSelectedColumns();
    }

    public int getSelectedRowCount() {
        if (this.selectionModel != null) {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            int n3 = 0;
            int n4 = n;
            while (n4 <= n2) {
                if (this.selectionModel.isSelectedIndex(n4)) {
                    ++n3;
                }
                ++n4;
            }
            return n3;
        }
        return 0;
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public boolean isRowSelected(int n) {
        if (this.selectionModel != null) {
            return this.selectionModel.isSelectedIndex(n);
        }
        return false;
    }

    public boolean isColumnSelected(int n) {
        return this.columnModel.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isCellSelected(int n, int n2) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return !(this.getRowSelectionAllowed() && !this.isRowSelected(n) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n2));
    }

    private void changeSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                listSelectionModel.setAnchorSelectionIndex(n);
            } else {
                listSelectionModel.setLeadSelectionIndex(n);
            }
        } else if (bl) {
            if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        Rectangle rectangle;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        this.changeSelectionModel(listSelectionModel2, n2, bl, bl2);
        this.changeSelectionModel(listSelectionModel, n, bl, bl2);
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n, n2, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public TableColumn getColumn(Object object) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndex(object);
        return tableColumnModel.getColumn(n);
    }

    public int convertColumnIndexToModel(int n) {
        if (n < 0) {
            return n;
        }
        return this.getColumnModel().getColumn(n).getModelIndex();
    }

    public int convertColumnIndexToView(int n) {
        if (n < 0) {
            return n;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = 0;
        while (n2 < this.getColumnCount()) {
            if (tableColumnModel.getColumn(n2).getModelIndex() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public String getColumnName(int n) {
        return this.getModel().getColumnName(this.convertColumnIndexToModel(n));
    }

    public Class getColumnClass(int n) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(n));
    }

    public Object getValueAt(int n, int n2) {
        return this.getModel().getValueAt(n, this.convertColumnIndexToModel(n2));
    }

    public void setValueAt(Object object, int n, int n2) {
        this.getModel().setValueAt(object, n, this.convertColumnIndexToModel(n2));
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getModel().isCellEditable(n, this.convertColumnIndexToModel(n2));
    }

    public void addColumn(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        String string = this.getModel().getColumnName(n);
        if (tableColumn.getHeaderValue() == null) {
            tableColumn.setHeaderValue(string);
        }
        this.getColumnModel().addColumn(tableColumn);
    }

    public void removeColumn(TableColumn tableColumn) {
        this.getColumnModel().removeColumn(tableColumn);
    }

    public void moveColumn(int n, int n2) {
        this.getColumnModel().moveColumn(n, n2);
    }

    public int columnAtPoint(Point point) {
        return this.getColumnModel().getColumnIndexAtX(point.x);
    }

    public int rowAtPoint(Point point) {
        int n;
        int n2 = point.y;
        int n3 = n = this.rowModel == null ? n2 / this.getRowHeight() : this.rowModel.getIndex(n2);
        if (n < 0) {
            return -1;
        }
        if (n >= this.getRowCount()) {
            return -1;
        }
        return n;
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        int n3;
        Rectangle rectangle = new Rectangle();
        boolean bl2 = true;
        if (n < 0) {
            bl2 = false;
        } else if (n >= this.getRowCount()) {
            rectangle.y = this.getHeight();
            bl2 = false;
        } else {
            rectangle.height = this.getRowHeight(n);
            int n4 = rectangle.y = this.rowModel == null ? n * rectangle.height : this.rowModel.getPosition(n);
        }
        if (n2 < 0) {
            bl2 = false;
        } else if (n2 >= this.getColumnCount()) {
            rectangle.x = this.getWidth();
            bl2 = false;
        } else {
            TableColumnModel tableColumnModel = this.getColumnModel();
            n3 = 0;
            while (n3 < n2) {
                rectangle.x += tableColumnModel.getColumn(n3).getWidth();
                ++n3;
            }
            rectangle.width = tableColumnModel.getColumn(n2).getWidth();
        }
        if (bl2 && !bl) {
            int n5 = this.getRowMargin();
            n3 = this.getColumnModel().getColumnMargin();
            rectangle.setBounds(rectangle.x + n3 / 2, rectangle.y + n5 / 2, rectangle.width - n3, rectangle.height - n5);
        }
        return rectangle;
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            if (tableColumnModel.getColumn(n) == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void doLayout() {
        this.sizeColumnsToFit(-1);
        super.doLayout();
    }

    public void sizeColumnsToFit(boolean bl) {
        int n = this.autoResizeMode;
        this.setAutoResizeMode(bl ? 3 : 4);
        this.sizeColumnsToFit(-1);
        this.setAutoResizeMode(n);
    }

    public void sizeColumnsToFit(int n) {
        if (n == -1) {
            this.setWidthsFromPreferredWidths(false);
        } else if (this.autoResizeMode == 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        } else {
            int n2 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n, n2);
        }
    }

    private void setWidthsFromPreferredWidths(final boolean bl) {
        int n = this.getWidth();
        int n2 = this.getPreferredSize().width;
        int n3 = !bl ? n : n2;
        final TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(){

            public int getElementCount() {
                return tableColumnModel.getColumnCount();
            }

            public int getLowerBoundAt(int n) {
                return tableColumnModel.getColumn(n).getMinWidth();
            }

            public int getUpperBoundAt(int n) {
                return tableColumnModel.getColumn(n).getMaxWidth();
            }

            public int getMidPointAt(int n) {
                if (!bl) {
                    return tableColumnModel.getColumn(n).getPreferredWidth();
                }
                return tableColumnModel.getColumn(n).getWidth();
            }

            public void setSizeAt(int n, int n2) {
                if (!bl) {
                    tableColumnModel.getColumn(n2).setWidth(n);
                } else {
                    tableColumnModel.getColumn(n2).setPreferredWidth(n);
                }
            }
        };
        this.adjustSizes((long)n3, resizable3, bl);
    }

    private void accommodateDelta(int n, int n2) {
        int n3 = this.getColumnCount();
        int n4 = n;
        int n5 = n3;
        switch (this.autoResizeMode) {
            case 1: {
                n5 = ++n4 + 1;
                break;
            }
            case 2: {
                ++n4;
                n5 = n3;
                break;
            }
            case 3: {
                n4 = n3 - 1;
                n5 = n4 + 1;
                break;
            }
            case 4: {
                n4 = 0;
                n5 = n3;
                break;
            }
            default: {
                return;
            }
        }
        final int n6 = n4;
        final int n7 = n5;
        final TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(){

            public int getElementCount() {
                return n7 - n6;
            }

            public int getLowerBoundAt(int n) {
                return tableColumnModel.getColumn(n + n6).getMinWidth();
            }

            public int getUpperBoundAt(int n) {
                return tableColumnModel.getColumn(n + n6).getMaxWidth();
            }

            public int getMidPointAt(int n) {
                return tableColumnModel.getColumn(n + n6).getWidth();
            }

            public void setSizeAt(int n, int n2) {
                tableColumnModel.getColumn(n2 + n6).setWidth(n);
            }
        };
        int n8 = 0;
        int n9 = n4;
        while (n9 < n5) {
            TableColumn tableColumn = this.columnModel.getColumn(n9);
            int n10 = tableColumn.getWidth();
            n8 += n10;
            ++n9;
        }
        this.adjustSizes((long)(n8 + n2), resizable3, false);
        this.setWidthsFromPreferredWidths(true);
    }

    private void adjustSizes(long l, final Resizable3 resizable3, boolean bl) {
        int n = resizable3.getElementCount();
        long l2 = 0L;
        int n2 = 0;
        while (n2 < n) {
            l2 += (long)resizable3.getMidPointAt(n2);
            ++n2;
        }
        Resizable2 resizable2 = l < l2 == !bl ? new Resizable2(){

            public int getElementCount() {
                return resizable3.getElementCount();
            }

            public int getLowerBoundAt(int n) {
                return resizable3.getLowerBoundAt(n);
            }

            public int getUpperBoundAt(int n) {
                return resizable3.getMidPointAt(n);
            }

            public void setSizeAt(int n, int n2) {
                resizable3.setSizeAt(n, n2);
            }
        } : new Resizable2(){

            public int getElementCount() {
                return resizable3.getElementCount();
            }

            public int getLowerBoundAt(int n) {
                return resizable3.getMidPointAt(n);
            }

            public int getUpperBoundAt(int n) {
                return resizable3.getUpperBoundAt(n);
            }

            public void setSizeAt(int n, int n2) {
                resizable3.setSizeAt(n, n2);
            }
        };
        this.adjustSizes(l, resizable2, !bl);
    }

    private void adjustSizes(long l, Resizable2 resizable2, boolean bl) {
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        while (n < resizable2.getElementCount()) {
            l2 += (long)resizable2.getLowerBoundAt(n);
            l3 += (long)resizable2.getUpperBoundAt(n);
            ++n;
        }
        if (bl) {
            l = Math.min(Math.max(l2, l), l3);
        }
        int n2 = 0;
        while (n2 < resizable2.getElementCount()) {
            int n3;
            int n4 = resizable2.getLowerBoundAt(n2);
            int n5 = resizable2.getUpperBoundAt(n2);
            if (l2 == l3) {
                n3 = n4;
            } else {
                double d = (double)(l - l2) / (double)(l3 - l2);
                n3 = (int)Math.round((double)n4 + d * (double)(n5 - n4));
            }
            resizable2.setSizeAt(n3, n2);
            l -= (long)n3;
            l2 -= (long)n4;
            l3 -= (long)n5;
            ++n2;
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n2, n), n2, n)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n2, n, false);
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public boolean editCellAt(int n, int n2) {
        return this.editCellAt(n, n2, null);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        TableCellEditor tableCellEditor = this.getCellEditor(n, n2);
        if (tableCellEditor != null && tableCellEditor.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor(tableCellEditor, n, n2);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(n, n2, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor(tableCellEditor);
            this.setEditingRow(n);
            this.setEditingColumn(n2);
            tableCellEditor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        if (this.ui != tableUI) {
            super.setUI(tableUI);
            this.repaint();
        }
    }

    private void updateSubComponentUI(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    public void updateUI() {
        Object object;
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            object = tableColumnModel.getColumn(n);
            this.updateSubComponentUI(((TableColumn)object).getCellRenderer());
            this.updateSubComponentUI(((TableColumn)object).getCellEditor());
            this.updateSubComponentUI(((TableColumn)object).getHeaderRenderer());
            ++n;
        }
        object = this.defaultRenderersByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateSubComponentUI(object.nextElement());
        }
        Enumeration enumeration = this.defaultEditorsByColumnClass.elements();
        while (enumeration.hasMoreElements()) {
            this.updateSubComponentUI(enumeration.nextElement());
        }
        this.setUI((TableUI)UIManager.getUI(this));
        this.resizeAndRepaint();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (this.dataModel != tableModel) {
            TableModel tableModel2 = this.dataModel;
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            tableModel.addTableModelListener(this);
            if (this.getColumnModel() != null) {
                this.tableChanged(new TableModelEvent(tableModel, -1));
            }
            this.firePropertyChange("model", tableModel2, tableModel);
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            if (this.tableHeader != null) {
                this.tableHeader.setColumnModel(tableColumnModel);
            }
            this.firePropertyChange("columnModel", tableColumnModel2, tableColumnModel);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            if (listSelectionModel != null) {
                listSelectionModel.addListSelectionListener(this);
            }
            this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
            this.repaint();
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.clearSelection();
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
                return;
            }
            this.resizeAndRepaint();
            return;
        }
        if (this.rowModel != null) {
            this.repaint();
        }
        if (tableModelEvent.getType() == 1) {
            this.tableRowsInserted(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == -1) {
            this.tableRowsDeleted(tableModelEvent);
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n == -1) {
            rectangle = new Rectangle(0, n2 * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n4 = this.convertColumnIndexToView(n);
            rectangle = this.getCellRect(n2, n4, false);
        }
        if (n3 != Integer.MAX_VALUE) {
            rectangle.height = (n3 - n2 + 1) * this.getRowHeight();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.clearSelection();
            this.resizeAndRepaint();
        }
    }

    private void tableRowsInserted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n2 - n + 1;
        this.selectionModel.insertIndexInterval(n, n3, true);
        if (this.rowModel != null) {
            this.rowModel.insertEntries(n, n3, this.getRowHeight());
        }
        int n4 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n * n4, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n) * n4);
        this.revalidate();
        this.repaint(rectangle);
    }

    private void tableRowsDeleted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n2 - n + 1;
        int n4 = this.getRowCount() + n3;
        this.selectionModel.removeIndexInterval(n, n2);
        if (this.rowModel != null) {
            this.rowModel.removeEntries(n, n3);
        }
        int n5 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n * n5, this.getColumnModel().getTotalColumnWidth(), (n4 - n) * n5);
        this.revalidate();
        this.repaint(rectangle);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.reentrantCall) {
            return;
        }
        this.reentrantCall = true;
        if (this.isEditing() && this.hasFocus()) {
            this.removeEditor();
        }
        TableColumn tableColumn = null;
        if (this.tableHeader != null) {
            tableColumn = this.tableHeader.getResizingColumn();
        }
        if (tableColumn != null) {
            if (this.autoResizeMode == 0) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            } else {
                int n = this.viewIndexForColumn(tableColumn);
                int n2 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
                this.accommodateDelta(n, n2);
                this.repaint();
                this.reentrantCall = false;
                return;
            }
        }
        this.resizeAndRepaint();
        this.reentrantCall = false;
    }

    private int limit(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n, n2));
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getColumnCount() - 1);
        int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getColumnCount() - 1);
        Rectangle rectangle = this.getCellRect(0, n, false);
        Rectangle rectangle2 = this.getCellRect(this.getRowCount() - 1, n2, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getRowCount() - 1);
        int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getRowCount() - 1);
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getCellRect(n2, this.getColumnCount() - 1, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            this.setValueAt(object, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 100;
        }
        return this.getRowHeight();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = this.getRowHeight();
            return n3 > 0 ? Math.max(n3, rectangle.height / n3 * n3) : rectangle.height;
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private void swapColumns() {
        int n = this.getColumnModel().getColumnCount();
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n2) {
            this.moveColumn(n2, n3);
            ++n3;
        }
        this.columnsWereSwapped = !this.columnsWereSwapped;
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = this.getComponentOrientation();
        if (componentOrientation != componentOrientation2) {
            super.setComponentOrientation(componentOrientation);
            if (componentOrientation.isLeftToRight() && this.columnsWereSwapped || !componentOrientation.isLeftToRight() && !this.columnsWereSwapped) {
                this.swapColumns();
            }
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        if (!bl2 && n == 1 && this.hasFocus()) {
            Component component = this.getEditorComponent();
            if (component == null) {
                if (keyEvent == null || keyEvent.getID() != 401) {
                    return false;
                }
                int n2 = keyEvent.getKeyCode();
                if (n2 == 16 || n2 == 17 || n2 == 18) {
                    return false;
                }
                if (n2 == 117 || n2 == 119) {
                    return false;
                }
                int n3 = this.getSelectionModel().getAnchorSelectionIndex();
                int n4 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (n3 != -1 && n4 != -1 && !this.isEditing() && !this.editCellAt(n3, n4, keyEvent)) {
                    return false;
                }
                component = this.getEditorComponent();
                if (component == null) {
                    return false;
                }
            }
            if (component instanceof JComponent) {
                bl2 = ((JComponent)component).processKeyBinding(keyStroke, keyEvent, 0, bl);
            }
        }
        return bl2;
    }

    private void setLazyValue(Hashtable hashtable, Class clazz, String string) {
        hashtable.put(clazz, new UIDefaults.ProxyLazyValue(string));
    }

    private void setLazyRenderer(Class clazz, String string) {
        this.setLazyValue(this.defaultRenderersByColumnClass, clazz, string);
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.setLazyRenderer(class$java$lang$Object == null ? (class$java$lang$Object = JTable.class$("java.lang.Object")) : class$java$lang$Object, "javax.swing.table.DefaultTableCellRenderer");
        this.setLazyRenderer(class$java$lang$Number == null ? (class$java$lang$Number = JTable.class$("java.lang.Number")) : class$java$lang$Number, "javax.swing.JTable$NumberRenderer");
        this.setLazyRenderer(class$java$lang$Float == null ? (class$java$lang$Float = JTable.class$("java.lang.Float")) : class$java$lang$Float, "javax.swing.JTable$DoubleRenderer");
        this.setLazyRenderer(class$java$lang$Double == null ? (class$java$lang$Double = JTable.class$("java.lang.Double")) : class$java$lang$Double, "javax.swing.JTable$DoubleRenderer");
        this.setLazyRenderer(class$java$util$Date == null ? (class$java$util$Date = JTable.class$("java.util.Date")) : class$java$util$Date, "javax.swing.JTable$DateRenderer");
        this.setLazyRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = JTable.class$("javax.swing.Icon")) : class$javax$swing$Icon, "javax.swing.JTable$IconRenderer");
        this.setLazyRenderer(class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = JTable.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon, "javax.swing.JTable$IconRenderer");
        this.setLazyRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JTable.class$("java.lang.Boolean")) : class$java$lang$Boolean, "javax.swing.JTable$BooleanRenderer");
    }

    private void setLazyEditor(Class clazz, String string) {
        this.setLazyValue(this.defaultEditorsByColumnClass, clazz, string);
    }

    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new UIDefaults();
        this.setLazyEditor(class$java$lang$Object == null ? (class$java$lang$Object = JTable.class$("java.lang.Object")) : class$java$lang$Object, "javax.swing.JTable$GenericEditor");
        this.setLazyEditor(class$java$lang$Number == null ? (class$java$lang$Number = JTable.class$("java.lang.Number")) : class$java$lang$Number, "javax.swing.JTable$NumberEditor");
        this.setLazyEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JTable.class$("java.lang.Boolean")) : class$java$lang$Boolean, "javax.swing.JTable$BooleanEditor");
    }

    protected void initializeLocalVars() {
        this.getSelectionModel().setAnchorSelectionIndex(0);
        this.setOpaque(true);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setShowGrid(true);
        this.setAutoResizeMode(2);
        this.setRowHeight(16);
        this.setRowMargin(1);
        this.setRowSelectionAllowed(true);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.setPreferredScrollableViewportSize(new Dimension(450, 400));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.firePropertyChange("tableCellEditor", tableCellEditor2, tableCellEditor);
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        }
        return tableCellRenderer;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        boolean bl = this.isCellSelected(n, n2);
        boolean bl2 = this.selectionModel.getAnchorSelectionIndex() == n;
        boolean bl3 = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == n2;
        boolean bl4 = bl2 && bl3 && this.hasFocus();
        return tableCellRenderer.getTableCellRendererComponent(this, object, bl, bl4, n, n2);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        return tableCellEditor;
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        boolean bl;
        Object object = this.getValueAt(n, n2);
        Component component = tableCellEditor.getTableCellEditorComponent(this, object, bl = this.isCellSelected(n, n2), n, n2);
        if (component instanceof JComponent) {
            ((JComponent)component).setNextFocusableComponent(this);
        }
        return component;
    }

    public void removeEditor() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            this.requestFocus();
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint(rectangle);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        this.createDefaultRenderers();
        this.createDefaultEditors();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    void compWriteObjectNotify() {
        super.compWriteObjectNotify();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    protected String paramString() {
        String string;
        String string2 = this.gridColor != null ? this.gridColor.toString() : "";
        String string3 = this.showHorizontalLines ? "true" : "false";
        String string4 = string = this.showVerticalLines ? "true" : "false";
        String string5 = this.autoResizeMode == 0 ? "AUTO_RESIZE_OFF" : (this.autoResizeMode == 1 ? "AUTO_RESIZE_NEXT_COLUMN" : (this.autoResizeMode == 2 ? "AUTO_RESIZE_SUBSEQUENT_COLUMNS" : (this.autoResizeMode == 3 ? "AUTO_RESIZE_LAST_COLUMN" : (this.autoResizeMode == 4 ? "AUTO_RESIZE_ALL_COLUMNS" : ""))));
        String string6 = this.autoCreateColumnsFromModel ? "true" : "false";
        String string7 = this.preferredViewportSize != null ? this.preferredViewportSize.toString() : "";
        String string8 = this.rowSelectionAllowed ? "true" : "false";
        String string9 = this.cellSelectionEnabled ? "true" : "false";
        String string10 = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string11 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",autoCreateColumnsFromModel=" + string6 + ",autoResizeMode=" + string5 + ",cellSelectionEnabled=" + string9 + ",editingColumn=" + this.editingColumn + ",editingRow=" + this.editingRow + ",gridColor=" + string2 + ",preferredViewportSize=" + string7 + ",rowHeight=" + this.rowHeight + ",rowMargin=" + this.rowMargin + ",rowSelectionAllowed=" + string8 + ",selectionBackground=" + string11 + ",selectionForeground=" + string10 + ",showHorizontalLines=" + string3 + ",showVerticalLines=" + string;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTable();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleTable {
        int lastSelectedRow;
        int lastSelectedCol;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescription;
        private Accessible[] columnDescription;

        AccessibleJTable() {
            JTable.this.addPropertyChangeListener(this);
            JTable.this.getSelectionModel().addListSelectionListener(this);
            TableColumnModel tableColumnModel = JTable.this.getColumnModel();
            tableColumnModel.addColumnModelListener(this);
            tableColumnModel.getSelectionModel().addListSelectionListener(this);
            JTable.this.getModel().addTableModelListener(this);
            this.lastSelectedRow = JTable.this.getSelectedRow();
            this.lastSelectedCol = JTable.this.getSelectedColumn();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.compareTo("model") == 0) {
                if (object != null && object instanceof TableModel) {
                    ((TableModel)object).removeTableModelListener(this);
                }
                if (object2 != null && object2 instanceof TableModel) {
                    ((TableModel)object2).addTableModelListener(this);
                }
            } else if (string.compareTo("selectionModel") == 0) {
                Object object3 = propertyChangeEvent.getSource();
                if (object3 == JTable.this) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                } else if (object3 == JTable.this.getColumnModel()) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                }
            } else if (string.compareTo("columnModel") == 0) {
                TableColumnModel tableColumnModel;
                if (object != null && object instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object;
                    tableColumnModel.removeColumnModelListener(this);
                    tableColumnModel.getSelectionModel().removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object;
                    tableColumnModel.addColumnModelListener(this);
                    tableColumnModel.getSelectionModel().addListSelectionListener(this);
                }
            } else if (string.compareTo("tableCellEditor") == 0) {
                if (object != null && object instanceof TableCellEditor) {
                    ((TableCellEditor)object).removeCellEditorListener(this);
                }
                if (object2 != null && object2 instanceof TableCellEditor) {
                    ((TableCellEditor)object2).addCellEditorListener(this);
                }
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getColumn();
            if (n == -1) {
                n = 0;
                n2 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void tableRowsInserted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getColumn();
            if (n == -1) {
                n = 0;
                n2 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void tableRowsDeleted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getColumn();
            if (n == -1) {
                n = 0;
                n2 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = 1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getFromIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            int n2 = 1;
            AccessibleJTableModelChange accessibleJTableModelChange2 = new AccessibleJTableModelChange(n2, 0, 0, tableColumnModelEvent.getToIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange2);
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
            int n = JTable.this.getSelectedRow();
            int n2 = JTable.this.getSelectedColumn();
            if (n != this.lastSelectedRow || n2 != this.lastSelectedCol) {
                Accessible accessible = this.getAccessibleAt(this.lastSelectedRow, this.lastSelectedCol);
                Accessible accessible2 = this.getAccessibleAt(n, n2);
                this.firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
                this.lastSelectedRow = n;
                this.lastSelectedCol = n2;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JTable.this.columnAtPoint(point);
            int n2 = JTable.this.rowAtPoint(point);
            if (n != -1 && n2 != -1) {
                Serializable serializable;
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(n);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = JTable.this.getColumnClass(n);
                    tableCellRenderer = JTable.this.getDefaultRenderer((Class)serializable);
                }
                serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, n2, n);
                return new AccessibleJTableCell(JTable.this, n2, n, this.getAccessibleIndexAt(n2, n));
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JTable.this.getColumnCount() * JTable.this.getRowCount();
        }

        public Accessible getAccessibleChild(int n) {
            Serializable serializable;
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            TableColumn tableColumn = JTable.this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                serializable = JTable.this.getColumnClass(n2);
                tableCellRenderer = JTable.this.getDefaultRenderer((Class)serializable);
            }
            serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, n3, n2);
            return new AccessibleJTableCell(JTable.this, n3, n2, this.getAccessibleIndexAt(n3, n2));
        }

        public int getAccessibleSelectionCount() {
            int n = JTable.this.getSelectedRowCount();
            int n2 = JTable.this.getSelectedColumnCount();
            if (JTable.this.cellSelectionEnabled) {
                return n * n2;
            }
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                return n * JTable.this.getColumnCount() + n2 * JTable.this.getRowCount() - n * n2;
            }
            if (JTable.this.getRowSelectionAllowed()) {
                return n * JTable.this.getColumnCount();
            }
            if (JTable.this.getColumnSelectionAllowed()) {
                return n2 * JTable.this.getRowCount();
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n > this.getAccessibleSelectionCount()) {
                return null;
            }
            int n2 = JTable.this.getSelectedRowCount();
            int n3 = JTable.this.getSelectedColumnCount();
            int[] nArray = JTable.this.getSelectedRows();
            int[] nArray2 = JTable.this.getSelectedColumns();
            int n4 = JTable.this.getColumnCount();
            int n5 = JTable.this.getRowCount();
            if (JTable.this.cellSelectionEnabled) {
                int n6 = nArray[n / n3];
                int n7 = nArray2[n % n3];
                return this.getAccessibleChild(n6 * n4 + n7);
            }
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                int n8 = n;
                int n9 = nArray[0] == 0 ? 0 : 1;
                int n10 = 0;
                int n11 = -1;
                while (n10 < nArray.length) {
                    switch (n9) {
                        case 0: {
                            if (n8 < n4) {
                                int n12 = n8 % n4;
                                int n13 = nArray[n10];
                                return this.getAccessibleChild(n13 * n4 + n12);
                            }
                            n8 -= n4;
                            if (n10 + 1 == nArray.length || nArray[n10] != nArray[n10 + 1] - 1) {
                                n9 = 1;
                                n11 = nArray[n10];
                            }
                            ++n10;
                            break;
                        }
                        case 1: {
                            if (n8 < n3 * (nArray[n10] - (n11 == -1 ? 0 : n11 + 1))) {
                                int n14 = nArray2[n8 % n3];
                                int n15 = (n10 > 0 ? nArray[n10 - 1] + 1 : 0) + n8 / n3;
                                return this.getAccessibleChild(n15 * n4 + n14);
                            }
                            n8 -= n3 * (nArray[n10] - (n11 == -1 ? 0 : n11 + 1));
                            n9 = 0;
                        }
                    }
                }
                if (n8 < n3 * (n5 - (n11 == -1 ? 0 : n11 + 1))) {
                    int n16 = nArray2[n8 % n3];
                    int n17 = nArray[n10 - 1] + n8 / n3 + 1;
                    return this.getAccessibleChild(n17 * n4 + n16);
                }
            } else {
                if (JTable.this.getRowSelectionAllowed()) {
                    int n18 = n % n4;
                    int n19 = nArray[n / n4];
                    return this.getAccessibleChild(n19 * n4 + n18);
                }
                if (JTable.this.getColumnSelectionAllowed()) {
                    int n20 = nArray2[n % n3];
                    int n21 = n / n3;
                    return this.getAccessibleChild(n21 * n4 + n20);
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            int n2 = this.getAccessibleColumnAtIndex(n);
            int n3 = this.getAccessibleRowAtIndex(n);
            return JTable.this.isCellSelected(n3, n2);
        }

        public void addAccessibleSelection(int n) {
            if (JTable.this.cellSelectionEnabled) {
                int n2 = this.getAccessibleColumnAtIndex(n);
                int n3 = this.getAccessibleRowAtIndex(n);
                JTable.this.addRowSelectionInterval(n3, n3);
                JTable.this.addColumnSelectionInterval(n2, n2);
            }
        }

        public void removeAccessibleSelection(int n) {
            if (JTable.this.cellSelectionEnabled) {
                int n2 = this.getAccessibleColumnAtIndex(n);
                int n3 = this.getAccessibleRowAtIndex(n);
                JTable.this.removeRowSelectionInterval(n3, n3);
                JTable.this.removeColumnSelectionInterval(n2, n2);
            }
        }

        public void clearAccessibleSelection() {
            JTable.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            if (JTable.this.cellSelectionEnabled) {
                JTable.this.selectAll();
            }
        }

        public AccessibleTable getAccessibleTable() {
            return this;
        }

        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        public void setAccessibleCaption(Accessible accessible) {
            Accessible accessible2 = this.caption;
            this.caption = accessible;
            this.firePropertyChange("accessibleTableCaptionChanged", accessible2, this.caption);
        }

        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        public void setAccessibleSummary(Accessible accessible) {
            Accessible accessible2 = this.summary;
            this.summary = accessible;
            this.firePropertyChange("accessibleTableSummaryChanged", accessible2, this.summary);
        }

        public int getAccessibleRowCount() {
            return JTable.this.getRowCount();
        }

        public int getAccessibleColumnCount() {
            return JTable.this.getColumnCount();
        }

        public Accessible getAccessibleAt(int n, int n2) {
            return this.getAccessibleChild(n * this.getAccessibleColumnCount() + n2);
        }

        public int getAccessibleRowExtentAt(int n, int n2) {
            return 1;
        }

        public int getAccessibleColumnExtentAt(int n, int n2) {
            return 1;
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        public AccessibleTable getAccessibleColumnHeader() {
            JTableHeader jTableHeader = JTable.this.getTableHeader();
            AccessibleContext accessibleContext = jTableHeader.getAccessibleContext();
            if (accessibleContext != null) {
                AbstractTableModel abstractTableModel = new AbstractTableModel(this, accessibleContext){
                    private final /* synthetic */ AccessibleContext val$ac;
                    private final /* synthetic */ AccessibleJTable this$1;
                    {
                        this.this$1 = accessibleJTable;
                        this.val$ac = accessibleContext;
                    }

                    public int getColumnCount() {
                        return this.val$ac.getAccessibleChildrenCount();
                    }

                    public int getRowCount() {
                        return 1;
                    }

                    public Object getValueAt(int n, int n2) {
                        return this.val$ac.getAccessibleChild(n2);
                    }
                };
                JTable jTable = new JTable(abstractTableModel);
                AccessibleContext accessibleContext2 = jTable.getAccessibleContext();
                if (accessibleContext2 != null) {
                    return accessibleContext2.getAccessibleTable();
                }
                return null;
            }
            return null;
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public Accessible getAccessibleRowDescription(int n) {
            if (n < 0 || n >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(n).toString());
            }
            if (this.rowDescription == null) {
                return null;
            }
            return this.rowDescription[n];
        }

        public void setAccessibleRowDescription(int n, Accessible accessible) {
            if (n < 0 || n >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(n).toString());
            }
            if (this.rowDescription == null) {
                int n2 = this.getAccessibleRowCount();
                this.rowDescription = new Accessible[n2];
            }
            this.rowDescription[n] = accessible;
        }

        public Accessible getAccessibleColumnDescription(int n) {
            if (n < 0 || n >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(n).toString());
            }
            if (this.columnDescription == null) {
                return null;
            }
            return this.columnDescription[n];
        }

        public void setAccessibleColumnDescription(int n, Accessible accessible) {
            if (n < 0 || n >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(n).toString());
            }
            if (this.columnDescription == null) {
                int n2 = this.getAccessibleColumnCount();
                this.columnDescription = new Accessible[n2];
            }
            this.columnDescription[n] = accessible;
        }

        public boolean isAccessibleSelected(int n, int n2) {
            return JTable.this.isCellSelected(n, n2);
        }

        public boolean isAccessibleRowSelected(int n) {
            return JTable.this.isRowSelected(n);
        }

        public boolean isAccessibleColumnSelected(int n) {
            return JTable.this.isColumnSelected(n);
        }

        public int[] getSelectedAccessibleRows() {
            return JTable.this.getSelectedRows();
        }

        public int[] getSelectedAccessibleColumns() {
            return JTable.this.getSelectedColumns();
        }

        public int getAccessibleRowAtIndex(int n) {
            return n / this.getAccessibleColumnCount();
        }

        public int getAccessibleColumnAtIndex(int n) {
            return n % this.getAccessibleColumnCount();
        }

        public int getAccessibleIndexAt(int n, int n2) {
            return n * this.getAccessibleColumnCount() + n2;
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable parent;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(JTable jTable, int n, int n2, int n3) {
                this.parent = jTable;
                this.row = n;
                this.column = n2;
                this.index = n3;
                this.setAccessibleParent(this.parent);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Serializable serializable;
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer((Class)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, JTable.this.getValueAt(this.row, this.column), false, false, this.row, this.column)) instanceof Accessible) {
                    return ((Accessible)((Object)serializable)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class clazz = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer(clazz);
                }
                return tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, this.row, this.column);
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                Rectangle rectangle2;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                if ((rectangle2 = JTable.this.getVisibleRect()).intersects(rectangle = JTable.this.getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.parent.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                if (this.row == JTable.this.getSelectedRow() && this.column == JTable.this.getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                return this.parent;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl);
                    }
                }
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellRect(this.row, this.column, false);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(int n, int n2, int n3, int n4, int n5) {
                this.type = n;
                this.firstRow = n2;
                this.lastRow = n3;
                this.firstColumn = n4;
                this.lastColumn = n5;
            }

            public int getType() {
                return this.type;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    static class GenericEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = GenericEditor.class$("java.lang.String")) : class$java$lang$String};
        Constructor constructor;
        Object value;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Object;

        public GenericEditor() {
            super(new JTextField());
        }

        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == (class$java$lang$String == null ? (class$java$lang$String = GenericEditor.class$("java.lang.String")) : class$java$lang$String)) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(new Object[]{string});
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class clazz = jTable.getColumnClass(n2);
                if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = GenericEditor.class$("java.lang.Object")) : class$java$lang$Object)) {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = GenericEditor.class$("java.lang.String")) : class$java$lang$String;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private static interface Resizable3
    extends Resizable2 {
        public int getMidPointAt(int var1);
    }

    private static interface Resizable2 {
        public int getElementCount();

        public int getLowerBoundAt(int var1);

        public int getUpperBoundAt(int var1);

        public void setSizeAt(int var1, int var2);
    }
}

