/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ImageIcon
implements Icon,
Serializable,
Accessible {
    private transient String filename;
    private transient URL location;
    transient Image image;
    transient int loadStatus = 0;
    ImageObserver imageObserver;
    String description = null;
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    int width = -1;
    int height = -1;
    private AccessibleImageIcon accessibleContext = null;

    public ImageIcon(String string, String string2) {
        this.image = Toolkit.getDefaultToolkit().getImage(string);
        if (this.image == null) {
            return;
        }
        this.filename = string;
        this.description = string2;
        this.loadImage(this.image);
    }

    public ImageIcon(String string) {
        this(string, string);
    }

    public ImageIcon(URL uRL, String string) {
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (this.image == null) {
            return;
        }
        this.location = uRL;
        this.description = string;
        this.loadImage(this.image);
    }

    public ImageIcon(URL uRL) {
        this(uRL, uRL.toExternalForm());
    }

    public ImageIcon(Image image, String string) {
        this(image);
        this.description = string;
    }

    public ImageIcon(Image image) {
        this.image = image;
        Object object = image.getProperty("comment", this.imageObserver);
        if (object instanceof String) {
            this.description = (String)object;
        }
        this.loadImage(image);
    }

    public ImageIcon(byte[] byArray, String string) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        this.description = string;
        this.loadImage(this.image);
    }

    public ImageIcon(byte[] byArray) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        Object object = this.image.getProperty("comment", this.imageObserver);
        if (object instanceof String) {
            this.description = (String)object;
        }
        this.loadImage(this.image);
    }

    public ImageIcon() {
    }

    protected void loadImage(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 20000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            this.loadStatus = tracker.statusID(0, false);
            tracker.removeImage(image, 0);
            this.width = image.getWidth(this.imageObserver);
            this.height = image.getHeight(this.imageObserver);
        }
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.imageObserver == null) {
            graphics.drawImage(this.image, n, n2, component);
        } else {
            graphics.drawImage(this.image, n, n2, this.imageObserver);
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public String toString() {
        return this.description;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int[] nArray = (int[])objectInputStream.readObject();
        if (nArray != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ColorModel colorModel = ColorModel.getRGBdefault();
            this.image = toolkit.createImage(new MemoryImageSource(n, n2, colorModel, nArray, 0, n));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int[] nArray;
        objectOutputStream.defaultWriteObject();
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        int[] nArray2 = nArray = this.image != null ? new int[n * n2] : null;
        if (this.image != null) {
            try {
                PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, n, n2, nArray, 0, n);
                pixelGrabber.grabPixels();
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    throw new IOException("failed to load image contents");
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("image load interrupted");
            }
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(n2);
        objectOutputStream.writeObject(nArray);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageIcon();
        }
        return this.accessibleContext;
    }

    protected class AccessibleImageIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        protected AccessibleImageIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return ImageIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            ImageIcon.this.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return ImageIcon.this.height;
        }

        public int getAccessibleIconWidth() {
            return ImageIcon.this.width;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }
}

