/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Util;
import javax.rmi.GetORBPropertiesFileAction;
import org.omg.CORBA.INITIALIZE;

public class PortableRemoteObject {
    private static PortableRemoteObjectDelegate proDelegate = null;
    private static final String PortableRemoteObjectClassKey = "javax.rmi.CORBA.PortableRemoteObjectClass";
    private static final String defaultPortableRemoteObjectImplName = "com.ibm.rmi.javax.rmi.PortableRemoteObject";

    protected PortableRemoteObject() throws RemoteException {
        PortableRemoteObject.exportObject((Remote)((Object)this));
    }

    public static void exportObject(Remote remote) throws RemoteException {
        if (proDelegate != null) {
            proDelegate.exportObject(remote);
        }
    }

    public static Remote toStub(Remote remote) throws NoSuchObjectException {
        if (proDelegate != null) {
            return proDelegate.toStub(remote);
        }
        return null;
    }

    public static void unexportObject(Remote remote) throws NoSuchObjectException {
        if (proDelegate != null) {
            proDelegate.unexportObject(remote);
        }
    }

    public static Object narrow(Object object, Class clazz) throws ClassCastException {
        if (proDelegate != null) {
            return proDelegate.narrow(object, clazz);
        }
        return null;
    }

    public static void connect(Remote remote, Remote remote2) throws RemoteException {
        if (proDelegate != null) {
            proDelegate.connect(remote, remote2);
        }
    }

    private static Object createDelegateIfSpecified(final String string) {
        Properties properties;
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
        if (string2 == null && (properties = PortableRemoteObject.getORBPropertiesFile()) != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = defaultPortableRemoteObjectImplName;
        }
        if (string2 != null) {
            try {
                return Util.loadClass(string2, null, null).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new INITIALIZE("cannot instantiate " + string2);
            }
            catch (Exception exception) {
                throw new INITIALIZE("cannot instantiate " + string2);
            }
        }
        return null;
    }

    private static Properties getORBPropertiesFile() {
        return (Properties)AccessController.doPrivileged(new GetORBPropertiesFileAction());
    }

    static {
        proDelegate = (PortableRemoteObjectDelegate)PortableRemoteObject.createDelegateIfSpecified(PortableRemoteObjectClassKey);
    }
}

