/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.CORBA;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.rmi.CORBA.GetORBPropertiesFileAction;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public abstract class Stub
extends ObjectImpl
implements Serializable {
    private transient StubDelegate stubDelegate = null;
    private static Class stubDelegateClass = null;
    private static final String StubClassKey = "javax.rmi.CORBA.StubClass";
    private static final String defaultStubImplName = "com.ibm.rmi.javax.rmi.CORBA.StubDelegateImpl";

    protected Stub() {
        if (stubDelegateClass != null) {
            try {
                this.stubDelegate = (StubDelegate)stubDelegateClass.newInstance();
            }
            catch (Exception exception) {
                throw new INITIALIZE("cannot instantiate " + stubDelegateClass);
            }
        }
    }

    public int hashCode() {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            return this.stubDelegate.hashCode(this);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            return this.stubDelegate.equals(this, object);
        }
        return false;
    }

    public String toString() {
        String string;
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null && (string = this.stubDelegate.toString(this)) != null) {
            return string;
        }
        return super.toString();
    }

    public void connect(ORB oRB) throws RemoteException {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            this.stubDelegate.connect(this, oRB);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            this.stubDelegate.readObject(this, objectInputStream);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.stubDelegate == null) {
            this.setDefaultDelegate();
        }
        if (this.stubDelegate != null) {
            this.stubDelegate.writeObject(this, objectOutputStream);
        }
    }

    private void setDefaultDelegate() {
        if (stubDelegateClass != null) {
            try {
                this.stubDelegate = (StubDelegate)stubDelegateClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Object createDelegateIfSpecified(final String string) {
        Properties properties;
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
        if (string2 == null && (properties = Stub.getORBPropertiesFile()) != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = defaultStubImplName;
        }
        if (string2 != null) {
            try {
                return Util.loadClass(string2, null, null).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new INITIALIZE("cannot instantiate " + string2);
            }
            catch (Exception exception) {
                throw new INITIALIZE("cannot instantiate " + string2);
            }
        }
        return null;
    }

    private static Properties getORBPropertiesFile() {
        return (Properties)AccessController.doPrivileged(new GetORBPropertiesFileAction());
    }

    static {
        Object object = Stub.createDelegateIfSpecified(StubClassKey);
        if (object != null) {
            stubDelegateClass = object.getClass();
        }
    }
}

