/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import sun.rmi.transport.ObjectTable;

public abstract class RemoteObject
implements Remote,
Serializable {
    protected transient RemoteRef ref;
    private static final long serialVersionUID = -3215090123894869218L;

    protected RemoteObject() {
        this.ref = null;
    }

    protected RemoteObject(RemoteRef remoteRef) {
        this.ref = remoteRef;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote remote) throws NoSuchObjectException {
        if (remote instanceof RemoteStub) {
            return (RemoteStub)remote;
        }
        return ObjectTable.getStub(remote);
    }

    public int hashCode() {
        return this.ref == null ? super.hashCode() : this.ref.remoteHashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RemoteObject) {
            if (this.ref == null) {
                return object == this;
            }
            return this.ref.remoteEquals(((RemoteObject)object).ref);
        }
        if (object != null) {
            return object.equals(this);
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getName();
        return this.ref == null ? string : string + "[" + this.ref.remoteToString() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new MarshalException("Invalid remote object");
        }
        String string = this.ref.getRefClass(objectOutputStream);
        if (string == null || string.length() == 0) {
            objectOutputStream.writeUTF("");
            objectOutputStream.writeObject(this.ref);
        } else {
            objectOutputStream.writeUTF(string);
            this.ref.writeExternal(objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            String string = objectInputStream.readUTF();
            if (string == null || string.length() == 0) {
                this.ref = (RemoteRef)objectInputStream.readObject();
            } else {
                Class clazz = Class.forName("sun.rmi.server." + string);
                this.ref = (RemoteRef)clazz.newInstance();
                this.ref.readExternal(objectInputStream);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new UnmarshalException("Unable to create remote reference", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnmarshalException("Illegal access creating remote reference: " + illegalAccessException);
        }
    }
}

