/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.jvm.ExtendedSystem;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.FactoryURLClassLoader;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class URLClassLoader
extends SecureClassLoader {
    private URLClassPath ucp;
    private AccessControlContext acc;
    private ClassFinder loader = new ClassFinder();
    private static URLClassLoader extLoader = null;
    private static boolean attemptedExtLoader = false;

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory);
        this.acc = AccessController.getContext();
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    private static final String ibmJVMGetExcludedFields() {
        return new String("extloader");
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            this.loader.name = string;
            Class clazz = (Class)AccessController.doPrivileged(this.loader, this.acc);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                boolean bl;
                if (certificateArray.isSealed()) {
                    bl = certificateArray.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else {
                if (this == URLClassLoader.getStandardExtensionClassLoader()) {
                    Object object3;
                    String string2 = null;
                    if (null != object) {
                        object3 = ((Manifest)object).getMainAttributes();
                        string2 = ((Attributes)object3).getValue(ExtendedSystem.EXTENSION_COMPATIBLE);
                    }
                    if (null == string2) {
                        object3 = new File(uRL.getFile());
                        String string3 = ((File)object3).getCanonicalPath();
                        ExtendedSystem.setJVMUnresettableConditionally(65556, new String("Unchecked extension loading class: " + string + " from path " + string3));
                    }
                }
                if (object != null) {
                    this.definePackage((String)object2, (Manifest)object, uRL);
                } else {
                    this.definePackage((String)object2, null, null, null, null, null, null, null);
                }
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    private static ClassLoader getStandardExtensionClassLoader() {
        if (!attemptedExtLoader) {
            attemptedExtLoader = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Launcher launcher = Launcher.getLauncher();
                        Class clazz = launcher.getClass();
                        Field field = clazz.getDeclaredField("extLoader");
                        field.setAccessible(true);
                        extLoader = (URLClassLoader)field.get(launcher);
                        field.setAccessible(false);
                        return Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        throw new InternalError(exception.toString());
                    }
                }
            });
        }
        return extLoader;
    }

    private static File[] getCheckedExtDirs() {
        File[] fileArray;
        String string = System.getProperty("java.checked.ext.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            int n = stringTokenizer.countTokens();
            fileArray = new File[n];
            int n2 = 0;
            while (n2 < n) {
                fileArray[n2] = new File(stringTokenizer.nextToken());
                ++n2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    private static Vector getCheckedExtURLs(File[] fileArray) throws IOException {
        Vector vector = new Vector();
        int n = 0;
        while (n < fileArray.length) {
            String[] stringArray = fileArray[n].list();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    File file = new File(fileArray[n], stringArray[n2]);
                    vector.add(file.getCanonicalPath());
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public URL findResource(String string) {
        if (null == string) {
            return null;
        }
        final String string2 = new String(string);
        Resource resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.ucp.getResource(string2, true);
            }
        }, this.acc);
        return resource != null ? this.ucp.checkURL(resource.getURL()) : null;
    }

    public Enumeration findResources(String string) throws IOException {
        final Enumeration enumeration = this.ucp.getResources(string, true);
        return new Enumeration(){
            private URL res;

            public Object nextElement() {
                if (this.res == null) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.res;
                this.res = null;
                return uRL;
            }

            public boolean hasMoreElements() {
                Resource resource;
                if (this.res != null) {
                    return true;
                }
                while ((resource = (Resource)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object run() {
                        if (!3.access$200(this.this$1).hasMoreElements()) {
                            return null;
                        }
                        return 3.access$200(this.this$1).nextElement();
                    }
                }, URLClassLoader.this.acc)) != null) {
                    this.res = URLClassLoader.this.ucp.checkURL(resource.getURL());
                    if (this.res == null) continue;
                }
                return this.res != null;
            }

            static /* synthetic */ Enumeration access$200(3 var0) {
                return var0.enumeration;
            }
        };
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Permission permission;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            permission = uRL.openConnection().getPermission();
        }
        catch (IOException iOException) {
            permission = null;
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
                permission = new FilePermission((String)object, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object = uRL.getFile().replace('/', File.separatorChar);
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
            }
            permission = new FilePermission((String)object, "read");
        } else {
            object = uRL.getHost();
            if (object == null) {
                object = "localhost";
            }
            permission = new SocketPermission((String)object, "connect, accept");
        }
        if (permission != null) {
            object = System.getSecurityManager();
            if (object != null) {
                Permission permission2 = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object, permission2){
                    private final /* synthetic */ SecurityManager val$sm;
                    private final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray, classLoader);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    final class ClassFinder
    implements PrivilegedExceptionAction {
        String name;

        ClassFinder() {
        }

        public Object run() throws ClassNotFoundException {
            String string = this.name.replace('.', '/').concat(".class");
            try {
                Resource resource = URLClassLoader.this.ucp.getResource(string, false);
                if (resource != null) {
                    return URLClassLoader.this.defineClass(this.name, resource);
                }
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(this.name, iOException);
            }
            return null;
        }
    }
}

