/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private BigInteger intVal;
    private long intLong;
    private static final long MAX_DIGITS = 18L;
    private static final long MAX_LONG = 0x7FFFFFFFFFFFFFFEL;
    private static final long MIN_LONG = -9223372036854775807L;
    private static final long NO_LONG = Long.MIN_VALUE;
    private int scale = 0;
    private static final long serialVersionUID = 6108874887143696463L;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public BigDecimal(String string) {
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigDecimal");
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        String string2 = string;
        String string3 = "";
        int n = 0;
        int n2 = string.length();
        this.scale = 0;
        int n3 = string.indexOf(46);
        int n4 = string.indexOf(101);
        if (n4 == -1) {
            n4 = string.indexOf(69);
        }
        if (n4 != -1) {
            String string4 = string.substring(n4 + 1);
            if (string4.length() == 0) {
                throw new NumberFormatException();
            }
            if (string4.charAt(0) == '+' && (string4 = string4.substring(1)).charAt(0) == '-') {
                throw new NumberFormatException();
            }
            n = Integer.parseInt(string4);
            n2 = n4;
            string2 = string.substring(0, n4);
        }
        if (n3 != -1) {
            if (n3 == 0 && string.charAt(n3 + 1) == '-') {
                throw new NumberFormatException();
            }
            string3 = string.substring(n3 + 1, n2--);
            this.scale = string3.length();
            string2 = string2.substring(0, n3);
        }
        this.scale -= n;
        if (this.scale < 0) {
            n2 -= this.scale;
        }
        if ((long)n2 <= 18L) {
            this.intLong = Long.parseLong(string2 + string3);
            while (this.scale < 0) {
                this.intLong *= 10L;
                ++this.scale;
            }
        } else {
            this.intLong = Long.MIN_VALUE;
            this.intVal = new BigInteger(string2 + string3);
            if (this.scale < 0) {
                this.intVal = BigDecimal.timesTenToThe(this.intVal, -this.scale);
                this.scale = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal(double var1_1) {
        super();
        if (Double.isInfinite(var1_1) || Double.isNaN(var1_1)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        var3_2 = Double.doubleToLongBits(var1_1);
        var5_3 = var3_2 >> 63 == 0L ? 1 : -1;
        var6_4 = (int)(var3_2 >> 52 & 2047L);
        var7_5 = var6_4 == 0 ? (var3_2 & 0xFFFFFFFFFFFFFL) << 1 : var3_2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        var6_4 -= 1075;
        if (var7_5 != 0L) ** GOTO lbl15
        this.intLong = 0L;
        return;
lbl-1000:
        // 1 sources

        {
            var7_5 >>= 1;
            ++var6_4;
lbl15:
            // 2 sources

            ** while ((var7_5 & 1L) == 0L)
        }
lbl16:
        // 1 sources

        this.intLong = (long)var5_3 * var7_5;
        var9_6 = 1L;
        if (var6_4 < 0 && var6_4 > -57) {
            var11_7 = var6_4;
            while (var11_7 < 0) {
                var9_6 *= 5L;
                ++var11_7;
            }
            this.multIntLong(var9_6);
            this.scale = -var6_4;
        }
        if (var6_4 > 0 && var6_4 < 57) {
            var11_7 = var6_4;
            while (var11_7 > 0) {
                var9_6 *= 2L;
                --var11_7;
            }
            this.multIntLong(var9_6);
        } else {
            this.intLong = -9223372036854775808L;
            this.intVal = BigInteger.valueOf((long)var5_3 * var7_5);
            if (var6_4 < 0) {
                this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-var6_4));
                this.scale = -var6_4;
            } else if (var6_4 > 0) {
                this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(var6_4));
            }
        }
    }

    public BigDecimal(BigInteger bigInteger) {
        this.intVal = bigInteger;
        this.intLong = Long.MIN_VALUE;
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        if (n < 0) {
            throw new NumberFormatException("Negative scale");
        }
        this.intVal = bigInteger;
        this.scale = n;
        this.intLong = Long.MIN_VALUE;
    }

    private BigDecimal(long l, int n) {
        if (n < 0) {
            throw new NumberFormatException("Negative scale");
        }
        if (l > 0x7FFFFFFFFFFFFFFEL || l < -9223372036854775807L) {
            this.intLong = Long.MIN_VALUE;
            this.intVal = BigInteger.valueOf(l);
        } else {
            this.intLong = l;
        }
        this.scale = n;
    }

    public static BigDecimal valueOf(long l, int n) {
        return new BigDecimal(l, n);
    }

    public static BigDecimal valueOf(long l) {
        return new BigDecimal(l, 0);
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        long l = bigDecimalArray[0].intLong;
        long l2 = bigDecimalArray[1].intLong;
        if (l != Long.MIN_VALUE & l2 != Long.MIN_VALUE) {
            boolean bl = false;
            if (l < 0L) {
                if (l2 < 0L && l2 < -9223372036854775807L - l) {
                    bl = true;
                }
            } else if (l2 > 0L && l2 > 0x7FFFFFFFFFFFFFFEL - l) {
                bl = true;
            }
            if (!bl) {
                return new BigDecimal(l + l2, bigDecimalArray[0].scale);
            }
        }
        if (bigDecimalArray[0].intVal == null) {
            bigDecimalArray[0].intVal = BigInteger.valueOf(l);
        }
        if (bigDecimalArray[1].intVal == null) {
            bigDecimalArray[1].intVal = BigInteger.valueOf(l2);
        }
        return new BigDecimal(bigDecimalArray[0].intVal.add(bigDecimalArray[1].intVal), bigDecimalArray[0].scale);
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        long l = bigDecimalArray[0].intLong;
        long l2 = bigDecimalArray[1].intLong;
        if (l != Long.MIN_VALUE & l2 != Long.MIN_VALUE) {
            boolean bl = false;
            if (l < 0L) {
                if (l2 < 0L && l2 < -9223372036854775807L + l) {
                    bl = true;
                }
            } else if (l2 > 0L && l2 > 0x7FFFFFFFFFFFFFFEL + l) {
                bl = true;
            }
            if (!bl) {
                return new BigDecimal(l - l2, bigDecimalArray[0].scale);
            }
        }
        if (bigDecimalArray[0].intVal == null) {
            bigDecimalArray[0].intVal = BigInteger.valueOf(l);
        }
        if (bigDecimalArray[1].intVal == null) {
            bigDecimalArray[1].intVal = BigInteger.valueOf(l2);
        }
        return new BigDecimal(bigDecimalArray[0].intVal.subtract(bigDecimalArray[1].intVal), bigDecimalArray[0].scale);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        long l;
        long l2 = this.intLong;
        if (l2 != Long.MIN_VALUE & (l = bigDecimal.intLong) != Long.MIN_VALUE) {
            boolean bl = false;
            if (l != 0L) {
                if (l2 < 0L) {
                    if (l < 0L) {
                        if (l2 < 0x7FFFFFFFFFFFFFFEL / l) {
                            bl = true;
                        }
                    } else if (l2 < -9223372036854775807L / l) {
                        bl = true;
                    }
                } else if (l < 0L) {
                    if (l2 > -9223372036854775807L / l) {
                        bl = true;
                    }
                } else if (l2 > 0x7FFFFFFFFFFFFFFEL / l) {
                    bl = true;
                }
            }
            if (!bl) {
                return new BigDecimal(l2 * l, this.scale + bigDecimal.scale);
            }
        }
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(l2);
        }
        if (bigDecimal.intVal == null) {
            bigDecimal.intVal = BigInteger.valueOf(l);
        }
        return new BigDecimal(this.intVal.multiply(bigDecimal.intVal), this.scale + bigDecimal.scale);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        int n3;
        if (n < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        int n4 = n;
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = bigDecimal;
        int n5 = this.scale - bigDecimal.scale;
        if ((long)n4 < 18L) {
            if (n4 != n5) {
                if (n5 < n4) {
                    bigDecimal2 = this.scaleUp(this, n4 - n5);
                } else {
                    bigDecimal3 = this.scaleUp(bigDecimal, n5 - n4);
                }
            }
            if (bigDecimal2.intLong != Long.MIN_VALUE && bigDecimal3.intLong != Long.MIN_VALUE) {
                long l = bigDecimal2.intLong / bigDecimal3.intLong;
                long l2 = bigDecimal2.intLong % bigDecimal3.intLong;
                if (l2 != 0L) {
                    switch (n2) {
                        case 0: {
                            if (l2 > 0L) {
                                l = l >= 0L ? ++l : --l;
                            }
                            if (l2 >= 0L) break;
                            if (l <= 0L) {
                                --l;
                                break;
                            }
                            ++l;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (l2 > 0L) {
                                ++l;
                            }
                            if (l2 >= 0L || l <= 0L) break;
                            ++l;
                            break;
                        }
                        case 3: {
                            if (l2 >= 0L || l > 0L) break;
                            --l;
                            break;
                        }
                        case 4: {
                            long l3 = l2 * 10L / bigDecimal3.intLong;
                            if (l3 >= 5L) {
                                ++l;
                            }
                            if (l3 > -5L) break;
                            --l;
                            break;
                        }
                        case 5: {
                            if (l > 0L) {
                                if (l2 > 0L) {
                                    if (l2 * 2L <= bigDecimal3.intLong) break;
                                    ++l;
                                    break;
                                }
                                if (l2 * -2L >= bigDecimal3.intLong) break;
                                ++l;
                                break;
                            }
                            if (l2 > 0L) {
                                if (l2 * 2L <= bigDecimal3.intLong) break;
                                ++l;
                                break;
                            }
                            if (l2 * -2L <= bigDecimal3.intLong) break;
                            --l;
                            break;
                        }
                        case 6: {
                            if (l % 2L == 0L) {
                                if (l > 0L) {
                                    if (l2 > 0L) {
                                        if (l2 * 2L <= bigDecimal3.intLong) break;
                                        ++l;
                                        break;
                                    }
                                    if (l2 * 2L >= bigDecimal3.intLong) break;
                                    ++l;
                                    break;
                                }
                                if (l2 > 0L) {
                                    if (l2 * 2L <= bigDecimal3.intLong) break;
                                    ++l;
                                    break;
                                }
                                if (l2 * -2L <= bigDecimal3.intLong) break;
                                --l;
                                break;
                            }
                            long l4 = l2 * 10L / bigDecimal3.intLong;
                            if (l4 >= 5L) {
                                ++l;
                                break;
                            }
                            if (l4 > -5L) break;
                            --l;
                            break;
                        }
                        case 7: {
                            if (l2 == 0L) break;
                            throw new ArithmeticException("BigDecimal: Rounding necessary");
                        }
                        default: {
                            throw new IllegalArgumentException("BigDecimal: Invalid rounding mode");
                        }
                    }
                }
                return new BigDecimal(l, n4);
            }
        } else if (n + bigDecimal.scale >= this.scale) {
            bigDecimal2 = this.setScale(n + bigDecimal.scale);
            bigDecimal3 = bigDecimal;
        } else {
            bigDecimal2 = this;
            bigDecimal3 = bigDecimal.setScale(this.scale - n);
        }
        if (bigDecimal2.intVal == null) {
            bigDecimal2.intVal = BigInteger.valueOf(bigDecimal2.intLong);
        }
        if (bigDecimal3.intVal == null) {
            bigDecimal3.intVal = BigInteger.valueOf(bigDecimal3.intLong);
        }
        BigInteger[] bigIntegerArray = bigDecimal2.intVal.divideAndRemainder(bigDecimal3.intVal);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        if (bigInteger2.signum() == 0) {
            return new BigDecimal(bigInteger, n);
        }
        if (n2 == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int n6 = bigDecimal2.signum() * bigDecimal3.signum();
        boolean bl = n2 == 0 ? true : (n2 == 1 ? false : (n2 == 2 ? n6 > 0 : (n2 == 3 ? n6 < 0 : ((n3 = bigInteger2.abs().multiply(BigInteger.valueOf(2L)).compareTo(bigDecimal3.intVal.abs())) < 0 ? false : (n3 > 0 ? true : (n2 == 4 ? true : (n2 == 5 ? false : bigInteger.testBit(0))))))));
        return bl ? new BigDecimal(bigInteger.add(BigInteger.valueOf(n6)), n) : new BigDecimal(bigInteger, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal abs() {
        if (this.intLong != Long.MIN_VALUE) {
            if (this.intLong < 0L) {
                return new BigDecimal(-this.intLong, this.scale);
            }
            return this;
        }
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal negate() {
        if (this.intLong != Long.MIN_VALUE) {
            return new BigDecimal(-this.intLong, this.scale);
        }
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public int signum() {
        if (this.intLong != Long.MIN_VALUE) {
            if (this.intLong > 0L) {
                return 1;
            }
            if (this.intLong < 0L) {
                return -1;
            }
            return 0;
        }
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        if (this.intLong != Long.MIN_VALUE && this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intLong);
        }
        return this.intVal;
    }

    public BigDecimal setScale(int n, int n2) {
        if (n < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (n == this.scale) {
            return this;
        }
        if (n > this.scale) {
            return this.scaleUp(this, n - this.scale);
        }
        if ((long)n < 18L) {
            return this.divide(this.scaleUp(BigDecimal.valueOf(1L), n), n, n2);
        }
        return this.divide(BigDecimal.valueOf(1L), n, n2);
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, 7);
    }

    public BigDecimal movePointLeft(int n) {
        if (this.intLong != Long.MIN_VALUE) {
            return n >= 0 ? new BigDecimal(this.intLong, this.scale + n) : this.movePointRight(-n);
        }
        return n >= 0 ? new BigDecimal(this.intVal, this.scale + n) : this.movePointRight(-n);
    }

    public BigDecimal movePointRight(int n) {
        if (this.intLong != Long.MIN_VALUE) {
            if (this.scale >= n) {
                return new BigDecimal(this.intLong, this.scale - n);
            }
            if ((long)n < 18L) {
                long l;
                long l2 = 1L;
                int n2 = 0;
                while (n2 < n) {
                    l2 *= 10L;
                    ++n2;
                }
                if (this.intLong < 0L & -this.intLong < (l = 0x7FFFFFFFFFFFFFFEL / l2) || this.intLong >= 0L & this.intLong < l) {
                    return new BigDecimal(this.intLong * l2, this.scale);
                }
                return new BigDecimal(BigDecimal.timesTenToThe(BigInteger.valueOf(this.intLong), n - this.scale), 0);
            }
        }
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intLong);
        }
        return this.scale >= n ? new BigDecimal(this.intVal, this.scale - n) : new BigDecimal(BigDecimal.timesTenToThe(this.intVal, n - this.scale), 0);
    }

    public int compareTo(BigDecimal bigDecimal) {
        int n;
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        if (bigDecimalArray[0].scale != bigDecimalArray[1].scale) {
            BigDecimal.matchScale(bigDecimalArray);
        }
        if (bigDecimalArray[0].intLong != Long.MIN_VALUE && bigDecimalArray[1].intLong != Long.MIN_VALUE) {
            if (bigDecimalArray[0].intLong == bigDecimalArray[1].intLong) {
                return 0;
            }
            if (bigDecimalArray[0].intLong < bigDecimalArray[1].intLong) {
                return -1;
            }
            return 1;
        }
        if (bigDecimalArray[0].intVal == null) {
            bigDecimalArray[0].intVal = BigInteger.valueOf(bigDecimalArray[0].intLong);
        }
        if (bigDecimalArray[1].intVal == null) {
            bigDecimalArray[1].intVal = BigInteger.valueOf(bigDecimalArray[1].intLong);
        }
        if ((n = this.signum() - bigDecimal.signum()) != 0) {
            return n > 0 ? 1 : -1;
        }
        return bigDecimalArray[0].intVal.compareTo(bigDecimalArray[1].intVal);
    }

    public int compareTo(Object object) {
        return this.compareTo((BigDecimal)object);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intLong);
        }
        if (bigDecimal.intVal == null) {
            bigDecimal.intVal = BigInteger.valueOf(bigDecimal.intLong);
        }
        return this.scale == bigDecimal.scale && this.intVal.equals(bigDecimal.intVal);
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) < 0 ? this : bigDecimal;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) > 0 ? this : bigDecimal;
    }

    public int hashCode() {
        if (this.intLong != Long.MIN_VALUE) {
            BigInteger bigInteger = BigInteger.valueOf(this.intLong);
            return 31 * bigInteger.hashCode() + this.scale;
        }
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        StringBuffer stringBuffer;
        String string;
        if (this.intLong != Long.MIN_VALUE) {
            if (this.scale == 0) {
                return Long.toString(this.intLong);
            }
            string = Long.toString(Math.abs(this.intLong));
        } else {
            string = this.intVal.abs().toString();
        }
        if (this.scale == 0) {
            return this.intVal.toString();
        }
        int n = this.signum();
        int n2 = string.length() - this.scale;
        if (n2 == 0) {
            return (n < 0 ? "-0." : "0.") + string;
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n2, '.');
            if (n < 0) {
                stringBuffer.insert(0, '-');
            }
        } else {
            stringBuffer = new StringBuffer(3 - n2 + string.length());
            stringBuffer.append(n < 0 ? "-0." : "0.");
            int n3 = 0;
            while (n3 < -n2) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intLong);
        }
        return this.scale == 0 ? this.intVal : this.intVal.divide(BigInteger.valueOf(10L).pow(this.scale));
    }

    public int intValue() {
        if (this.intLong != Long.MIN_VALUE && this.scale == 0) {
            return (int)this.intLong;
        }
        return this.toBigInteger().intValue();
    }

    public long longValue() {
        if (this.intLong != Long.MIN_VALUE && this.scale == 0) {
            return this.intLong;
        }
        return this.toBigInteger().longValue();
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    private void multIntLong(long l) {
        long l2;
        if (this.intLong < 0L & -this.intLong < (l2 = l < 0L ? -9223372036854775807L / l : 0x7FFFFFFFFFFFFFFEL / l) || this.intLong >= 0L & this.intLong < l2) {
            this.intLong *= l;
        } else {
            this.intVal = BigInteger.valueOf(this.intLong).multiply(BigInteger.valueOf(l));
            this.intLong = Long.MIN_VALUE;
        }
    }

    private BigDecimal scaleUp(BigDecimal bigDecimal, int n) {
        if (bigDecimal.intLong == Long.MIN_VALUE) {
            BigDecimal bigDecimal2 = new BigDecimal(BigDecimal.timesTenToThe(bigDecimal.intVal, n), bigDecimal.scale + n);
            return new BigDecimal(BigDecimal.timesTenToThe(bigDecimal.intVal, n), bigDecimal.scale + n);
        }
        long l = bigDecimal.intLong;
        if ((long)n < 18L) {
            long l2;
            long l3 = 1L;
            int n2 = 0;
            while (n2 < n) {
                l3 *= 10L;
                ++n2;
            }
            if (l < 0L & -l < (l2 = 0x7FFFFFFFFFFFFFFEL / l3) || l >= 0L & l < l2) {
                return new BigDecimal(l * l3, bigDecimal.scale + n);
            }
            return new BigDecimal(BigDecimal.timesTenToThe(BigInteger.valueOf(l), n), bigDecimal.scale + n);
        }
        return new BigDecimal(BigDecimal.timesTenToThe(BigInteger.valueOf(l), n), bigDecimal.scale + n);
    }

    private static BigInteger timesTenToThe(BigInteger bigInteger, int n) {
        return bigInteger.multiply(BigInteger.valueOf(10L).pow(n));
    }

    private static void matchScale(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray[0].scale < bigDecimalArray[1].scale) {
            bigDecimalArray[0] = bigDecimalArray[0].setScale(bigDecimalArray[1].scale);
        } else if (bigDecimalArray[1].scale < bigDecimalArray[0].scale) {
            bigDecimalArray[1] = bigDecimalArray[1].setScale(bigDecimalArray[0].scale);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.intLong = Long.MIN_VALUE;
        objectInputStream.defaultReadObject();
        if (this.scale < 0) {
            throw new StreamCorruptedException("BigDecimal: Negative scale");
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.intLong != Long.MIN_VALUE) {
            this.intVal = BigInteger.valueOf(this.intLong);
        }
        objectOutputStream.defaultWriteObject();
    }
}

