/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

class OS2Process
extends Process {
    private int handle = 0;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private int hqtermination = 0;
    private int sid = 0;
    private Object waitObj = null;
    private int rc = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OS2Process(String[] stringArray, String[] stringArray2) throws Exception {
        String string;
        StringBuffer stringBuffer = new StringBuffer(80);
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            int n2 = 0;
            while (n2 < string.length()) {
                if (string.charAt(n2) != ' ' && string.charAt(n2) != '\t') break;
                ++n2;
            }
            if (n2 > 0) {
                string = string.substring(n2);
            }
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                if (string.charAt(0) != '\"') {
                    stringBuffer.append(string);
                } else {
                    if (!string.endsWith("\"")) throw new IllegalArgumentException();
                    stringBuffer.append(string);
                }
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(' ');
            ++n;
        }
        string = stringBuffer.toString();
        String string2 = null;
        if (stringArray2 != null) {
            StringBuffer stringBuffer2 = new StringBuffer(256);
            int n3 = 0;
            while (n3 < stringArray2.length) {
                stringBuffer2.append(stringArray2[n3]).append('\u0000');
                ++n3;
            }
            string2 = stringBuffer2.toString();
        }
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.handle = this.create(string, string2, this.stdin_fd, this.stdout_fd, this.stderr_fd);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                OS2Process.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(OS2Process.this.stdin_fd));
                OS2Process.this.stdout_stream = new BufferedInputStream(new FileInputStream(OS2Process.this.stdout_fd));
                OS2Process.this.stderr_stream = new FileInputStream(OS2Process.this.stderr_fd);
                return null;
            }
        });
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public void finalize() {
        this.close();
    }

    private native int waitForUninterruptible();

    public int waitFor() throws InterruptedException {
        Object object;
        if (this.waitObj == null) {
            this.waitObj = new Object();
            object = new Thread(){

                public void run() {
                    OS2Process.this.rc = OS2Process.this.waitForUninterruptible();
                    Object object = OS2Process.this.waitObj;
                    synchronized (object) {
                        OS2Process.this.waitObj.notify();
                    }
                }
            };
            ((Thread)object).start();
        }
        object = this.waitObj;
        synchronized (object) {
            if ((this.handle & 0xFFFF0000) == 0) {
                this.waitObj.wait();
            }
        }
        return this.rc;
    }

    public native int exitValue();

    public native void destroy();

    private native int create(String var1, String var2, FileDescriptor var3, FileDescriptor var4, FileDescriptor var5);

    private native void close();
}

