/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class OS2FileSystem
extends FileSystem {
    private final char slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
    private final char altSlash;
    private final char semicolon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);
    private static String[] driveDirCache = new String[26];

    public OS2FileSystem() {
        this.altSlash = (char)(this.slash == '\\' ? 47 : 92);
    }

    private boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' || c <= 'Z';
    }

    private String slashify(String string) {
        if (string.length() > 0 && string.charAt(0) != this.slash) {
            return this.slash + string;
        }
        return string;
    }

    public char getSeparator() {
        return this.slash;
    }

    public char getPathSeparator() {
        return this.semicolon;
    }

    private int normalizePrefix(String string, int n, StringBuffer stringBuffer) {
        char c;
        int n2 = 0;
        while (n2 < n && this.isSlash(string.charAt(n2))) {
            ++n2;
        }
        if (n - n2 >= 2 && this.isLetter(c = string.charAt(n2)) && string.charAt(n2 + 1) == ':') {
            stringBuffer.append(c);
            stringBuffer.append(':');
            n2 += 2;
        } else {
            n2 = 0;
            if (n >= 2 && this.isSlash(string.charAt(0)) && this.isSlash(string.charAt(1))) {
                n2 = 1;
                stringBuffer.append(this.slash);
            }
        }
        return n2;
    }

    private String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        if (n2 < 3) {
            n2 = 0;
        }
        char c = this.slash;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (n2 == 0) {
            n3 = this.normalizePrefix(string, n, stringBuffer);
        } else {
            n3 = n2;
            stringBuffer.append(string.substring(0, n2));
        }
        while (n3 < n) {
            char c2;
            if (this.isSlash(c2 = string.charAt(n3++))) {
                while (n3 < n && this.isSlash(string.charAt(n3))) {
                    ++n3;
                }
                if (n3 == n) {
                    int n4 = stringBuffer.length();
                    if (n4 == 2 && stringBuffer.charAt(1) == ':') {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n4 == 0) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (n4 != 1 || !this.isSlash(stringBuffer.charAt(0))) break;
                    stringBuffer.append(c);
                    break;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public String normalize(String string) {
        int n = string.length();
        char c = this.slash;
        char c2 = this.altSlash;
        char c3 = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            char c4 = string.charAt(n2);
            if (c4 == c2) {
                return this.normalize(string, n, c3 == c ? n2 - 1 : n2);
            }
            if (c4 == c && c3 == c && n2 > 1) {
                return this.normalize(string, n, n2 - 1);
            }
            if (c4 == ':' && n2 > 1) {
                return this.normalize(string, n, 0);
            }
            c3 = c4;
            ++n2;
        }
        if (c3 == c) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    public int prefixLength(String string) {
        char c;
        char c2 = this.slash;
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char c3 = string.charAt(0);
        char c4 = c = n > 1 ? string.charAt(1) : (char)'\u0000';
        if (c3 == c2) {
            if (c == c2) {
                return 2;
            }
            return 1;
        }
        if (this.isLetter(c3) && c == ':') {
            if (n > 2 && string.charAt(2) == c2) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public String resolve(String string, String string2) {
        String string3;
        char c = this.slash;
        int n = string.length();
        if (n == 0) {
            return string2;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return string;
        }
        String string4 = string2;
        if (n2 > 1 && string4.charAt(0) == c) {
            string4 = string4.charAt(1) == c ? string4.substring(2) : string4.substring(1);
        }
        if ((string3 = string).charAt(n - 1) == c) {
            string3 = string3.substring(0, n - 1);
        }
        return string3 + this.slashify(string4);
    }

    public String getDefaultParent() {
        return "" + this.slash;
    }

    public boolean isAbsolute(File file) {
        int n = file.getPrefixLength();
        return n == 2 && file.getPath().charAt(0) == this.slash || n == 3;
    }

    private static native String getDriveDirectory(int var0);

    private static int driveIndex(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        return -1;
    }

    private static String getDriveDirectory(char c) {
        int n = OS2FileSystem.driveIndex(c);
        if (n < 0) {
            return null;
        }
        String string = driveDirCache[n];
        if (string != null) {
            return string;
        }
        OS2FileSystem.driveDirCache[n] = string = OS2FileSystem.getDriveDirectory(n + 1);
        return string;
    }

    private String getUserPath() {
        return this.normalize(System.getProperty("user.dir"));
    }

    private String getDrive(String string) {
        int n = this.prefixLength(string);
        return n == 3 ? string.substring(0, 2) : null;
    }

    public String resolve(File file) {
        String string = file.getPath();
        int n = file.getPrefixLength();
        if (n == 2 && string.charAt(0) == this.slash) {
            return string;
        }
        if (n == 3) {
            return string;
        }
        if (n == 0) {
            return this.getUserPath() + this.slashify(string);
        }
        if (n == 1) {
            String string2 = this.getUserPath();
            String string3 = this.getDrive(string2);
            if (string3 != null) {
                return string3 + string;
            }
            return string2 + string;
        }
        if (n == 2) {
            String string4 = this.getUserPath();
            String string5 = this.getDrive(string4);
            if (string5 != null && string.startsWith(string5)) {
                return string4 + this.slashify(string.substring(2));
            }
            char c = string.charAt(0);
            String string6 = OS2FileSystem.getDriveDirectory(c);
            if (string6 != null) {
                String string7 = "" + c + ':' + string6 + this.slashify(string.substring(2));
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkRead(string7);
                    }
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Cannot resolve path " + string);
                }
                return string7;
            }
            return c + ":" + this.slashify(string.substring(2));
        }
        throw new InternalError("Unresolvable path: " + string);
    }

    public native String canonicalize(String var1) throws IOException;

    public native int getBooleanAttributes(File var1);

    public native boolean checkAccess(File var1, boolean var2);

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public native boolean createFileExclusively(String var1) throws IOException;

    public native boolean delete(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public native String[] list(File var1);

    public native boolean createDirectory(File var1);

    public native boolean rename(File var1, File var2);

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean setReadOnly(File var1);

    private boolean access(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static native int listRoots0();

    public File[] listRoots() {
        int n = OS2FileSystem.listRoots0();
        int n2 = 0;
        int n3 = 0;
        while (n3 < 26) {
            if ((n >> n3 & 1) != 0) {
                if (!this.access((char)(65 + n3) + ":" + this.slash)) {
                    n &= ~(1 << n3);
                } else {
                    ++n2;
                }
            }
            ++n3;
        }
        File[] fileArray = new File[n2];
        int n4 = 0;
        char c = this.slash;
        int n5 = 0;
        while (n5 < 26) {
            if ((n >> n5 & 1) != 0) {
                fileArray[n4++] = new File((char)(65 + n5) + ":" + c);
            }
            ++n5;
        }
        return fileArray;
    }

    public int compare(File file, File file2) {
        return file.getPath().compareToIgnoreCase(file2.getPath());
    }

    public int hashCode(File file) {
        return file.getPath().toLowerCase().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        OS2FileSystem.initIDs();
    }
}

