/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.jvm.ExtendedSystem;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private boolean isClosed = false;

    private void ensureOpen() {
    }

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    public synchronized void write(int n) {
        this.ensureOpen();
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            this.buf = (byte[])ExtendedSystem.resizeArray(Math.max(this.buf.length << 1, n2), this.buf, 0, this.count);
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            this.buf = (byte[])ExtendedSystem.resizeArray(Math.max(this.buf.length << 1, n3), this.buf, 0, this.count);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public String toString(int n) {
        return new String(this.buf, n, 0, this.count);
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
    }
}

