/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int maxBitSize;
    private int scanlineStride;

    private static native void initIDs();

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
        this.dataType = n;
        this.bitMasks = (int[])nArray.clone();
        this.scanlineStride = n4;
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        this.maxBitSize = 0;
        int n5 = 0;
        while (n5 < this.numBands) {
            int n6 = 0;
            int n7 = 0;
            int n8 = nArray[n5];
            if (n8 != 0) {
                while ((n8 & 1) == 0) {
                    n8 >>>= 1;
                    ++n6;
                }
                while ((n8 & 1) == 1) {
                    n8 >>>= 1;
                    ++n7;
                }
                if (n8 != 0) {
                    throw new IllegalArgumentException("Mask " + nArray[n5] + " must be contiguous");
                }
            }
            this.bitOffsets[n5] = n6;
            this.bitSizes[n5] = n7;
            if (n7 > this.maxBitSize) {
                this.maxBitSize = n7;
            }
            ++n5;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    private long getBufferSize() {
        long l = this.scanlineStride * (this.height - 1) + this.width;
        return l;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(this.dataType, n, n2, this.bitMasks);
        return singlePixelPackedSampleModel;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n);
            }
        }
        return dataBuffer;
    }

    public int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        int n = 0;
        while (n < this.numBands) {
            nArray[n] = 0;
            int n2 = this.bitMasks[n] >>> this.bitOffsets[n];
            while ((n2 & 1) != 0) {
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
                n2 >>>= 1;
            }
            ++n;
        }
        return nArray;
    }

    public int getSampleSize(int n) {
        int n2 = 0;
        int n3 = this.bitMasks[n] >>> this.bitOffsets[n];
        while ((n3 & 1) != 0) {
            ++n2;
            n3 >>>= 1;
        }
        return n2;
    }

    public int getOffset(int n, int n2) {
        int n3 = n2 * this.scanlineStride + n;
        return n3;
    }

    public int[] getBitOffsets() {
        return (int[])this.bitOffsets.clone();
    }

    public int[] getBitMasks() {
        return (int[])this.bitMasks.clone();
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.numBands) {
            throw new RasterFormatException("There are only " + this.numBands + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.bitMasks[nArray[n]];
            ++n;
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                nArray[0] = dataBuffer.getElem(n2 * this.scanlineStride + n);
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray == null ? new int[this.numBands] : nArray;
        int n3 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray2[n4] = (n3 & this.bitMasks[n4]) >>> this.bitOffsets[n4];
            ++n4;
        }
        return nArray2;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n5 = n2 * this.scanlineStride + n;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = dataBuffer.getElem(n5 + n8);
                int n10 = 0;
                while (n10 < this.numBands) {
                    nArray2[n6++] = (n9 & this.bitMasks[n10]) >>> this.bitOffsets[n10];
                    ++n10;
                }
                ++n8;
            }
            n5 += this.scanlineStride;
            ++n7;
        }
        return nArray2;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        return (n4 & this.bitMasks[n3]) >>> this.bitOffsets[n3];
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = dataBuffer.getElem(n6 + n9);
                nArray2[n7++] = (n10 & this.bitMasks[n5]) >>> this.bitOffsets[n5];
                ++n9;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
        return nArray2;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, byArray[0] & 0xFF);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, sArray[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n2 * this.scanlineStride + n, nArray[0]);
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.numBands) {
            n3 |= nArray[n4] << this.bitOffsets[n4] & this.bitMasks[n4];
            ++n4;
        }
        dataBuffer.setElem(n2 * this.scanlineStride + n, n3);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n2 * this.scanlineStride + n;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = 0;
                int n10 = 0;
                while (n10 < this.numBands) {
                    int n11 = nArray[n6++];
                    n9 |= n11 << this.bitOffsets[n10] & this.bitMasks[n10];
                    ++n10;
                }
                dataBuffer.setElem(n5 + n8, n9);
                ++n8;
            }
            n5 += this.scanlineStride;
            ++n7;
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int n5 = dataBuffer.getElem(n2 * this.scanlineStride + n);
        n5 &= ~this.bitMasks[n3];
        dataBuffer.setElem(n2 * this.scanlineStride + n, n5 |= n4 << this.bitOffsets[n3] & this.bitMasks[n3]);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = n2 * this.scanlineStride + n;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = dataBuffer.getElem(n6 + n9);
                n10 &= ~this.bitMasks[n5];
                int n11 = nArray[n7++];
                dataBuffer.setElem(n6 + n9, n10 |= n11 << this.bitOffsets[n5] & this.bitMasks[n5]);
                ++n9;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
    }

    static {
        SinglePixelPackedSampleModel.initIDs();
    }
}

