/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands = 1;
    protected int numBanks = 1;
    protected int scanlineStride;
    protected int pixelStride;

    private static native void initIDs();

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super(n, n2, n3, nArray.length);
        this.dataType = n;
        this.pixelStride = n4;
        this.scanlineStride = n5;
        this.bandOffsets = (int[])nArray.clone();
        this.numBands = nArray.length;
        if (n4 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (this.numBands < 1) {
            throw new IllegalArgumentException("Must have at least one band.");
        }
        this.bankIndices = new int[this.numBands];
        int n6 = 0;
        while (n6 < this.numBands) {
            this.bankIndices[n6] = 0;
            ++n6;
        }
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, nArray2.length);
        this.dataType = n;
        this.pixelStride = n4;
        this.scanlineStride = n5;
        this.bandOffsets = (int[])nArray2.clone();
        this.bankIndices = (int[])nArray.clone();
        if (n4 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        int n6 = nArray[0];
        if (n6 < 0) {
            throw new IllegalArgumentException("Index of bank 0 is less than 0 (" + n6 + ")");
        }
        int n7 = 1;
        while (n7 < nArray.length) {
            if (nArray[n7] > n6) {
                n6 = nArray[n7];
            } else if (nArray[n7] < 0) {
                throw new IllegalArgumentException("Index of bank " + n7 + " is less than 0 (" + n6 + ")");
            }
            ++n7;
        }
        this.numBanks = n6 + 1;
        this.numBands = nArray2.length;
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException("Length of bandOffsets must equal length of bankIndices.");
        }
    }

    private long getBufferSize() {
        int n = this.bandOffsets[0];
        int n2 = 1;
        while (n2 < this.bandOffsets.length) {
            n = Math.max(n, this.bandOffsets[n2]);
            ++n2;
        }
        long l = 0L;
        if (n >= 0) {
            l += (long)(n + 1);
        }
        if (this.pixelStride > 0) {
            l += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l += (long)(this.scanlineStride * (this.height - 1));
        }
        return l;
    }

    int[] orderBands(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray2[n2] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray3.length) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < nArray3.length) {
                if (nArray[nArray2[n4]] > nArray[nArray2[n5]]) {
                    n4 = n5;
                }
                ++n5;
            }
            nArray3[nArray2[n4]] = n3 * n;
            nArray2[n4] = nArray2[n3];
            ++n3;
        }
        return nArray3;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3;
        int[] nArray;
        Object var3_3 = null;
        int n4 = this.bandOffsets[0];
        int n5 = this.bandOffsets[0];
        int n6 = 1;
        while (n6 < this.bandOffsets.length) {
            n4 = Math.min(n4, this.bandOffsets[n6]);
            n5 = Math.max(n5, this.bandOffsets[n6]);
            ++n6;
        }
        int n7 = this.bandOffsets.length;
        int n8 = Math.abs(this.pixelStride);
        int n9 = Math.abs(this.scanlineStride);
        int n10 = Math.abs(n5 -= n4);
        if (n8 > n9) {
            if (n8 > n10) {
                if (n9 > n10) {
                    nArray = new int[this.bandOffsets.length];
                    n3 = 0;
                    while (n3 < n7) {
                        nArray[n3] = this.bandOffsets[n3] - n4;
                        ++n3;
                    }
                    n9 = n10 + 1;
                    n8 = n9 * n2;
                } else {
                    nArray = this.orderBands(this.bandOffsets, n9 * n2);
                    n8 = n7 * n9 * n2;
                }
            } else {
                n8 = n9 * n2;
                nArray = this.orderBands(this.bandOffsets, n8 * n);
            }
        } else if (n8 > n10) {
            nArray = new int[this.bandOffsets.length];
            n3 = 0;
            while (n3 < n7) {
                nArray[n3] = this.bandOffsets[n3] - n4;
                ++n3;
            }
            n8 = n10 + 1;
            n9 = n8 * n;
        } else if (n9 > n10) {
            nArray = this.orderBands(this.bandOffsets, n8 * n);
            n9 = n7 * n8 * n;
        } else {
            n9 = n8 * n;
            nArray = this.orderBands(this.bandOffsets, n9 * n2);
        }
        n3 = 0;
        if (this.scanlineStride < 0) {
            n3 += n9 * n2;
            n9 *= -1;
        }
        if (this.pixelStride < 0) {
            n3 += n8 * n;
            n8 *= -1;
        }
        int n11 = 0;
        while (n11 < n7) {
            int n12 = n11++;
            nArray[n12] = nArray[n12] + n3;
        }
        return new ComponentSampleModel(this.dataType, n, n2, n8, n9, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.bankIndices[nArray[n]];
            nArray3[n] = this.bandOffsets[nArray[n]];
            ++n;
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBanks);
            }
        }
        return dataBuffer;
    }

    public int getOffset(int n, int n2) {
        int n3 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[0];
        return n3;
    }

    public int getOffset(int n, int n2, int n3) {
        int n4 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3];
        return n4;
    }

    public final int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        int n = this.getSampleSize(0);
        int n2 = 0;
        while (n2 < this.numBands) {
            nArray[n2] = n;
            ++n2;
        }
        return nArray;
    }

    public final int getSampleSize(int n) {
        return DataBuffer.getDataTypeSize(this.dataType);
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.getNumBands();
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                int n6 = 0;
                while (n6 < n4) {
                    byArray[n6] = (byte)dataBuffer.getElem(this.bankIndices[n6], n5 + this.bandOffsets[n6]);
                    ++n6;
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                int n7 = 0;
                while (n7 < n4) {
                    sArray[n7] = (short)dataBuffer.getElem(this.bankIndices[n7], n5 + this.bandOffsets[n7]);
                    ++n7;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                int n8 = 0;
                while (n8 < n4) {
                    nArray[n8] = dataBuffer.getElem(this.bankIndices[n8], n5 + this.bandOffsets[n8]);
                    ++n8;
                }
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n3 = n2 * this.scanlineStride + n * this.pixelStride;
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray2[n4] = dataBuffer.getElem(this.bankIndices[n4], n3 + this.bandOffsets[n4]);
            ++n4;
        }
        return nArray2;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = 0;
                while (n10 < this.numBands) {
                    nArray2[n6++] = dataBuffer.getElem(this.bankIndices[n10], n8 + this.bandOffsets[n10]);
                    ++n10;
                }
                n8 += this.pixelStride;
                ++n9;
            }
            n5 += this.scanlineStride;
            ++n7;
        }
        return nArray2;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = dataBuffer.getElem(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return n4;
    }

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        float f = dataBuffer.getElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return f;
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        double d = dataBuffer.getElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return d;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n5];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n3) {
                nArray2[n7++] = dataBuffer.getElem(this.bankIndices[n5], n9);
                n9 += this.pixelStride;
                ++n10;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
        return nArray2;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n6 = 0;
                while (n6 < n4) {
                    dataBuffer.setElem(this.bankIndices[n6], n5 + this.bandOffsets[n6], byArray[n6] & 0xFF);
                    ++n6;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                int n7 = 0;
                while (n7 < n4) {
                    dataBuffer.setElem(this.bankIndices[n7], n5 + this.bandOffsets[n7], sArray[n7] & 0xFFFF);
                    ++n7;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n8 = 0;
                while (n8 < n4) {
                    dataBuffer.setElem(this.bankIndices[n8], n5 + this.bandOffsets[n8], nArray[n8]);
                    ++n8;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n9 = 0;
                while (n9 < n4) {
                    dataBuffer.setElemFloat(this.bankIndices[n9], n5 + this.bandOffsets[n9], fArray[n9]);
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n10 = 0;
                while (n10 < n4) {
                    dataBuffer.setElemDouble(this.bankIndices[n10], n5 + this.bandOffsets[n10], dArray[n10]);
                    ++n10;
                }
                break;
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = n2 * this.scanlineStride + n * this.pixelStride;
        int n4 = 0;
        while (n4 < this.numBands) {
            dataBuffer.setElem(this.bankIndices[n4], n3 + this.bandOffsets[n4], nArray[n4]);
            ++n4;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = 0;
                while (n10 < this.numBands) {
                    dataBuffer.setElem(this.bankIndices[n10], n8 + this.bandOffsets[n10], nArray[n6++]);
                    ++n10;
                }
                n8 += this.pixelStride;
                ++n9;
            }
            n5 += this.scanlineStride;
            ++n7;
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], n4);
    }

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], f);
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], d);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n5];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n3) {
                dataBuffer.setElem(this.bankIndices[n5], n9, nArray[n7++]);
                n9 += this.pixelStride;
                ++n10;
            }
            n6 += this.scanlineStride;
            ++n8;
        }
    }

    static {
        ComponentSampleModel.initIDs();
    }
}

