/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Stack;
import sun.awt.GlobalCursorManager;

class LightweightDispatcher
implements Serializable,
AWTEventListener {
    private static final long serialVersionUID = 5184291520170872969L;
    private static final int LWD_MOUSE_DRAGGED_OVER = 1500;
    private Container nativeContainer;
    private Component focus;
    private transient Stack focusStack = new Stack();
    private transient Component mouseEventTarget;
    private transient Component targetLastEntered;
    private transient boolean isMouseInNativeContainer = false;
    private transient boolean isClickOrphaned = false;
    private boolean dragging;
    private Cursor nativeCursor;
    private long eventMask;
    private static final long PROXY_EVENT_MASK = 60L;
    private static final long MOUSE_MASK = 48L;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
        this.focus = null;
        this.mouseEventTarget = null;
        this.eventMask = 0L;
    }

    void dispose() {
        this.stopListeningForOtherDrags();
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    boolean setFocusRequest(Component component) {
        int n;
        boolean bl = false;
        Window window = this.nativeContainer.getWindow();
        if (window == null || component == null) {
            return true;
        }
        Component component2 = window.getFocusOwner();
        this.focusStack.push(component);
        if (this.focusStack.size() == 1) {
            if (component2 == null) {
                bl = true;
            } else if (component2 == this.nativeContainer) {
                this.nativeContainer.dispatchEvent(new FocusEvent(this.nativeContainer, 1005, false));
            } else if (component2 != component) {
                if (component2 == this.focus) {
                    if (this.focus != null) {
                        Component component3 = this.focus;
                        this.focus = null;
                        component3.dispatchEvent(new FocusEvent(component3, 1005, false));
                    }
                } else {
                    bl = true;
                }
            }
        }
        if ((n = this.focusStack.size()) > 0) {
            this.focus = (Component)this.focusStack.pop();
            this.focusStack.clear();
            if (!(bl || component2 == component && n <= 1)) {
                this.focus.dispatchEvent(new FocusEvent(this.focus, 1004, false));
            }
        }
        return bl;
    }

    boolean dispatchEvent(AWTEvent aWTEvent) {
        boolean bl = false;
        if ((this.eventMask & 0x3CL) != 0L) {
            if (aWTEvent instanceof MouseEvent && (this.eventMask & 0x30L) != 0L) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                bl = this.processMouseEvent(mouseEvent);
            } else if (aWTEvent instanceof FocusEvent) {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                bl = this.processFocusEvent(focusEvent);
            } else if (aWTEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                bl = this.processKeyEvent(keyEvent);
            }
        }
        if (aWTEvent.getID() == 503) {
            GlobalCursorManager.updateCursorImmediately((InputEvent)aWTEvent);
        }
        return bl;
    }

    private boolean processKeyEvent(KeyEvent keyEvent) {
        if (this.focus != null) {
            Component component = keyEvent.getComponent();
            keyEvent.setSource(this.focus);
            this.focus.dispatchEvent(keyEvent);
            keyEvent.setSource(component);
            return keyEvent.isConsumed();
        }
        return false;
    }

    private boolean processFocusEvent(FocusEvent focusEvent) {
        if (this.focus != null) {
            int n = focusEvent.getID();
            FocusEvent focusEvent2 = new FocusEvent(this.focus, n, focusEvent.isTemporary());
            focusEvent.copyPrivateDataInto(focusEvent2);
            this.focus.dispatchEvent(focusEvent2);
            if (n == 1005 && !focusEvent.isTemporary()) {
                this.focus = null;
            }
            return true;
        }
        return false;
    }

    private boolean processMouseEvent(MouseEvent mouseEvent) {
        Component component;
        int n = mouseEvent.getID();
        Component component2 = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component2, mouseEvent);
        if (this.mouseEventTarget == null && (n == 503 || n == 501)) {
            component = component2 != this.nativeContainer ? component2 : null;
            this.setMouseTarget(component, mouseEvent);
        }
        if (this.mouseEventTarget != null) {
            switch (n) {
                case 506: {
                    if (!this.dragging) break;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 501: {
                    this.dragging = true;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    break;
                }
                case 502: {
                    Component component3 = this.mouseEventTarget;
                    this.dragging = false;
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), false);
                    this.setMouseTarget(component, mouseEvent);
                    this.isClickOrphaned = component != component3;
                    break;
                }
                case 500: {
                    if (!this.isClickOrphaned) {
                        this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                    }
                    this.isClickOrphaned = false;
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    if (this.dragging) break;
                    this.setMouseTarget(null, mouseEvent);
                    break;
                }
                case 503: {
                    component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), false);
                    this.setMouseTarget(component, mouseEvent);
                    this.retargetMouseEvent(this.mouseEventTarget, n, mouseEvent);
                }
            }
            mouseEvent.consume();
        }
        return mouseEvent.isConsumed();
    }

    private void setMouseTarget(Component component, MouseEvent mouseEvent) {
        if (component != this.mouseEventTarget) {
            this.mouseEventTarget = component;
        }
    }

    private void trackMouseEnterExit(Component component, MouseEvent mouseEvent) {
        Component component2 = null;
        int n = mouseEvent.getID();
        if (n != 505 && n != 506 && n != 1500 && !this.isMouseInNativeContainer) {
            this.isMouseInNativeContainer = true;
            this.startListeningForOtherDrags();
        } else if (n == 505) {
            this.isMouseInNativeContainer = false;
            this.stopListeningForOtherDrags();
        }
        if (this.isMouseInNativeContainer) {
            component2 = component;
        }
        if (this.targetLastEntered == component2) {
            return;
        }
        if (this.targetLastEntered != null && this.targetLastEntered != this.nativeContainer) {
            this.retargetMouseEvent(this.targetLastEntered, 505, mouseEvent);
        }
        if (this.nativeContainer != null && component2 == null) {
            this.retargetMouseEvent(this.nativeContainer, 505, mouseEvent);
        }
        if (n == 505) {
            mouseEvent.consume();
        }
        if (this.nativeContainer != null && this.targetLastEntered == null) {
            this.retargetMouseEvent(this.nativeContainer, 504, mouseEvent);
        }
        if (component2 != null && component2 != this.nativeContainer) {
            this.retargetMouseEvent(component2, 504, mouseEvent);
        }
        if (n == 504) {
            mouseEvent.consume();
        }
        this.targetLastEntered = component2;
    }

    private void startListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().addAWTEventListener(LightweightDispatcher.this, 48L);
                return null;
            }
        });
    }

    private void stopListeningForOtherDrags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LightweightDispatcher.this.nativeContainer.getToolkit().removeAWTEventListener(LightweightDispatcher.this);
                return null;
            }
        });
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        Component component;
        boolean bl;
        boolean bl2 = bl = aWTEvent instanceof MouseEvent && aWTEvent.id == 506 && aWTEvent.getSource() != this.nativeContainer;
        if (!bl) {
            return;
        }
        MouseEvent mouseEvent2 = (MouseEvent)aWTEvent;
        Object object = this.nativeContainer.getTreeLock();
        synchronized (object) {
            component = mouseEvent2.getComponent();
            if (!component.isShowing() || !this.nativeContainer.isShowing()) {
                return;
            }
            mouseEvent = new MouseEvent(this.nativeContainer, 1500, mouseEvent2.getWhen(), mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger());
            mouseEvent2.copyPrivateDataInto(mouseEvent);
            Point point = component.getLocationOnScreen();
            Point point2 = this.nativeContainer.getLocationOnScreen();
            mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
        }
        component = this.nativeContainer.getMouseEventTarget(mouseEvent.getX(), mouseEvent.getY(), true);
        this.trackMouseEnterExit(component, mouseEvent);
    }

    void retargetMouseEvent(Component component, int n, MouseEvent mouseEvent) {
        if (component == null) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Component component2 = component;
        while (component2 != null && component2 != this.nativeContainer) {
            n2 -= component2.x;
            n3 -= component2.y;
            component2 = component2.getParent();
        }
        if (component2 != null) {
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            mouseEvent.copyPrivateDataInto(mouseEvent2);
            if (component == this.nativeContainer) {
                ((Container)component).dispatchEventToSelf(mouseEvent2);
            } else {
                component.dispatchEvent(mouseEvent2);
            }
        }
    }
}

