/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.awt.DebugHelper;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$EventDispatchThread == null ? (class$java$awt$EventDispatchThread = EventDispatchThread.class$("java.awt.EventDispatchThread")) : class$java$awt$EventDispatchThread);
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private boolean bMouseLeftDown = false;
    private boolean bMouseMiddleDown = false;
    private boolean bMouseRightDown = false;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();
    static /* synthetic */ Class class$java$awt$EventDispatchThread;
    static /* synthetic */ Class class$java$lang$Throwable;

    EventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    public void stopDispatching() {
        this.doDispatch = false;
        this.theQueue.postEventPrivate(new EmptyEvent());
        if (Thread.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.pumpEvents(new Conditional(){

            public boolean evaluate() {
                return true;
            }
        });
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEventsForHierarchy(conditional, null);
    }

    void pumpEventsForHierarchy(Conditional conditional, Component component) {
        this.bMouseLeftDown = false;
        this.bMouseMiddleDown = false;
        this.bMouseRightDown = false;
        while (this.doDispatch && conditional.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForHierarchy(component)) continue;
            this.doDispatch = false;
        }
    }

    boolean pumpOneEventForHierarchy(Component component) {
        try {
            AWTEvent aWTEvent = this.theQueue.getNextEvent();
            if (component != null) {
                while (aWTEvent instanceof InputEvent) {
                    Serializable serializable;
                    Component component2 = (Component)aWTEvent.getSource();
                    if (aWTEvent instanceof MouseEvent && ((AWTEvent)(serializable = (MouseEvent)aWTEvent)).getID() == 501) {
                        if ((((InputEvent)serializable).getModifiers() & 0x10) == 16) {
                            this.bMouseLeftDown = true;
                        } else if ((((InputEvent)serializable).getModifiers() & 8) == 8) {
                            this.bMouseMiddleDown = true;
                        } else if ((((InputEvent)serializable).getModifiers() & 4) == 4) {
                            this.bMouseRightDown = true;
                        }
                    }
                    if (component instanceof Container) {
                        while (component2 != component && component2 != null) {
                            if (component2 instanceof Dialog && ((Dialog)(serializable = (Dialog)component2)).isModal()) {
                                component2 = component;
                                break;
                            }
                            component2 = component2.getParent();
                        }
                    }
                    if (component2 == component) break;
                    if (aWTEvent.getID() == 502) {
                        serializable = (MouseEvent)aWTEvent;
                        if (!this.bMouseLeftDown && (((InputEvent)serializable).getModifiers() & 0x10) == 16 || !this.bMouseMiddleDown && (((InputEvent)serializable).getModifiers() & 8) == 8 || !this.bMouseRightDown && (((InputEvent)serializable).getModifiers() & 4) == 4) break;
                    }
                    aWTEvent = this.theQueue.getNextEvent();
                }
            }
            this.theQueue.dispatchEvent(aWTEvent);
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Throwable throwable) {
            if (!this.handleException(throwable)) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
            return true;
        }
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object object;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = (String)AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = EventDispatchThread.class$("java.lang.Throwable")) : class$java$lang$Throwable});
                object = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(object, new Object[]{throwable});
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
        }
    }
}

