/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import sun.awt.AppContext;
import sun.awt.ConstrainableGraphics;
import sun.awt.DebugHelper;
import sun.awt.GlobalCursorManager;
import sun.awt.NativeLibLoader;
import sun.awt.RepaintArea;
import sun.awt.SunToolkit;
import sun.awt.WindowClosingListener;
import sun.awt.im.CompositionArea;
import sun.java2d.loops.RasterOutputManager;
import sun.security.action.GetPropertyAction;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    transient ComponentPeer peer;
    transient Container parent;
    transient AppContext appContext;
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    transient GraphicsConfiguration graphicsConfig = null;
    boolean visible = true;
    boolean enabled = true;
    boolean valid = false;
    DropTarget dropTarget;
    boolean hasFocus = false;
    Vector popups;
    private String name;
    private boolean nameExplicitlySet = false;
    static final Object LOCK = new AWTTreeLock();
    Dimension minSize;
    Dimension prefSize;
    transient ComponentOrientation componentOrientation = ComponentOrientation.UNKNOWN;
    boolean newEventsOnly = false;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient InputMethodListener inputMethodListener;
    transient RuntimeException windowClosingException = null;
    static final String actionListenerK = "actionL";
    static final String adjustmentListenerK = "adjustmentL";
    static final String componentListenerK = "componentL";
    static final String containerListenerK = "containerL";
    static final String focusListenerK = "focusL";
    static final String itemListenerK = "itemL";
    static final String keyListenerK = "keyL";
    static final String mouseListenerK = "mouseL";
    static final String mouseMotionListenerK = "mouseMotionL";
    static final String textListenerK = "textL";
    static final String ownedWindowK = "ownedL";
    static final String windowListenerK = "windowL";
    static final String inputMethodListenerK = "inputMethodL";
    static final String hierarchyListenerK = "hierarchyL";
    static final String hierarchyBoundsListenerK = "hierarchyBoundsL";
    long eventMask = 4096L;
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$Component == null ? (class$java$awt$Component = Component.class$("java.awt.Component")) : class$java$awt$Component);
    static boolean isInc;
    static int incRate;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    private static final long serialVersionUID = -7644114512714619750L;
    private PropertyChangeSupport changeSupport;
    boolean isPacked = false;
    private transient Object privateKey = new Object();
    static Hashtable metrics;
    private int componentSerializedDataVersion = 3;
    AccessibleContext accessibleContext = null;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$event$ComponentListener;
    static /* synthetic */ Class class$java$awt$event$FocusListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyBoundsListener;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;
    static /* synthetic */ Class class$java$awt$event$InputMethodListener;

    protected Component() {
        this.appContext = AppContext.getAppContext();
        SunToolkit.insertTargetMapping(this, this.appContext);
    }

    String constructComponentName() {
        return null;
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Component component = this;
            synchronized (component) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    public void setName(String string) {
        Component component = this;
        synchronized (component) {
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public Container getParent() {
        return this.getParent_NoClientCode();
    }

    final Container getParent_NoClientCode() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public synchronized void setDropTarget(DropTarget dropTarget) {
        block12: {
            if (dropTarget == this.dropTarget || this.dropTarget != null && this.dropTarget.equals(dropTarget)) {
                return;
            }
            DropTarget dropTarget2 = this.dropTarget;
            if (dropTarget2 != null) {
                if (this.peer != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                DropTarget dropTarget3 = this.dropTarget;
                this.dropTarget = null;
                try {
                    dropTarget3.setComponent(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((this.dropTarget = dropTarget) != null) {
                try {
                    this.dropTarget.setComponent(this);
                    if (this.peer != null) {
                        this.dropTarget.addNotify(this.peer);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (dropTarget2 == null) break block12;
                    try {
                        dropTarget2.setComponent(this);
                        if (this.peer != null) {
                            this.dropTarget.addNotify(this.peer);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public synchronized DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig != null) {
                GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
                return graphicsConfiguration;
            }
            if (this.getParent() != null) {
                GraphicsConfiguration graphicsConfiguration = this.getParent().getGraphicsConfiguration();
                return graphicsConfiguration;
            }
            GraphicsConfiguration graphicsConfiguration = null;
            return graphicsConfiguration;
        }
    }

    void resetGC() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.graphicsConfig = null;
        }
    }

    void checkGD(String string) {
        if (this.graphicsConfig != null && !this.graphicsConfig.getDevice().getIDstring().equals(string)) {
            throw new IllegalArgumentException("adding a container to a container on a different GraphicsDevice");
        }
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public Toolkit getToolkit() {
        return this.getToolkitImpl();
    }

    final Toolkit getToolkitImpl() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getToolkit();
        }
        Container container = this.parent;
        if (container != null) {
            return container.getToolkitImpl();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isDisplayable() {
        return this.getPeer() != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    boolean isRecursivelyVisible() {
        return this.visible && (this.parent == null || this.parent.isRecursivelyVisible());
    }

    public boolean isShowing() {
        if (this.visible && this.peer != null) {
            Container container = this.parent;
            return container == null || container.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabledImpl();
    }

    final boolean isEnabledImpl() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable() {
        if (!this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.enable();
                    if (this.visible) {
                        GlobalCursorManager.updateCursorImmediately();
                    }
                }
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        if (this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = false;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.disable();
                    if (this.visible) {
                        GlobalCursorManager.updateCursorImmediately();
                    }
                }
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean bl) {
        if (bl) {
            InputContext inputContext;
            if ((this.eventMask & 0x1000L) != 0L) {
                return;
            }
            if (this.hasFocus() && (inputContext = this.getInputContext()) != null) {
                FocusEvent focusEvent = new FocusEvent(this, 1004);
                inputContext.dispatchEvent(focusEvent);
            }
            this.eventMask |= 0x1000L;
        } else {
            InputContext inputContext;
            if (this.areInputMethodsEnabled() && (inputContext = this.getInputContext()) != null) {
                inputContext.endComposition();
                inputContext.removeNotify(this);
            }
            this.eventMask &= 0xFFFFFFFFFFFFEFFFL;
        }
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if (!this.visible) {
            Object object;
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                this.visible = true;
                object = this.peer;
                if (object != null) {
                    object.show();
                    this.createHierarchyEvents(1400, this, this.parent, 4L);
                    if (object instanceof LightweightPeer) {
                        this.repaint();
                    }
                    GlobalCursorManager.updateCursorImmediately();
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this.visible) {
            Object object;
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                this.visible = false;
                object = this.peer;
                if (object != null) {
                    object.hide();
                    this.createHierarchyEvents(1400, this, this.parent, 4L);
                    if (object instanceof LightweightPeer) {
                        this.repaint();
                    }
                    GlobalCursorManager.updateCursorImmediately();
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 103);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getForeground() : null;
    }

    public void setForeground(Color color) {
        Color color2 = this.foreground;
        ComponentPeer componentPeer = this.peer;
        this.foreground = color;
        if (componentPeer != null && (color = this.getForeground()) != null) {
            componentPeer.setForeground(color);
        }
        this.firePropertyChange("foreground", color2, color);
    }

    public Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getBackground() : null;
    }

    public void setBackground(Color color) {
        Color color2 = this.background;
        ComponentPeer componentPeer = this.peer;
        this.background = color;
        if (componentPeer != null && (color = this.getBackground()) != null) {
            componentPeer.setBackground(color);
        }
        this.firePropertyChange("background", color2, color);
    }

    public Font getFont() {
        return this.getFont_NoClientCode();
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        return container != null ? container.getFont_NoClientCode() : null;
    }

    public void setFont(Font font) {
        Font font2;
        Font font3;
        Component component = this;
        synchronized (component) {
            font3 = this.font;
            ComponentPeer componentPeer = this.peer;
            font2 = this.font = font;
            if (componentPeer != null && (font = this.getFont()) != null) {
                componentPeer.setFont(font);
                this.peerFont = font;
            }
        }
        this.firePropertyChange("font", font3, font2);
        if (this.valid) {
            this.invalidate();
        }
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.parent;
        if (container == null) {
            throw new IllegalComponentStateException("This component must have a parent in order to determine its locale");
        }
        return container.getLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.valid) {
            this.invalidate();
        }
    }

    public ColorModel getColorModel() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    public Point getLocationOnScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Point point = this.getLocationOnScreen_NoTreeLock();
            return point;
        }
    }

    final Point getLocationOnScreen_NoTreeLock() {
        if (this.peer != null && this.isShowing()) {
            if (this.peer instanceof LightweightPeer) {
                Container container = this.getNativeContainer();
                Point point = container.peer.getLocationOnScreen();
                Component component = this;
                while (component != container) {
                    point.x += component.x;
                    point.y += component.y;
                    component = component.getParent();
                }
                return point;
            }
            Point point = this.peer.getLocationOnScreen();
            return point;
        }
        throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean bl = this.width != n3 || this.height != n4;
            boolean bl2 = this.x != n || this.y != n2;
            boolean bl3 = this.peer instanceof LightweightPeer;
            if (bl) {
                this.isPacked = false;
            }
            if (bl || bl2 || !this.isShowing() && this.isVisible() && this.isDisplayable()) {
                if (bl3 && this.visible) {
                    this.repaint();
                }
                this.x = n;
                this.y = n2;
                this.width = n3;
                this.height = n4;
                if (this.peer != null) {
                    if (bl3) {
                        this.peer.setBounds(n, n2, n3, n4);
                    } else {
                        int n5 = n;
                        int n6 = n2;
                        Container container = this.parent;
                        while (container != null && container.peer instanceof LightweightPeer) {
                            n5 += container.x;
                            n6 += container.y;
                            container = container.parent;
                        }
                        this.peer.setBounds(n5, n6, n3, n4);
                    }
                    if (bl) {
                        this.invalidate();
                    }
                    if (this.parent != null && this.parent.valid) {
                        this.parent.invalidate();
                    }
                }
                if (bl) {
                    if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                        ComponentEvent componentEvent = new ComponentEvent(this, 101);
                        Toolkit.getEventQueue().postEvent(componentEvent);
                    } else {
                        this.createChildHierarchyEvents(1402, 0L);
                    }
                }
                if (bl2) {
                    if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                        ComponentEvent componentEvent = new ComponentEvent(this, 100);
                        Toolkit.getEventQueue().postEvent(componentEvent);
                    } else {
                        this.createChildHierarchyEvents(1401, 0L);
                    }
                }
                if (bl3 && this.visible) {
                    this.repaint();
                }
            } else if (this.peer != null) {
                if (bl3) {
                    this.peer.setBounds(n, n2, n3, n4);
                } else {
                    int n7 = n;
                    int n8 = n2;
                    Container container = this.parent;
                    while (container != null && container.peer instanceof LightweightPeer) {
                        n7 += container.x;
                        n8 += container.y;
                        container = container.parent;
                    }
                    if ((n7 != n || n8 != n2) && this.parent != null) {
                        this.peer.setBounds(n7, n8, n3, n4);
                    }
                }
                if (this.parent != null && this.parent.valid) {
                    this.parent.invalidate();
                }
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public boolean isOpaque() {
        return !this.isLightweight();
    }

    public boolean isLightweight() {
        return this.getPeer() instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.prefSize = this.peer != null ? this.peer.preferredSize() : this.getMinimumSize();
            return dimension2;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.minSize = this.peer != null ? this.peer.minimumSize() : this.size();
            return dimension2;
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Font font;
                Font font2;
                ComponentPeer componentPeer = this.peer;
                if (!(this.valid || componentPeer == null || (font2 = this.getFont()) == (font = this.peerFont) || font != null && font.equals(font2))) {
                    componentPeer.setFont(font2);
                    this.peerFont = font2;
                }
            }
            this.valid = true;
        }
    }

    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.valid = false;
            this.prefSize = null;
            this.minSize = null;
            if (this.parent != null && this.parent.valid) {
                this.parent.invalidate();
            }
        }
    }

    public Graphics getGraphics() {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent == null) {
                return null;
            }
            Graphics graphics = this.parent.getGraphics();
            if (graphics == null) {
                return null;
            }
            if (graphics instanceof ConstrainableGraphics) {
                ((ConstrainableGraphics)((Object)graphics)).constrain(this.x, this.y, this.width, this.height);
            } else {
                graphics.translate(this.x, this.y);
                graphics.setClip(0, 0, this.width, this.height);
            }
            graphics.setFont(this.getFont());
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setBackground(this.getBackground());
            }
            return graphics;
        }
        ComponentPeer componentPeer = this.peer;
        return componentPeer != null ? componentPeer.getGraphics() : null;
    }

    public FontMetrics getFontMetrics(Font font) {
        Graphics graphics;
        FontMetrics fontMetrics = (FontMetrics)metrics.get(font);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        if (RasterOutputManager.usesPlatformFont() && this.peer != null && !(this.peer instanceof LightweightPeer)) {
            fontMetrics = this.peer.getFontMetrics(font);
            metrics.put(font, fontMetrics);
            return fontMetrics;
        }
        if (this.parent != null && (graphics = this.parent.getGraphics()) != null) {
            try {
                fontMetrics = graphics.getFontMetrics(font);
                metrics.put(font, fontMetrics);
                FontMetrics fontMetrics2 = fontMetrics;
                Object var6_5 = null;
                graphics.dispose();
                return fontMetrics2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                graphics.dispose();
                throw throwable;
            }
        }
        fontMetrics = this.getToolkit().getFontMetrics(font);
        metrics.put(font, fontMetrics);
        return fontMetrics;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        if (this.peer != null) {
            GlobalCursorManager.updateCursorImmediately();
        }
    }

    public Cursor getCursor() {
        Cursor cursor = this.cursor;
        if (cursor != null) {
            return cursor;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getCursor();
        }
        return Cursor.getPredefinedCursor(0);
    }

    public void paint(Graphics graphics) {
        String string;
        if (this.isShowing() && this.peer instanceof LightweightPeer && ((string = this.peer.getClass().toString()).indexOf("class java") == 0 || string.indexOf("class sun") == 0)) {
            this.peer.paint(graphics);
        }
    }

    public void update(Graphics graphics) {
        if (this instanceof Canvas || this instanceof Panel || this instanceof Window) {
            if (graphics instanceof Graphics2D) {
                graphics.clearRect(0, 0, this.width, this.height);
            } else {
                Color color = graphics.getColor();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.width, this.height);
                graphics.setColor(color);
            }
        }
        GraphicsCallback.PaintCallback.getInstance().run(this, graphics);
    }

    public void paintAll(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PeerPaintCallback.getInstance().runOneComponent(this, new Rectangle(0, 0, this.width, this.height), graphics, graphics.getClip(), 3);
        }
    }

    void lightweightPaint(Graphics graphics) {
        this.paint(graphics);
    }

    void paintHeavyweightComponents(Graphics graphics) {
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.peer instanceof LightweightPeer && !(this instanceof Canvas) && !(this instanceof Panel)) {
            if (this.parent != null) {
                int n5 = this.x + (n < 0 ? 0 : n);
                int n6 = this.y + (n2 < 0 ? 0 : n2);
                int n7 = n3 > this.width ? this.width : n3;
                int n8 = n4 > this.height ? this.height : n4;
                this.parent.repaint(l, n5, n6, n7, n8);
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            ComponentPeer componentPeer = this.peer;
            if (componentPeer != null && n3 > 0 && n4 > 0) {
                componentPeer.repaint(l, n, n2, n3, n4);
            }
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PeerPrintCallback.getInstance().runOneComponent(this, new Rectangle(0, 0, this.width, this.height), graphics, graphics.getClip(), 3);
        }
    }

    void lightweightPrint(Graphics graphics) {
        this.print(graphics);
    }

    void printHeavyweightComponents(Graphics graphics) {
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        if ((n & 0x30) != 0) {
            n6 = 0;
        } else if ((n & 8) != 0 && isInc) {
            try {
                n6 = incRate;
                if (n6 < 0) {
                    n6 = 0;
                }
            }
            catch (Exception exception) {
                n6 = 100;
            }
        }
        if (n6 >= 0) {
            this.repaint(n6, 0, 0, this.width, this.height);
        }
        return (n & 0xA0) == 0;
    }

    public Image createImage(ImageProducer imageProducer) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            if (this.parent != null) {
                return this.parent.createImage(n, n2);
            }
            return null;
        }
        return componentPeer != null ? componentPeer.createImage(n, n2) : null;
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent != null ? this.parent.prepareImage(image, n, n2, imageObserver) : this.getToolkit().prepareImage(image, n, n2, imageObserver);
        }
        return componentPeer != null ? componentPeer.prepareImage(image, n, n2, imageObserver) : this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent != null ? this.parent.checkImage(image, n, n2, imageObserver) : this.getToolkit().checkImage(image, n, n2, imageObserver);
        }
        return componentPeer != null ? componentPeer.checkImage(image, n, n2, imageObserver) : this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean inside(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component locate(int n, int n2) {
        return this.contains(n, n2) ? this : null;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        Serializable serializable;
        Object object;
        int n = aWTEvent.getID();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.notifyAWTEventListeners(aWTEvent);
        if (this.areInputMethodsEnabled() && (aWTEvent instanceof InputMethodEvent && !(this instanceof CompositionArea) || aWTEvent instanceof InputEvent || aWTEvent instanceof FocusEvent) && (object = this.getInputContext()) != null) {
            ((InputContext)object).dispatchEvent(aWTEvent);
            if (aWTEvent.isConsumed()) {
                return;
            }
        }
        switch (n) {
            case 1004: {
                if (this.parent == null || this instanceof Window) break;
                this.parent.setFocusOwner(this);
                break;
            }
            case 1005: {
                break;
            }
            case 401: 
            case 402: {
                object = (Container)(this instanceof Container ? this : this.parent);
                if (object == null) break;
                ((Container)object).preProcessKeyEvent((KeyEvent)aWTEvent);
                if (!aWTEvent.isConsumed()) break;
                return;
            }
            case 201: {
                if (!(toolkit instanceof WindowClosingListener)) break;
                this.windowClosingException = ((WindowClosingListener)((Object)toolkit)).windowClosingNotify((WindowEvent)aWTEvent);
                if (!this.checkWindowClosingException()) break;
                return;
            }
        }
        if (this.newEventsOnly && this.eventEnabled(aWTEvent)) {
            this.processEvent(aWTEvent);
        } else if ((!(aWTEvent instanceof MouseEvent) || this.postsOldMouseEvents()) && (serializable = aWTEvent.convertToOld()) != null) {
            int n2 = ((Event)serializable).key;
            int n3 = ((Event)serializable).modifiers;
            this.postEvent((Event)serializable);
            if (((Event)serializable).isConsumed()) {
                aWTEvent.consume();
            }
            switch (((Event)serializable).id) {
                case 401: 
                case 402: 
                case 403: 
                case 404: {
                    if (((Event)serializable).key != n2) {
                        ((KeyEvent)aWTEvent).setKeyChar(((Event)serializable).getKeyEventChar());
                    }
                    if (((Event)serializable).modifiers == n3) break;
                    ((KeyEvent)aWTEvent).setModifiers(((Event)serializable).modifiers);
                    break;
                }
            }
        }
        if (!aWTEvent.isConsumed()) {
            if (aWTEvent instanceof KeyEvent) {
                serializable = (Container)(this instanceof Container ? this : this.parent);
                if (serializable != null) {
                    ((Container)serializable).postProcessKeyEvent((KeyEvent)aWTEvent);
                }
            } else {
                switch (n) {
                    case 201: {
                        if (!(toolkit instanceof WindowClosingListener)) break;
                        this.windowClosingException = ((WindowClosingListener)((Object)toolkit)).windowClosingDelivered((WindowEvent)aWTEvent);
                        if (!this.checkWindowClosingException()) break;
                        return;
                    }
                }
            }
        }
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
    }

    boolean checkWindowClosingException() {
        if (this.windowClosingException != null) {
            if (this instanceof Dialog) {
                ((Dialog)this).interruptBlocking();
            } else {
                this.windowClosingException.fillInStackTrace();
                this.windowClosingException.printStackTrace();
                this.windowClosingException = null;
            }
            return true;
        }
        return false;
    }

    boolean areInputMethodsEnabled() {
        return (this.eventMask & 0x1000L) != 0L && ((this.eventMask & 8L) != 0L || this.keyListener != null);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                if ((this.eventMask & 1L) == 0L && this.componentListener == null) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this.eventMask & 4L) == 0L && this.focusListener == null) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this.eventMask & 8L) == 0L && this.keyListener == null) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this.eventMask & 0x10L) == 0L && this.mouseListener == null) break;
                return true;
            }
            case 503: 
            case 506: {
                if ((this.eventMask & 0x20L) == 0L && this.mouseMotionListener == null) break;
                return true;
            }
            case 1100: 
            case 1101: {
                if ((this.eventMask & 0x800L) == 0L && this.inputMethodListener == null) break;
                return true;
            }
            case 1400: {
                if ((this.eventMask & 0x8000L) == 0L && this.hierarchyListener == null) break;
                return true;
            }
            case 1401: 
            case 1402: {
                if ((this.eventMask & 0x10000L) == 0L && this.hierarchyBoundsListener == null) break;
                return true;
            }
        }
        return aWTEvent.id > 1999;
    }

    private Window getWindowForObject(Object object) {
        if (object instanceof Component) {
            while (object != null) {
                if (object instanceof Window) {
                    return (Window)object;
                }
                object = ((Component)object).getParent();
            }
        }
        return null;
    }

    public boolean postEvent(Event event) {
        ComponentPeer componentPeer = this.peer;
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        Container container = this.parent;
        int n = event.x;
        int n2 = event.y;
        if (container != null) {
            event.translate(this.x, this.y);
            if (container.postEvent(event)) {
                event.consume();
                return true;
            }
            event.x = n;
            event.y = n2;
        }
        return false;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer && this.parent != null) {
            this.parent.proxyEnableEvents(4L);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        boolean bl;
        if (hierarchyListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl = this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L;
            this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, hierarchyListener);
            bl = bl && this.hierarchyListener != null;
            this.newEventsOnly = true;
        }
        if (bl) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.parent != null) {
                    this.parent.adjustListeningChildren(32768L, 1);
                }
            }
        }
    }

    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        boolean bl;
        if (hierarchyListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl = this.hierarchyListener != null && (this.eventMask & 0x8000L) == 0L;
            this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, hierarchyListener);
            bl = bl && this.hierarchyListener == null;
        }
        if (bl) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.parent != null) {
                    this.parent.adjustListeningChildren(32768L, -1);
                }
            }
        }
    }

    public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        boolean bl;
        if (hierarchyBoundsListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl = this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L;
            this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, hierarchyBoundsListener);
            bl = bl && this.hierarchyBoundsListener != null;
            this.newEventsOnly = true;
        }
        if (bl) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.parent != null) {
                    this.parent.adjustListeningChildren(65536L, 1);
                }
            }
        }
    }

    public void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        boolean bl;
        if (hierarchyBoundsListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl = this.hierarchyBoundsListener != null && (this.eventMask & 0x10000L) == 0L;
            this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, hierarchyBoundsListener);
            bl = bl && this.hierarchyBoundsListener == null;
        }
        if (bl) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.parent != null) {
                    this.parent.adjustListeningChildren(65536L, -1);
                }
            }
        }
    }

    int numListening(long l) {
        if (l == 32768L && (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L) || l == 65536L && (this.hierarchyBoundsListener != null || (this.eventMask & 0x10000L) != 0L)) {
            return 1;
        }
        return 0;
    }

    int createHierarchyEvents(int n, Component component, Container container, long l) {
        switch (n) {
            case 1400: {
                if (this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L) break;
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, n, component, container, l);
                this.dispatchEvent(hierarchyEvent);
                return 1;
            }
            case 1401: 
            case 1402: {
                if (this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L) break;
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, n, component, container);
                this.dispatchEvent(hierarchyEvent);
                return 1;
            }
        }
        return 0;
    }

    void createChildHierarchyEvents(int n, long l) {
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer && this.parent != null) {
            this.parent.proxyEnableEvents(8L);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer && this.parent != null) {
            this.parent.proxyEnableEvents(16L);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer && this.parent != null) {
            this.parent.proxyEnableEvents(32L);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener eventListener = null;
        if (clazz == (class$java$awt$event$ComponentListener == null ? (class$java$awt$event$ComponentListener = Component.class$("java.awt.event.ComponentListener")) : class$java$awt$event$ComponentListener)) {
            eventListener = this.componentListener;
        } else if (clazz == (class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = Component.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener)) {
            eventListener = this.focusListener;
        } else if (clazz == (class$java$awt$event$HierarchyListener == null ? (class$java$awt$event$HierarchyListener = Component.class$("java.awt.event.HierarchyListener")) : class$java$awt$event$HierarchyListener)) {
            eventListener = this.hierarchyListener;
        } else if (clazz == (class$java$awt$event$HierarchyBoundsListener == null ? (class$java$awt$event$HierarchyBoundsListener = Component.class$("java.awt.event.HierarchyBoundsListener")) : class$java$awt$event$HierarchyBoundsListener)) {
            eventListener = this.hierarchyBoundsListener;
        } else if (clazz == (class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = Component.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener)) {
            eventListener = this.keyListener;
        } else if (clazz == (class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Component.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener)) {
            eventListener = this.mouseListener;
        } else if (clazz == (class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = Component.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener)) {
            eventListener = this.mouseMotionListener;
        } else if (clazz == (class$java$awt$event$InputMethodListener == null ? (class$java$awt$event$InputMethodListener = Component.class$("java.awt.event.InputMethodListener")) : class$java$awt$event$InputMethodListener)) {
            eventListener = this.inputMethodListener;
        }
        return AWTEventMulticaster.getListeners(eventListener, clazz);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        Container container = this.parent;
        if (container == null) {
            return null;
        }
        return container.getInputContext();
    }

    protected final void enableEvents(long l) {
        long l2 = 0L;
        Component component = this;
        synchronized (component) {
            if ((l & 0x8000L) != 0L && this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L) {
                l2 |= 0x8000L;
            }
            if ((l & 0x10000L) != 0L && this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L) {
                l2 |= 0x10000L;
            }
            this.eventMask |= l;
            this.newEventsOnly = true;
        }
        if (this.peer instanceof LightweightPeer && this.parent != null) {
            this.parent.proxyEnableEvents(this.eventMask);
        }
        if (l2 != 0L) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.parent != null) {
                    this.parent.adjustListeningChildren(l2, 1);
                }
            }
        }
    }

    protected final void disableEvents(long l) {
        long l2 = 0L;
        Component component = this;
        synchronized (component) {
            if ((l & 0x8000L) != 0L && this.hierarchyListener == null && (this.eventMask & 0x8000L) != 0L) {
                l2 |= 0x8000L;
            }
            if ((l & 0x10000L) != 0L && this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) != 0L) {
                l2 |= 0x10000L;
            }
            this.eventMask &= l ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l2 != 0L) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.parent != null) {
                    this.parent.adjustListeningChildren(l2, -1);
                }
            }
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        int n = aWTEvent.getID();
        switch (n) {
            case 503: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getModifiers() != ((MouseEvent)aWTEvent2).getModifiers()) break;
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                Rectangle rectangle;
                if (this.peer != null) {
                    this.peer.coalescePaintEvent((PaintEvent)aWTEvent2);
                    return aWTEvent2;
                }
                PaintEvent paintEvent = (PaintEvent)aWTEvent;
                PaintEvent paintEvent2 = (PaintEvent)aWTEvent2;
                Rectangle rectangle2 = paintEvent.getUpdateRect();
                if (rectangle2.contains(rectangle = paintEvent2.getUpdateRect())) {
                    return aWTEvent;
                }
                if (!rectangle.contains(rectangle2)) break;
                return aWTEvent2;
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        } else if (aWTEvent instanceof HierarchyEvent) {
            switch (aWTEvent.getID()) {
                case 1400: {
                    this.processHierarchyEvent((HierarchyEvent)aWTEvent);
                    break;
                }
                case 1401: 
                case 1402: {
                    this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent);
                }
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        ComponentListener componentListener = this.componentListener;
        if (componentListener != null) {
            int n = componentEvent.getID();
            switch (n) {
                case 101: {
                    componentListener.componentResized(componentEvent);
                    break;
                }
                case 100: {
                    componentListener.componentMoved(componentEvent);
                    break;
                }
                case 102: {
                    componentListener.componentShown(componentEvent);
                    break;
                }
                case 103: {
                    componentListener.componentHidden(componentEvent);
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        FocusListener focusListener = this.focusListener;
        if (focusListener != null) {
            int n = focusEvent.getID();
            switch (n) {
                case 1004: {
                    focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    focusListener.focusLost(focusEvent);
                }
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        KeyListener keyListener = this.keyListener;
        if (keyListener != null) {
            int n = keyEvent.getID();
            switch (n) {
                case 400: {
                    keyListener.keyTyped(keyEvent);
                    break;
                }
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        MouseListener mouseListener = this.mouseListener;
        if (mouseListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 501: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseMotionListener mouseMotionListener = this.mouseMotionListener;
        if (mouseMotionListener != null) {
            int n = mouseEvent.getID();
            switch (n) {
                case 503: {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    mouseMotionListener.mouseDragged(mouseEvent);
                }
            }
        }
    }

    boolean postsOldMouseEvents() {
        return false;
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        InputMethodListener inputMethodListener = this.inputMethodListener;
        if (inputMethodListener != null) {
            int n = inputMethodEvent.getID();
            switch (n) {
                case 1100: {
                    inputMethodListener.inputMethodTextChanged(inputMethodEvent);
                    break;
                }
                case 1101: {
                    inputMethodListener.caretPositionChanged(inputMethodEvent);
                }
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        HierarchyListener hierarchyListener = this.hierarchyListener;
        if (hierarchyListener != null) {
            int n = hierarchyEvent.getID();
            switch (n) {
                case 1400: {
                    hierarchyListener.hierarchyChanged(hierarchyEvent);
                }
            }
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        HierarchyBoundsListener hierarchyBoundsListener = this.hierarchyBoundsListener;
        if (hierarchyBoundsListener != null) {
            int n = hierarchyEvent.getID();
            switch (n) {
                case 1401: {
                    hierarchyBoundsListener.ancestorMoved(hierarchyEvent);
                    break;
                }
                case 1402: {
                    hierarchyBoundsListener.ancestorResized(hierarchyEvent);
                }
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer == null || componentPeer instanceof LightweightPeer) {
                if (componentPeer == null) {
                    this.peer = componentPeer = this.getToolkit().createComponent(this);
                }
                if (this.parent != null) {
                    long l = 0L;
                    if (this.mouseListener != null || (this.eventMask & 0x10L) != 0L) {
                        l |= 0x10L;
                    }
                    if (this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L) {
                        l |= 0x20L;
                    }
                    if (this.focusListener != null || (this.eventMask & 4L) != 0L) {
                        l |= 4L;
                    }
                    if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                        l |= 8L;
                    }
                    if (l != 0L && this.parent != null) {
                        this.parent.proxyEnableEvents(l);
                    }
                }
            } else {
                Container container = this.parent;
                if (container != null && container.peer instanceof LightweightPeer) {
                    new NativeInLightFixer();
                }
            }
            this.invalidate();
            int n = this.popups != null ? this.popups.size() : 0;
            int n2 = 0;
            while (n2 < n) {
                serializable = (PopupMenu)this.popups.elementAt(n2);
                serializable.addNotify();
                ++n2;
            }
            if (this.dropTarget != null) {
                this.dropTarget.addNotify(componentPeer);
            }
            this.peerFont = this.getFont();
            if (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L) {
                serializable = new HierarchyEvent(this, 1400, this, this.parent, 2 | (this.isRecursivelyVisible() ? 4 : 0));
                this.dispatchEvent((AWTEvent)serializable);
            }
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            int n = this.popups != null ? this.popups.size() : 0;
            int n2 = 0;
            while (n2 < n) {
                object2 = (PopupMenu)this.popups.elementAt(n2);
                ((Menu)object2).removeNotify();
                ++n2;
            }
            if (this.areInputMethodsEnabled() && (object2 = this.getInputContext()) != null) {
                ((InputContext)object2).removeNotify(this);
            }
            if ((object2 = this.peer) != null) {
                if (this.dropTarget != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                if (this.visible) {
                    object2.hide();
                }
                this.peer = null;
                this.peerFont = null;
                Toolkit.getEventQueue().removeSourceEvents(this);
                object2.dispose();
            }
            if ((object2 instanceof LightweightPeer || object2 == null) && this.hasFocus()) {
                this.dispatchEvent(new FocusEvent(this, 1005));
            }
            if (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L) {
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, 1400, this, this.parent, 2 | (this.isRecursivelyVisible() ? 4 : 0));
                this.dispatchEvent(hierarchyEvent);
            }
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            return componentPeer.isFocusTraversable();
        }
        return false;
    }

    public void requestFocus() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null) {
            if (componentPeer instanceof LightweightPeer) {
                if (this.parent != null) {
                    this.parent.proxyRequestFocus(this);
                }
            } else {
                componentPeer.requestFocus();
                Toolkit.getEventQueue().changeKeyEventFocus(this);
            }
        }
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public void nextFocus() {
        Container container = this.parent;
        if (container != null) {
            container.transferFocus(this);
        }
    }

    public boolean hasFocus() {
        if ((this.eventMask & 4L) != 0L) {
            return this.hasFocus;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return ((Window)container).getFocusOwner() == this;
            }
            container = container.getParent();
        }
        return false;
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popupMenu);
        popupMenu.parent = this;
        if (this.peer != null && popupMenu.peer == null) {
            popupMenu.addNotify();
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n;
        if (this.popups != null && (n = this.popups.indexOf(menuComponent)) >= 0) {
            PopupMenu popupMenu = (PopupMenu)menuComponent;
            if (popupMenu.peer != null) {
                popupMenu.removeNotify();
            }
            popupMenu.parent = null;
            this.popups.removeElementAt(n);
            if (this.popups.size() == 0) {
                this.popups = null;
            }
        }
    }

    protected String paramString() {
        String string = this.getName();
        String string2 = (string != null ? string : "") + "," + this.x + "," + this.y + "," + this.width + "x" + this.height;
        if (!this.valid) {
            string2 = string2 + ",invalid";
        }
        if (!this.visible) {
            string2 = string2 + ",hidden";
        }
        if (!this.enabled) {
            string2 = string2 + ",disabled";
        }
        return string2;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
        printStream.println(this);
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("  ");
            ++n2;
        }
        printWriter.println(this);
    }

    Container getNativeContainer() {
        Container container = this.parent;
        while (container != null && container.peer instanceof LightweightPeer) {
            container = container.getParent();
        }
        return container;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getName();
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, componentListenerK, this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, focusListenerK, this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, keyListenerK, this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, mouseListenerK, this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, mouseMotionListenerK, this.mouseMotionListener);
        AWTEventMulticaster.save(objectOutputStream, inputMethodListenerK, this.inputMethodListener);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(this.componentOrientation);
        AWTEventMulticaster.save(objectOutputStream, hierarchyListenerK, this.hierarchyListener);
        AWTEventMulticaster.save(objectOutputStream, hierarchyBoundsListenerK, this.hierarchyBoundsListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block17: {
            Object object;
            Object object2;
            block16: {
                objectInputStream.defaultReadObject();
                this.privateKey = new Object();
                this.appContext = AppContext.getAppContext();
                SunToolkit.insertTargetMapping(this, this.appContext);
                while (null != (object2 = objectInputStream.readObject())) {
                    object = ((String)object2).intern();
                    if (componentListenerK == object) {
                        this.addComponentListener((ComponentListener)objectInputStream.readObject());
                        continue;
                    }
                    if (focusListenerK == object) {
                        this.addFocusListener((FocusListener)objectInputStream.readObject());
                        continue;
                    }
                    if (keyListenerK == object) {
                        this.addKeyListener((KeyListener)objectInputStream.readObject());
                        continue;
                    }
                    if (mouseListenerK == object) {
                        this.addMouseListener((MouseListener)objectInputStream.readObject());
                        continue;
                    }
                    if (mouseMotionListenerK == object) {
                        this.addMouseMotionListener((MouseMotionListener)objectInputStream.readObject());
                        continue;
                    }
                    if (inputMethodListenerK == object) {
                        this.addInputMethodListener((InputMethodListener)objectInputStream.readObject());
                        continue;
                    }
                    objectInputStream.readObject();
                }
                object = null;
                try {
                    object = objectInputStream.readObject();
                }
                catch (OptionalDataException optionalDataException) {
                    if (optionalDataException.eof) break block16;
                    throw optionalDataException;
                }
            }
            this.componentOrientation = object != null ? (ComponentOrientation)object : ComponentOrientation.UNKNOWN;
            try {
                while (null != (object2 = objectInputStream.readObject())) {
                    String string = ((String)object2).intern();
                    if (hierarchyListenerK == string) {
                        this.addHierarchyListener((HierarchyListener)objectInputStream.readObject());
                        continue;
                    }
                    if (hierarchyBoundsListenerK == string) {
                        this.addHierarchyBoundsListener((HierarchyBoundsListener)objectInputStream.readObject());
                        continue;
                    }
                    objectInputStream.readObject();
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block17;
                throw optionalDataException;
            }
        }
        if (this.popups != null) {
            int n = this.popups.size();
            int n2 = 0;
            while (n2 < n) {
                PopupMenu popupMenu = (PopupMenu)this.popups.elementAt(n2);
                popupMenu.parent = this;
                ++n2;
            }
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = this.componentOrientation;
        this.componentOrientation = componentOrientation;
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
        if (this.valid) {
            this.invalidate();
        }
    }

    public ComponentOrientation getComponentOrientation() {
        return this.componentOrientation;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    int getAccessibleIndexInParent() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = -1;
            Container container = this.getParent();
            if (container != null && container instanceof Accessible) {
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    if (componentArray[n2] instanceof Accessible) {
                        ++n;
                    }
                    if (this.equals(componentArray[n2])) {
                        int n3 = n;
                        return n3;
                    }
                    ++n2;
                }
            }
            int n4 = -1;
            return n4;
        }
    }

    AccessibleStateSet getAccessibleStateSet() {
        Object object = this.getTreeLock();
        synchronized (object) {
            AccessibleSelection accessibleSelection;
            AccessibleContext accessibleContext;
            Accessible accessible;
            Object object2;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (this.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (this.isFocusTraversable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (this.hasFocus()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (this instanceof Accessible && (object2 = ((Accessible)((Object)this)).getAccessibleContext()) != null && (accessible = ((AccessibleContext)object2).getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                int n = ((AccessibleContext)object2).getAccessibleIndexInParent();
                if (n >= 0 && accessibleSelection.isAccessibleChildSelected(n)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
            }
            if (this instanceof JComponent && ((JComponent)this).isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            object2 = accessibleStateSet;
            return object2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NativeLibLoader.loadLibraries();
        Component.initIDs();
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.incrementaldraw"));
        isInc = string == null || string.equals("true");
        string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.redrawrate"));
        incRate = string != null ? Integer.parseInt(string) : 100;
        RepaintArea.setRepaintCallback(GraphicsCallback.PaintCallback.getInstance());
        metrics = new Hashtable();
    }

    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected ComponentListener accessibleAWTComponentHandler = null;
        protected FocusListener accessibleAWTFocusHandler = null;

        protected AccessibleAWTComponent() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleAWTComponentHandler == null) {
                this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler();
                Component.this.addComponentListener(this.accessibleAWTComponentHandler);
            }
            if (this.accessibleAWTFocusHandler == null) {
                this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler();
                Component.this.addFocusListener(this.accessibleAWTFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleAWTComponentHandler != null) {
                Component.this.removeComponentListener(this.accessibleAWTComponentHandler);
                this.accessibleAWTComponentHandler = null;
            }
            if (this.accessibleAWTFocusHandler != null) {
                Component.this.removeFocusListener(this.accessibleAWTFocusHandler);
                this.accessibleAWTFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public String getAccessibleName() {
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return Component.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = Component.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return Component.this.getAccessibleIndexInParent();
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() {
            return Component.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Component.this.getBackground();
        }

        public void setBackground(Color color) {
            Component.this.setBackground(color);
        }

        public Color getForeground() {
            return Component.this.getForeground();
        }

        public void setForeground(Color color) {
            Component.this.setForeground(color);
        }

        public Cursor getCursor() {
            return Component.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Component.this.setCursor(cursor);
        }

        public Font getFont() {
            return Component.this.getFont();
        }

        public void setFont(Font font) {
            Component.this.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            if (font == null) {
                return null;
            }
            return Component.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = Component.this.isEnabled();
            Component.this.setEnabled(bl);
            if (bl != bl2 && Component.this.accessibleContext != null) {
                if (bl) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
                } else {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
                }
            }
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean bl) {
            boolean bl2 = Component.this.isVisible();
            Component.this.setVisible(bl);
            if (bl != bl2 && Component.this.accessibleContext != null) {
                if (bl) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                } else {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(Point point) {
            return Component.this.contains(point);
        }

        public Point getLocationOnScreen() {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                if (Component.this.isShowing()) {
                    Point point = Component.this.getLocationOnScreen();
                    return point;
                }
                Point point = null;
                return point;
            }
        }

        public Point getLocation() {
            return Component.this.getLocation();
        }

        public void setLocation(Point point) {
            Component.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return Component.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            Component.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return Component.this.getSize();
        }

        public void setSize(Dimension dimension) {
            Component.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusTraversable();
        }

        public void requestFocus() {
            Component.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            Component.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            Component.this.removeFocusListener(focusListener);
        }

        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            protected AccessibleAWTFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }

        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            protected AccessibleAWTComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    private final class NativeInLightFixer
    implements ComponentListener,
    ContainerListener {
        Vector lightParents = new Vector();
        Container nativeHost;

        NativeInLightFixer() {
            Container container = Component.this.parent;
            while (container.peer instanceof LightweightPeer) {
                container.addComponentListener(this);
                container.addContainerListener(this);
                this.lightParents.addElement(container);
                container = container.parent;
            }
            this.nativeHost = container;
            container.addContainerListener(this);
            this.componentMoved(null);
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                int n = Component.this.x;
                int n2 = Component.this.y;
                Container container = Component.this.parent;
                while (container != null && container.peer instanceof LightweightPeer) {
                    n += container.x;
                    n2 += container.y;
                    container = container.parent;
                }
                if (Component.this.peer != null) {
                    Component.this.peer.setBounds(n, n2, Component.this.width, Component.this.height);
                }
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (Component.this.isShowing()) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.show();
                    }
                }
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (Component.this.visible) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.hide();
                    }
                }
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component == Component.this) {
                this.removeReferences();
            } else {
                int n = this.lightParents.size();
                int n2 = 0;
                while (n2 < n) {
                    Container container = (Container)this.lightParents.elementAt(n2);
                    if (container == component) {
                        this.removeReferences();
                        break;
                    }
                    ++n2;
                }
            }
        }

        void removeReferences() {
            int n = this.lightParents.size();
            int n2 = 0;
            while (n2 < n) {
                Container container = (Container)this.lightParents.elementAt(n2);
                container.removeComponentListener(this);
                container.removeContainerListener(this);
                ++n2;
            }
            this.nativeHost.removeContainerListener(this);
        }
    }

    static class AWTTreeLock {
        AWTTreeLock() {
        }
    }
}

