/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import com.sun.media.sound.SimpleInputDeviceProvider;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import javax.sound.sampled.TargetDataLine;

class SimpleInputDevice
extends AbstractMixer {
    private JSSecurity jsSecurity;
    private Port[] ports;
    private boolean implStarted = false;
    static /* synthetic */ Class class$javax$sound$sampled$DataLine;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;
    static /* synthetic */ Class class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine;

    SimpleInputDevice(SimpleInputDeviceProvider.InputDeviceInfo inputDeviceInfo) {
        super(null, new Control[0], null, -1, inputDeviceInfo, null, null);
        int n;
        AudioFormat[] audioFormatArray;
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: constructor");
        }
        this.jsSecurity = JSSecurityManager.getJSSecurity();
        Platform.initialize();
        this.nGetFormats(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), this.formats, AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ULAW, AudioFormat.Encoding.ALAW);
        Vector vector = this.formats;
        synchronized (vector) {
            audioFormatArray = new AudioFormat[this.formats.size()];
            n = 0;
            while (n < audioFormatArray.length) {
                audioFormatArray[n] = (AudioFormat)this.formats.elementAt(n);
                ++n;
            }
        }
        this.info = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = SimpleInputDevice.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, audioFormatArray, 0, -1);
        n = this.nGetNumPorts();
        this.sourceLineInfo = new Port.Info[n];
        this.ports = new Port[n];
        int n2 = 0;
        while (n2 < n) {
            String string = this.nGetPortName(n2);
            this.sourceLineInfo[n2] = this.getPortInfo(string);
            this.ports[n2] = new InputDevicePort((Port.Info)this.sourceLineInfo[n2], this, new Control[0]);
            ++n2;
        }
        this.targetLineInfo = new DataLine.Info[1];
        this.targetLineInfo[0] = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = SimpleInputDevice.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, audioFormatArray, 0, -1);
        this.format = this.formats.size() > 0 ? (AudioFormat)this.formats.lastElement() : null;
        this.defaultFormat = this.format;
        this.defaultBufferSize = this.bufferSize;
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: constructor completed");
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        DataLine.Info info2;
        Line.Info info3 = this.getLineInfo(info);
        if (info3 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info3 instanceof Port.Info) {
            int n = 0;
            while (n < this.ports.length) {
                if (info3.equals(this.ports[n].getLineInfo())) {
                    return this.ports[n];
                }
                ++n;
            }
        }
        if (info3 instanceof DataLine.Info && (info2 = (DataLine.Info)info3).getLineClass().isAssignableFrom(class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine == null ? (class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine = SimpleInputDevice.class$("com.sun.media.sound.SimpleInputDevice$InputDeviceDataLine")) : class$com$sun$media$sound$SimpleInputDevice$InputDeviceDataLine)) {
            AudioFormat[] audioFormatArray;
            int n = -1;
            AudioFormat audioFormat = null;
            if (info instanceof DataLine.Info) {
                audioFormatArray = ((DataLine.Info)info).getFormats();
                if (audioFormatArray != null && audioFormatArray.length > 0) {
                    audioFormat = audioFormatArray[audioFormatArray.length - 1];
                }
                if ((n = ((DataLine.Info)info).getMaxBufferSize()) == -1) {
                    n = ((DataLine.Info)info).getMinBufferSize();
                }
                if (n <= 0) {
                    n = -1;
                }
            }
            if (audioFormat == null) {
                audioFormatArray = info2.getFormats();
                audioFormat = audioFormatArray[audioFormatArray.length - 1];
            }
            if (n == -1) {
                n = (int)(audioFormat.getFrameRate() * (float)audioFormat.getFrameSize() / 2.0f);
            }
            return new InputDeviceDataLine(info2, this, audioFormat, n);
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return 1;
        }
        if (info2 instanceof DataLine.Info) {
            return -1;
        }
        return 0;
    }

    public void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implOpen");
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = 8;
        int n3 = 0;
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            n3 = 1;
        } else if (audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            n3 = 2;
        }
        this.nOpen(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), n3, (int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), n / (audioFormat.getFrameSize() * n2));
        this.format = audioFormat;
        this.bufferSize = this.nGetBufferSizeInFrames() * audioFormat.getFrameSize() * n2;
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implOpen succeeded");
        }
    }

    public void implClose() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implClose");
        }
        this.nClose();
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implClose succeeded");
        }
    }

    void implStart() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implStart");
        }
        if (!this.implStarted) {
            if (Printer.debug) {
                Printer.debug("SimpleInputDevice: implStart: starting the device");
            }
            this.nStart();
            this.implStarted = true;
        } else {
            if (Printer.debug) {
                Printer.debug("SimpleInputDevice: implStart: resuming the device");
            }
            this.nResume();
        }
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implStart succeeded");
        }
    }

    void implStop() {
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implStop");
        }
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implStop");
        }
        this.nPause();
        this.releaseMonitors();
        this.setActive(false);
        this.setStarted(false);
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implStop succeeded");
        }
    }

    protected void open(DataLine dataLine, AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + dataLine + ")");
        }
        if (this.equals(dataLine)) {
            return;
        }
        if (this.isSourceLine(dataLine.getLineInfo())) {
            if (!this.sourceLines.contains(dataLine)) {
                this.open(audioFormat, n);
                this.sourceLines.addElement(dataLine);
            }
        } else if (this.isTargetLine(dataLine.getLineInfo())) {
            if (!this.targetLines.contains(dataLine)) {
                this.open(audioFormat, n);
                this.targetLines.addElement(dataLine);
            }
        } else if (Printer.err) {
            Printer.err("Unknown line received for AbstractMixer.open(Line): " + dataLine);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(line, format, bufferSize) completed");
        }
    }

    private Port.Info getPortInfo(String string) {
        if (string.equals(Port.Info.MICROPHONE.toString())) {
            return Port.Info.MICROPHONE;
        }
        if (string.equals(Port.Info.LINE_IN.toString())) {
            return Port.Info.LINE_IN;
        }
        if (string.equals(Port.Info.COMPACT_DISC.toString())) {
            return Port.Info.COMPACT_DISC;
        }
        return new InputDevicePortInfo(string);
    }

    private void releaseMonitors() {
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: releaseMonitors() started");
        }
        try {
            this.notifyAll();
            this.wait(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Vector vector = (Vector)this.targetLines.clone();
        int n = 0;
        while (n < vector.size()) {
            try {
                vector.elementAt(n).notifyAll();
                vector.elementAt(n).wait(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: releaseMonitors() finished");
        }
    }

    private void callbackCaptureStreamDestroy() {
        if (Printer.debug) {
            Printer.debug("SimpleInputDevice: callbackCaptureStreamDestroy");
        }
    }

    private void callbackStreamPutData(byte[] byArray, int n) {
        if (Printer.verbose) {
            Printer.verbose(">> SimpleInputDevice: callbackStreamPutData: data: " + byArray + " data.length: " + byArray.length + " lengthInFrames: " + n);
        }
        this.setActive(true);
        this.setStarted(true);
        int n2 = n * this.format.getFrameSize();
        Vector vector = (Vector)this.targetLines.clone();
        int n3 = 0;
        while (n3 < vector.size()) {
            InputDeviceDataLine inputDeviceDataLine = (InputDeviceDataLine)vector.elementAt(n3);
            if (inputDeviceDataLine.isOpen() && inputDeviceDataLine.isStartedRunning()) {
                inputDeviceDataLine.setActive(true);
                inputDeviceDataLine.setStarted(true);
                int n4 = inputDeviceDataLine.getCircularBuffer().writeover(byArray, 0, n2);
                InputDeviceDataLine inputDeviceDataLine2 = inputDeviceDataLine;
                synchronized (inputDeviceDataLine2) {
                    inputDeviceDataLine.notifyAll();
                }
                if (n4 > 0 && Printer.debug) {
                    Printer.debug("callbackStreamPutData: buffer overflow for line " + inputDeviceDataLine + "!  received " + n2 + " bytes, dumped " + n4);
                }
            }
            ++n3;
        }
        if (Printer.verbose) {
            Printer.verbose("<< SimpleInputDevice: callbackStreamPutData completed");
        }
    }

    private native void nGetFormats(int var1, Vector var2, AudioFormat.Encoding var3, AudioFormat.Encoding var4, AudioFormat.Encoding var5, AudioFormat.Encoding var6);

    private native void nOpen(int var1, int var2, float var3, int var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose();

    private native void nStart();

    private native void nPause();

    private native void nResume();

    private native void nDrain();

    private native void nFlush();

    private native long nGetPosition();

    private native int nGetBufferSizeInFrames();

    private native int nGetNumPorts();

    private native String nGetPortName(int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class InputDevicePortInfo
    extends Port.Info {
        static /* synthetic */ Class class$javax$sound$sampled$Port;

        private InputDevicePortInfo(String string) {
            super(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = InputDevicePortInfo.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port, string, true);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class InputDevicePort
    extends AbstractLine
    implements Port {
        private InputDevicePort(Port.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
            super(info, abstractMixer, controlArray);
        }

        public synchronized void open() throws LineUnavailableException {
            if (!this.isOpen()) {
                if (SimpleInputDevice.this.jsSecurity != null) {
                    SimpleInputDevice.this.jsSecurity.checkRecordPermission();
                }
                this.mixer.open(this);
                this.setOpen(true);
            }
        }

        public synchronized void close() {
            if (this.isOpen()) {
                if (SimpleInputDevice.this.jsSecurity != null) {
                    SimpleInputDevice.this.jsSecurity.checkRecordPermission();
                }
                this.setOpen(false);
                this.mixer.close(this);
            }
        }
    }

    private class InputDeviceDataLine
    extends AbstractDataLine
    implements TargetDataLine {
        private CircularBuffer circularBuffer = null;

        private InputDeviceDataLine(DataLine.Info info, SimpleInputDevice simpleInputDevice2, AudioFormat audioFormat, int n) {
            super(info, simpleInputDevice2, null, audioFormat, n);
            if (Printer.trace) {
                Printer.trace("InputDeviceDataLine CONSTRUCTOR: info: " + info + " initialFormat: " + audioFormat + " initialBufferSize: " + n);
            }
        }

        public int read(byte[] byArray, int n, int n2) {
            if (Printer.verbose) {
                Printer.verbose("> InputDeviceDataLine.read(b.length: " + byArray.length + " off: " + n + " len: " + n2);
            }
            int n3 = n2;
            if (n2 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n2 + " bytes )");
            }
            int n4 = 0;
            int n5 = 0;
            while (this.isOpen() && this.isStartedRunning() && n4 < n3) {
                n5 = this.circularBuffer.read(byArray, n, n3 - n4);
                n += n5;
                if ((n4 += n5) >= n3) continue;
                try {
                    InputDeviceDataLine inputDeviceDataLine = this;
                    synchronized (inputDeviceDataLine) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (Printer.verbose) {
                Printer.verbose("< InputDeviceDataLine.read returning: " + n4);
            }
            return n4;
        }

        public int available() {
            return this.circularBuffer.bytesAvailableToRead();
        }

        void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implOpen");
            }
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            n = this.mixer.getBufferSize();
            boolean bl = false;
            boolean bl2 = false;
            if (audioFormat.getSampleSizeInBits() <= 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !Platform.isSigned8()) {
                bl = true;
            } else if (audioFormat.getSampleSizeInBits() <= 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && Platform.isSigned8()) {
                bl = true;
            }
            if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
                bl2 = true;
            }
            this.circularBuffer = new CircularBuffer(n, bl, bl2);
            this.bufferSize = n;
            this.format = audioFormat;
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implOpen succeeded");
            }
        }

        void implClose() {
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implClose()");
            }
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            SimpleInputDevice.this.implStarted = false;
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implClose() succeeded");
            }
        }

        public synchronized void open() throws LineUnavailableException {
            try {
                super.open();
            }
            catch (LineUnavailableException lineUnavailableException) {
                AudioFormat audioFormat = AbstractMixer.getSystemFormat();
                if (audioFormat != null) {
                    this.open(audioFormat);
                }
                throw lineUnavailableException;
            }
        }

        void implStart() {
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implStart");
            }
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implStart succeeded");
            }
        }

        void implStop() {
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implStop");
            }
            this.setActive(false);
            this.setStarted(false);
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implStop succeeded");
            }
        }

        public void drain() {
            if (this.isOpen()) {
                this.circularBuffer.drain();
                SimpleInputDevice.this.nDrain();
            }
        }

        public void flush() {
            if (this.isOpen()) {
                this.circularBuffer.flush();
                SimpleInputDevice.this.nFlush();
            }
        }

        public int getFramePosition() {
            return this.isOpen() ? (int)SimpleInputDevice.this.nGetPosition() : super.getFramePosition();
        }

        private CircularBuffer getCircularBuffer() {
            return this.circularBuffer;
        }
    }
}

