/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12PropertyAction;
import com.sun.media.sound.JDK12Security;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class Platform {
    private static final String[] libraries;
    private static boolean signed8;
    private static boolean bigEndian;
    private static String javahome;
    private static String classpath;
    private static JSSecurity jsSecurity;
    private static boolean securityPrivilege;

    private Platform() {
    }

    static void initialize() {
        if (Printer.trace) {
            Printer.trace("Platform: initialize()");
        }
    }

    static boolean isBigEndian() {
        return bigEndian;
    }

    static boolean isSigned8() {
        return signed8;
    }

    static String getJavahome() {
        return javahome;
    }

    static String getClasspath() {
        return classpath;
    }

    private static void loadLibraries() {
        if (Printer.trace) {
            Printer.trace(">>Platform.loadLibraries");
        }
        try {
            int n = 0;
            while (n < libraries.length) {
                try {
                    if (securityPrivilege) {
                        if (jsSecurity != null) {
                            if (Printer.debug) {
                                Printer.debug("using security manager to load libraries");
                            }
                            jsSecurity.loadLibrary(libraries[n]);
                        } else {
                            if (Printer.debug) {
                                Printer.debug("not using security manager to load libraries");
                            }
                            System.loadLibrary(libraries[n]);
                        }
                        if (Printer.debug) {
                            Printer.debug("loaded library " + libraries[n]);
                        }
                    } else if (Printer.debug) {
                        Printer.debug("no security privilege, did not load library " + libraries[n]);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (Printer.err) {
                        Printer.err("UnsatisfiedLinkError loading native library " + libraries[n]);
                    }
                    throw unsatisfiedLinkError;
                }
                ++n;
            }
        }
        catch (SecurityException securityException) {
            if (Printer.err) {
                Printer.err("Security exception loading native libraries.  JavaSound requires access to these resources.");
            }
            throw securityException;
        }
    }

    private static void readProperties() {
        try {
            bigEndian = false;
            signed8 = false;
            String string = null;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity instanceof JDK12Security) {
                    if (Printer.debug) {
                        Printer.debug("using 12 security to get properties");
                    }
                    try {
                        Constructor constructor = JDK12PropertyAction.cons;
                        string = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"os.arch"})});
                        javahome = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"java.home"})});
                        classpath = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"java.class.path"})});
                    }
                    catch (Exception exception) {
                        if (Printer.debug) {
                            Printer.debug("not using security to get properties");
                        }
                        string = System.getProperty("os.arch");
                        javahome = System.getProperty("java.home");
                        classpath = System.getProperty("java.class.path");
                    }
                } else {
                    if (Printer.debug) {
                        Printer.debug("using security to get properties");
                    }
                    string = jsSecurity.readProperty("os.arch");
                    javahome = jsSecurity.readProperty("java.home");
                    classpath = jsSecurity.readProperty("java.class.path");
                }
            } else {
                if (Printer.debug) {
                    Printer.debug("not using security to get properties");
                }
                string = System.getProperty("os.arch");
                javahome = System.getProperty("java.home");
                classpath = System.getProperty("java.class.path");
            }
            if (string != null) {
                if (string.equals("x86")) {
                    if (Printer.debug) {
                        Printer.debug("found x86 hardware");
                    }
                    bigEndian = false;
                    signed8 = false;
                } else if (string.equals("sparc")) {
                    if (Printer.debug) {
                        Printer.debug("found sparc hardware");
                    }
                    bigEndian = true;
                    signed8 = true;
                } else if (string.equals("ppc")) {
                    if (Printer.debug) {
                        Printer.debug("found power pc hardware");
                    }
                    bigEndian = true;
                    signed8 = false;
                } else if (Printer.err) {
                    Printer.err("could not determine hardware architecture");
                }
            }
        }
        catch (SecurityException securityException) {
            if (Printer.err) {
                Printer.err("Security exception getting system properties.  JavaSound requires access to these resources.");
            }
            throw securityException;
        }
    }

    static {
        Object[][] objectArray;
        Class[] classArray;
        Method[] methodArray;
        block12: {
            libraries = new String[]{"jsound"};
            jsSecurity = null;
            securityPrivilege = false;
            methodArray = new Method[1];
            classArray = new Class[1];
            objectArray = new Object[1][0];
            if (Printer.trace) {
                Printer.trace(">> Platform.java: static");
            }
            try {
                jsSecurity = JSSecurityManager.getJSSecurity();
                securityPrivilege = true;
            }
            catch (SecurityException securityException) {
                if (!Printer.err) break block12;
                Printer.err("Platform.java: Security Exception: " + securityException);
            }
        }
        if (Printer.debug) {
            Printer.debug("jsSecurity: " + jsSecurity);
        }
        if (Printer.debug) {
            Printer.debug("securityPrivilege: " + securityPrivilege);
        }
        if (securityPrivilege && jsSecurity != null) {
            if (!(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity instanceof JDK12Security) {
                    Platform.loadLibraries();
                    Platform.readProperties();
                } else {
                    block13: {
                        try {
                            jsSecurity.requestPermission(methodArray, classArray, objectArray, 1);
                            methodArray[0].invoke(classArray[0], objectArray[0]);
                            jsSecurity.requestPermission(methodArray, classArray, objectArray, 64);
                            methodArray[0].invoke(classArray[0], objectArray[0]);
                        }
                        catch (Exception exception) {
                            if (!Printer.err) break block13;
                            Printer.err("Unable to get read property privilege: " + exception);
                        }
                    }
                    Platform.loadLibraries();
                    Platform.readProperties();
                }
            }
        } else {
            Platform.loadLibraries();
            Platform.readProperties();
        }
    }
}

