/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.HeadspaceInstrument;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.HeadspaceSoundbank;
import com.sun.media.sound.MidiOutDeviceProvider;
import com.sun.media.sound.MixerMidiChannel;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

abstract class AbstractPlayer
extends AbstractMidiDevice
implements Synthesizer {
    private static final String[] defaultSoundbankNames = new String[]{"soundbank-deluxe.gm", "soundbank-mid.gm", "soundbank.gm", "soundbank-min.gm", "sndbank.gm"};
    private static final String soundJarName = "sound.jar";
    private static final Class[] supportedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice == null ? (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")) : class$com$sun$media$sound$SimpleOutputDevice, class$com$sun$media$sound$MidiOutDevice == null ? (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")) : class$com$sun$media$sound$MidiOutDevice};
    static HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
    private static Soundbank defaultSoundbank = null;
    private Class[] orderedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice == null ? (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")) : class$com$sun$media$sound$SimpleOutputDevice, class$com$sun$media$sound$MidiOutDevice == null ? (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")) : class$com$sun$media$sound$MidiOutDevice};
    AbstractMidiDevice internalSynth = null;
    protected MixerMidiChannel[] channels;
    private Vector instruments = new Vector();
    private Vector transmitters = new Vector();
    private Vector receivers = new Vector();
    static /* synthetic */ Class class$com$sun$media$sound$SimpleOutputDevice;
    static /* synthetic */ Class class$com$sun$media$sound$MidiOutDevice;

    protected AbstractPlayer(MidiDevice.Info info) {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer CONSTRUCTOR: " + this);
        }
        this.channels = new MixerMidiChannel[16];
        int n = 0;
        while (n < this.channels.length) {
            this.channels[n] = new MixerMidiChannel(this, n);
            ++n;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer CONSTRUCTOR completed: " + this);
        }
    }

    public synchronized void open() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer open(): " + this);
        }
        if (this.isOpen()) {
            if (Printer.trace) {
                Printer.trace("<< AbstractPlayer open(): already open: " + this);
            }
            return;
        }
        mixer.open(this);
        this.implOpen();
        this.open = true;
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer open(): open completed: " + this);
        }
    }

    public synchronized void close() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer close(): " + this);
        }
        if (this.isOpen()) {
            int n = 0;
            while (n < this.transmitters.size()) {
                ((Transmitter)this.transmitters.elementAt(n)).close();
                ++n;
            }
            this.transmitters.removeAllElements();
            int n2 = 0;
            while (n2 < this.receivers.size()) {
                ((Receiver)this.receivers.elementAt(n2)).close();
                ++n2;
            }
            this.receivers.removeAllElements();
            this.open = false;
            this.implClose();
            mixer.close(this);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer close() completed: " + this);
        }
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        PlayerOutTransmitter playerOutTransmitter = new PlayerOutTransmitter();
        this.transmitters.addElement(playerOutTransmitter);
        return playerOutTransmitter;
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        PlayerReceiver playerReceiver = new PlayerReceiver();
        this.receivers.addElement(playerReceiver);
        return playerReceiver;
    }

    public int getMaxPolyphony() {
        return HeadspaceMixer.getMixerInstance().getMidiVoices();
    }

    public long getLatency() {
        return 0L;
    }

    public MidiChannel[] getChannels() {
        MidiChannel[] midiChannelArray = new MidiChannel[this.channels.length];
        System.arraycopy(this.channels, 0, midiChannelArray, 0, this.channels.length);
        return midiChannelArray;
    }

    public VoiceStatus[] getVoiceStatus() {
        return new VoiceStatus[0];
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return soundbank instanceof HeadspaceSoundbank;
    }

    public boolean loadInstrument(Instrument instrument) {
        if (this.instruments.contains(instrument)) {
            return true;
        }
        try {
            if (this.nLoadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.addElement(instrument);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public void unloadInstrument(Instrument instrument) {
        try {
            if (this.nUnloadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.removeElement(instrument);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        try {
            return this.nRemapInstrument(this.id, ((HeadspaceInstrument)instrument).getId(), ((HeadspaceInstrument)instrument2).getId());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank() + " or " + instrument2.getSoundbank());
        }
    }

    public Soundbank getDefaultSoundbank() {
        return defaultSoundbank;
    }

    public Instrument[] getAvailableInstruments() {
        if (defaultSoundbank != null) {
            return defaultSoundbank.getInstruments();
        }
        return new Instrument[0];
    }

    public Instrument[] getLoadedInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            int n = 0;
            while (n < instrumentArray.length) {
                instrumentArray[n] = (Instrument)this.instruments.elementAt(n);
                ++n;
            }
        }
        return instrumentArray;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        boolean bl = true;
        Instrument[] instrumentArray = soundbank.getInstruments();
        int n = 0;
        while (n < instrumentArray.length) {
            if (!this.loadInstrument(instrumentArray[n])) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
        Instrument[] instrumentArray = soundbank.getInstruments();
        int n = 0;
        while (n < instrumentArray.length) {
            this.unloadInstrument(instrumentArray[n]);
            ++n;
        }
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        boolean bl = true;
        int n = 0;
        while (n < patchArray.length) {
            Instrument instrument = soundbank.getInstrument(patchArray[n]);
            if (instrument != null) {
                if (!this.loadInstrument(instrument)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
        int n = 0;
        while (n < patchArray.length) {
            Instrument instrument = soundbank.getInstrument(patchArray[n]);
            if (instrument != null) {
                this.unloadInstrument(instrument);
            }
            ++n;
        }
    }

    public void setMidiOutClasses(Class[] classArray) {
        boolean bl = false;
        int n = 0;
        while (n < classArray.length) {
            bl = false;
            int n2 = 0;
            while (n2 < supportedMidiOutClasses.length) {
                if (supportedMidiOutClasses[n2].isAssignableFrom(classArray[n])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new IllegalArgumentException("Unsupported class for midi out services: " + classArray[n]);
            }
            ++n;
        }
        this.orderedMidiOutClasses = classArray;
    }

    public Class[] getMidiOutClasses() {
        return this.orderedMidiOutClasses;
    }

    abstract long getTimeStamp();

    abstract void setTimeStamp(long var1);

    boolean isUsingSoftwareSynth() {
        return this.internalSynth == this;
    }

    protected void openInternalSynth() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openInternalSynth: " + this);
        }
        if (this.internalSynth != null) {
            if (Printer.trace) {
                Printer.trace("<< AbstractPlayer: openInternalSynth: internalSynth already set: " + this.internalSynth);
            }
            return;
        }
        int n = 0;
        while (n < this.orderedMidiOutClasses.length) {
            if (Printer.debug) {
                Printer.debug("AbstractPlayer: openInternalSynth: checking orderedMidiOutClasses[" + n + "] : " + this.orderedMidiOutClasses[n]);
            }
            if ((class$com$sun$media$sound$MidiOutDevice == null ? AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice") : class$com$sun$media$sound$MidiOutDevice).isAssignableFrom(this.orderedMidiOutClasses[n])) {
                if (Printer.debug) {
                    Printer.debug("AbstractPlayer: openInternalSynth: trying midi out");
                }
                this.internalSynth = this.openMidiOut();
                if (this.internalSynth != null) {
                    if (Printer.debug) {
                        Printer.debug("AbstractPlayer: openInternalSynth: got it! internalSynth: " + this.internalSynth);
                    }
                    return;
                }
            } else if ((class$com$sun$media$sound$SimpleOutputDevice == null ? AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice") : class$com$sun$media$sound$SimpleOutputDevice).isAssignableFrom(this.orderedMidiOutClasses[n])) {
                if (Printer.debug) {
                    Printer.debug("AbstractPlayer: openInternalSynth: trying software midi");
                }
                if (defaultSoundbank == null) {
                    defaultSoundbank = this.loadDefaultSoundbank();
                }
                if (defaultSoundbank != null) {
                    this.internalSynth = this.openSoftwareSynth();
                    if (Printer.debug) {
                        Printer.debug("AbstractPlayer: openInternalSynth: got it! internalSynth: " + this.internalSynth);
                    }
                    return;
                }
            }
            ++n;
        }
        this.internalSynth = this.openSoftwareSynth();
        if (defaultSoundbank == null && (defaultSoundbank = this.loadDefaultSoundbank()) == null && Printer.err) {
            Printer.err("\nWARNING: The default soundbank is not loaded.\nAudio synthesis may be unavailable until instruments are loaded.\n");
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openInternalSynth: internalSynth" + this.internalSynth);
        }
    }

    protected void closeInternalSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: closeInternalSynth");
        }
        if (this.internalSynth != this) {
            this.nRemoveReceiver(this.id, this.internalSynth.getId());
            this.internalSynth.close(this);
        } else {
            this.nRemoveReceiver(this.id, 0L);
        }
        this.internalSynth = null;
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: closeInternalSynth completed");
        }
    }

    protected AbstractMidiDevice openSoftwareSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openSoftwareSynth");
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openSoftwareSynth returning: " + this);
        }
        return this;
    }

    protected AbstractMidiDevice openMidiOut() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openMidiOut");
        }
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        while (n < infoArray.length) {
            block7: {
                if (infoArray[n] instanceof MidiOutDeviceProvider.MidiOutDeviceInfo) {
                    try {
                        AbstractMidiDevice abstractMidiDevice = (AbstractMidiDevice)MidiSystem.getMidiDevice(infoArray[n]);
                        abstractMidiDevice.open();
                        if (Printer.trace) {
                            Printer.trace("<< AbstractPlayer: openMidiOut returning: " + abstractMidiDevice);
                        }
                        return abstractMidiDevice;
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        if (!Printer.debug) break block7;
                        Printer.debug("<< AbstractPlayer: openMidiOut: failed to open midi out device: " + midiUnavailableException);
                    }
                }
            }
            ++n;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openMidiOut returning null");
        }
        return null;
    }

    protected void connectToInternalSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: connectToInternalSynth");
        }
        if (this.internalSynth == null) {
            if (Printer.err) {
                Printer.err("AbstractPlayer.connectToInternalSynth: internalSynth is null!");
            }
            return;
        }
        if (this.internalSynth == this) {
            AbstractPlayer abstractPlayer = this;
            synchronized (abstractPlayer) {
                this.nAddReceiver(this.id, 0L);
            }
        }
        AbstractPlayer abstractPlayer = this;
        synchronized (abstractPlayer) {
            this.nAddReceiver(this.id, this.internalSynth.getId());
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: connectToInternalSynth completed");
        }
    }

    synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: implClose");
        }
        this.closeInternalSynth();
        long l = this.id;
        this.id = 0L;
        int n = 0;
        while (n < this.channels.length) {
            this.channels[n].setId(this.id);
            ++n;
        }
        this.nClose(l);
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: implClose completed");
        }
    }

    protected boolean parse(int n, int n2, int n3, int n4, long l) {
        if (n == 128) {
            this.setTimeStamp(l);
            this.channels[n2].noteOff(n3, n4);
            return true;
        }
        if (n == 144) {
            this.setTimeStamp(l);
            this.channels[n2].noteOn(n3, n4);
            return true;
        }
        if (n == 160) {
            this.setTimeStamp(l);
            this.channels[n2].setPolyPressure(n3, n4);
            return true;
        }
        if (n == 176) {
            this.setTimeStamp(l);
            this.channels[n2].controlChange(n3, n4);
            return true;
        }
        if (n == 192) {
            this.setTimeStamp(l);
            this.channels[n2].programChange(n3, n4);
            return true;
        }
        if (n == 208) {
            this.setTimeStamp(l);
            this.channels[n2].setChannelPressure(n3);
            return true;
        }
        if (n == 224) {
            this.setTimeStamp(l);
            this.channels[n2].setPitchBend(n3 & 0xF0 | n4 & 0xF);
            return true;
        }
        return false;
    }

    private Soundbank loadDefaultSoundbank() {
        HeadspaceSoundbank headspaceSoundbank = null;
        int n = 0;
        while (n < defaultSoundbankNames.length) {
            String string;
            String string2 = defaultSoundbankNames[n];
            try {
                string = "file:" + string2;
                URL uRL = new URL(string);
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + uRL);
                }
                if ((headspaceSoundbank = new HeadspaceSoundbank(uRL)) != null) {
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String string3 = Platform.getClasspath();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && headspaceSoundbank == null) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4.substring(string4.lastIndexOf(File.separatorChar) + 1, string4.length());
                if (!string5.equals(soundJarName)) continue;
                string = string4.substring(0, string4.lastIndexOf(File.separatorChar));
                string = string + File.separatorChar + string2;
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + string);
                }
                try {
                    headspaceSoundbank = new HeadspaceSoundbank(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (headspaceSoundbank != null) break;
            string = Platform.getJavahome();
            string = string + File.separatorChar + "lib" + File.separatorChar + "audio" + File.separatorChar + string2;
            try {
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + string);
                }
                if ((headspaceSoundbank = new HeadspaceSoundbank(string)) != null) {
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        if (Printer.debug) {
            Printer.debug("Default soundbank: " + headspaceSoundbank);
        }
        return headspaceSoundbank;
    }

    protected native void nClose(long var1);

    protected native void nAddReceiver(long var1, long var3);

    protected native void nRemoveReceiver(long var1, long var3);

    private native boolean nLoadInstrument(long var1, int var3);

    private native boolean nUnloadInstrument(long var1, int var3);

    private native boolean nRemapInstrument(long var1, int var3, int var4);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PlayerReceiver
    implements Receiver {
        private boolean open = true;

        PlayerReceiver() {
        }

        public void send(MidiMessage midiMessage, long l) {
            if (!this.open) {
                return;
            }
            if (AbstractPlayer.this.id == 0L) {
                throw new IllegalStateException("Synthesizer is not open.");
            }
            Vector vector = AbstractPlayer.this.transmitters;
            synchronized (vector) {
                int n = 0;
                while (n < AbstractPlayer.this.transmitters.size()) {
                    Receiver receiver = ((Transmitter)AbstractPlayer.this.transmitters.elementAt(n)).getReceiver();
                    if (receiver != null) {
                        receiver.send(midiMessage, l);
                    }
                    ++n;
                }
            }
            if (!(midiMessage instanceof ShortMessage)) {
                if (Printer.err) {
                    Printer.err("Unsupported message type: " + midiMessage);
                }
                return;
            }
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            AbstractPlayer.this.parse(shortMessage.getCommand(), shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2(), l);
        }

        public void close() {
            AbstractPlayer.this.receivers.removeElement(this);
            this.open = false;
        }
    }

    class PlayerOutTransmitter
    implements Transmitter {
        private boolean open = true;
        private Receiver receiver = null;

        PlayerOutTransmitter() {
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            AbstractPlayer.this.transmitters.removeElement(this);
            this.open = false;
        }
    }
}

