/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    private static final JTextField sizer = new JTextField();

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        if (this.comboBox.getRenderer() instanceof UIResource) {
            sizer.setFont(this.comboBox.getFont());
            dimension.height = WindowsComboBoxUI.sizer.getPreferredSize().height;
        } else {
            dimension.height += insets.top + insets.bottom;
        }
        int n = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return dimension;
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        ActionMap actionMap2 = (ActionMap)UIManager.get("ComboBox.actionMap");
        super.installKeyboardActions();
        if (actionMap2 == null && (actionMap = (ActionMap)UIManager.get("ComboBox.actionMap")) != null) {
            actionMap.put("selectPrevious", new UpAction());
            actionMap.put("selectNext", new DownAction());
        }
    }

    void windowsSetPopupVisible(boolean bl) {
        this.setPopupVisible(this.comboBox, bl);
    }

    protected ComboPopup createPopup() {
        return new WindowsComboPopup(this.comboBox);
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (!jComboBox.isEditable() || jComboBox.isEditable() && windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.selectPreviousPossibleValue();
                }
            }
        }
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (!jComboBox.isEditable() || jComboBox.isEditable() && windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.selectNextPossibleValue();
                }
            }
        }
    }

    protected class WindowsComboPopup
    extends BasicComboPopup {
        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 115) {
                    if (WindowsComboPopup.this.isVisible()) {
                        WindowsComboPopup.this.hide();
                    } else {
                        WindowsComboPopup.this.show();
                    }
                } else if (keyEvent.isAltDown() && keyEvent.getKeyCode() != 18) {
                    if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                        if (WindowsComboPopup.this.isVisible()) {
                            WindowsComboPopup.this.hide();
                        } else {
                            WindowsComboPopup.this.show();
                        }
                    }
                } else if (WindowsComboPopup.this.comboBox.isEditable() && !WindowsComboPopup.this.isVisible() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                    WindowsComboPopup.this.show();
                } else if (!WindowsComboPopup.this.comboBox.isEditable() && WindowsComboPopup.this.isVisible()) {
                    super.keyReleased(keyEvent);
                }
            }
        }
    }
}

