/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.rmi.ras.Utility;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ListenerThread
extends com.ibm.CORBA.transport.ListenerThread {
    protected static final int MAX_CLEANUP_RETRIES = 5;
    protected ServerSocket serverSocket;
    protected int acceptTimeout;
    protected ConnectionTable connectionTable;
    protected TransportBase transportBase = null;
    static int instanceCounter = 0;
    int thisInstanceNumber;

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, String string, TransportBase transportBase) {
        this(connectionTable, serverSocket, 0, string, transportBase);
    }

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, int n, String string, TransportBase transportBase) {
        super(string);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "<init>:99", (Object)("serverSocket=" + serverSocket + " timeout=" + n));
        }
        this.serverSocket = serverSocket;
        this.acceptTimeout = n;
        this.connectionTable = connectionTable;
        this.thisInstanceNumber = instanceCounter++;
        this.transportBase = transportBase;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:113");
        }
    }

    public void run() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "run:127");
        }
        final String string = "LT=" + this.thisInstanceNumber + ":" + this.getName();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ListenerThread.this.setName(string);
                return null;
            }
        });
        int n = 0;
        try {
            this.serverSocket.setSoTimeout(this.acceptTimeout);
        }
        catch (SocketException socketException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "run:161", (Exception)socketException);
        }
        while (true) {
            try {
                while (true) {
                    Socket socket;
                    block13: {
                        socket = this.serverSocket.accept();
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(8208L, this, "run:182", Utility.getMessage("ListenerThread.acceptSocket", socket.toString()));
                        }
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (Exception exception) {
                            if (!ORBRas.isTrcLogging) break block13;
                            ORBRas.orbTrcLogger.trace(8208L, this, "run:195", exception.toString());
                        }
                    }
                    this.transportBase.createTransportConnection(socket, this);
                    n = 0;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.isShutdownPending()) continue;
                if (!ORBRas.isTrcLogging) break;
                ORBRas.orbTrcLogger.trace(8208L, this, "run:218", "accept interrupted with shutdown pending");
            }
            catch (SocketException socketException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "run:229", (Exception)socketException);
                if (n == 5 || !this.connectionTable.cleanUp()) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "run:252", exception);
                continue;
            }
            break;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "run:260");
        }
    }
}

