/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.ORBRas;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class LibraryManager {
    private static final String thisClassName = "com.ibm.rmi.io.LibraryManager";
    private static boolean attempted = false;
    private static boolean isLoaded = false;
    private static int majorVersion = 2;
    private static int minorVersion = 1;

    private static native int getMajorVersion();

    private static native int getMinorVersion();

    public static boolean load() {
        block10: {
            if (attempted) {
                return isLoaded;
            }
            attempted = true;
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.loadLibrary("orb");
                        return null;
                    }
                });
                isLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, thisClassName, "load:77", unsatisfiedLinkError.toString());
                }
            }
            catch (Exception exception) {
                if (!ORBRas.isTrcLogging) break block10;
                ORBRas.orbTrcLogger.trace(4112L, thisClassName, "load:87", exception.toString());
            }
        }
        if (isLoaded) {
            int n = LibraryManager.getMajorVersion();
            int n2 = LibraryManager.getMinorVersion();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, thisClassName, "load:100", "orb library: expected " + majorVersion + "." + minorVersion + " loaded " + n + "." + n2);
            }
            if (n != majorVersion || n2 != minorVersion) {
                System.err.println("WARNING : The orb library is not the correct version.");
                System.err.println("          Expected v" + majorVersion + "." + minorVersion + " but loaded v" + n + "." + n2 + "\n");
                System.err.println("          *** YOU ARE ADVISED TO USE EXPECTED VERSION ***");
                if (n != majorVersion) {
                    isLoaded = false;
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, thisClassName, "load:129", isLoaded ? "Using native orb library" : "Not using native orb library. Performance may be degraded");
        }
        return isLoaded;
    }
}

