/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.IOOutputStream;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.classloader.TransientAllocation;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.io.OutputStreamHook;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Stack;
import javax.rmi.CORBA.Util;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPOutputStream
extends OutputStreamHook
implements TransientAllocation,
IOOutputStream {
    private static final String thisClassName = "com.ibm.rmi.io.IIOPOutputStream";
    private static final byte kFormatVersionOne = 1;
    private OutputStream orbStream;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int recursionDepth = 0;
    private int simpleWriteDepth = 0;
    private IOException abortIOException = null;
    private Stack classDescStack = new Stack();
    private Object[] writeObjectArglist = new Object[]{this};
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
    }

    public final OutputStream getOrbStream() {
        return this.orbStream;
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    public final void writeObjectDelegate(Object object) {
        Util.writeAbstractObject(this.orbStream, object);
    }

    public final void writeObjectOverride(Object object) throws IOException {
        this.writeObjectDelegate(object);
    }

    public final void simpleWriteObject(Object object) throws IOException {
        Object object2 = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleWriteDepth;
        try {
            try {
                this.outputObject(object);
            }
            catch (IOException iOException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "simpleWriteObject:153", (Exception)iOException);
                if (this.abortIOException == null) {
                    this.abortIOException = iOException;
                }
                Object var7_5 = null;
                --this.simpleWriteDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
            }
            Object var7_4 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            throw throwable;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleWriteDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public final void defaultWriteObjectDelegate() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObjectDelegate");
        }
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        if (objectStreamFieldArray.length > 0) {
            this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
        }
    }

    public final boolean enableReplaceObjectDelegate(boolean bl) {
        return false;
    }

    protected final void annotateClass(Class clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    public final void close() throws IOException {
    }

    protected final void drain() throws IOException {
    }

    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "flush:231", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final Object replaceObject(Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    public final void reset() throws IOException {
        try {
            if (this.currentObject != null || this.currentClassDesc != null) {
                throw new IOException("Illegal call to reset");
            }
            this.abortIOException = null;
            if (this.classDescStack == null) {
                this.classDescStack = new Stack();
            } else {
                this.classDescStack.setSize(0);
            }
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "reset:276", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray) throws IOException {
        try {
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (byte[]):296", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.orbStream.write_octet_array(byArray, n, n2);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (byte[], int, int):316", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void write(int n) throws IOException {
        try {
            this.orbStream.write_octet((byte)(n & 0xFF));
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "write (int):336", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBoolean(boolean bl) throws IOException {
        try {
            this.orbStream.write_boolean(bl);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeBoolean:356", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeByte(int n) throws IOException {
        try {
            this.orbStream.write_octet((byte)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeByte:376", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBytes(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeBytes:397", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChar(int n) throws IOException {
        try {
            this.orbStream.write_wchar((char)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeChar:417", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChars(String string) throws IOException {
        try {
            char[] cArray = string.toCharArray();
            this.orbStream.write_wchar_array(cArray, 0, cArray.length);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeChars:438", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeDouble(double d) throws IOException {
        try {
            this.orbStream.write_double(d);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeDouble:458", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeFloat(float f) throws IOException {
        try {
            this.orbStream.write_float(f);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeFloat:478", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeInt(int n) throws IOException {
        try {
            this.orbStream.write_long(n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeInt:498", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeLong(long l) throws IOException {
        try {
            this.orbStream.write_longlong(l);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeLong:518", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    public final void writeShort(int n) throws IOException {
        try {
            this.orbStream.write_short((short)n);
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeShort:538", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    protected final void writeStreamHeader() throws IOException {
    }

    public final void writeUTF(String string) throws IOException {
        try {
            if (this.orbStream instanceof PartnerVersion) {
                short s = ((PartnerVersion)((Object)this.orbStream)).getPartnerMajor();
                short s2 = ((PartnerVersion)((Object)this.orbStream)).getPartnerMinor();
                switch (s) {
                    case 11: {
                        this.orbStream.write_string(string);
                        break;
                    }
                    case 12: {
                        this.orbStream.write_string(string);
                        break;
                    }
                    case 13: {
                        this.orbStream.write_string(string);
                        break;
                    }
                    case 4865: {
                        this.orbStream.write_string(string);
                        break;
                    }
                    default: {
                        this.orbStream.write_wstring(string);
                        break;
                    }
                }
            } else {
                this.orbStream.write_wstring(string);
            }
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "writeUTF:574", error.toString(), (Object)error);
            throw new IOException(error.getMessage());
        }
    }

    private boolean checkSpecialClasses(Object object) throws IOException {
        if (object instanceof ObjectStreamClass) {
            throw new IOException("Serialization of ObjectStreamClass not supported");
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(Object object) throws IOException {
        if (object instanceof String) {
            this.orbStream.write_value((Serializable)object);
            return true;
        }
        return false;
    }

    private void outputObject(Object object) throws IOException {
        this.currentObject = object;
        Class clazz = object.getClass();
        this.currentClassDesc = ObjectStreamClass.lookup(clazz);
        if (this.currentClassDesc == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (this.currentClassDesc.isExternalizable()) {
            this.writeByte(1);
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
        } else {
            int n = this.classDescStack.size();
            try {
                ObjectStreamClass objectStreamClass;
                while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                    this.classDescStack.push(this.currentClassDesc);
                    this.currentClassDesc = objectStreamClass;
                }
                do {
                    if (this.currentClassDesc.hasWriteObject()) {
                        this.invokeObjectWriter(this.currentClassDesc, object);
                    } else {
                        this.defaultWriteObjectDelegate();
                    }
                    if (this.classDescStack.size() <= n) break;
                } while ((this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
                Object var6_6 = null;
                this.classDescStack.setSize(n);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.classDescStack.setSize(n);
                throw throwable;
            }
        }
    }

    private void invokeObjectWriter(ObjectStreamClass objectStreamClass, Object object) throws IOException {
        try {
            try {
                this.writeByte(1);
                this.writeBoolean(false);
                objectStreamClass.writeObjectMethod.invoke(object, this.writeObjectArglist);
            }
            catch (InvocationTargetException invocationTargetException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectWriter:710", (Exception)invocationTargetException);
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new Error("invokeObjectWriter internal error");
            }
            catch (IllegalAccessException illegalAccessException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "invokeObjectWriter:726", (Exception)illegalAccessException);
                Object var7_4 = null;
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            throw throwable;
        }
    }

    private void outputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            ReflectField reflectField = objectStreamFieldArray[n].getReflectField();
            if (reflectField == null) {
                throw new InvalidClassException(clazz.getName(), "Nonexistent field " + objectStreamFieldArray[n].getName());
            }
            try {
                block2 : switch (objectStreamFieldArray[n].getTypeCode()) {
                    case 'B': {
                        byte by = reflectField.getByte(object);
                        this.orbStream.write_octet(by);
                        break;
                    }
                    case 'C': {
                        char c = reflectField.getChar(object);
                        this.orbStream.write_wchar(c);
                        break;
                    }
                    case 'F': {
                        float f = reflectField.getFloat(object);
                        this.orbStream.write_float(f);
                        break;
                    }
                    case 'D': {
                        double d = reflectField.getDouble(object);
                        this.orbStream.write_double(d);
                        break;
                    }
                    case 'I': {
                        int n2 = reflectField.getInt(object);
                        this.orbStream.write_long(n2);
                        break;
                    }
                    case 'J': {
                        long l = reflectField.getLong(object);
                        this.orbStream.write_longlong(l);
                        break;
                    }
                    case 'S': {
                        short s = reflectField.getShort(object);
                        this.orbStream.write_short(s);
                        break;
                    }
                    case 'Z': {
                        boolean bl = reflectField.getBoolean(object);
                        this.orbStream.write_boolean(bl);
                        break;
                    }
                    case 'L': 
                    case '[': {
                        Object object2 = reflectField.get(object);
                        ObjectStreamClass objectStreamClass = objectStreamFieldArray[n].getObjectStreamClass();
                        if (objectStreamFieldArray[n].isAny()) {
                            Util.writeAny(this.orbStream, object2);
                            break;
                        }
                        Class clazz2 = objectStreamClass.forClass();
                        int n3 = 2;
                        if (clazz2.isInterface()) {
                            String string = clazz2.getName();
                            if ((class$java$rmi$Remote == null ? IIOPOutputStream.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(clazz2)) {
                                n3 = 0;
                            } else if (objectStreamClass.isAbstractInterface()) {
                                n3 = 1;
                            } else if ((class$org$omg$CORBA$Object == null ? IIOPOutputStream.class$("org.omg.CORBA.Object") : class$org$omg$CORBA$Object).isAssignableFrom(clazz2)) {
                                n3 = 0;
                            } else if (RepositoryId.isAbstractBase(clazz2)) {
                                n3 = 1;
                            }
                        }
                        switch (n3) {
                            case 0: {
                                Util.writeRemoteObject(this.orbStream, object2);
                                break block2;
                            }
                            case 1: {
                                Util.writeAbstractObject(this.orbStream, object2);
                                break block2;
                            }
                            case 2: {
                                try {
                                    this.orbStream.write_value((Serializable)object2, clazz2);
                                    break block2;
                                }
                                catch (ClassCastException classCastException) {
                                    if (object2 instanceof Serializable) {
                                        throw classCastException;
                                    }
                                    ORBRas.orbTrcLogger.exception(4104L, this, "outputClassFields:838", (Exception)classCastException);
                                    Utility.throwNotSerializableForCorba(object2.getClass().getName());
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        throw new InvalidClassException(clazz.getName());
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "outputClassFields:857", (Exception)illegalAccessException);
                throw new InvalidClassException(clazz.getName(), "IllegalAccessException " + objectStreamFieldArray[n].getName());
            }
            ++n;
        }
    }

    protected void putClassFields(Hashtable hashtable) throws IOException {
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        this.putClassFields(hashtable, objectStreamFieldArray);
    }

    private void putClassFields(Hashtable hashtable, ObjectStreamField[] objectStreamFieldArray) throws IOException {
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            Object object = hashtable.get(objectStreamFieldArray[n].getName());
            if (object != null) {
                switch (objectStreamFieldArray[n].getTypeCode()) {
                    case 'B': {
                        byte by = object == null ? (byte)0 : (Byte)object;
                        this.orbStream.write_octet(by);
                        break;
                    }
                    case 'C': {
                        char c = object == null ? (char)'\u0000' : ((Character)object).charValue();
                        this.orbStream.write_wchar(c);
                        break;
                    }
                    case 'F': {
                        float f = object == null ? 0.0f : ((Float)object).floatValue();
                        this.orbStream.write_float(f);
                        break;
                    }
                    case 'D': {
                        double d = object == null ? 0.0 : (Double)object;
                        this.orbStream.write_double(d);
                        break;
                    }
                    case 'I': {
                        int n2 = object == null ? 0 : (Integer)object;
                        this.orbStream.write_long(n2);
                        break;
                    }
                    case 'J': {
                        long l = object == null ? 0L : (Long)object;
                        this.orbStream.write_longlong(l);
                        break;
                    }
                    case 'S': {
                        short s = object == null ? (short)0 : (Short)object;
                        this.orbStream.write_short(s);
                        break;
                    }
                    case 'Z': {
                        boolean bl = object == null ? false : (Boolean)object;
                        this.orbStream.write_boolean(bl);
                        break;
                    }
                    case 'L': 
                    case '[': {
                        ObjectStreamClass objectStreamClass = objectStreamFieldArray[n].getObjectStreamClass();
                        if (objectStreamFieldArray[n].isAny()) {
                            Util.writeAny(this.orbStream, object);
                            break;
                        }
                        Class clazz = objectStreamClass.forClass();
                        int n3 = 2;
                        if (clazz.isInterface()) {
                            String string = clazz.getName();
                            if ((class$java$rmi$Remote == null ? IIOPOutputStream.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                                n3 = 0;
                            } else if (objectStreamClass.isAbstractInterface()) {
                                n3 = 1;
                            } else if ((class$org$omg$CORBA$Object == null ? IIOPOutputStream.class$("org.omg.CORBA.Object") : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
                                n3 = 0;
                            } else if (RepositoryId.isAbstractBase(clazz)) {
                                n3 = 1;
                            }
                        }
                        switch (n3) {
                            case 0: {
                                Util.writeRemoteObject(this.orbStream, object);
                                break;
                            }
                            case 1: {
                                Util.writeAbstractObject(this.orbStream, object);
                                break;
                            }
                            case 2: {
                                try {
                                    this.orbStream.write_value((Serializable)object, clazz);
                                    break;
                                }
                                catch (ClassCastException classCastException) {
                                    if (object instanceof Serializable) {
                                        throw classCastException;
                                    }
                                    ORBRas.orbTrcLogger.exception(4104L, this, "putClassFields:978", (Exception)classCastException);
                                    Utility.throwNotSerializableForCorba(object.getClass().getName());
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        throw new InvalidClassException(this.currentClassDesc.getName());
                    }
                }
            }
            ++n;
        }
    }

    protected void clearStream() {
        this.currentObject = null;
        this.currentClassDesc = null;
        this.recursionDepth = 0;
        this.simpleWriteDepth = 0;
        this.abortIOException = null;
        this.orbStream = null;
        if (this.classDescStack == null) {
            this.classDescStack = new Stack();
        } else {
            this.classDescStack.setSize(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

