/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class IIOPInputStream
extends CDRInputStream
implements com.ibm.CORBA.iiop.IIOPInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected Connection conn;
    protected Message msg;
    boolean firstFragment = true;
    boolean dumpBuffer = true;
    boolean dumpMsgHeader = true;
    private int markOffset;
    private int markStart;
    private int markIndex;
    private int markSize;
    private Message markMsg;
    private boolean markFirstFragment;
    private byte[] markBuf;
    private CDRInputStream is;
    private CDRInputStream markIs;
    private CDRInputStream nextStream;
    private int fragmentCount;
    private int markFragmentCount;
    private long markBlockLength;

    public IIOPInputStream() {
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super(oRB, null, 0);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.msg = message;
        this.setGIOPVersion(message.getGIOPMajor(), message.getGIOPMinor(), true);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message) throws IOException {
        this(connection.getORB(), connection);
        this.buf = byArray;
        this.markBuf = byArray;
        this.msg = message;
        this.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), true);
        this.index = 12;
        this.littleEndian = this.msg.isLittleEndian();
        int n = this.msg.getType();
        this.size = this.msg.getSize();
        if (this.size > this.buf.length) {
            byte[] byArray2 = this.buf;
            this.buf = new byte[this.size];
            System.arraycopy(byArray2, 0, this.buf, 0, byArray2.length);
        }
        Message.readFully(connection.getInputStream(), this.buf, this.index, this.size - this.index);
        if (!(this.msg.preGIOP12() || n != 0 && n != 3 && n != 1 && n != 4 && n != 7)) {
            this.msg.setRequestId(this.read_long());
            if (!this.msg.isFragmentToFollow() && n != 7) {
                this.msg.read(this);
            } else if (n != 7) {
                this.dumpMsgHeader = false;
            }
        } else {
            this.msg.read(this);
        }
        this.logCommTrace(byArray, this.size, 0);
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message, int n) throws IOException {
        this(connection.getORB(), connection);
        this.buf = byArray;
        this.markBuf = byArray;
        this.msg = message;
        this.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), true);
        this.littleEndian = this.msg.isLittleEndian();
        int n2 = this.msg.getType();
        this.size = this.msg.getSize() + n;
        this.start = n;
        this.index = n + 12;
        if (!(this.msg.preGIOP12() || n2 != 0 && n2 != 3 && n2 != 1 && n2 != 4 && n2 != 7)) {
            this.msg.setRequestId(this.read_long());
            if (!this.msg.isFragmentToFollow() && n2 != 7) {
                this.msg.read(this);
            } else if (n2 != 7) {
                this.dumpMsgHeader = false;
            }
        } else {
            this.msg.read(this);
        }
        connection.updateTimeStamp();
        this.logCommTrace(byArray, this.size, n);
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.orb = connection.getORB();
    }

    public final com.ibm.CORBA.iiop.Message getMessage() {
        return this.msg;
    }

    protected boolean isFirstFragment() {
        return this.firstFragment;
    }

    public void getNextBuffer() {
        this.offset += this.index - this.start;
        this.offset -= 16;
        if (this.nextStream != null) {
            this.is = this.nextStream;
            this.nextStream = null;
        } else {
            this.is = this.conn.getNextFragment(this.msg.getRequestId(), this.msg.getType());
        }
        ++this.fragmentCount;
        this.firstFragment = false;
        this.msg = ((IIOPInputStream)this.is).msg;
        this.buf = this.is.buf;
        this.start = this.is.start;
        this.index = this.is.start + 12;
        this.size = this.is.size;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "getNextBuffer:234", "reqId " + this.msg.getRequestId() + " new fragment offset_hex " + Integer.toHexString(this.get_offset() + 4));
        }
    }

    public int mark() {
        this.markOffset = this.offset;
        this.markStart = this.start;
        this.markIndex = this.index;
        this.markSize = this.size;
        this.markMsg = this.msg;
        this.markFirstFragment = this.firstFragment;
        this.markBuf = this.buf;
        this.markIs = this.is;
        this.markFragmentCount = this.fragmentCount;
        this.markBlockLength = this.blockLength;
        return this.index;
    }

    public void reset(int n) {
        if (this.fragmentCount == this.markFragmentCount) {
            this.index = n;
        } else {
            if (this.fragmentCount - this.markFragmentCount > 1 || n != this.markIndex) {
                throw new MARSHAL("Stream reset error", 1229125823, CompletionStatus.COMPLETED_NO);
            }
            this.nextStream = this.is;
            this.buf = this.markBuf;
            this.offset = this.markOffset;
            this.start = this.markStart;
            this.index = this.markIndex;
            this.size = this.markSize;
            this.msg = this.markMsg;
            this.firstFragment = this.markFirstFragment;
            this.fragmentCount = this.markFragmentCount;
            this.is = this.markIs;
            this.blockLength = this.markBlockLength;
        }
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL("Read beyond end of input stream", 1229125844, CompletionStatus.COMPLETED_MAYBE);
    }

    protected void logCommTrace() {
        this.dumpBuffer = false;
        this.dumpMsgHeader = true;
        this.logCommTrace(this.buf, this.size, this.start);
    }

    private void logCommTrace(byte[] byArray, int n, int n2) {
        if (((ORB)this.orb).CommTraceIsEnabled()) {
            Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, byArray, n, n2, this.conn.getTransportConnection());
        }
    }
}

