/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.ClientSubcontract;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.ExtendedSystem;
import com.ibm.rmi.IOR;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.BufferPool;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.ObjectPool;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class CDROutputStream
extends com.ibm.CORBA.iiop.CDROutputStream
implements DataOutputStream,
PartnerVersion {
    protected boolean littleEndian;
    protected int size;
    protected int buflen;
    protected int offset;
    protected byte[] buf;
    protected org.omg.CORBA.ORB orb;
    protected int blockSizeIndex = -1;
    protected boolean startNewChunk;
    protected boolean writingChunkMarker;
    protected int tcsChar = -1;
    protected int tcsWChar = -1;
    protected CharToTcsConverter tcsCConverter = null;
    protected CharToTcsConverter tcsWConverter = null;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private Hashtable codebaseCache = null;
    private IdentityHashtable valueCache = null;
    private Hashtable repositoryIdCache = null;
    private int end_flag = 0;
    private boolean mustChunk = false;
    private boolean inBlock = false;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private Connection conn = null;
    private int firstNullTc = -1;
    private int firstStringTc = -1;
    private byte GIOPMajor = 1;
    private byte GIOPMinor = (byte)2;
    private boolean preGIOP12_CDR = false;
    private boolean fragmentable = false;
    protected int fragSize = 0;
    private int requestedBufLen = 0;
    private int addIndirectionBytes = 0;
    private static BufferPool defaultBufferPool = new BufferPool("DefaultBufferPool", 1024, 100);
    private BufferPool fragBufferPool;
    private int startOffset = 0;
    private short partnerMajor;
    private short partnerMinor;
    private short partnerExtended;
    private boolean checkedPartnerVersion = false;
    private boolean checkedOptimisedTCVersion = false;
    private boolean optimisedTCVersion;
    private boolean checkedOldNullTC = false;
    private boolean oldNullTC;
    boolean oldSUID = false;
    private Hashtable typeMap = null;
    public static TypeCodeImpl boxStringTC = new TypeCodeImpl(null, 30, RepositoryId.createForJavaType(class$java$lang$String == null ? (class$java$lang$String = CDROutputStream.class$("java.lang.String")) : class$java$lang$String), "", TypeCodeImpl.get_primitive_tc(27));
    public static TypeCodeImpl abstractBaseTC = TypeCodeImpl.get_primitive_tc(32);
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    protected boolean haveCheckedOldNestingDepths;
    protected boolean useOldNestingDepths;
    private static ValueHandlerPool vhandlerPool = new ValueHandlerPool(50);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;

    public CDROutputStream(org.omg.CORBA.ORB oRB) {
        this(oRB, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, byte by, byte by2) {
        this(oRB, false);
        this.setGIOPVersion(by, by2, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl) {
        this(oRB, bl, 1024);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl, int n) {
        this.orb = (com.ibm.rmi.ORB)oRB;
        this.littleEndian = bl;
        this.requestedBufLen = n;
        this.offset = 0;
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, int n, int n2) {
        this(oRB, false);
        this.setCodeSets(n, n2);
    }

    public CDROutputStream() {
    }

    public CDROutputStream(CDROutputStream cDROutputStream) {
        this(cDROutputStream.orb, cDROutputStream.littleEndian);
        this.typeMap = cDROutputStream.getTypeMap();
        cDROutputStream.alignAndReserve(4, 4);
        this.offset = cDROutputStream.get_offset(true) + 4;
        this.setGIOPVersion(cDROutputStream.GIOPMajor, cDROutputStream.GIOPMinor, false);
    }

    public void setPartnerVersion(short s, short s2) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
    }

    public void setGIOPVersion(byte by, byte by2, boolean bl) {
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        if (by == 1 && by2 <= 1) {
            this.preGIOP12_CDR = true;
            this.fragmentable = false;
            this.fragSize = 0;
        } else {
            this.preGIOP12_CDR = false;
            this.fragmentable = bl;
        }
    }

    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    public short getPartnerMajor() {
        Connection connection;
        if (this.partnerMajor == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerMajor = connection.getPartnerMajor();
        }
        return this.partnerMajor;
    }

    public short getPartnerMinor() {
        Connection connection;
        if (this.partnerMinor == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerMinor = connection.getPartnerMinor();
        }
        return this.partnerMinor;
    }

    public void setPartnerExtended(short s) {
        this.partnerExtended = s;
    }

    public short getPartnerExtended() {
        Connection connection;
        if (this.partnerExtended == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerExtended = connection.getPartnerExtended();
        }
        return this.partnerExtended;
    }

    public void setCodeSets(int n, int n2) {
        this.tcsChar = n;
        this.tcsWChar = n2;
        this.tcsCConverter = null;
        this.tcsWConverter = null;
    }

    public int getCharCodeSet() {
        return this.tcsChar;
    }

    public int getWCharCodeSet() {
        return this.tcsWChar;
    }

    public void addTypePosition(TypeCodeImpl typeCodeImpl, int n) {
        if (this.typeMap == null) {
            this.typeMap = new Hashtable(16);
        }
        this.typeMap.put(typeCodeImpl, new Integer(n));
    }

    public int getTypePosition(TypeCodeImpl typeCodeImpl) {
        if (this.typeMap == null) {
            return -1;
        }
        java.lang.Object object = this.typeMap.get(typeCodeImpl);
        if (object != null) {
            return (Integer)object;
        }
        return -1;
    }

    private byte[] getPoolBuffer(int n) {
        if (n == 1024) {
            return defaultBufferPool.getBuffer(n);
        }
        if (this.fragBufferPool == null && this.orb != null) {
            this.fragBufferPool = ((com.ibm.rmi.ORB)this.orb).getBufferPool();
        }
        if (this.fragBufferPool != null) {
            return this.fragBufferPool.getBuffer(n);
        }
        return (byte[])ExtendedSystem.newArray(Byte.TYPE, n, this);
    }

    public void releaseBuffer() {
        if (this.buf != null) {
            if (this.buf.length == 1024) {
                defaultBufferPool.releaseBuffer(this.buf);
            } else if (this.fragBufferPool != null) {
                this.fragBufferPool.releaseBuffer(this.buf);
            }
            this.buf = null;
        }
    }

    private Hashtable getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new Hashtable(16);
        }
        return this.typeMap;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        return byArray;
    }

    final int alignAndReserve(int n, int n2) {
        int n3;
        if (n > 1 && (n3 = this.size & n - 1) != 0) {
            n3 = n - n3;
            int n4 = 0;
            while (n4 < n3) {
                this.buf[this.size++] = 0;
                ++n4;
            }
        }
        if (n2 == 0) {
            return 0;
        }
        n3 = this.size + n > this.buflen ? this.grow(n, n2) : (this.size + n2 >= this.buflen ? this.buflen - this.size : n2);
        return (n3 - n3 % n) / n;
    }

    protected int grow(int n, int n2) {
        if (this.buf == null) {
            if (this.fragmentable && this.orb != null && (this.fragSize = ((ORB)this.orb).getFragmentSize()) > 0) {
                this.buflen = this.fragSize;
            } else {
                if (this.buflen == 0) {
                    this.buflen = 1024;
                }
                this.fragSize = 0;
            }
            while (n2 >= this.buflen) {
                this.buflen *= 2;
            }
            if (this.fragSize > 0 && this.buflen > this.fragSize) {
                this.buflen = this.fragSize;
            }
            this.buf = this.getPoolBuffer(this.buflen);
            return this.buflen > n2 ? n2 : this.buflen;
        }
        if (this.fragmentable && this.orb != null && (this.fragSize = ((ORB)this.orb).getFragmentSize()) > 0) {
            if (this.inBlock && !this.startNewChunk && !this.writingChunkMarker) {
                this.end_block(n2, true);
                this.sendFragment();
                this.startNewChunk = true;
            } else {
                this.sendFragment();
                if (this.writingChunkMarker) {
                    this.blockSizeIndex = this.size + 4;
                }
            }
            this.end_flag_index = 0;
            if (this.size + n2 > this.fragSize) {
                return this.fragSize - this.size;
            }
            return n2;
        }
        if (this.fragSize > 0 && this.buflen == this.fragSize) {
            return this.buflen - this.size;
        }
        byte[] byArray = this.buf;
        this.buflen = byArray.length * 2;
        while (this.size + n2 >= this.buflen) {
            this.buflen *= 2;
        }
        if (this.fragSize > 0 && this.buflen > this.fragSize) {
            this.buflen = this.fragSize;
        }
        this.buf = (byte[])ExtendedSystem.resizeArray(this.buflen, byArray, 0, byArray.length);
        if (byArray.length == 1024) {
            defaultBufferPool.releaseBuffer(byArray);
        }
        return this.buflen >= this.size + n2 ? n2 : this.buflen - this.size;
    }

    protected void sendFragment() {
        throw new MARSHAL("OutputStream fragmentation error", 1229125818, CompletionStatus.COMPLETED_NO);
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    public InputStream create_input_stream() {
        return new CDRInputStream(this.orb, this.buf, this.size, this.littleEndian);
    }

    public void write_longdouble(double d) {
        throw new NO_IMPLEMENT("Long Double Not Implemented (3)", 1229124492, CompletionStatus.COMPLETED_MAYBE);
    }

    private void checkChunkStart() {
        if (this.startNewChunk) {
            this.writingChunkMarker = true;
            this.startNewChunk = false;
            this.write_long(0);
            this.writingChunkMarker = false;
            this.blockSizeIndex = this.size;
            this.inBlock = true;
        }
    }

    public void write_octet(byte by) {
        this.checkChunkStart();
        if (this.size + 1 >= this.buflen) {
            this.alignAndReserve(1, 1);
        }
        this.buf[this.size++] = by;
    }

    public void write_boolean(boolean bl) {
        this.checkChunkStart();
        this.write_octet(bl ? (byte)1 : 0);
    }

    public void write_char(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(new char[]{c});
        if (byArray.length > 1) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (char) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.write_octet(byArray[0]);
    }

    private final void writeLittleEndianWchar(char c) {
        this.write_octet((byte)(c & 0xFF));
        this.write_octet((byte)(c >>> 8 & 0xFF));
    }

    private final void writeBigEndianWchar(char c) {
        this.write_octet((byte)(c >>> 8 & 0xFF));
        this.write_octet((byte)(c & 0xFF));
    }

    private final void writeLittleEndianShort(short s) {
        this.buf[this.size++] = (byte)(s & 0xFF);
        this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
    }

    private final void writeBigEndianShort(short s) {
        this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(s & 0xFF);
    }

    private final void writeLittleEndianLong(int n) {
        this.buf[this.size++] = (byte)(n & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
    }

    private final void writeBigEndianLong(int n) {
        this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(n & 0xFF);
    }

    private final void writeLittleEndianLongLong(long l) {
        this.buf[this.size++] = (byte)(l & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
    }

    private final void writeBigEndianLongLong(long l) {
        this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
        this.buf[this.size++] = (byte)(l & 0xFFL);
    }

    public void write_wchar(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(new char[]{c}, this.littleEndian);
        int n = cArray.length;
        if (this.preGIOP12_CDR) {
            if (n > 1) {
                throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (wchar) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            this.alignAndReserve(2, 2);
        } else {
            this.write_octet((byte)(n * 2));
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.littleEndian) {
                this.writeLittleEndianWchar(cArray[n2]);
            } else {
                this.writeBigEndianWchar(cArray[n2]);
            }
            ++n2;
        }
    }

    public void write_short(short s) {
        this.checkChunkStart();
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s);
        } else {
            this.writeBigEndianShort(s);
        }
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.write_long(n, true);
    }

    public void write_long(int n, boolean bl) {
        if (bl) {
            this.checkChunkStart();
        }
        if ((this.size & 3) != 0 || this.size + 4 >= this.buflen) {
            this.alignAndReserve(4, 4);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.checkChunkStart();
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l);
        } else {
            this.writeBigEndianLongLong(l);
        }
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM("Null Param (2) - string", 1229124098, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        int n = byArray.length;
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n + 1);
        if (this.littleEndian) {
            this.writeLittleEndianLong(n + 1);
        } else {
            this.writeBigEndianLong(n + 1);
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n3 = this.alignAndReserve(1, n - n2 + 1);
            if (n3 + n2 == n + 1) {
                --n3;
            }
            System.arraycopy(byArray, n2, this.buf, this.size, n3);
            this.size += n3;
            n2 += n3;
        }
        if (this.size + 1 >= this.buflen) {
            this.alignAndReserve(1, 1);
        }
        this.buf[this.size++] = 0;
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw new BAD_PARAM("Null Param (3) - wstring", 1229124099, CompletionStatus.COMPLETED_MAYBE);
        }
        int n = 0;
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(string.toCharArray(), this.littleEndian);
        int n2 = cArray.length;
        int n3 = n2 * 2;
        if (this.preGIOP12_CDR) {
            this.write_long(n2 + 1);
        } else {
            this.checkChunkStart();
            n = this.alignAndReserve(4, 4 + n2 * 2);
            if (this.littleEndian) {
                this.writeLittleEndianLong(n3);
            } else {
                this.writeBigEndianLong(n3);
            }
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            n = this.alignAndReserve(2, (n2 - n4) * 2);
            if (this.littleEndian) {
                n5 = 0;
                while (n5 < n) {
                    this.buf[this.size++] = (byte)(cArray[n4] & 0xFF);
                    this.buf[this.size++] = (byte)(cArray[n4++] >>> 8 & 0xFF);
                    ++n5;
                }
                continue;
            }
            n5 = 0;
            while (n5 < n) {
                this.buf[this.size++] = (byte)(cArray[n4] >>> 8 & 0xFF);
                this.buf[this.size++] = (byte)(cArray[n4++] & 0xFF);
                ++n5;
            }
        }
        if (this.preGIOP12_CDR) {
            this.write_short((short)0);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2, true);
    }

    public void write_octet_array(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray == null) {
            throw new BAD_PARAM("Null Param (4) - octet array", 1229124100, CompletionStatus.COMPLETED_MAYBE);
        }
        if (bl) {
            this.checkChunkStart();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.alignAndReserve(1, n2 - n3);
            System.arraycopy(byArray, n + n3, this.buf, this.size, n4);
            this.size += n4;
            n3 += n4;
        }
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null Param (5) - any", 1229124101, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM("Null Param (6) - TypeCode", 1229124102, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this);
    }

    public void writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return;
        }
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this);
            }
        } else {
            typeCodeImpl.write_value(this);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            this.write_value((Serializable)object2);
        } else if (n == 30) {
            this.write_value((Serializable)object2);
        } else if (n == 14) {
            this.write_Object((Object)object2);
        } else if (n == 32) {
            this.write_abstract_interface(object2);
        } else {
            throw new BAD_PARAM("Unexpected type for any", 1229125805, CompletionStatus.COMPLETED_NO);
        }
    }

    private void writeStringAnyOpt(String string, boolean bl) {
        if (this.firstStringTc == -1 || !bl) {
            this.firstStringTc = boxStringTC.writeValueOpt(this);
        } else {
            this.writeIndirection(this.firstStringTc);
        }
        this.write_value((Serializable)((java.lang.Object)string));
    }

    private void writeNullAnyOpt(boolean bl) {
        if (this.firstNullTc == -1 || !bl) {
            if (this.useOldNullTC()) {
                this.firstNullTc = TypeCodeImpl.get_primitive_tc(TCKind.tk_value).writeValueOpt(this);
                this.write_value(null);
            } else {
                this.firstNullTc = abstractBaseTC.writeValueOpt(this);
                this.write_abstract_interface(null);
            }
        } else {
            this.writeIndirection(this.firstNullTc);
            this.write_abstract_interface(null);
        }
    }

    public void writeIndirection(int n) {
        this.checkChunkStart();
        this.addIndirectionBytes = 4;
        if ((this.size & 3) != 0 || this.size + 4 >= this.buflen) {
            this.alignAndReserve(4, 4);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(-1);
        } else {
            this.writeBigEndianLong(-1);
        }
        this.addIndirectionBytes = 0;
        this.alignAndReserve(4, 4);
        if (this.littleEndian) {
            this.writeLittleEndianLong(n - this.get_offset());
        } else {
            this.writeBigEndianLong(n - this.get_offset());
        }
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this);
            return;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL(1330446340, CompletionStatus.COMPLETED_MAYBE);
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        IOR iOR = null;
        try {
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
            iOR = (IOR)clientSubcontract.marshal();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "write_Object:1022", exception);
        }
        if (iOR == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect(this.orb);
                }
                catch (RemoteException remoteException) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "write_Object:1034", (Exception)remoteException);
                    throw new MARSHAL("no IOR: servant was not connected to ORB", 1229125797, CompletionStatus.COMPLETED_MAYBE);
                }
            } else {
                ((com.ibm.rmi.corba.ORB)this.orb).internalConnect(object);
            }
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
            if (this.isSkeleton(object) && ((ClientDelegate)clientSubcontract).isClientCallback()) {
                Connection connection = this.getConnection();
                iOR = (IOR)((ClientDelegate)clientSubcontract).getCallbackIOR(connection.localHost(), connection.localPort());
            } else {
                iOR = (IOR)clientSubcontract.marshal();
            }
        }
        iOR.write(this);
    }

    private boolean isSkeleton(Object object) {
        return object instanceof InvokeHandler || ((ObjectImpl)object)._is_local() || object instanceof DynamicImplementation;
    }

    public void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "write_abstract_interface:1094", (Exception)classCastException);
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                Utility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write_value(Serializable serializable, String string) {
        boolean bl;
        block39: {
            block38: {
                block37: {
                    block35: {
                        bl = false;
                        try {
                            try {
                                int n;
                                int n2;
                                if (serializable == null) {
                                    this.write_long(0);
                                    java.lang.Object var10_4 = null;
                                    if (!bl) return;
                                    this.releaseValueHandler();
                                    return;
                                }
                                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                                    int n3 = (Integer)this.valueCache.get(serializable);
                                    this.writeIndirection(n3);
                                    break block35;
                                }
                                Class clazz = serializable.getClass();
                                boolean bl2 = this.mustChunk;
                                if (!this.checkedPartnerVersion) {
                                    n2 = this.getPartnerMajor();
                                    n = this.getPartnerMinor();
                                    if (n2 != 0 && n2 < 12 && n < 2) {
                                        this.oldSUID = true;
                                    }
                                    this.checkedPartnerVersion = true;
                                }
                                if (this.inBlock) {
                                    this.end_block();
                                }
                                if (serializable instanceof String) {
                                    if (this.mustChunk) {
                                        n2 = this.writeValueTag(true, false, null);
                                        this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        this.start_block();
                                        --this.end_flag;
                                        this.write_wstring((String)((java.lang.Object)serializable));
                                        this.end_block();
                                        this.writeEndTag(true);
                                    } else {
                                        n2 = this.writeValueTag(false, false, null);
                                        this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        if (this.useOldNestingDepths()) {
                                            --this.end_flag;
                                        }
                                        this.write_wstring((String)((java.lang.Object)serializable));
                                        this.writeEndTag(false);
                                    }
                                } else if (clazz.isArray()) {
                                    if (this.valueHandler == null) {
                                        bl = true;
                                        this.setValueHandler();
                                    }
                                    if (this.mustChunk) {
                                        n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        this.start_block();
                                        --this.end_flag;
                                        this.valueHandler.writeValue(this, serializable);
                                        this.end_block();
                                        this.writeEndTag(true);
                                    } else {
                                        n2 = this.writeValueTag(false, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        if (this.useOldNestingDepths()) {
                                            --this.end_flag;
                                        }
                                        this.valueHandler.writeValue(this, serializable);
                                        this.writeEndTag(false);
                                    }
                                } else if (serializable instanceof ValueBase) {
                                    this.mustChunk = true;
                                    n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                                    String string2 = ((ValueBase)serializable)._truncatable_ids()[0];
                                    this.write_repositoryId(string2);
                                    this.updateIndirectionTable(n2, serializable, serializable);
                                    this.start_block();
                                    --this.end_flag;
                                    this.writeIDLValue(serializable, string2);
                                    this.end_block();
                                    this.writeEndTag(true);
                                } else if (this.shouldWriteAsIDLEntity(serializable)) {
                                    this.writeIDLEntity((IDLEntity)serializable);
                                } else if (serializable instanceof Class) {
                                    this.writeClass(string, (Class)serializable);
                                } else {
                                    Serializable serializable2;
                                    if (this.valueHandler == null) {
                                        bl = true;
                                        this.setValueHandler();
                                    }
                                    if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                                        this.write_long(0);
                                        break block37;
                                    }
                                    if (serializable != serializable2) {
                                        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                                            n = (Integer)this.valueCache.get(serializable);
                                            this.writeIndirection(n);
                                            break block38;
                                        }
                                        clazz = serializable.getClass();
                                    }
                                    if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                                        this.mustChunk = true;
                                        n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createForJavaType(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n, serializable, serializable2);
                                        --this.end_flag;
                                        this.start_block();
                                        this.valueHandler.writeValue(this, serializable);
                                        this.end_block();
                                        this.writeEndTag(true);
                                    } else {
                                        n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createForJavaType(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n, serializable, serializable2);
                                        if (this.useOldNestingDepths()) {
                                            --this.end_flag;
                                        }
                                        this.valueHandler.writeValue(this, serializable);
                                        this.writeEndTag(false);
                                    }
                                }
                                this.mustChunk = bl2;
                                if (this.mustChunk) {
                                    this.start_block();
                                }
                                break block39;
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "write_value (Serializable, String):1362", outOfMemoryError.toString(), (java.lang.Object)outOfMemoryError);
                                throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126019, CompletionStatus.COMPLETED_NO);
                            }
                        }
                        catch (Throwable throwable) {
                            java.lang.Object var10_9 = null;
                            if (!bl) throw throwable;
                            this.releaseValueHandler();
                            throw throwable;
                        }
                    }
                    java.lang.Object var10_5 = null;
                    if (!bl) return;
                    this.releaseValueHandler();
                    return;
                }
                java.lang.Object var10_6 = null;
                if (!bl) return;
                this.releaseValueHandler();
                return;
            }
            java.lang.Object var10_7 = null;
            if (!bl) return;
            this.releaseValueHandler();
            return;
        }
        java.lang.Object var10_8 = null;
        if (!bl) return;
        this.releaseValueHandler();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write_value(Serializable serializable) {
        boolean bl;
        block39: {
            block38: {
                block37: {
                    block35: {
                        bl = false;
                        try {
                            try {
                                int n;
                                int n2;
                                if (serializable == null) {
                                    this.write_long(0);
                                    java.lang.Object var9_3 = null;
                                    if (!bl) return;
                                    this.releaseValueHandler();
                                    return;
                                }
                                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                                    int n3 = (Integer)this.valueCache.get(serializable);
                                    this.writeIndirection(n3);
                                    break block35;
                                }
                                Class clazz = serializable.getClass();
                                boolean bl2 = this.mustChunk;
                                if (!this.checkedPartnerVersion) {
                                    n2 = this.getPartnerMajor();
                                    n = this.getPartnerMinor();
                                    if (n2 != 0 && n2 < 12 && n < 2) {
                                        this.oldSUID = true;
                                    }
                                    this.checkedPartnerVersion = true;
                                }
                                if (this.inBlock) {
                                    this.end_block();
                                }
                                if (serializable instanceof String) {
                                    if (this.mustChunk) {
                                        n2 = this.writeValueTag(true, false, null);
                                        this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        this.start_block();
                                        --this.end_flag;
                                        this.write_wstring((String)((java.lang.Object)serializable));
                                        this.end_block();
                                        this.writeEndTag(true);
                                    } else {
                                        n2 = this.writeValueTag(false, false, null);
                                        this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        if (this.useOldNestingDepths()) {
                                            --this.end_flag;
                                        }
                                        this.write_wstring((String)((java.lang.Object)serializable));
                                        this.writeEndTag(false);
                                    }
                                } else if (clazz.isArray()) {
                                    if (this.valueHandler == null) {
                                        bl = true;
                                        this.setValueHandler();
                                    }
                                    if (this.mustChunk) {
                                        n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        this.start_block();
                                        --this.end_flag;
                                        this.valueHandler.writeValue(this, serializable);
                                        this.end_block();
                                        this.writeEndTag(true);
                                    } else {
                                        n2 = this.writeValueTag(false, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n2, serializable, serializable);
                                        if (this.useOldNestingDepths()) {
                                            --this.end_flag;
                                        }
                                        this.valueHandler.writeValue(this, serializable);
                                        this.writeEndTag(false);
                                    }
                                } else if (serializable instanceof ValueBase) {
                                    this.mustChunk = true;
                                    n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                                    String string = ((ValueBase)serializable)._truncatable_ids()[0];
                                    this.write_repositoryId(string);
                                    this.updateIndirectionTable(n2, serializable, serializable);
                                    this.start_block();
                                    --this.end_flag;
                                    this.writeIDLValue(serializable, string);
                                    this.end_block();
                                    this.writeEndTag(true);
                                } else if (this.shouldWriteAsIDLEntity(serializable)) {
                                    this.writeIDLEntity((IDLEntity)serializable);
                                } else if (serializable instanceof Class) {
                                    this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
                                } else {
                                    Serializable serializable2;
                                    if (this.valueHandler == null) {
                                        bl = true;
                                        this.setValueHandler();
                                    }
                                    if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                                        this.write_long(0);
                                        break block37;
                                    }
                                    if (serializable != serializable2) {
                                        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                                            n = (Integer)this.valueCache.get(serializable);
                                            this.writeIndirection(n);
                                            break block38;
                                        }
                                        clazz = serializable.getClass();
                                    }
                                    if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                                        this.mustChunk = true;
                                        n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createForJavaType(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n, serializable, serializable2);
                                        --this.end_flag;
                                        this.start_block();
                                        this.valueHandler.writeValue(this, serializable);
                                        this.end_block();
                                        this.writeEndTag(true);
                                    } else {
                                        n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                                        this.write_repositoryId(RepositoryId.createForJavaType(clazz, this.oldSUID));
                                        this.updateIndirectionTable(n, serializable, serializable2);
                                        if (this.useOldNestingDepths()) {
                                            --this.end_flag;
                                        }
                                        this.valueHandler.writeValue(this, serializable);
                                        this.writeEndTag(false);
                                    }
                                }
                                this.mustChunk = bl2;
                                if (this.mustChunk) {
                                    this.start_block();
                                }
                                break block39;
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "write_value (Serializable):1633", outOfMemoryError.toString(), (java.lang.Object)outOfMemoryError);
                                throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126020, CompletionStatus.COMPLETED_NO);
                            }
                        }
                        catch (Throwable throwable) {
                            java.lang.Object var9_8 = null;
                            if (!bl) throw throwable;
                            this.releaseValueHandler();
                            throw throwable;
                        }
                    }
                    java.lang.Object var9_4 = null;
                    if (!bl) return;
                    this.releaseValueHandler();
                    return;
                }
                java.lang.Object var9_5 = null;
                if (!bl) return;
                this.releaseValueHandler();
                return;
            }
            java.lang.Object var9_6 = null;
            if (!bl) return;
            this.releaseValueHandler();
            return;
        }
        java.lang.Object var9_7 = null;
        if (!bl) return;
        this.releaseValueHandler();
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        try {
            if (serializable == null) {
                this.write_long(0);
                return;
            }
            if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                int n = (Integer)this.valueCache.get(serializable);
                this.writeIndirection(n);
                return;
            }
            boolean bl = this.mustChunk;
            boolean bl2 = false;
            if (this.mustChunk) {
                if (this.inBlock) {
                    this.end_block();
                }
                int n = this.writeValueTag(true, false, Util.getCodebase(serializable.getClass()));
                this.write_repositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                if (bl2) {
                    ((CustomMarshal)((java.lang.Object)serializable)).marshal(this);
                } else {
                    boxedValueHelper.write_value(this, serializable);
                }
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(serializable.getClass()));
                this.write_repositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
                boxedValueHelper.write_value(this, serializable);
                this.writeEndTag(false);
            }
            this.mustChunk = bl;
            if (this.mustChunk) {
                this.start_block();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "write_value (Serializable, org.omg.CORBA.portable.BoxedValueHelper):1726", outOfMemoryError.toString(), (java.lang.Object)outOfMemoryError);
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126021, CompletionStatus.COMPLETED_NO);
        }
    }

    public int get_offset() {
        return this.get_offset(false);
    }

    public int get_offset(boolean bl) {
        if (bl) {
            this.checkChunkStart();
        }
        return this.offset + this.size;
    }

    public void start_block() {
        int n = this.size & 3;
        if (n != 0) {
            n = 4 - n;
            this.size += n;
        }
        this.startNewChunk = true;
        this.inBlock = true;
        this.blockSizeIndex = this.size + 4;
    }

    public void end_block() {
        this.end_block(0, false);
    }

    public void end_block(int n, boolean bl) {
        if (!this.inBlock) {
            return;
        }
        if (!bl) {
            this.inBlock = false;
            if (this.startNewChunk) {
                this.blockSizeIndex = -1;
                this.startNewChunk = false;
                return;
            }
        }
        this.startNewChunk = false;
        int n2 = this.size;
        this.size = this.blockSizeIndex - 4;
        int n3 = n + n2 - this.blockSizeIndex + this.addIndirectionBytes;
        this.write_long(n3);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "end_block (int, boolean):1798", "start block index_hex " + Integer.toHexString(this.get_offset()) + " blockLength_hex " + Integer.toHexString(n3));
        }
        this.size = n2;
        this.blockSizeIndex = -1;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private Connection getConnection() {
        if (this.conn != null) {
            return this.conn;
        }
        if (this instanceof IIOPOutputStream) {
            this.conn = ((IIOPOutputStream)this).getConnection();
        }
        return this.conn;
    }

    private int getTcsC() {
        if (this.tcsChar != -1) {
            return this.tcsChar;
        }
        Connection connection = this.getConnection();
        this.tcsChar = connection != null ? connection.getCharCodeSet() : 65537;
        return this.tcsChar;
    }

    private int getTcsW() {
        if (this.tcsWChar != -1) {
            return this.tcsWChar;
        }
        Connection connection = this.getConnection();
        if (connection != null) {
            this.tcsWChar = connection.getWCharCodeSet();
            if (this.tcsWChar == 0 && ((ORB)this.orb).getWCharDefault() != 0) {
                this.tcsWChar = ((ORB)this.orb).getWCharDefault();
            }
        } else {
            this.tcsWChar = 65792;
        }
        if (this.tcsWChar == 0 && this.getPartnerMajor() == 11 && this.getPartnerMinor() < 2) {
            this.tcsWChar = 65792;
        }
        return this.tcsWChar;
    }

    private CharToTcsConverter getTcsCConverter() {
        if (this.tcsCConverter == null) {
            int n = this.getTcsC();
            if (n == 0) {
                n = 65537;
            }
            this.tcsCConverter = CharToTcsConverter.getConverter(n);
            if (!this.tcsCConverter.isByteOriented()) {
                throw new INTERNAL("non-byte-oriented char code set specified", 1229125042, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsCConverter;
    }

    private CharToTcsConverter getTcsWConverter() {
        if (this.tcsWConverter == null) {
            int n = this.getTcsW();
            if (n == 0) {
                throw new INV_OBJREF("wchar code set support not specified", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            this.tcsWConverter = CharToTcsConverter.getConverter(n);
            if (this.tcsWConverter.isByteOriented()) {
                throw new INTERNAL("byte-oriented wchar code set specified", 1229125044, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsWConverter;
    }

    public boolean isOptimisedTCVersion() {
        if (!this.checkedOptimisedTCVersion) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.optimisedTCVersion = s == 12 && s2 >= 3 || s == 13 && s2 >= 3 || s == 4865 && s2 >= 2 || s > 4865;
            this.checkedOptimisedTCVersion = true;
        }
        return this.optimisedTCVersion;
    }

    protected boolean useOldNullTC() {
        if (!this.checkedOldNullTC) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.oldNullTC = s == 11 || s == 12 && s2 < 4 || s == 13 && s2 < 3 || s == 4865 && s2 < 2;
            this.checkedOldNullTC = true;
        }
        return this.oldNullTC;
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM("Null Param (7) - boolean array", 1229124103, CompletionStatus.COMPLETED_MAYBE);
        }
        this.checkChunkStart();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.alignAndReserve(1, n2 - n3);
            int n5 = 0;
            while (n5 < n4) {
                this.buf[this.size++] = blArray[n + n3++] ? (byte)1 : 0;
                ++n5;
            }
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        byte[] byArray;
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (8) - char array", 1229124104, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        if (n == 0 && n2 == cArray.length) {
            byArray = charToTcsConverter.convertToByte(cArray);
        } else {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byArray = charToTcsConverter.convertToByte(cArray2);
        }
        if (byArray.length > n2) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        int n3 = 0;
        this.checkChunkStart();
        while (n3 < n2) {
            int n4 = this.alignAndReserve(1, n2 - n3);
            System.arraycopy(byArray, n3, this.buf, this.size, n4);
            this.size += n4;
            n3 += n4;
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (9) - wchar array", 1229124105, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        if (this.preGIOP12_CDR) {
            char[] cArray2;
            if (n == 0 && cArray.length == n2) {
                cArray2 = charToTcsConverter.convertToChar(cArray, this.littleEndian);
            } else {
                char[] cArray3 = new char[n2];
                System.arraycopy(cArray, n, cArray3, 0, n2);
                cArray2 = charToTcsConverter.convertToChar(cArray3, this.littleEndian);
            }
            if (cArray2.length > n2) {
                throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - wchar array", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (n2 > 0) {
                this.alignAndReserve(2, n2 * 2);
            }
            if (this.littleEndian) {
                int n3 = 0;
                while (n3 < n2) {
                    this.writeLittleEndianWchar(cArray2[n3]);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n2) {
                    this.writeBigEndianWchar(cArray2[n4]);
                    ++n4;
                }
            }
        } else {
            byte[] byArray = new byte[n2 * 3];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                char[] cArray4 = charToTcsConverter.convertToChar(new char[]{cArray[n + n6]}, this.littleEndian);
                if (n5 + (cArray4.length * 2 + 1) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[byArray2.length * 2];
                    System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                }
                byArray[n5++] = (byte)(cArray4.length * 2);
                int n7 = 0;
                while (n7 < cArray4.length) {
                    if (this.littleEndian) {
                        byArray[n5++] = (byte)(cArray4[n7] & 0xFF);
                        byArray[n5++] = (byte)(cArray4[n7] >>> 8 & 0xFF);
                    } else {
                        byArray[n5++] = (byte)(cArray4[n7] >>> 8 & 0xFF);
                        byArray[n5++] = (byte)(cArray4[n7] & 0xFF);
                    }
                    ++n7;
                }
                ++n6;
            }
            this.write_octet_array(byArray, 0, n5);
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM("Null Param (10) - short_array", 1229124106, CompletionStatus.COMPLETED_MAYBE);
        }
        this.checkChunkStart();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.alignAndReserve(2, (n2 - n3) * 2);
            int n5 = 0;
            while (n5 < n4) {
                if (this.littleEndian) {
                    this.writeLittleEndianShort(sArray[n + n3++]);
                } else {
                    this.writeBigEndianShort(sArray[n + n3++]);
                }
                ++n5;
            }
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM("Null Param (11) - ushort_array", 1229124107, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = this.alignAndReserve(4, (n2 - n3) * 4);
                if (this.littleEndian) {
                    n4 = 0;
                    while (n4 < n5) {
                        this.writeLittleEndianLong(nArray[n + n3++]);
                        ++n4;
                    }
                    continue;
                }
                n4 = 0;
                while (n4 < n5) {
                    this.writeBigEndianLong(nArray[n + n3++]);
                    ++n4;
                }
            }
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM("Null Param (12) - ulong_array", 1229124108, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkChunkStart();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.alignAndReserve(8, (n2 - n3) * 8);
            int n5 = 0;
            while (n5 < n4) {
                if (this.littleEndian) {
                    this.writeLittleEndianLongLong(lArray[n + n3++]);
                } else {
                    this.writeBigEndianLongLong(lArray[n + n3++]);
                }
                ++n5;
            }
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM("Null Param (13) - ulonglong_array", 1229124109, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                int n5;
                n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                if (this.littleEndian) {
                    n5 = 0;
                    while (n5 < n4) {
                        this.writeLittleEndianLong(Float.floatToIntBits(fArray[n + n3++]));
                        ++n5;
                    }
                    continue;
                }
                n5 = 0;
                while (n5 < n4) {
                    this.writeBigEndianLong(Float.floatToIntBits(fArray[n + n3++]));
                    ++n5;
                }
            }
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM("Null Param (14) - double_array", 1229124110, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                int n5;
                n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                if (this.littleEndian) {
                    n5 = 0;
                    while (n5 < n4) {
                        this.writeLittleEndianLongLong(Double.doubleToLongBits(dArray[n + n3++]));
                        ++n5;
                    }
                    continue;
                }
                n5 = 0;
                while (n5 < n4) {
                    this.writeBigEndianLongLong(Double.doubleToLongBits(dArray[n + n3++]));
                    ++n5;
                }
            }
        }
    }

    public void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM("Null Param (15) - string_array", 1229124111, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_string(stringArray[n3 + n]);
            ++n3;
        }
    }

    public void write_wstring_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM("Null Param (16) - wstring_array", 1229124112, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_wstring(stringArray[n3 + n]);
            ++n3;
        }
    }

    public void write_any_array(Any[] anyArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.write_any(anyArray[n3 + n]);
            ++n3;
        }
    }

    public final void reset() {
        this.offset += this.size;
        this.size = 0;
        this.end_flag = 0;
        this.end_flag_index = 0;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.size);
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        outputStream.write_long(this.size);
        outputStream.write_octet_array(this.buf, 0, this.size);
    }

    public final int getSize() {
        return this.size;
    }

    protected byte[] getBuffer() {
        return this.buf;
    }

    public static int getDefaultBufferSize() {
        return 1024;
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new IdentityHashtable();
        }
        this.valueCache.put(object, new Integer(n));
        if (object2 != object) {
            this.valueCache.put(object2, new Integer(n));
        }
    }

    private final void write_repositoryId(String string) {
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            int n = (Integer)this.repositoryIdCache.get(string);
            this.writeIndirection(n);
            return;
        }
        int n = string.length() + 1;
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n);
        if (this.littleEndian) {
            this.buf[this.size++] = (byte)(n & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
        } else {
            this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
            this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
            this.buf[this.size++] = (byte)(n & 0xFF);
        }
        --n;
        byte[] byArray = RepositoryId.getByteArray(string);
        if (byArray == null) {
            byArray = new byte[n + 1];
            int n2 = 0;
            char[] cArray = new char[string.length()];
            string.getChars(0, n, cArray, 0);
            int n3 = 0;
            while (n3 < n) {
                if (cArray[n3] > '\u00ff') {
                    throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set (6) - repositoryId", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                byArray[n2++] = (byte)(cArray[n3] >>> 0 & 0xFF);
                ++n3;
            }
            byArray[n2++] = 0;
            RepositoryId.setByteArray(string, byArray);
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new Hashtable();
        }
        this.repositoryIdCache.put(string, new Integer(this.get_offset() - 4));
        this.write_octet_array(byArray, 0, byArray.length, false);
    }

    private void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            int n2 = (Integer)this.codebaseCache.get(string);
            this.writeIndirection(n2);
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new Hashtable();
            }
            this.codebaseCache.put(string, new Integer(n));
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, String string) {
        int n = 0;
        int n2 = 0;
        if (bl && bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked_NoRep;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked_NoRep;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            n2 = RepositoryId.kPreComputed_StandardRMIUnchunked;
            this.write_long(n2);
            n = this.get_offset(true) - 4;
        } else {
            n2 = RepositoryId.kPreComputed_CodeBaseRMIUnchunked;
            this.write_long(n2);
            n = this.get_offset(true) - 4;
            this.write_codebase(string, this.get_offset());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "writeValueTag:2388", "write value tag " + Integer.toHexString(n2) + " index_hex " + Integer.toHexString(n));
        }
        return n;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write(this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal(this);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boolean bl = false;
            if (bl) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this);
            } else {
                boxedValueHelper.write_value(this, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl) {
        if (bl) {
            if (this.size == this.end_flag_index) {
                this.size -= 4;
            }
            this.write_long(this.end_flag);
            if (!this.useOldNestingDepths()) {
                ++this.end_flag;
            }
        }
        this.end_flag_index = this.size;
        if (this.useOldNestingDepths()) {
            ++this.end_flag;
        }
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(RepositoryId.kClassDescValueRepID);
            }
            this.start_block();
            --this.end_flag;
            Utility.writeClassValue(this, clazz);
            this.end_block();
            this.writeEndTag(true);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(RepositoryId.kClassDescValueRepID);
            }
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            Utility.writeClassValue(this, clazz);
            this.writeEndTag(false);
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = RepositoryId.createForJavaType(iDLEntity);
        Class clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, string2);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = CDROutputStream.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, clazz};
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod(CDROutputStream.kWriteMethod, classArray);
                }
            });
            java.lang.Object[] objectArray = new java.lang.Object[]{this, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2549", (Exception)classNotFoundException);
            throw new MARSHAL(classNotFoundException.getMessage(), 1229125798, CompletionStatus.COMPLETED_NO);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2558", exception);
            throw new MARSHAL(exception.getMessage(), 1229125799, CompletionStatus.COMPLETED_NO);
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2566", (Exception)illegalAccessException);
            throw new MARSHAL(illegalAccessException.getMessage(), 1229125800, CompletionStatus.COMPLETED_NO);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2578", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "writeIDLEntity:2583", throwable.getMessage(), (java.lang.Object)throwable);
            }
            throw new MARSHAL("InvocationTargetException:" + throwable.getMessage(), 1229125801, CompletionStatus.COMPLETED_NO);
        }
        this.end_block();
        this.writeEndTag(true);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public String[] _truncatable_ids() {
        return _ids;
    }

    public void printBuffer() {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < 16) {
                String string;
                int n3 = this.buf[n + n2];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                if ((string = Integer.toHexString(n3)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n2;
            }
            System.out.println(new String(this.buf, n, 16));
            n += 16;
        }
    }

    protected boolean useOldNestingDepths() {
        if (!this.haveCheckedOldNestingDepths) {
            short s = this.getPartnerMajor();
            if (s != 0 && s < 4880) {
                this.useOldNestingDepths = true;
            }
            this.haveCheckedOldNestingDepths = true;
        }
        return this.useOldNestingDepths;
    }

    public boolean isFragmentable() {
        return this.fragmentable;
    }

    private void setValueHandler() {
        this.valueHandler = (ValueHandler)vhandlerPool.getObject();
    }

    private void releaseValueHandler() {
        ((ValueHandlerImpl)this.valueHandler).reset();
        vhandlerPool.releaseObject(this.valueHandler);
        this.valueHandler = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ValueHandlerPool
    extends ObjectPool {
        public ValueHandlerPool(int n) {
            super("ValueHandlerPool:CDROS", n);
        }

        public java.lang.Object createObject() {
            return new ValueHandlerImpl(false);
        }
    }
}

