/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.ExtendedSystem;

public class BufferPool {
    private byte[][] buffers;
    private int index;
    private int bufferLength;
    private int maxBuffers;
    private String name;

    public BufferPool() {
        this("Singleton", 0, 0);
    }

    public BufferPool(String string, int n, int n2) {
        this.name = string;
        this.bufferLength = n;
        if (this.bufferLength > 0) {
            this.maxBuffers = n2;
            this.buffers = new byte[n2][this.bufferLength];
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "<init> (int, int):83", string + ": Initialize BufferPool - BufferPool max size: " + this.maxBuffers + " Buffer length: " + this.bufferLength);
        }
    }

    public synchronized byte[] getBuffer(int n) {
        if (n == this.bufferLength && this.index > 0) {
            byte[] byArray = this.buffers[--this.index];
            this.buffers[this.index] = null;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "getBuffer:103", this.name + ": Take Buffer.  BufferPool size: " + this.index);
            }
            return byArray;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "getBuffer:109", this.name + ": Create Buffer.  Buffer length: " + n);
        }
        return (byte[])ExtendedSystem.newArray(Byte.TYPE, n, this);
    }

    public synchronized void releaseBuffer(byte[] byArray) {
        if (byArray != null && byArray.length == this.bufferLength && this.index < this.maxBuffers) {
            this.buffers[this.index++] = byArray;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "releaseBuffer:128", this.name + ": Return Buffer.  BufferPool size: " + this.index);
            }
        }
    }
}

