/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ObjectURL;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;

public class IIOPAddrImpl
implements ObjectURL.IIOPAddr {
    int port = 2809;
    byte major = 1;
    byte minor = 0;
    String host = null;

    public IIOPAddrImpl(String string) {
        int n;
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty iiop_addr", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            this.setPort(string.substring(n2 + 1));
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf(64)) >= 0) {
            this.setVersion(string.substring(0, n));
            string = string.substring(n + 1);
        }
        this.setHost(string);
    }

    public IIOPAddrImpl(String string, int n, byte by, byte by2) {
        this.setHost(string);
        this.setPort(n);
        this.setVersion(by, by2);
    }

    private void setVersion(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty version", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        int n = string.indexOf(46);
        if (n <= 0 || n + 1 >= string.length()) {
            throw new BAD_PARAM("bad iiop version " + string, 1330446345, CompletionStatus.COMPLETED_NO);
        }
        try {
            this.setVersion(Byte.parseByte(string.substring(0, n)), Byte.parseByte(string.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BAD_PARAM(numberFormatException.getMessage() + " in " + string, 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private void setVersion(byte by, byte by2) {
        if (by != 1 || by2 > 2) {
            throw new BAD_PARAM("invalid GIOP version " + by + "." + by2, 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.major = by;
        this.minor = by2;
    }

    private void setPort(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty port", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        try {
            this.port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BAD_PARAM(numberFormatException.getMessage() + " in " + string, 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private void setPort(int n) {
        this.port = n;
    }

    private void setHost(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty host", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.host = string;
    }

    public String toString() {
        return "iiop:" + this.major + '.' + this.minor + '@' + this.host + ':' + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }
}

