/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.Corbaloc;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class Corbaname
extends Corbaloc
implements ObjectURL {
    private String stringName = "";

    public Corbaname(String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "<init>:79", string);
        }
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("string is null or empty", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        if (!string.toLowerCase().startsWith("corbaname:")) {
            throw new BAD_PARAM("string does not start with corbaname:", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        int n = (string = string.substring("corbaname:".length())).indexOf(35);
        if (n == -1) {
            this.parseCorbaloc(string);
        } else {
            this.parseCorbaloc(string.substring(0, n));
            if (n + 1 < string.length()) {
                this.stringName = INSUtil.decode2936(string.substring(n + 1));
            }
        }
    }

    public String toString() {
        return "corbaname:" + this.corbalocToString() + '#' + this.getStringName();
    }

    public static final void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                System.out.println(stringArray[n] + " -> " + new Corbaname(stringArray[n]));
            }
            catch (Exception exception) {
                System.out.println(stringArray[n] + " -> " + exception.toString());
            }
            ++n;
        }
    }

    protected final Object lookupName(Object object) {
        NamingContextExt namingContextExt;
        if (!object._is_a(NamingContextHelper.id())) {
            throw new BAD_PARAM("located object is not a NameService", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        if (this.stringName == null || this.stringName.length() == 0) {
            return object;
        }
        try {
            namingContextExt = NamingContextExtHelper.narrow(object);
        }
        catch (Exception exception) {
            throw new BAD_PARAM("located object does not support INS", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        try {
            return namingContextExt.resolve_str(this.stringName);
        }
        catch (CannotProceed cannotProceed) {
            ORBRas.orbTrcLogger.exception(4104L, this, "lookupName:173", (Exception)cannotProceed);
            throw new BAD_PARAM(this.stringName + ": " + cannotProceed.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
        catch (InvalidName invalidName) {
            ORBRas.orbTrcLogger.exception(4104L, this, "lookupName:182", (Exception)invalidName);
            throw new BAD_PARAM(this.stringName + ": " + invalidName.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
        catch (NotFound notFound) {
            ORBRas.orbTrcLogger.exception(4104L, this, "lookupName:191", (Exception)notFound);
            throw new BAD_PARAM(this.stringName + ": " + notFound.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }

    public boolean isCorbaloc() {
        return false;
    }

    public boolean isCorbaname() {
        return true;
    }

    public String getStringName() {
        return INSUtil.encode2936(this.stringName);
    }
}

