/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.IOR;
import com.ibm.rmi.corba.CORBAObjectImpl;
import com.ibm.rmi.corba.IIOPAddrImpl;
import com.ibm.rmi.corba.ORB;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class Corbaloc
implements ObjectURL {
    private String keyString = "NameService";
    private byte[] objectKey;
    private boolean isRir = false;
    private ArrayList iiopList = null;
    private String encoding = "ISO-8859-1";

    protected Corbaloc() {
    }

    public Corbaloc(String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "<init>:99", (java.lang.Object)string);
        }
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("string is null or empty", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        if (!string.toLowerCase().startsWith("corbaloc:")) {
            throw new BAD_PARAM("string does not start with corbaloc:", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        this.parseCorbaloc(string.substring("corbaloc:".length()));
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:121", (java.lang.Object)this.toString());
        }
    }

    protected void parseCorbaloc(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            this.parseObjAddrList(string);
        } else {
            this.parseObjAddrList(string.substring(0, n));
            if (n + 1 < string.length()) {
                this.keyString = INSUtil.decode2936(string.substring(n + 1));
            }
        }
        try {
            this.objectKey = this.keyString.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "parseCorbaloc:155", (Exception)unsupportedEncodingException);
            this.objectKey = this.keyString.getBytes();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseObjAddrList(String var1_1) {
        if (var1_1 != null && var1_1.length() != 0) ** GOTO lbl10
        throw new BAD_PARAM("string has no address scheme", 1330446344, CompletionStatus.COMPLETED_NO);
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.indexOf(44);
            if (var2_2 == -1) {
                this.parseObjAddr(var1_1);
                var1_1 = null;
                continue;
            }
            this.parseObjAddr(var1_1.substring(0, var2_2));
            var1_1 = var2_2 + 1 <= var1_1.length() ? var1_1.substring(var2_2 + 1) : null;
lbl10:
            // 3 sources

            ** while (var1_1 != null)
        }
lbl11:
        // 1 sources

        if (this.isRir && this.iiopList != null) {
            throw new BAD_PARAM("rir: cannot be used with any other protocol", 1330446344, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parseObjAddr(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty obj_addr", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        int n = string.indexOf(58);
        if (n == -1) {
            throw new BAD_PARAM("missing prot_addr " + string, 1330446344, CompletionStatus.COMPLETED_NO);
        }
        if (string.startsWith("rir:")) {
            if (n + 1 < string.length()) {
                throw new BAD_PARAM("invalid obj_addr " + string, 1330446345, CompletionStatus.COMPLETED_NO);
            }
            this.isRir = true;
        } else if (n == 0 || string.startsWith("iiop:")) {
            this.addToIIOPList(new IIOPAddrImpl(string.substring(n + 1)));
        } else {
            throw new BAD_PARAM("invalid protocol " + string, 1330446344, CompletionStatus.COMPLETED_NO);
        }
    }

    private void addToIIOPList(IIOPAddrImpl iIOPAddrImpl) {
        if (iIOPAddrImpl == null) {
            return;
        }
        if (this.iiopList == null) {
            this.iiopList = new ArrayList();
        }
        this.iiopList.add(iIOPAddrImpl);
    }

    public String toString() {
        return "corbaloc:" + this.corbalocToString();
    }

    protected String corbalocToString() {
        String string = "";
        if (this.isRir) {
            string = string + "rir:";
        } else {
            int n = 0;
            while (n < this.iiopList.size()) {
                if (n > 0) {
                    string = string + ',';
                }
                string = string + this.iiopList.get(n).toString();
                ++n;
            }
        }
        return string + '/' + this.getKeyString();
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                System.out.println(stringArray[n] + " -> " + new Corbaloc(stringArray[n]));
            }
            catch (Exception exception) {
                System.out.println(stringArray[n] + " -> " + exception.toString());
            }
            ++n;
        }
    }

    private Object locateUsingINS(ORB oRB, IIOPAddrImpl iIOPAddrImpl) {
        com.ibm.CORBA.iiop.ORB cfr_ignored_0 = (com.ibm.CORBA.iiop.ORB)oRB;
        IOR iOR = (IOR)com.ibm.CORBA.iiop.ORB.createBootstrapIOR((com.ibm.CORBA.iiop.ORB)oRB, iIOPAddrImpl.host, iIOPAddrImpl.port, this.objectKey);
        iOR.getProfile().setMinor(iIOPAddrImpl.minor);
        ClientDelegate clientDelegate = new ClientDelegate((com.ibm.CORBA.iiop.ORB)oRB, iOR, 16);
        CORBAObjectImpl cORBAObjectImpl = new CORBAObjectImpl();
        cORBAObjectImpl._set_delegate(clientDelegate);
        iOR = (IOR)((com.ibm.rmi.iiop.ORB)oRB).getClientGIOP().locate(iOR, clientDelegate);
        return oRB.IORToObject(iOR);
    }

    private Object locateUsingBootstrap(ORB oRB, IIOPAddrImpl iIOPAddrImpl) throws InvalidName {
        return oRB.initialReferenceClient.resolve_initial_references(this.keyString, iIOPAddrImpl.host, iIOPAddrImpl.port);
    }

    private Object locateUsingRir(ORB oRB) {
        try {
            return oRB.resolve_initial_references(this.keyString);
        }
        catch (InvalidName invalidName) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "locateUsingRir:324", invalidName.toString());
            }
            throw new BAD_PARAM("could not locate rir object " + this.keyString + ": " + invalidName.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }

    protected Object lookupName(Object object) {
        return object;
    }

    public Object resolve(com.ibm.CORBA.iiop.ORB oRB) {
        FirstException firstException;
        block11: {
            IIOPAddrImpl iIOPAddrImpl;
            firstException = new FirstException();
            if (this.isRir) {
                try {
                    return this.lookupName(this.locateUsingRir(oRB));
                }
                catch (Exception exception) {
                    firstException.set(exception, null);
                    break block11;
                }
            }
            boolean[] blArray = new boolean[this.iiopList.size()];
            int n = 0;
            while (n < this.iiopList.size()) {
                iIOPAddrImpl = (IIOPAddrImpl)this.iiopList.get(n);
                blArray[n] = false;
                try {
                    return this.lookupName(this.locateUsingINS(oRB, iIOPAddrImpl));
                }
                catch (Exception exception) {
                    firstException.set(exception, iIOPAddrImpl);
                    if (exception instanceof COMM_FAILURE || exception instanceof TRANSIENT) {
                        blArray[n] = true;
                    }
                    ++n;
                }
            }
            int n2 = 0;
            while (n2 < this.iiopList.size()) {
                block12: {
                    if (!blArray[n2]) {
                        iIOPAddrImpl = (IIOPAddrImpl)this.iiopList.get(n2);
                        try {
                            return this.lookupName(this.locateUsingBootstrap(oRB, iIOPAddrImpl));
                        }
                        catch (Exception exception) {
                            if (!ORBRas.isTrcLogging) break block12;
                            ORBRas.orbTrcLogger.trace(8208L, this, "resolve:396", exception.toString());
                        }
                    }
                }
                ++n2;
            }
        }
        throw firstException.get();
    }

    public boolean isCorbaloc() {
        return true;
    }

    public boolean isCorbaname() {
        return false;
    }

    public boolean isIOR() {
        return false;
    }

    public boolean isRir() {
        return this.isRir;
    }

    public Iterator getIIOPList() {
        if (this.iiopList != null) {
            return this.iiopList.iterator();
        }
        return null;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public String getKeyString() {
        return INSUtil.encode2936(this.keyString);
    }

    public String getStringName() {
        return null;
    }

    private class FirstException {
        private Exception e = null;
        private ObjectURL.IIOPAddr iiopAddr = null;

        private FirstException() {
        }

        public void set(Exception exception, ObjectURL.IIOPAddr iIOPAddr) {
            if (this.e == null || this.e instanceof SystemException && !(exception instanceof SystemException)) {
                this.e = exception;
                this.iiopAddr = iIOPAddr;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "set:430", exception.toString());
            }
        }

        public SystemException get() {
            if (this.e == null) {
                return new BAD_PARAM("could not locate object", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            if (this.e instanceof SystemException) {
                return (SystemException)this.e;
            }
            return new BAD_PARAM(this.e.toString() + (this.iiopAddr == null ? "" : " with " + this.iiopAddr.toString()), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }
}

