/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jvm.ExtendedSystem;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.CDRInputStream;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;

public class Profile
implements com.ibm.CORBA.iiop.Profile {
    protected String host;
    protected int port;
    protected byte major = 1;
    protected byte minor = (byte)2;
    protected byte[] objectKey;
    private byte[] data;
    protected TaggedComponent[] components;
    private com.ibm.rmi.ORB factory;
    private String dottedDecimalHostAddress = null;
    private CodeSetComponentInfo cs = null;
    private int partnerVersion = 0;
    private short partnerExtended = 0;
    private boolean interceptorsRun = false;

    public Profile(com.ibm.rmi.ORB oRB) {
        this.factory = oRB;
        this.components = new TaggedComponent[0];
    }

    public Profile(com.ibm.rmi.ORB oRB, byte[] byArray) {
        this(oRB);
        this.objectKey = byArray;
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, byte[] byArray) {
        this(oRB, string, n, byArray, null);
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, byte[] byArray, Profile.TaggedComponent[] taggedComponentArray) {
        this.factory = oRB;
        this.host = string;
        this.port = n;
        this.objectKey = byArray;
        if (taggedComponentArray == null) {
            this.components = new TaggedComponent[2];
            this.components[0] = this.createCodeSetComponent();
            this.components[1] = this.createPartnerComponent();
        } else {
            this.components = (TaggedComponent[])taggedComponentArray;
            this.setCodeSetInfo();
            this.setPartnerInfo();
        }
    }

    private TaggedComponent createCodeSetComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        this.cs = (CodeSetComponentInfo)this.factory.getCodeSetComponentInfo();
        cDROutputStream.putEndian();
        this.cs.write(cDROutputStream);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(1, byArray);
    }

    private TaggedComponent createPartnerComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        this.partnerExtended = ((ORB)this.factory).getPartnerExtended();
        cDROutputStream.write_ushort(this.partnerExtended);
        this.partnerVersion = ((ORB)this.factory).getPartnerVersion();
        cDROutputStream.write_ulong(this.partnerVersion);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(1229081866, byArray);
    }

    public void setCodeSetInfo() {
        int n = 0;
        while (n < this.components.length) {
            if (this.components[n].tag == 1) {
                com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = this.components[n].getComponentData(this.factory);
                this.cs = new CodeSetComponentInfo();
                this.cs.read(cDRInputStream);
            }
            ++n;
        }
    }

    public void setPartnerInfo() {
        int n = 0;
        while (n < this.components.length) {
            if (this.components[n].tag == 1229081866) {
                com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = this.components[n].getComponentData(this.factory);
                cDRInputStream.consumeEndian();
                this.partnerExtended = cDRInputStream.read_ushort();
                this.partnerVersion = cDRInputStream.read_ulong();
            }
            ++n;
        }
    }

    public byte[] getEncapsulation() throws SystemException {
        if (this.data != null) {
            return this.data;
        }
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        cDROutputStream.write_octet(this.major);
        cDROutputStream.write_octet(this.minor);
        cDROutputStream.write_string(this.host);
        cDROutputStream.write_short((short)this.port);
        cDROutputStream.write_long(this.objectKey.length);
        cDROutputStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        if (this.minor > 0) {
            cDROutputStream.write_long(this.components.length);
            int n = 0;
            while (n < this.components.length) {
                this.components[n].write(cDROutputStream);
                ++n;
            }
        }
        this.data = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return this.data;
    }

    public Profile.TaggedComponent[] getTaggedComponents() {
        return this.components;
    }

    public Profile.TaggedComponent[] getTaggedComponents(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.components.length) {
            if (this.components[n3].tag == n) {
                ++n2;
            }
            ++n3;
        }
        Profile.TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < this.components.length) {
            if (this.components[n4].tag == n) {
                taggedComponentArray[n2++] = this.components[n4];
            }
            ++n4;
        }
        return taggedComponentArray;
    }

    public byte[] getTaggedComponent(int n) {
        int n2 = 0;
        while (n2 < this.components.length) {
            if (this.components[n2].tag == n) {
                return this.components[n2].component_data;
            }
            ++n2;
        }
        return null;
    }

    public void putTaggedComponent(int n, byte[] byArray) {
        this.putTaggedComponent(n, byArray, true);
    }

    public void putTaggedComponent(int n, byte[] byArray, boolean bl) {
        int n2;
        TaggedComponent taggedComponent = null;
        if (bl) {
            n2 = 0;
            while (n2 < this.components.length) {
                if (this.components[n2].tag == n) {
                    taggedComponent = this.components[n2];
                }
                ++n2;
            }
        }
        if (taggedComponent == null) {
            n2 = this.components.length;
            this.components = (TaggedComponent[])ExtendedSystem.resizeArray(n2 + 1, this.components, 0, n2);
            this.components[n2] = new TaggedComponent(n, byArray);
        } else {
            taggedComponent.component_data = byArray;
        }
        if (n == 1) {
            this.setCodeSetInfo();
        } else if (n == 1229081866) {
            this.setPartnerInfo();
        }
    }

    public void removeTaggedComponent(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.components.length) {
            if (this.components[n3].tag != n) {
                ++n2;
            }
            ++n3;
        }
        if (n2 < this.components.length) {
            TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
            n2 = 0;
            int n4 = 0;
            while (n4 < this.components.length) {
                if (this.components[n4].tag != n) {
                    taggedComponentArray[n2] = this.components[n4];
                    ++n2;
                }
                ++n4;
            }
            this.components = taggedComponentArray;
        }
    }

    public void addTaggedComponent(TaggedComponent taggedComponent) {
        TaggedComponent[] taggedComponentArray = this.components;
        this.components = new TaggedComponent[taggedComponentArray.length + 1];
        System.arraycopy(taggedComponentArray, 0, this.components, 0, taggedComponentArray.length);
        this.components[taggedComponentArray.length] = taggedComponent;
    }

    public void addTaggedComponents(TaggedComponent[] taggedComponentArray) {
        TaggedComponent[] taggedComponentArray2 = this.components;
        this.components = new TaggedComponent[taggedComponentArray2.length + taggedComponentArray.length];
        System.arraycopy(taggedComponentArray2, 0, this.components, 0, taggedComponentArray2.length);
        System.arraycopy(taggedComponentArray, 0, this.components, taggedComponentArray2.length, taggedComponentArray.length);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
        this.dottedDecimalHostAddress = null;
    }

    public String getHostIPAddress() {
        if (this.dottedDecimalHostAddress == null) {
            this.dottedDecimalHostAddress = this.factory.getTransportManager().getHostIPAddress(this.host);
        }
        return this.dottedDecimalHostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public ObjectKey getObjectKeyObject() {
        return new ObjectKey(this.objectKey);
    }

    public void setObjectKey(byte[] byArray) {
        this.objectKey = byArray;
    }

    public com.ibm.rmi.ORB getFactory() {
        return this.factory;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public void setMinor(byte by) {
        this.minor = by;
    }

    public com.ibm.CORBA.iiop.CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs;
    }

    public int getPartnerVersion() {
        return this.partnerVersion;
    }

    public short getPartnerExtended() {
        return this.partnerExtended;
    }

    public boolean isEquivalent(com.ibm.CORBA.iiop.Profile profile) {
        if (this.getPort() != profile.getPort() || !this.getHost().equalsIgnoreCase(profile.getHost()) || this.getObjectKey().length != profile.getObjectKey().length) {
            return false;
        }
        byte[] byArray = profile.getObjectKey();
        int n = 0;
        while (n < this.objectKey.length) {
            if (this.objectKey[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void read(com.ibm.CORBA.iiop.CDRInputStream cDRInputStream) {
        byte[] byArray;
        this.dottedDecimalHostAddress = null;
        int n = cDRInputStream.read_ulong();
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new MARSHAL("Encountered malformed request while reading Tagged Component (1)", 1229126036, CompletionStatus.COMPLETED_NO);
        }
        cDRInputStream.read_octet_array(byArray, 0, n);
        CDRInputStream cDRInputStream2 = new CDRInputStream(this.factory, byArray, n);
        ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).consumeEndian();
        this.major = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_octet();
        this.minor = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_octet();
        this.host = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_string();
        this.port = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_short() & 0xFFFF;
        int n2 = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_long();
        try {
            this.objectKey = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new MARSHAL("Encountered malformed request while reading Tagged Component (2)", 1229126037, CompletionStatus.COMPLETED_NO);
        }
        ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_octet_array(this.objectKey, 0, n2);
        if (this.minor > 0) {
            int n3 = ((com.ibm.CORBA.iiop.CDRInputStream)cDRInputStream2).read_long();
            try {
                this.components = new TaggedComponent[n3];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("Encountered malformed request while reading Tagged Component (3)", 1229126038, CompletionStatus.COMPLETED_NO);
            }
            int n4 = 0;
            while (n4 < n3) {
                this.components[n4] = new TaggedComponent();
                this.components[n4].read(cDRInputStream2);
                ++n4;
            }
        } else {
            this.components = new TaggedComponent[0];
        }
        this.setCodeSetInfo();
        this.setPartnerInfo();
    }

    public void write(CDROutputStream cDROutputStream) {
        CDROutputStream cDROutputStream2 = this.factory.newOutputStream();
        cDROutputStream2.putEndian();
        cDROutputStream2.write_octet(this.major);
        cDROutputStream2.write_octet(this.minor);
        cDROutputStream2.write_string(this.host);
        cDROutputStream2.write_short((short)this.port);
        cDROutputStream2.write_long(this.objectKey.length);
        cDROutputStream2.write_octet_array(this.objectKey, 0, this.objectKey.length);
        if (this.minor > 0) {
            cDROutputStream2.write_long(this.components.length);
            int n = 0;
            while (n < this.components.length) {
                this.components[n].write(cDROutputStream2);
                ++n;
            }
        }
        cDROutputStream2.writeOctetSequenceTo(cDROutputStream);
        cDROutputStream2.releaseBuffer();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "clone:558", (Exception)cloneNotSupportedException);
            throw new INTERNAL("failed to clone Profile", 1229125048, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void interceptorsRun(boolean bl) {
        this.interceptorsRun = bl;
    }

    public boolean interceptorsRun() {
        return this.interceptorsRun;
    }

    public static class TaggedComponent
    implements Profile.TaggedComponent {
        public int tag;
        public byte[] component_data;

        public TaggedComponent() {
            this.tag = -1;
            this.component_data = null;
        }

        public TaggedComponent(int n, byte[] byArray) {
            this.tag = n;
            this.component_data = byArray;
        }

        public void read(com.ibm.CORBA.iiop.CDRInputStream cDRInputStream) {
            this.tag = cDRInputStream.read_ulong();
            int n = cDRInputStream.read_long();
            try {
                this.component_data = (byte[])ExtendedSystem.newArray(Byte.TYPE, n, this);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("Encountered malformed request while reading Profile", 1229126035, CompletionStatus.COMPLETED_NO);
            }
            cDRInputStream.read_octet_array(this.component_data, 0, n);
        }

        public void write(CDROutputStream cDROutputStream) {
            cDROutputStream.write_ulong(this.tag);
            cDROutputStream.write_long(this.component_data.length);
            cDROutputStream.write_octet_array(this.component_data, 0, this.component_data.length);
        }

        public com.ibm.CORBA.iiop.CDRInputStream getComponentData(com.ibm.CORBA.iiop.ORB oRB) {
            return this.getComponentData((com.ibm.rmi.ORB)oRB);
        }

        public com.ibm.CORBA.iiop.CDRInputStream getComponentData(com.ibm.rmi.ORB oRB) {
            com.ibm.CORBA.iiop.CDRInputStream cDRInputStream = oRB.newInputStream(this.component_data, this.component_data.length);
            cDRInputStream.consumeEndian();
            return cDRInputStream;
        }

        public int tag() {
            return this.tag;
        }

        public void setTag(int n) {
            this.tag = n;
        }

        public byte[] componentData() {
            int n = this.component_data.length;
            byte[] byArray = new byte[n];
            System.arraycopy(this.component_data, 0, byArray, 0, n);
            return byArray;
        }

        public void setComponentData(byte[] byArray) {
            int n = byArray.length;
            this.component_data = new byte[n];
            System.arraycopy(byArray, 0, this.component_data, 0, n);
        }
    }
}

