/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ASCIIPrintStream
extends PrintStream {
    private static boolean ASCIIPlatform = true;
    private String eol = System.getProperty("line.separator");

    public ASCIIPrintStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public ASCIIPrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    private void write(String string) {
        if (ASCIIPlatform) {
            super.print(string);
            return;
        }
        int n = string.length();
        char[] cArray = new char[n];
        byte[] byArray = new byte[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = cArray[n2] < '\u0100' ? (int)cArray[n2] : 63;
            ++n2;
        }
        this.write(byArray, 0, n);
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(String.valueOf(cArray));
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.write(this.eol);
    }

    public void println(boolean bl) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(bl);
            this.write(this.eol);
        }
    }

    public void println(char c) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(c);
            this.write(this.eol);
        }
    }

    public void println(int n) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(n);
            this.write(this.eol);
        }
    }

    public void println(long l) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(l);
            this.write(this.eol);
        }
    }

    public void println(float f) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(f);
            this.write(this.eol);
        }
    }

    public void println(double d) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(d);
            this.write(this.eol);
        }
    }

    public void println(char[] cArray) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(cArray);
            this.write(this.eol);
        }
    }

    public void println(String string) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(string);
            this.write(this.eol);
        }
    }

    public void println(Object object) {
        ASCIIPrintStream aSCIIPrintStream = this;
        synchronized (aSCIIPrintStream) {
            this.print(object);
            this.write(this.eol);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ASCIIPlatform = System.getProperty("platform.notASCII", "false").equalsIgnoreCase("false");
                return null;
            }
        });
    }
}

