/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;

public final class TraceRecordInternal
extends TraceRecord {
    private int lastEntry;

    protected TraceRecordInternal(TraceFile traceFile, int n) throws IOException {
        super(traceFile, n);
    }

    protected final void prime() throws IOException {
        this.buffer = new byte[this.bufferSize - 72];
        byte by = 0;
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        long l = Long.MAX_VALUE;
        if ((long)this.bufferSize - this.nextEntry > 1L) {
            this.traceFile.seek((long)this.start + this.nextEntry + 1L);
            this.traceFile.read(this.buffer, 0, this.bufferSize - (int)this.nextEntry - 1);
        }
        this.traceFile.seek(this.start + 72);
        this.traceFile.read(this.buffer, this.bufferSize - (int)this.nextEntry - 1, (int)this.nextEntry - 72 + 1);
        int n2 = this.bufferSize - 72 - 1;
        Util.Debug.println("TraceBuffer: reading buffer size=:        " + (this.bufferSize - 72));
        Util.Debug.println("TraceBuffer: nextEntry        :           " + (int)this.nextEntry);
        Util.Debug.println("TraceBuffer: buffer[nextEntry]:           " + this.buffer[n2]);
        Util.Debug.println("TraceBuffer: File offset:                 " + this.start);
        int n3 = Util.constructUnsignedByte(this.buffer, n2);
        int n4 = 0;
        while (true) {
            if ((n2 -= n3) < 0) {
                n2 += n3;
                break;
            }
            if (n3 == 8 && this.buffer[n2 + 3] == 0 && this.buffer[n2 + 2] == 0 && this.buffer[n2 + 1] == 0) {
                this.wrapTimes.push(this.upperWord);
                this.upperWord = Util.constructUnsignedLong(this.buffer, n2 + 4, 4);
                Util.Debug.println("TraceBuffer: timewrap entry=" + n2 + " upperWord=" + this.upperWord);
                l = Long.MAX_VALUE;
            }
            if (n3 == 4 && this.buffer[n2 + 2] == 0 && this.buffer[n2 + 1] == 0) {
                Util.Debug.println("Entry with data length>256");
                by = this.buffer[n2 + 3];
                n = Util.constructUnsignedByte(this.buffer, n2);
                if (n2 - (n + by * 256) < 0) {
                    Util.Debug.println("entry < 0 must be a partial entry");
                    n2 += n3;
                    break;
                }
                this.longEntryTraceIDs.push(new Integer(Util.constructTraceID(this.buffer, (n2 -= n + by * 256) + 1)));
                this.buffer[n2 + 1] = 0;
                this.buffer[n2 + 2] = 0;
                this.buffer[n2 + 3] = by;
                n3 = n;
            }
            if (bl) {
                long l2 = Util.constructUnsignedLong(this.buffer, n2 + 4, 4).longValue();
                if (l2 != this.timeStamp.and(BigInteger.valueOf(0xFFFFFFFFL)).longValue()) {
                    bl2 = true;
                    Util.Debug.println("Possible damage to first trace entry");
                    Util.Debug.println("Trace time = " + l2 + " header = " + this.timeStamp.and(BigInteger.valueOf(0xFFFFFFFFL)).longValue());
                }
                bl = false;
            }
            if (bl2) {
                int n5 = Util.constructTraceID(this.buffer, n2 + 1);
                long l3 = Util.constructUnsignedLong(this.buffer, n2 + 4, 4).longValue();
                if (n5 > 256) {
                    if (MessageFile.getMessageFromID(n5) == null) {
                        Util.Debug.println("Bad trace identifier: " + n5);
                        Util.Debug.println("Ignoring " + (n2 + n3) + " bytes of the buffer");
                        n2 += n3;
                        break;
                    }
                    if (l3 > l) {
                        Util.Debug.println("Bad trace timeStamp :" + l3);
                        Util.Debug.println("Ignoring " + (n2 + n3) + "bytes of the buffer");
                        n2 += n3;
                        break;
                    }
                    l = l3;
                }
            }
            if (n3 == 0) {
                if (by == 0) {
                    Util.Debug.println("TraceRecord: Hit 0 length entry");
                    break;
                }
                Util.Debug.println("TraceRecord: 0 length entry (long record length is exact multiple of 256)");
            }
            n4 = Util.constructUnsignedByte(this.buffer, n2);
            this.buffer[n2] = (byte)n3;
            n3 = n4;
        }
        this.offset = n2;
        this.currentTimeStamp = this.upperWord.shiftLeft(32).or(Util.constructUnsignedLong(this.buffer, n2 + 4, 4));
    }

    protected final int getNextEntry() throws IOException {
        int n;
        if (this.notFormatted) {
            return 1;
        }
        this.notFormatted = true;
        do {
            if (this.offset >= this.bufferSize - 72 - 1) {
                n = 0;
                continue;
            }
            n = this.processNextEntryHeader(this.buffer, this.offset);
            if (this.currentLength >= 256) {
                this.offset += 4;
            }
            this.offset += this.currentLength;
        } while (n == 2);
        return n;
    }
}

