/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class TraceRecord
implements Comparable {
    protected static Hashtable indentLevels;
    protected static long lastThread;
    protected static byte ENTRY_TYPE;
    protected static byte EXIT_TYPE;
    protected static byte EVENT_TYPE;
    protected static byte EXCEPTION_TYPE;
    protected static byte MEM_TYPE;
    protected static byte DEBUG_TYPE;
    protected static byte PERF_TYPE;
    protected static byte MAX_TYPES;
    protected static byte ENTRY_EXCPT_TYPE;
    protected static byte EXIT_EXCPT_TYPE;
    protected static byte MEM_EXCPT_TYPE;
    protected static byte DEBUG_EXCPT_TYPE;
    protected static byte PERF_EXCPT_TYPE;
    protected static String[] Chars;
    protected static String[] types;
    protected static final StringBuffer BASE_INDENT;
    protected static final String TAB = " ";
    protected static final int TRACEID_OFFSET = 1;
    protected static final int TIMESTAMP_OFFSET = 4;
    protected byte[] buffer = null;
    protected BigInteger timeStamp;
    protected BigInteger wrapTime;
    protected BigInteger writePlatform = BigInteger.ZERO;
    protected BigInteger writeSystem = BigInteger.ZERO;
    protected long threadID = 0L;
    protected String threadName;
    protected long nextEntry;
    private String padding;
    private boolean doIndent;
    private String threadIDString;
    protected boolean recordFinished = false;
    protected TraceThread traceThread = null;
    protected TraceFile traceFile;
    protected int bufferSize;
    protected int start;
    protected int offset;
    protected byte[] currentBuffer;
    protected int currentOffset;
    protected int currentTraceID;
    protected int currentLength;
    protected BigInteger currentTimeStamp;
    private Message currentMessage;
    private int currentType;
    private String currentComponent;
    protected BigInteger upperWord = BigInteger.ZERO;
    protected Stack wrapTimes = new Stack();
    protected Stack longEntryTraceIDs = new Stack();
    protected boolean notFormatted = false;
    private int lastErrorRecord = -1;
    protected final int headerSize = 72;

    protected TraceRecord(TraceFile traceFile, int n) throws IOException {
        traceFile.seek(n);
        this.timeStamp = traceFile.readBigInteger(8);
        this.wrapTime = traceFile.readBigInteger(8);
        this.writePlatform = traceFile.readBigInteger(8);
        this.writeSystem = traceFile.readBigInteger(8);
        this.threadID = traceFile.readL();
        this.threadName = traceFile.readString(28);
        this.nextEntry = traceFile.readI();
        this.upperWord = this.timeStamp.shiftRight(32);
        this.wrapTimes.push(this.upperWord);
        this.threadIDString = Long.toString(this.threadID, 16);
        Util.Debug.println("reading timeStamp     " + this.timeStamp);
        Util.Debug.println("reading wrapTime      " + this.wrapTime);
        Util.Debug.println("reading writePlatform " + this.writePlatform);
        Util.Debug.println("reading writeSystem   " + this.writeSystem);
        this.bufferSize = traceFile.traceFileHeader.getBufferSize();
        this.traceFile = traceFile;
        this.start = n;
        this.currentTimeStamp = this.timeStamp;
        if (this.nextEntry >= 0L && (this.nextEntry < 72L || this.nextEntry > (long)this.bufferSize)) {
            Util.Debug.println("Invalid Buffer - nextEntry = " + this.nextEntry + ", headerSize = " + 72 + ", bufferSize = " + this.bufferSize);
            ++TraceFormat.invalidBuffers;
            return;
        }
        if (this.writePlatform.compareTo(TraceFormat.lastWritePlatform) > 0) {
            Util.Debug.println("updating lastWritePlatform" + this.writePlatform);
            Util.Debug.println("updating lastWriteSystem  " + this.writeSystem);
            TraceFormat.lastWritePlatform = this.writePlatform;
            TraceFormat.lastWriteSystem = this.writeSystem;
        }
        if (this.wrapTime.compareTo(TraceFormat.first) < 0) {
            TraceFormat.first = this.wrapTime;
        }
        if (this.timeStamp.compareTo(TraceFormat.last) > 0) {
            TraceFormat.last = this.timeStamp;
        }
        this.padding = Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4 ? "00000000" : "0000000000000000";
        this.doIndent = TraceArgs.indent;
        Util.Debug.println("*********************************************************");
        Util.Debug.println("TraceBufferHeader: timeStamp : 0x" + this.timeStamp.toString(16));
        Util.Debug.println("TraceBufferHeader: threadID  : 0x" + Long.toString(this.threadID, 16));
        Util.Debug.println("TraceBufferHeader: threadName: " + this.threadName + "\n");
        Util.Debug.println("TraceBufferHeader: nextEntry : " + this.nextEntry);
        Util.Debug.println("*********************************************************");
        boolean bl = false;
        Util.Debug.println("Processing Record Header");
        bl = false;
        if (!Util.findThreadID(new Long(this.threadID))) {
            return;
        }
        Iterator iterator = TraceFormat.threads.iterator();
        while (iterator.hasNext()) {
            this.traceThread = (TraceThread)iterator.next();
            if (this.threadID != this.traceThread.threadID) continue;
            bl = true;
            Util.Debug.println("Found existing threadID " + this.threadID);
            break;
        }
        if (!bl) {
            this.traceThread = new TraceThread(this.threadID, this.threadName);
            TraceFormat.threads.addElement(this.traceThread);
        }
        this.traceThread.addElement(this);
    }

    protected static final void initStatics() {
        indentLevels = null;
        lastThread = 0L;
        Chars = new String[12];
        types = new String[12];
    }

    protected final BigInteger getCurrentTimeStamp() {
        return this.currentTimeStamp;
    }

    protected final TraceRecord getNextRecord() {
        int n = this.traceThread.indexOf(this) + 1;
        if (n >= this.traceThread.size()) {
            return null;
        }
        BigInteger bigInteger = ((TraceRecord)this.traceThread.elementAt((int)(n - 1))).timeStamp;
        BigInteger bigInteger2 = ((TraceRecord)this.traceThread.elementAt((int)n)).timeStamp;
        if (bigInteger.equals(bigInteger2)) {
            if (this.lastErrorRecord != n) {
                this.lastErrorRecord = n;
                TraceFormat.outStream.println("\nWARNING: duplicate trace record discarded (record " + (n + 1) + " for thread 0x" + Long.toHexString(this.threadID) + ")");
                --TraceFormat.expectedRecords;
            }
            if (n + 1 >= this.traceThread.size()) {
                return null;
            }
            return (TraceRecord)this.traceThread.elementAt(n + 1);
        }
        return (TraceRecord)this.traceThread.elementAt(n);
    }

    protected final int processNextEntryHeader(byte[] byArray, int n) throws IOException {
        this.currentLength = Util.constructUnsignedByte(byArray, n);
        this.currentTraceID = Util.constructTraceID(byArray, n + 1);
        if (this.currentTraceID == 0) {
            if (this.currentLength == 8) {
                this.upperWord = (BigInteger)this.wrapTimes.pop();
                Util.Debug.println("TraceRecord: timewrap new upperWord=" + this.upperWord);
            }
            return 2;
        }
        if (this.currentTraceID == 256 && this.currentLength == 8) {
            this.currentTimeStamp = this.wrapTime;
            Util.Debug.println("TraceRecord: lost records");
        } else {
            this.currentTimeStamp = this.upperWord.shiftLeft(32).or(Util.constructUnsignedLong(byArray, n + 4, 4));
        }
        if (this.currentTraceID < 256) {
            Util.Debug.println("processing long record: start                   " + n);
            Util.Debug.println("processing long record: previous currentLength  " + this.currentLength);
            Util.Debug.println("processing long record: previous currentTraceID " + this.currentTraceID);
            this.currentLength += this.currentTraceID * 256;
            this.currentTraceID = (Integer)this.longEntryTraceIDs.pop();
            Util.Debug.println("processing long record: currentLength           " + this.currentLength);
            Util.Debug.println("processing long record: currentTraceID          " + this.currentTraceID);
        }
        if ((this.currentMessage = MessageFile.getMessageFromID(this.currentTraceID)) == null) {
            Util.Debug.println("TraceRecord: message is null ");
            Util.Debug.println("TraceRecord: currentTraceID  " + this.currentTraceID);
            Util.Debug.println("TraceRecord: currentLength   " + this.currentLength);
            Util.Debug.println("TraceRecord: notFormatted    " + this.notFormatted);
            Util.Debug.println("TraceRecord: start           " + n);
            Util.printDump(byArray, n + this.currentLength);
            TraceFormat.outStream.println(TAB);
            TraceFormat.outStream.println("*** Invalid trace entry TraceID=" + Integer.toHexString(this.currentTraceID) + " found in Trace Buffer");
            return 0;
        }
        this.currentType = this.currentMessage.getType();
        this.currentComponent = this.currentMessage.getComponent();
        this.currentBuffer = byArray;
        this.currentOffset = n;
        if (this.currentLength == 0) {
            Util.Debug.println("TraceRecord: currentLength 0 start=" + n);
            Util.printDump(byArray, 16);
            TraceFormat.outStream.println("Internal Error");
            throw new IOException();
        }
        if (!Util.findComponentAndType(this.currentComponent.toLowerCase(), types[this.currentType].toLowerCase())) {
            return 2;
        }
        return 1;
    }

    protected final String formatCurrentEntry() throws IOException {
        String string;
        boolean bl = this.threadID != lastThread;
        lastThread = this.threadID;
        StringBuffer stringBuffer = TraceRecord.getIndent(this.threadIDString, this.doIndent);
        StringBuffer stringBuffer2 = new StringBuffer(Util.getFormattedTime(this.currentTimeStamp));
        try {
            string = this.currentTraceID == 256 ? this.currentMessage.getMessage(this.currentBuffer, this.currentOffset + 4, this.currentOffset + 8) : this.currentMessage.getMessage(this.currentBuffer, this.currentOffset + 8, this.currentOffset + this.currentLength);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = "*** Invalid data in Trace Entry ***";
        }
        stringBuffer2.ensureCapacity(100);
        String string2 = Integer.toHexString(this.currentTraceID);
        string2 = "000000".substring(string2.length()) + string2;
        if ((double)TraceFormat.verMod >= 1.1) {
            stringBuffer2.append(bl ? "*" : TAB).append(this.padding.substring(this.threadIDString.length()) + this.threadIDString).append(TAB).append(string2).append((this.currentType & EXCEPTION_TYPE) == EXCEPTION_TYPE ? "*" : TAB).append(types[this.currentType]);
        } else {
            stringBuffer2.append(bl ? "*" : TAB).append(this.padding.substring(this.threadIDString.length()) + this.threadIDString).append(TAB).append(string2).append(this.currentType == EXCEPTION_TYPE ? Chars[this.currentType] : TAB).append(types[this.currentType]);
        }
        if (this.doIndent && (this.currentType == EXIT_TYPE || this.currentType == EXIT_EXCPT_TYPE)) {
            stringBuffer.delete(0, TAB.length());
            TraceRecord.setIndent(this.threadIDString, stringBuffer);
        }
        stringBuffer2.append(BASE_INDENT.toString()).append(this.doIndent ? stringBuffer.toString() : "").append(Chars[this.currentType]).append(TAB).append(string);
        if (this.doIndent && (this.currentType == ENTRY_TYPE || this.currentType == ENTRY_EXCPT_TYPE)) {
            stringBuffer.append(TAB);
            TraceRecord.setIndent(this.threadIDString, stringBuffer);
        }
        this.notFormatted = false;
        return stringBuffer2.toString();
    }

    protected final void release() {
        this.buffer = null;
    }

    public final int compareTo(Object object) {
        return this.currentTimeStamp.compareTo(((TraceRecord)object).getCurrentTimeStamp());
    }

    protected static final StringBuffer getIndent(String string, boolean bl) {
        StringBuffer stringBuffer;
        if (!bl) {
            return BASE_INDENT;
        }
        if (indentLevels == null) {
            indentLevels = new Hashtable();
        }
        return (stringBuffer = (StringBuffer)indentLevels.get(string)) == null ? new StringBuffer() : stringBuffer;
    }

    protected static final void setIndent(String string, StringBuffer stringBuffer) {
        if (indentLevels == null) {
            indentLevels = new Hashtable();
        }
        indentLevels.remove(string);
        indentLevels.put(string, stringBuffer);
    }

    protected void prime() throws IOException {
    }

    protected int getNextEntry() throws IOException {
        return 0;
    }

    static {
        BASE_INDENT = new StringBuffer();
    }
}

