/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.svcdump;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvJavaStack;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.svcdump.Address;
import com.ibm.jvm.dump.svcdump.AddressSpace;
import com.ibm.jvm.dump.svcdump.Dsa;
import com.ibm.jvm.dump.svcdump.Function;
import java.util.Hashtable;
import java.util.Vector;

public class Tcb
extends DvThread {
    AddressSpace space;
    int topDsaAddress;
    Dsa topDsa;
    Dsa[] stack;
    int tcbid;
    int tid;
    int ee;
    int state;
    int caa;
    String type;
    boolean isKnownType;
    boolean scannedTid;
    Hashtable traceTable;
    Function[] traceFunctions;
    static final int STCB = 312;
    static final int OTCB = 216;
    static final int THLI = 188;
    static final int TID = 52;
    boolean is131 = false;
    boolean is131b = false;
    boolean verbose;
    int[] failingRegisters;

    public DvProcess getProcess() {
        return this.space.getProcesses()[0];
    }

    public String id() {
        return this.hexId();
    }

    public boolean isJava() {
        return this.tid != 0;
    }

    public DvAddress eeAddress() {
        return new Address(this.ee);
    }

    public DvNativeFrame[] getNativeFrames() {
        Vector vector = new Vector();
        Dsa dsa = this.topDsa;
        while (dsa != null) {
            vector.add(dsa);
            dsa = dsa.previous();
        }
        return (DvNativeFrame[])vector.toArray(new DvNativeFrame[0]);
    }

    public DvJavaFrame[] getJavaFrames() {
        throw new Error("unimplemented method");
    }

    public DvAddress getPSW() {
        throw new Error("unimplemented method");
    }

    public DvRegister[] getRegisters() {
        throw new Error("unimplemented method");
    }

    public void printAllocCache() {
        if (this.ee != 0 && this.is131) {
            try {
                int n;
                System.out.println("alloc cache info:");
                int n2 = this.space.readInt(this.ee + 32);
                int n3 = this.space.readInt(this.ee + 36);
                int n4 = this.space.readInt(this.ee + 40);
                int n5 = this.space.readInt(this.ee + 44);
                int n6 = this.space.readInt(this.ee + 68);
                System.out.println("cache_busy = 0x" + Tcb.hex(n2));
                System.out.println("cache_block = 0x" + Tcb.hex(n4));
                System.out.println("cache_size = 0x" + Tcb.hex(n3) + " -> 0x" + Tcb.hex(n4 + n3));
                System.out.println("cache_orig_size = 0x" + Tcb.hex(n5) + " -> 0x" + Tcb.hex(n4 + n5));
                System.out.println("target_size = 0x" + Tcb.hex(n6));
                int n7 = 0;
                if (n4 != 0 && n3 != 0) {
                    n = n5 - n3;
                    int n8 = n4 + n3;
                    int n9 = n8 + n;
                    int n10 = this.space.readInt(n4 - 12);
                    int n11 = this.space.readInt(n4 - 8);
                    int n12 = this.space.readInt(n4 - 4);
                    System.out.println("cache link size = 0x" + Tcb.hex(n10));
                    System.out.println("cache obj size = 0x" + Tcb.hex(n11));
                    System.out.println("cache flags = 0x" + Tcb.hex(n12));
                    while (n8 < n9) {
                        int n13 = this.space.readInt(n8) & 0x3FFFFFF8;
                        System.out.print(Tcb.hex(n8) + ": len = " + Tcb.hex(n13));
                        int n14 = this.space.readInt(n8 + 4);
                        int n15 = this.space.readInt(n8 + 8);
                        System.out.print(" methods = " + Tcb.hex(n14) + " flags = " + Tcb.hex(n15));
                        if (n15 == 0 && n14 != 0) {
                            int n16 = this.space.readInt(n14);
                            String string = this.space.jvm.cbName(n16);
                            System.out.print(" class = " + string);
                        }
                        System.out.println("");
                        if (n13 <= 0 || n13 > n5) {
                            n7 = n8;
                            break;
                        }
                        n8 += n13;
                    }
                }
                if (n7 != 0) {
                    System.out.println("*** dodgy alloc cache? dump follows ***");
                    n = n4;
                    while (n < n7 + 256) {
                        System.out.println("0x" + Tcb.hex(n) + ": " + Tcb.hex(this.space.readInt(n)));
                        n += 4;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("problem reading ee " + Tcb.hex(this.ee));
            }
        }
    }

    boolean isValidEE(int n) {
        try {
            int n2 = this.space.readInt(n);
            int n3 = this.space.readInt(n2);
            int n4 = this.space.readInt(n2 + 4);
            int n5 = this.space.readInt(n2 + 8);
            int n6 = this.space.readInt(n2 + 12);
            int n7 = this.space.readInt(n2 + 16);
            if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0 && n7 > 0x1000000) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void findEE() throws Exception {
        this.ee = this.space.readInt(this.tid + 40);
        if (this.ee < 65536) {
            this.ee = this.tid - 528;
            if (this.isValidEE(this.ee)) {
                this.is131b = true;
            } else {
                this.ee = this.tid - 512;
                if (!this.isValidEE(this.ee)) {
                    throw new Exception("Invalid ee: " + Tcb.hex(this.ee));
                }
            }
            this.is131 = true;
        }
        this.space.createJvm();
        this.space.jvm.setJvmFromEE(this.ee);
    }

    void findDsaFromLastFrame() {
        try {
            int n = 0;
            n = this.is131 ? this.space.readInt(this.ee + 412) : this.space.readInt(this.ee + 64);
            if (n != 0) {
                this.topDsa = Dsa.findTop(this, n);
                this.isKnownType = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Tcb(AddressSpace addressSpace, int n) {
        this.space = addressSpace;
        this.tcbid = n;
        try {
            int n2 = addressSpace.readInt(n + 312);
            int n3 = addressSpace.readInt(n2 + 216);
            int n4 = addressSpace.readInt(n3 + 188);
            this.tid = addressSpace.readInt(n4 + 52);
            if (this.tid != 0) {
                addressSpace.mapTid(this.tid, this);
                this.findEE();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isLE() || this.isRtwa() || this.isLinkage() || this.isLinkage2() || this.isIrb() || this.isCics() || this.isUsta()) {
            this.isKnownType = true;
            try {
                this.topDsa = new Dsa(this, this.topDsaAddress);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.topDsa == null || this.topDsa.prevCount() < 3) {
                this.type = "dodgy";
                try {
                    this.topDsaAddress = this.findBestDsa();
                    this.topDsa = new Dsa(this, this.topDsaAddress);
                }
                catch (Exception exception) {}
            }
        } else {
            this.type = "unknown";
            this.findDsaFromLastFrame();
            this.findCaa();
        }
    }

    Tcb(AddressSpace addressSpace, int n, int n2) {
        this.space = addressSpace;
        this.tid = n2;
        this.type = "Java thread with no TCB";
        this.findDsaFromLastFrame();
    }

    void findCaa() {
    }

    public void addTraceEntry(int n, int n2) {
        Integer n3;
        Integer n4;
        if (this.traceTable == null) {
            this.traceTable = new Hashtable();
        }
        this.traceTable.put(n4, new Integer((n3 = (Integer)this.traceTable.get(n4 = new Integer(n2))) == null ? 1 : n3 + 1));
    }

    public Function[] traceFunctions() {
        if (this.traceFunctions == null && this.traceTable != null) {
            this.traceFunctions = this.space.traceFunctions(this.traceTable);
        }
        return this.traceFunctions;
    }

    public Dsa topDsa() {
        return this.topDsa;
    }

    public Dsa[] stack() {
        if (this.stack == null) {
            Vector vector = new Vector();
            Dsa dsa = this.topDsa();
            while (dsa != null) {
                vector.add(dsa);
                dsa = dsa.previous();
            }
            this.stack = (Dsa[])vector.toArray(new Dsa[0]);
        }
        return this.stack;
    }

    public boolean isValidCaa(int n) {
        block4: {
            try {
                int n2 = this.space.readInt(n - 24);
                int n3 = this.space.readInt(n - 20) & 0xFFFF0000;
                if (n2 == -1010448957 && n3 == -1044316160) {
                    this.caa = n;
                    return true;
                }
                if (this.verbose) {
                    System.out.println("invalid caa " + Tcb.hex(n) + ": " + Tcb.hex(n2) + ", " + Tcb.hex(n3));
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block4;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public int caa() {
        return this.caa;
    }

    public boolean isLE() {
        try {
            int n = this.space.readInt(this.tcbid + 96);
            if (this.isValidCaa(n)) {
                this.topDsaAddress = this.space.readInt(this.tcbid + 100);
                this.type = "LE";
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return false;
    }

    int findBestDsa() throws Exception {
        int n;
        block24: {
            int n2;
            int n3;
            int n4;
            int n5 = this.space.readInt(this.caa + 736);
            int n6 = this.space.readInt(n5 + 76);
            Dsa dsa = Dsa.findTop(this, n6);
            n = dsa.stackPointer();
            int n7 = dsa.prevCount();
            int n8 = this.space.readInt(this.tcbid + 100);
            try {
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n9 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n9 + 216);
                n3 = this.space.readInt(n4 + 56);
                n2 = this.space.readInt(n3 + 4);
                n8 = this.space.readInt(n2 + 76);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n10 = this.space.readInt(this.tcbid + 224);
                n8 = this.space.readInt(n10 + 112);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n11 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n11 + 116);
                n3 = this.space.readInt(n11 + 128);
                if (n4 != n3 && (dsa = new Dsa(this, n8 = this.space.readInt(n3 + 8 + 52))).prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n12 = this.space.readInt(this.tcbid);
                n8 = this.space.readInt(n12 + 84);
                dsa = new Dsa(this, n8);
                if (dsa.prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n13 = this.space.readInt(this.tcbid + 72);
                if (this.space.readInt(n13 + 112) == this.tcbid && (dsa = new Dsa(this, n8 = this.space.readInt(n13 + 132))).prevCount() > n7) {
                    n = dsa.stackPointer();
                    n7 = dsa.prevCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n14 = this.space.readInt(this.tcbid + 312);
                n4 = this.space.readInt(n14 + 116);
                n3 = this.space.readInt(n14 + 128);
                if (n4 == n3) break block24;
                try {
                    n2 = this.space.readInt(n3 + 8 + 20);
                    n8 = this.space.readInt(n2 + 84);
                    dsa = new Dsa(this, n8);
                    if (dsa.prevCount() > n7) {
                        n = dsa.stackPointer();
                        n7 = dsa.prevCount();
                    }
                }
                catch (Exception exception) {
                    int n15 = this.space.readInt(n3 + 8 + 44);
                    n8 = this.space.readInt(n15 + 84);
                    dsa = new Dsa(this, n8);
                    if (dsa.prevCount() > n7) {
                        n = dsa.stackPointer();
                        n7 = dsa.prevCount();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isUsta() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid + 312);
                int n2 = this.space.readInt(n + 216);
                int n3 = this.space.readInt(n2 + 56);
                int n4 = this.space.readInt(n3 + 4);
                int n5 = this.space.readInt(n4 + 72);
                if (this.isValidCaa(n5)) {
                    this.topDsaAddress = this.findBestDsa();
                    this.type = "Usta";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isLinkage() {
        block3: {
            try {
                int n;
                int n2 = this.space.readInt(this.tcbid + 312);
                int n3 = this.space.readInt(n2 + 116);
                int n4 = this.space.readInt(n2 + 128);
                if (n3 != n4 && this.isValidCaa(n = this.space.readInt(n4 + 8 + 48))) {
                    this.topDsaAddress = this.space.readInt(n4 + 8 + 52);
                    this.type = "Linkage";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isLinkage2() {
        block3: {
            try {
                int n;
                int n2;
                int n3 = this.space.readInt(this.tcbid + 312);
                int n4 = this.space.readInt(n3 + 116);
                int n5 = this.space.readInt(n3 + 128);
                if (n4 != n5 && this.space.readInt(n2 = this.space.readInt(n5 + 8 + 8)) == -454892607 && this.isValidCaa(n = this.space.readInt(n2 + 72))) {
                    this.topDsaAddress = this.space.readInt(n2 + 76);
                    this.type = "Linkage 2";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isRtwa() {
        block4: {
            try {
                int n;
                int n2 = this.space.readInt(this.tcbid + 224);
                if (n2 != 0 && this.isValidCaa(n = this.space.readInt(n2 + 108))) {
                    this.topDsaAddress = this.space.readInt(n2 + 112);
                    this.type = "Failing";
                    this.failingRegisters = new int[18];
                    int n3 = 0;
                    while (n3 < this.failingRegisters.length) {
                        this.failingRegisters[n3] = this.space.readInt(n2 + 60 + (n3 << 2));
                        ++n3;
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block4;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isIrb() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid);
                int n2 = this.space.readInt(n + 80);
                if (this.isValidCaa(n2)) {
                    this.topDsaAddress = this.space.readInt(n + 84);
                    this.type = "IRB";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isCics() {
        block3: {
            try {
                int n = this.space.readInt(this.tcbid + 72);
                if (this.space.readInt(n + 112) == this.tcbid) {
                    this.topDsaAddress = this.space.readInt(n + 132);
                    int n2 = this.space.readInt(this.topDsaAddress + 4);
                    n2 = this.space.readInt(n2 + 4);
                    this.type = "Cics";
                    return true;
                }
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                exception.printStackTrace(System.out);
            }
        }
        return false;
    }

    public boolean isKnownType() {
        return this.isKnownType;
    }

    public String type() {
        return this.type;
    }

    public int tid() {
        return this.tid;
    }

    public int ee() {
        return this.ee;
    }

    public int threadIndex() {
        if (this.isJava() && this.is131) {
            try {
                return this.space.readInt(this.ee + 340);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public int failingDsa() {
        int[] nArray = this.failingRegisters();
        if (nArray != null) {
            return nArray[13];
        }
        return 0;
    }

    public int failingPsw() {
        int[] nArray = this.failingRegisters();
        if (nArray != null) {
            return nArray[17] & Integer.MAX_VALUE;
        }
        return 0;
    }

    public int[] failingRegisters() {
        if (this.failingRegisters != null) {
            return this.failingRegisters;
        }
        try {
            int n = this.space.readInt(this.caa + 728);
            int n2 = this.space.readInt(n + 36);
            int n3 = this.space.readInt(n2);
            if (n3 != -371932216) {
                return null;
            }
            this.failingRegisters = new int[18];
            int n4 = 0;
            while (n4 < this.failingRegisters.length) {
                this.failingRegisters[n4] = this.space.readInt(n2 + 8 + (n4 << 2));
                ++n4;
            }
            return this.failingRegisters;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int tid_type() {
        try {
            return this.space.readInt(this.tid + 36);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int tid_state() {
        try {
            return this.space.readInt(this.tid + 40);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    String hexId() {
        return Integer.toHexString(this.tcbid);
    }

    public String toString() {
        return this.hexId();
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public DvJavaStack getJavaStack() {
        return null;
    }

    public DvNativeStack getNativeStack() {
        return null;
    }
}

