/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.svcdump;

import com.ibm.jvm.dump.svcdump.AddressSpace;
import com.ibm.jvm.dump.svcdump.Dump;
import java.text.DateFormat;
import java.util.Hashtable;

public class Jvm {
    AddressSpace space;
    boolean checkedVersion = false;
    boolean foundJvmPointer = false;
    boolean is131 = false;
    Hashtable names = new Hashtable();
    Hashtable livecounts = new Hashtable();
    Hashtable deadcounts = new Hashtable();
    int jvmp;
    int st;
    int stglobal;
    int st_jab;
    int heapbase;
    int heaplimit;
    int mh_heapbase;
    int mh_heaplimit;
    int th_heapbase;
    int th_heaplimit;
    int freeObjectCtr;
    int afctr;
    int totalObjectCtr;
    int freeList;
    int allocbits;
    int sampleEE;
    int lastaddress;
    int limit = 10;
    int totalLength = 0;
    int totalObjects = 0;
    static DateFormat df = DateFormat.getTimeInstance();

    Jvm(AddressSpace addressSpace) {
        this.space = addressSpace;
    }

    boolean verbose() {
        return Dump.verbose;
    }

    String cbName(int n) throws Exception {
        if (this.space.readInt(n + 28) == n) {
            if (this.checkedVersion) {
                if (this.is131 && this.space.readInt(n + 12) != n) {
                    throw new Error("Blooming heck!");
                }
            } else {
                this.is131 = false;
            }
        } else if (this.checkedVersion) {
            if (!this.is131) {
                throw new Error("Blooming heck!");
            }
        } else {
            this.is131 = true;
        }
        this.checkedVersion = true;
        int n2 = this.is131 ? this.space.readInt(n + 64) : this.space.readInt(n + 12);
        String string = (String)this.names.get(new Integer(n2));
        if (string == null) {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n3 = this.space.readUnsignedByte(n2++)) != 0) {
                stringBuffer.append((char)n3);
            }
            string = stringBuffer.toString();
            this.names.put(new Integer(n2), string);
        }
        return string;
    }

    void setJvmFromEE(int n) {
        if (this.sampleEE == 0) {
            this.sampleEE = n;
        }
    }

    public void print() {
        try {
            this.setJvmFromEE();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setJvmFromEE() throws Exception {
        int n;
        int n2;
        int n3;
        if (this.foundJvmPointer) {
            return;
        }
        if (!this.checkedVersion) {
            throw new Exception("Cannot set jvm before we have checked the version!");
        }
        if (!this.is131) {
            return;
        }
        if (Dump.verbose) {
            System.out.println("ee = " + Jvm.hex(this.sampleEE));
        }
        this.jvmp = this.space.readInt(this.sampleEE + 452);
        if (Dump.verbose) {
            System.out.println("jvmp = " + Jvm.hex(this.jvmp));
        }
        if ((n3 = this.space.readInt(this.jvmp)) != -725497387) {
            throw new Error("Eyecatcher MAIN not found in master jvm block");
        }
        int n4 = this.space.readInt(this.sampleEE + 456);
        if (Dump.verbose) {
            n2 = this.space.readInt(n4);
            System.out.println("queue_lock = " + Jvm.hex(n2));
            n = this.space.readInt(n4 + 16);
            System.out.println("heap_lock = " + Jvm.hex(n));
        }
        if (Dump.verbose) {
            System.out.println("eye = " + Jvm.hex(n3));
        }
        this.st = this.jvmp + 340;
        if (Dump.verbose) {
            System.out.println("st = " + Jvm.hex(this.st));
        }
        this.stglobal = this.space.readInt(this.st + 404);
        if (Dump.verbose) {
            System.out.println("stglobal = " + Jvm.hex(this.stglobal));
        }
        this.mh_heapbase = this.space.readInt(this.stglobal + 36);
        if (Dump.verbose) {
            System.out.println("mh_heapbase = " + Jvm.hex(this.mh_heapbase));
        }
        this.mh_heaplimit = this.space.readInt(this.stglobal + 40);
        if (Dump.verbose) {
            System.out.println("mh_heaplimit = " + Jvm.hex(this.mh_heaplimit));
        }
        this.th_heapbase = this.space.readInt(this.stglobal + 44);
        if (Dump.verbose) {
            System.out.println("th_heapbase = " + Jvm.hex(this.th_heapbase));
        }
        this.th_heaplimit = this.space.readInt(this.stglobal + 48);
        if (Dump.verbose) {
            System.out.println("th_heaplimit = " + Jvm.hex(this.th_heaplimit));
        }
        this.allocbits = this.space.readInt(this.stglobal + 100);
        if (Dump.verbose) {
            System.out.println("allocbits = " + Jvm.hex(this.allocbits));
        }
        this.st_jab = this.space.readInt(this.stglobal + 12);
        if (Dump.verbose) {
            System.out.println("st_jab = " + Jvm.hex(this.st_jab));
        }
        n2 = this.space.readInt(this.stglobal + 24);
        if (Dump.verbose) {
            System.out.println("real_heaptop = " + Jvm.hex(n2));
        }
        n = this.space.readInt(this.stglobal + 32);
        if (Dump.verbose) {
            System.out.println("real_TH_limit = " + Jvm.hex(n));
        }
        int n5 = this.space.readInt(this.st_jab);
        if (Dump.verbose) {
            System.out.println("init_nursery_size = " + Jvm.hex(n5));
        }
        this.afctr = this.space.readInt(this.stglobal + 996);
        this.freeObjectCtr = this.space.readInt(this.stglobal + 1016);
        this.totalObjectCtr = this.space.readInt(this.stglobal + 1020);
        this.freeList = this.space.readInt(this.stglobal + 1036);
        if (Dump.verbose) {
            System.out.println("freeList = " + Jvm.hex(this.freeList));
        }
        int n6 = this.space.readInt(this.stglobal + 1040);
        if (Dump.verbose) {
            System.out.println("freeTail = " + Jvm.hex(n6));
        }
        int n7 = this.space.readInt(this.stglobal + 1044);
        if (Dump.verbose) {
            System.out.println("deferredList = " + Jvm.hex(n7));
        }
        this.heapbase = this.mh_heapbase;
        this.heaplimit = this.mh_heaplimit;
        this.foundJvmPointer = true;
        int n8 = this.space.readInt(this.stglobal + 168);
        if (Dump.verbose) {
            System.out.println("gcctr = " + Jvm.hex(n8));
        }
        int n9 = this.space.readInt(this.stglobal + 172);
        if (Dump.verbose) {
            System.out.println("last_compactgc = " + Jvm.hex(n9));
        }
        int n10 = this.space.readInt(this.stglobal + 176);
        if (Dump.verbose) {
            System.out.println("last_icompactgc = " + Jvm.hex(n10));
        }
        int n11 = this.space.readInt(this.stglobal + 180);
        if (Dump.verbose) {
            System.out.println("last_fullgc = " + Jvm.hex(n11));
        }
        int n12 = this.space.readInt(this.stglobal + 184);
        if (Dump.verbose) {
            System.out.println("onlineCPUs = " + Jvm.hex(n12));
        }
        int n13 = this.space.readInt(this.stglobal + 188);
        if (Dump.verbose) {
            System.out.println("maxedOutTLHs = " + Jvm.hex(n13));
        }
        int n14 = this.space.readInt(this.stglobal + 192);
        if (Dump.verbose) {
            System.out.println("maxTLHSize = " + Jvm.hex(n14));
        }
        int n15 = this.space.readInt(this.stglobal + 960);
        if (Dump.verbose) {
            System.out.println("num_hints = " + Jvm.hex(n15));
        }
        int n16 = this.space.readInt(this.stglobal + 964);
        if (Dump.verbose) {
            System.out.println("hint_first = " + Jvm.hex(n16));
        }
        int n17 = this.space.readInt(this.stglobal + 968);
        if (Dump.verbose) {
            System.out.println("hint_free = " + Jvm.hex(n17));
        }
        int n18 = n17;
        while (n18 != 0) {
            int n19 = this.space.readInt(n18);
            int n20 = this.space.readInt(n18 + 4);
            int n21 = this.space.readInt(n18 + 8);
            if (Dump.verbose) {
                System.out.println("hint chunk: " + Jvm.hex(n20) + " len: " + Jvm.hex(n19) + " lru: " + Jvm.hex(n21));
            }
            n18 = this.space.readInt(n18 + 8);
        }
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }
}

