/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.svcdump;

import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.svcdump.AddressSpace;
import com.ibm.jvm.dump.svcdump.Dsa;
import com.ibm.jvm.dump.svcdump.Jvm;
import com.ibm.jvm.dump.svcdump.Tcb;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class Dump
extends DvDump {
    RandomAccessFile raf;
    AddressSpace[] spaces = new AddressSpace[0];
    AddressSpace[] validSpaces;
    static final int HEADERSIZE = 64;
    static final int BLOCKSIZE = 4160;
    static final int DR1 = -992349888;
    static final int DR2 = -992349632;
    static int currentBlock;
    boolean old;
    static boolean verbose;
    static String dvDumpName;

    public Dump() throws Exception {
        this(dvDumpName);
    }

    public static Boolean isSupportedSource(String string) {
        DvUtils.writetoTrace(" svcdump:isSupportedSource entry with " + string);
        dvDumpName = string;
        Boolean bl = new Boolean(Dump.validFile(new File(string)));
        if (bl.booleanValue()) {
            DvUtils.writetoTrace(" Dump recognised as svc dump");
        } else {
            DvUtils.writetoTrace(" Dump not recognised as svc dump");
        }
        DvUtils.writetoTrace(" svcdump:isSupportedSource exit ");
        return bl;
    }

    public DvAddressSpace[] getAddressSpaces() {
        return this.addressSpaces();
    }

    public DvAddressSpace getCurrentAddressSpace() {
        throw new Error("unimplemented method");
    }

    public int getArchitecture() {
        return 5;
    }

    public int getSystemType() {
        return 4;
    }

    public int getSubSystemType() {
        return 11;
    }

    public int getProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorSubType() {
        throw new Error("unimplemented method");
    }

    public int getCurrentProcessor() {
        throw new Error("unimplemented method");
    }

    public int getProcessorCount() {
        throw new Error("unimplemented method");
    }

    boolean validBlock(int n) {
        if (n == -992349632) {
            this.old = false;
        } else if (n == -992349888) {
            this.old = true;
        } else {
            return false;
        }
        return true;
    }

    static boolean validFile(File file) {
        DvUtils.writetoTrace(" svcdump:validFile entry ");
        boolean bl = false;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            int n = randomAccessFile.readInt();
            randomAccessFile.close();
            if (n == -992349888 || n == -992349632) {
                if (n == -992349888) {
                    DvUtils.writetoTrace(" magic value 0x" + Integer.toHexString(n) + " recognised (DR1)");
                } else {
                    DvUtils.writetoTrace(" magic value 0x" + Integer.toHexString(n) + " recognised (DR2)");
                }
                bl = true;
            } else {
                DvUtils.writetoTrace(" magic value 0x" + Integer.toHexString(n) + " not recognised");
            }
        }
        catch (Exception exception) {
            DvUtils.writetoTrace(" svcdump:validFile exception caught");
        }
        DvUtils.writetoTrace(" svcdump:validFile exit ");
        return bl;
    }

    static int maxBlocks(File file) {
        return (int)file.length() / 4160;
    }

    static int currentBlock() {
        return currentBlock;
    }

    void scanFile() throws Exception {
        AddressSpace addressSpace = null;
        try {
            byte[] byArray = new byte[28];
            int n = 0;
            while (true) {
                currentBlock = n / 4160;
                this.seek(n);
                this.raf.readFully(byArray);
                int n2 = this.getInt(byArray, 0);
                if (!this.validBlock(n2)) {
                    System.out.println("No DR2 found at offset " + Dump.hex(n) + " instead found " + Dump.hex(n2));
                    n = n - 4160 + 2896;
                    this.seek(n);
                    this.raf.readFully(byArray);
                    n2 = this.getInt(byArray, 0);
                    if (!this.validBlock(n2)) {
                        n -= 2896;
                        this.seek(n += 4);
                        while (!this.validBlock(this.readInt())) {
                            n += 4;
                        }
                        this.seek(n);
                        this.raf.readFully(byArray);
                    }
                }
                int n3 = this.getInt(byArray, 3);
                int n4 = this.getInt(byArray, this.old ? 5 : 6);
                addressSpace = this.getAddressSpace(n3);
                addressSpace.add(n4, n);
                n += 4160;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public Dump(String string) throws Exception {
        this(string, false);
    }

    public Dump(String string, boolean bl) throws Exception {
        Object object;
        Object object2;
        verbose = bl;
        this.raf = new RandomAccessFile(string, "r");
        try {
            object2 = new FileInputStream(string + ".cache");
            object = new ObjectInputStream((InputStream)object2);
            this.spaces = (AddressSpace[])((ObjectInputStream)object).readObject();
            System.out.println("read from cache");
            ((ObjectInputStream)object).close();
        }
        catch (Exception exception) {
            object = new FileOutputStream(string + ".cache");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            this.scanFile();
            objectOutputStream.writeObject(this.spaces);
            objectOutputStream.close();
        }
        object2 = null;
        int n = 0;
        while (n < this.spaces.length) {
            this.spaces[n].dump = this;
            this.spaces[n].sort();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.spaces.length) {
            block13: {
                object2 = this.spaces[n2];
                try {
                    int n3 = ((AddressSpace)object2).readInt(548L);
                    try {
                        int n4 = ((AddressSpace)object2).readInt(n3 + 108);
                        if (((AddressSpace)object2).id == 1) {
                            if (bl) {
                                System.out.println("ascb = " + Dump.hex(n4));
                            }
                            AddressSpace.ascbasxb = n4;
                            AddressSpace.root = object2;
                        }
                    }
                    catch (Exception exception) {
                        if (bl) {
                            System.out.println("inner failed for " + ((AddressSpace)object2).hexId());
                        }
                    }
                }
                catch (Exception exception) {
                    if (!bl) break block13;
                    System.out.println("outer failed for " + ((AddressSpace)object2).hexId());
                }
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < this.spaces.length) {
            object2 = this.spaces[n5];
            if (((AddressSpace)object2).isTrace()) {
                this.processTrace((AddressSpace)object2);
            }
            ++n5;
        }
    }

    int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    void seek(int n) throws IOException {
        this.raf.seek(n);
    }

    AddressSpace getAddressSpace(int n) {
        AddressSpace addressSpace;
        int n2 = 0;
        while (n2 < this.spaces.length) {
            addressSpace = this.spaces[n2];
            if (addressSpace.id == n) {
                return addressSpace;
            }
            ++n2;
        }
        AddressSpace[] addressSpaceArray = new AddressSpace[this.spaces.length + 1];
        System.arraycopy(this.spaces, 0, addressSpaceArray, 0, this.spaces.length);
        addressSpaceArray[this.spaces.length] = addressSpace = new AddressSpace(this, n);
        this.spaces = addressSpaceArray;
        return addressSpace;
    }

    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    public int[] readBlock() throws IOException {
        int[] nArray = new int[1024];
        byte[] byArray = new byte[4096];
        this.raf.readFully(byArray);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getInt(byArray, n);
            ++n;
        }
        return nArray;
    }

    static String hex(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        while (n2 < 8) {
            string = "0" + string;
            ++n2;
        }
        return string;
    }

    static byte fix(int n) {
        int n2 = n & 0xFF;
        if (n2 < 64 || n2 > 64 && n2 < 75 || n2 > 80 && n2 < 90 || n2 > 97 && n2 < 106 || n2 > 111 && n2 < 121 || n2 > 169 && n2 < 188 || n2 > 249) {
            n2 = 64;
        }
        byte by = (byte)n2;
        return by;
    }

    public static String ebcdic(int n) {
        byte[] byArray = new byte[]{Dump.fix(n >> 24), Dump.fix(n >> 16), Dump.fix(n >> 8), Dump.fix(n >> 0)};
        String string = null;
        try {
            string = new String(byArray, "Cp500");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public final boolean isEbcdic(short s) {
        return (s = (short)(s | 0x40)) >= 193 && s <= 201 || s >= 209 && s <= 217 || s >= 162 && s <= 169 || s >= 240 && s <= 249;
    }

    public final boolean isEbcdic(int n) {
        short s = (short)(n & 0xFF);
        short s2 = (short)(n >> 8 & 0xFF);
        short s3 = (short)(n >> 16 & 0xFF);
        short s4 = (short)(n >> 24 & 0xFF);
        return this.isEbcdic(s) && this.isEbcdic(s2) && this.isEbcdic(s3) && this.isEbcdic(s4);
    }

    public AddressSpace[] addressSpaces() {
        if (this.validSpaces != null) {
            return this.validSpaces;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            if (tcbArray != null) {
                vector.add(addressSpace);
            }
            ++n;
        }
        this.validSpaces = (AddressSpace[])vector.toArray(new AddressSpace[1]);
        Arrays.sort(this.validSpaces, new Comparator(){

            public int compare(Object object, Object object2) {
                AddressSpace addressSpace = (AddressSpace)object;
                AddressSpace addressSpace2 = (AddressSpace)object2;
                return addressSpace2.tcbs().length - addressSpace.tcbs().length;
            }
        });
        return this.validSpaces;
    }

    /*
     * Unable to fully structure code
     */
    public void processTrace(AddressSpace var1_1) throws Exception {
        if (Dump.verbose) {
            System.out.println("found trace in asid " + var1_1.hexId());
        }
        var2_2 = var1_1.addresses.get(0);
        var3_3 = var1_1.readShort(var2_2 + 28);
        var4_4 = null;
        var5_5 = 0;
        while (var5_5 < var3_3) {
            if (Dump.verbose) {
                System.out.println("*** processor " + var5_5 + " trace table ***");
            }
            var6_6 = var2_2 + 56 + var5_5 * 8;
            var7_7 = var1_1.readShort(var6_6);
            var8_8 = var1_1.readInt(var6_6 + 4);
            var9_9 = 0;
            var10_10 = 0;
            while (var10_10 < var7_7) {
                var11_11 = var1_1.readShort(var8_8 + var10_10 * 40 + 8);
                if (Dump.verbose) {
                    System.out.println("*** doing buffer section " + var10_10 + " flags " + Dump.hex(var11_11));
                }
                var12_12 = var1_1.readInt(var8_8 + var10_10 * 40);
                var13_13 = var1_1.readInt(var8_8 + var10_10 * 40 + 4);
                var14_14 = 0;
                var15_15 = var12_12;
                while (var15_15 < var12_12 + var13_13) {
                    block43: {
                        block44: {
                            block42: {
                                var16_16 = var1_1.readUnsignedByte(var15_15);
                                if (var16_16 >= 112) break block42;
                                switch (var16_16) {
                                    case 33: {
                                        var14_14 = 8;
                                        break;
                                    }
                                    case 50: {
                                        var14_14 = 12;
                                        break;
                                    }
                                    case 49: {
                                        var14_14 = 8;
                                        break;
                                    }
                                    case 16: {
                                        var14_14 = 4;
                                        break;
                                    }
                                    default: {
                                        if (var16_16 != 0 && Dump.verbose) {
                                            System.out.println("!!! unknown id " + Dump.hex(var16_16));
                                        }
                                        var14_14 = 4;
                                        break;
                                    }
                                }
                                break block43;
                            }
                            if (var16_16 < 128) break block44;
                            var17_17 = var1_1.readInt(var15_15);
                            var14_14 = 4;
                            if (var4_4 != null) {
                                if (Dump.verbose) {
                                    System.out.println("found branch " + Dump.hex(var17_17) + " in asid " + var4_4.hexId());
                                }
                                var4_4.addTraceEntry(0, var17_17, var9_9);
                            }
                            break block43;
                        }
                        var17_17 = var1_1.readShort(var15_15 + 10);
                        var9_9 = var1_1.readInt(var15_15 + 12);
                        var18_18 = var1_1.readShort(var15_15 + 18);
                        var19_19 = var1_1.readInt(var15_15 + 28);
                        var14_14 = 16 + (var16_16 & 15) * 4;
                        var20_20 = "unknown";
                        switch (var17_17) {
                            case 1: {
                                var20_20 = "SSCH";
                                var19_19 = var1_1.readInt(var15_15 + 24);
                                break;
                            }
                            case 3: {
                                var20_20 = "EXT";
                                break;
                            }
                            case 5: {
                                var20_20 = "SVC";
                                var19_19 = var1_1.readInt(var15_15 + 24);
                                break;
                            }
                            case 7: {
                                var20_20 = "PGM";
                                break;
                            }
                            case 11: {
                                var20_20 = "I/O";
                                break;
                            }
                            case 15: {
                                var20_20 = "DSP";
                                break;
                            }
                            case 25: {
                                var20_20 = "SUSP";
                                break;
                            }
                            case 127: {
                                var20_20 = "USR";
                                var19_19 = var1_1.readInt(var15_15 + 24);
                                break;
                            }
                            case 259: {
                                var20_20 = "EMS";
                                break;
                            }
                            case 261: {
                                var20_20 = "SVCR";
                                var19_19 = var1_1.readInt(var15_15 + 24);
                                break;
                            }
                            case 271: {
                                var20_20 = "SRB";
                                var19_19 = var1_1.readInt(var15_15 + 24);
                                break;
                            }
                            case 517: {
                                var20_20 = "SSRV";
                                var19_19 = var1_1.readInt(var15_15 + 20);
                                break;
                            }
                            case 527: {
                                var20_20 = "SSRB";
                                break;
                            }
                            case 771: {
                                var20_20 = "CALL";
                                break;
                            }
                            case 1025: {
                                var20_20 = "RSCH";
                                var19_19 = var1_1.readInt(var15_15 + 24);
                                break;
                            }
                            case 1027: {
                                var20_20 = "CLKC";
                                break;
                            }
                            case 3855: {
                                var20_20 = "WAIT";
                                var19_19 = var1_1.readInt(var15_15 + 20);
                                break block43;
                            }
                            default: {
                                if (Dump.verbose) {
                                    System.out.println("unknown type " + Dump.hex(var17_17) + " id " + Dump.hex(var16_16));
                                }
                                break block43;
                            }
                        }
                        if (Dump.verbose) {
                            System.out.println("found " + var20_20 + ", tcb = " + Dump.hex(var9_9) + " asid = " + Dump.hex(var18_18) + " psw = " + Dump.hex(var19_19));
                        }
                        if (var19_19 != 0 && (var19_19 & 1) == 1 && Dump.verbose) {
                            System.out.println("found dodgy " + var20_20 + ", tcb = " + Dump.hex(var9_9) + " asid = " + Dump.hex(var18_18) + " psw = " + Dump.hex(var19_19));
                        }
                        if (var4_4 != null && var4_4.id == var18_18) ** GOTO lbl-1000
                        var21_21 = 0;
                        while (var21_21 < this.spaces.length) {
                            var22_22 = this.spaces[var21_21];
                            if (var22_22.id == var18_18) {
                                var4_4 = var22_22;
                                break;
                            }
                            ++var21_21;
                        }
                        if (var21_21 == this.spaces.length) {
                            var4_4 = null;
                            if (Dump.verbose) {
                                System.out.println("Warning: could not locate asid " + Dump.hex(var18_18));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            var4_4.addTraceEntry(var17_17, var19_19, var9_9);
                        }
                    }
                    var15_15 += var14_14;
                }
                ++var10_10;
            }
            ++var5_5;
        }
    }

    public Jvm jvm() {
        int n = 0;
        while (n < this.spaces.length) {
            AddressSpace addressSpace = this.spaces[n];
            Tcb[] tcbArray = addressSpace.tcbs();
            int n2 = 0;
            while (n2 < tcbArray.length) {
                Tcb tcb = tcbArray[n2];
                if (tcb.isKnownType()) {
                    Dsa dsa = tcb.topDsa;
                    while (dsa != null) {
                        dsa.function(false);
                        dsa = dsa.previous();
                    }
                }
                ++n2;
            }
            if (addressSpace.jvm != null) {
                return addressSpace.jvm;
            }
            ++n;
        }
        return null;
    }

    static {
        verbose = false;
    }
}

