/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.svcdump;

import com.ibm.jvm.dump.svcdump.AddressSpace;
import com.ibm.jvm.dump.svcdump.Dump;
import com.ibm.jvm.dump.svcdump.Tcb;
import java.util.Hashtable;

public class Dsa {
    int address;
    Dsa previous;
    AddressSpace space;
    Tcb tcb;
    int[] registers = new int[16];
    String function;
    static int micb = 0;
    boolean foundPrevious;
    int prevCount = -1;
    boolean foundPrevCount;
    boolean is118;
    static String[] knownFunctions = new String[]{"CEEOPEF", "pthread exit forced", "CEEHSGL", "raise a condition", "CEEOSIGG", "deliver signal", "CEEOPCT", "pthread_cond_timedwait", "CEEOPML2", "pthread_mutex_lock", "CEEOPMU2", "pthread_mutex_unlock", "CEEPMDEL", "delete a load module", "CEEVGSTR", "get main storage", "CEEOPGS", "pthread_getspecific", "CEECZLOD", "process level load under CICS", "CEEPVDEL", "delete a module", "CEEVGQP", "get heap pool storage", "CEEOPCS", "pthread_cond_signal", "CEEOPMI", "pthread_mutex_init", "CEEPVLOD", "load module", "CEEVFQP", "free heap pool storage", "CEEVSTLO", "get heap latch", "CEEVCZST", "realloc", "CEEHDSP", "exception dispatcher", "CEEOPMD", "pthread_mutex_destroy", "CEEHHDLR", "register user condition handler", "CEEVGTST", "get heap storage", "CEEVGTSI", "extend stack", "CEEVFSTR", "free main storage", "CEEPTLC", "load dll", "CEEBTERM", "batch termination", "CEEM@MOU", "output MVS message", "CEEV#GTS", "get heap storage", "CEEOGLAT", "get contended latch", "CEEORLAT", "release contended latch", "CEEBBEXT", "bootstrap routine", "CEEOTERM", "posix termination", "CEEZRET", "thread termination", "EDCZMINV", "main invocation event handler", "CEEHSFXS", "stack frame exit schedule", "mmipSelectInvokeJavaMethod", "java", "mmipSelectInvokeSynchronizedJavaMethod", "java", "mmipInvokeJavaMethod", "java", "mmipInvokeSynchronizedJavaMethod", "java"};
    static Hashtable knownFunctionsTable = new Hashtable();

    public int stackPointer() {
        return this.address;
    }

    Dsa(Tcb tcb, int n) throws Exception {
        this.tcb = tcb;
        this.space = tcb.space;
        this.address = n;
        this.registers[14] = this.space.readInt(n + 12);
        this.registers[15] = this.space.readInt(n + 16);
        int n2 = 0;
        while (n2 < 14) {
            this.registers[n2] = this.space.readInt(n + 20 + n2 * 4);
            ++n2;
        }
    }

    public Dsa previous() {
        if (!this.foundPrevious) {
            this.foundPrevious = true;
            try {
                int n = this.space.readInt(this.address + 4);
                if (n != 0) {
                    this.previous = new Dsa(this.tcb, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.previous;
    }

    public static String function(AddressSpace addressSpace, int n) throws Exception {
        int n2;
        String string = null;
        int n3 = addressSpace.readInt(n + 4);
        if (n3 == 0xC3C5C5 || n3 == 29607365) {
            n2 = n + addressSpace.readInt(n + 12);
            int n4 = addressSpace.readUnsignedByte(n2);
            if (n3 == 29607365) {
                n4 <<= 1;
            }
            string = Dsa.readFunctionName(addressSpace, n2, n4);
        } else if ((n3 & 0xFF0000) == 0xCE0000) {
            n2 = n;
            int n5 = n3 >>> 24;
            string = Dsa.readFunctionName(addressSpace, n2, n5);
        } else if ((addressSpace.readInt(n) & 0xFFFFF000) == 1206972416) {
            n2 = addressSpace.readUnsignedByte(n + 4);
            byte[] byArray = new byte[n2];
            int n6 = 0;
            while (n6 < n2) {
                byArray[n6] = (byte)addressSpace.readUnsignedByte(n + 5 + n6);
                ++n6;
            }
            string = new String(byArray, "Cp500");
        } else {
            string = "(unknown)";
        }
        String string2 = (String)knownFunctionsTable.get(string);
        if (string2 != null && !string2.equals("java")) {
            string = string + "    (" + string2 + ")";
        }
        return string;
    }

    public String function(boolean bl) {
        if (this.function != null) {
            return this.function;
        }
        int n = this.entryPoint();
        if (n == 0) {
            this.function = "(unknown)";
            return this.function;
        }
        try {
            this.function = Dsa.function(this.space, n);
            if (bl) {
                int n2 = this.previous().registers[1];
                this.function = this.function + "(";
                int n3 = 0;
                while (n3 < 4) {
                    try {
                        int n4 = this.space.readInt(n2 + (n3 << 2));
                        this.function = this.function + Dsa.hex(n4);
                    }
                    catch (Exception exception) {
                        this.function = this.function + "?";
                    }
                    this.function = n3 == 3 ? this.function + ") " : this.function + ", ";
                    ++n3;
                }
            }
            this.appendJavaInfo();
            if (Dump.verbose) {
                this.function = this.function + " (ep = " + Dsa.hex(n) + ")";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.function;
    }

    public static Dsa findTop(Tcb tcb, int n) throws Exception {
        int n2 = n;
        try {
            int n3;
            while (tcb.space.readInt((n3 = tcb.space.readInt(n2 + 76)) + 4) == n2) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Dsa(tcb, n2);
    }

    public static Dsa findStack(Tcb tcb, int n) {
        Dsa dsa = null;
        int n2 = n;
        while (n2 > n - 4096) {
            try {
                int n3 = tcb.space.readInt(n2 + 76);
                if (tcb.space.readInt(n3 + 4) == n2) {
                    Dsa dsa2 = Dsa.findTop(tcb, n2);
                    if (dsa == null || dsa.prevCount() < dsa2.prevCount()) {
                        dsa = dsa2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 -= 4;
        }
        return dsa;
    }

    public int prevCount() {
        if (!this.foundPrevCount) {
            this.foundPrevCount = true;
            Dsa dsa = this;
            while (dsa != null) {
                ++this.prevCount;
                dsa = dsa.previous();
            }
        }
        return this.prevCount;
    }

    void appendJavaInfo() throws Exception {
        if (this.function.startsWith("mmipInvoke") || this.function.startsWith("mmisInvoke") || this.function.startsWith("mmipSelectInvoke") || this.function.equals("EXECJAVA")) {
            this.function = this.function + "  (" + this.cbName(false) + "." + this.mbName(false) + ")";
        } else if (this.function.equals("mmipExecuteJava")) {
            this.function = this.function + "  (" + this.cbName(true) + "." + this.mbName(true) + ")";
        } else if (this.function.equals("sysMonitorWait")) {
            int n = this.previous().registers[1];
            int n2 = this.space.readInt(n + 4);
            int n3 = this.space.readInt(n2);
            this.function = this.function + "(owner = " + Dsa.hex(n3) + ")";
        }
    }

    public static String readFunctionName(AddressSpace addressSpace, int n, int n2) throws Exception {
        int n3 = addressSpace.readShort(n + n2);
        if (n3 > 500) {
            throw new Exception("Impossibly long name: " + n3);
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = (byte)addressSpace.readUnsignedByte(n + n2 + 2 + n4);
            ++n4;
        }
        return new String(byArray, "Cp500");
    }

    String mbName(boolean bl) {
        String string = "";
        try {
            int n;
            int n2;
            int n3 = 0;
            if (bl) {
                n2 = this.previous().registers[1];
                int n4 = this.space.readInt(n2);
                n = this.space.readInt(n4 + 8);
                int n5 = this.space.readInt(n + 0);
                n3 = this.space.readInt(n5 + 4);
            } else {
                n3 = this.previous().registers[6];
            }
            n2 = this.space.readInt(n3 + 8);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = this.space.readUnsignedByte(n2++)) != 0) {
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    String cbName(boolean bl) {
        String string = "";
        try {
            int n;
            int n2 = 0;
            if (bl) {
                n = this.previous().registers[1];
                int n3 = this.space.readInt(n);
                int n4 = this.space.readInt(n3 + 8);
                int n5 = this.space.readInt(n4 + 0);
                n2 = this.space.readInt(n5 + 4);
            } else {
                n2 = this.previous().registers[6];
            }
            n = this.space.readInt(n2);
            this.space.createJvm();
            string = this.space.jvm.cbName(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public int entryPoint() {
        if (this.previous() == null) {
            return 0;
        }
        if (this.previous().address == this.tcb.failingDsa()) {
            try {
                int n = this.space.readInt(this.previous().address + 76);
                int n2 = this.space.readInt(n + 16);
                return n2 & Integer.MAX_VALUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.previous().registers[15] & Integer.MAX_VALUE;
    }

    public int address() {
        return this.address;
    }

    public int returnAddress() {
        return this.registers[14] & Integer.MAX_VALUE;
    }

    public int offset() {
        int n;
        if (this.address == this.tcb.failingDsa() && (n = this.tcb.failingPsw()) != 0) {
            return n - this.entryPoint();
        }
        return this.returnAddress() - this.entryPoint() - 2;
    }

    public int reg(int n) {
        return this.registers[n];
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static {
        int n = 0;
        while (n < knownFunctions.length) {
            knownFunctionsTable.put(knownFunctions[n], knownFunctions[n + 1]);
            n += 2;
        }
    }
}

