/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.svcdump;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.svcdump.Address;
import com.ibm.jvm.dump.svcdump.Dsa;
import com.ibm.jvm.dump.svcdump.Dump;
import com.ibm.jvm.dump.svcdump.Function;
import com.ibm.jvm.dump.svcdump.Jvm;
import com.ibm.jvm.dump.svcdump.MemRange;
import com.ibm.jvm.dump.svcdump.Process;
import com.ibm.jvm.dump.svcdump.Tcb;
import com.ibm.jvm.io.RandomAccessStream;
import com.ibm.jvm.util.IntegerArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;

public class AddressSpace
extends DvAddressSpace
implements Serializable,
RandomAccessStream {
    static int ascbasxb;
    static AddressSpace root;
    IntegerArray addresses = new IntegerArray();
    IntegerArray blocks = new IntegerArray();
    int id;
    Dump dump;
    Hashtable traceTable = new Hashtable();
    Function[] traceFunctions;
    Tcb[] tcbs;
    Tcb lastTcb;
    WeakHashMap blockTable = new WeakHashMap();
    HashMap tcbMap = new HashMap();
    Jvm jvm;
    int currentOffset;
    int firsttcb = 0;
    int lastAddress;
    BitSet pages = new BitSet();
    MemRange[] memRanges;
    Process[] processes;
    static int cacheMisses;

    public DvMemRanges[] getMemRanges() {
        return this.memRanges;
    }

    public DvProcess[] getProcesses() {
        if (this.processes == null) {
            this.processes = new Process[1];
            this.processes[0] = new Process(this);
        }
        return this.processes;
    }

    public DvProcess getCurrentProcess() {
        throw new Error("unimplemented method");
    }

    public DvAddress createAddress(long l) {
        Address address = new Address((int)l);
        return address;
    }

    public byte[] readBytes(DvAddress dvAddress, long l) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            try {
                byArray[n2] = this.readByte(n + n2);
            }
            catch (IOException iOException) {
                if (n2 == 0) {
                    throw new DvAddressException("Could not read: " + AddressSpace.hex(n + n2));
                }
                n2 = (int)l;
            }
            ++n2;
        }
        return byArray;
    }

    public byte readByte(DvAddress dvAddress) throws DvAddressException {
        byte by;
        int n = (int)dvAddress.getAddressAsLong();
        try {
            by = this.readByte(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
        return by;
    }

    public short readShort(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            return (short)this.readShort(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public int readInt(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            return this.readInt(n);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public long readLong(DvAddress dvAddress) throws DvAddressException {
        int n = (int)dvAddress.getAddressAsLong();
        try {
            long l = this.readInt(n);
            long l2 = this.readInt(n + 4);
            return l << 32 | l2;
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n));
        }
    }

    public String id() {
        return "" + this.id;
    }

    public DvAddress readPointer(DvAddress dvAddress) throws DvAddressException {
        int n;
        int n2 = (int)dvAddress.getAddressAsLong();
        try {
            n = this.readInt(n2);
        }
        catch (IOException iOException) {
            throw new DvAddressException("Could not read: " + AddressSpace.hex(n2));
        }
        Address address = new Address(n);
        return address;
    }

    public void createJvm() {
        if (this.jvm == null) {
            this.jvm = new Jvm(this);
        }
    }

    public Jvm getJvm() {
        return this.jvm;
    }

    public boolean isJava() {
        this.tcbs();
        return this.jvm != null;
    }

    public void mapTid(int n, Tcb tcb) {
        this.tcbMap.put(new Integer(n), tcb);
    }

    public int zeroBlocks() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.addresses.size()) {
            if (this.addresses.get(n2) != 0) break;
            ++n;
            ++n2;
        }
        return n;
    }

    public void addTraceEntry(int n, int n2, int n3) {
        Integer n4;
        Integer n5 = (Integer)this.traceTable.get(n4 = new Integer(n2));
        this.traceTable.put(n4, new Integer(n5 == null ? 1 : n5 + 1));
        if (this.lastTcb != null && this.lastTcb.tcbid == n3) {
            this.lastTcb.addTraceEntry(n, n2);
        } else if (this.tcbs() != null && n3 != 0) {
            int n6 = 0;
            while (n6 < this.tcbs.length) {
                this.lastTcb = this.tcbs[n6];
                if (this.lastTcb.tcbid == n3) {
                    this.lastTcb.addTraceEntry(n, n2);
                    break;
                }
                ++n6;
            }
        }
    }

    public Function[] traceFunctions(Hashtable hashtable) {
        Object[] objectArray;
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            objectArray = (Object[])enumeration.nextElement();
            String string = "unknown function";
            int n2 = objectArray.intValue();
            int n3 = 0;
            int n4 = (n2 &= 0x7FFFFFFC) + 4;
            while (n3 < 4096) {
                block10: {
                    try {
                        n = this.readInt(n4);
                        if (n == 0xC3C5C5 || n == 29607365) {
                            try {
                                string = Dsa.function(this, n4 - 4);
                                break;
                            }
                            catch (Exception exception) {
                                if (!Dump.verbose) break;
                                System.out.println("problem creating function at " + AddressSpace.hex(n4));
                            }
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        if (!Dump.verbose) break;
                        System.out.println("problem reading " + AddressSpace.hex(n4));
                    }
                    break;
                }
                n4 -= 4;
                ++n3;
            }
            if (Dump.verbose) {
                System.out.println("address " + AddressSpace.hex(objectArray.intValue()) + " maps to " + string);
            }
            n = (Integer)hashtable.get(objectArray);
            Function function = (Function)hashtable2.get(string);
            if (function == null) {
                function = new Function(string, n);
            } else {
                function.addCount(n);
            }
            hashtable2.put(string, function);
        }
        objectArray = (Function[])hashtable2.values().toArray(new Function[0]);
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Function function = (Function)object;
                Function function2 = (Function)object2;
                return function2.entryCount - function.entryCount;
            }
        });
        return objectArray;
    }

    public Function[] traceFunctions() {
        if (this.traceFunctions == null) {
            this.traceFunctions = this.traceFunctions(this.traceTable);
        }
        return this.traceFunctions;
    }

    public boolean isTrace() {
        try {
            int n = this.addresses.get(0);
            int n2 = this.readInt(n);
            return n2 == -471612472;
        }
        catch (Exception exception) {
            return false;
        }
    }

    AddressSpace(Dump dump, int n) {
        this.dump = dump;
        this.id = n;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    String hexId() {
        return Integer.toHexString(this.id);
    }

    public String toString() {
        return this.hexId();
    }

    public boolean validTCB(int n, boolean bl) {
        try {
            int n2 = this.readInt(n + 256);
            if (n2 == -473710016) {
                return true;
            }
            if (!bl && Dump.verbose) {
                System.out.println("bad eyecatcher: " + AddressSpace.hex(n2));
            }
            return false;
        }
        catch (Exception exception) {
            if (!bl && Dump.verbose) {
                System.out.println("could not read " + AddressSpace.hex(n + 256));
            }
            return false;
        }
    }

    public int nextTcb(int n) throws Exception {
        return this.readInt(n + 116);
    }

    public int prevTcb(int n) throws Exception {
        return this.readInt(n + 220);
    }

    public int validTCBs() {
        int n = 0;
        int n2 = 0;
        try {
            this.firsttcb = this.readInt(ascbasxb + 4);
        }
        catch (Exception exception) {
            if (Dump.verbose) {
                System.out.println("asid " + this.hexId() + ": could not read first tcb at " + (ascbasxb + 4));
            }
            return 0;
        }
        try {
            n2 = this.readInt(ascbasxb + 8);
        }
        catch (Exception exception) {
            if (Dump.verbose) {
                System.out.println("asid " + this.hexId() + ": could not read last tcb at " + (ascbasxb + 8));
            }
            return 0;
        }
        if (this.firsttcb == n2) {
            if (Dump.verbose) {
                System.out.println("first and last tcb the same! " + AddressSpace.hex(this.firsttcb));
            }
            try {
                this.firsttcb = root.readInt(ascbasxb + 4);
                n2 = root.readInt(ascbasxb + 8);
            }
            catch (Exception exception) {
                if (Dump.verbose) {
                    System.out.println("nice try");
                }
                return 0;
            }
            if (this.firsttcb == n2) {
                if (Dump.verbose) {
                    System.out.println("first and last tcb STILL the same! " + AddressSpace.hex(this.firsttcb));
                }
                return 0;
            }
        }
        try {
            int n3 = this.firsttcb;
            while (n3 != 0) {
                if (Dump.verbose) {
                    System.out.println("asid " + this.hexId() + ": process tcb at " + AddressSpace.hex(n3));
                }
                if (!this.validTCB(n3, false)) {
                    if (Dump.verbose) {
                        System.out.println("asid " + this.hexId() + ": invalid tcb at " + AddressSpace.hex(n3));
                    }
                    return 0;
                }
                ++n;
                if (n3 == n2) break;
                n3 = this.nextTcb(n3);
            }
            if (Dump.verbose) {
                System.out.println("asid " + this.hexId() + ": processed all tcbs from " + AddressSpace.hex(this.firsttcb) + " to " + AddressSpace.hex(n2));
            }
            return n;
        }
        catch (Exception exception) {
            if (Dump.verbose) {
                System.out.println("asid " + this.hexId() + ": error processing a tcb");
            }
            return 0;
        }
    }

    void lastDitch() {
        try {
            int n = this.readInt(ascbasxb + 4);
            int n2 = (n &= 0xFFF00000) + 0x100000;
            Vector vector = new Vector();
            while (n < n2) {
                if (this.validTCB(n, true)) {
                    vector.add(new Tcb(this, n));
                }
                n += 4;
            }
            this.tcbs = (Tcb[])vector.toArray(new Tcb[0]);
        }
        catch (Exception exception) {
            if (Dump.verbose) {
                System.out.println("could not recover tcbs");
            }
            this.tcbs = new Tcb[0];
        }
    }

    void addTcb(Tcb tcb) {
        Tcb[] tcbArray = new Tcb[this.tcbs.length + 1];
        System.arraycopy(this.tcbs, 0, tcbArray, 0, this.tcbs.length);
        tcbArray[this.tcbs.length] = tcb;
        this.tcbs = tcbArray;
    }

    public Tcb[] tcbs() {
        int n;
        if (this.tcbs != null) {
            return this.tcbs;
        }
        int n2 = this.validTCBs();
        if (n2 != 0) {
            try {
                this.tcbs = new Tcb[n2];
                n = this.firsttcb;
                int n3 = 0;
                while (n3 < n2) {
                    this.tcbs[n3] = new Tcb(this, n);
                    n = this.nextTcb(n);
                    ++n3;
                }
            }
            catch (Exception exception) {
                if (Dump.verbose) {
                    System.out.println("in asid " + this.hexId() + " problem creating tcbs:");
                    exception.printStackTrace(System.out);
                }
                return null;
            }
        } else {
            if (Dump.verbose) {
                System.out.println("in asid " + this.hexId() + " corrupt tcb chain...");
            }
            this.lastDitch();
        }
        if (this.tcbs == null) {
            return null;
        }
        n = 0;
        while (n < this.tcbs.length) {
            int n4;
            Tcb tcb = this.tcbs[n];
            if (!tcb.scannedTid && (n4 = tcb.tid()) != 0) {
                try {
                    n4 = this.readInt(n4);
                    while (n4 != 0) {
                        Tcb tcb2 = (Tcb)this.tcbMap.get(new Integer(n4));
                        if (tcb2 == null) {
                            tcb2 = new Tcb(this, 0, n4);
                            this.mapTid(n4, tcb2);
                            if (tcb2.isKnownType()) {
                                this.addTcb(tcb2);
                            }
                        } else if (tcb2.scannedTid) break;
                        tcb2.scannedTid = true;
                        n4 = this.readInt(n4);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        return this.tcbs;
    }

    public void add(int n, int n2) {
        if ((n & 0xFFF) != 0) {
            throw new Error("address " + AddressSpace.hex(n) + " is not page aligned!");
        }
        int n3 = n >> 12;
        if (this.pages.get(n3)) {
            if (Dump.verbose) {
                System.out.println("duplicate address " + AddressSpace.hex(n) + " for asid " + this.hexId());
            }
            return;
        }
        this.pages.set(n3);
        this.addresses.add(n);
        this.blocks.add(n2);
    }

    public void sort() {
        int n;
        this.addresses.sort(this.blocks);
        Vector vector = new Vector();
        int n2 = n = this.addresses.get(0);
        int n3 = 1;
        while (n3 < this.addresses.size()) {
            int n4 = this.addresses.get(n3);
            if (n4 != n2 + 4096) {
                int n5 = n2 + 4096 - n;
                MemRange memRange = new MemRange(n, n5);
                vector.addElement(memRange);
                n = n4;
            }
            n2 = n4;
            ++n3;
        }
        this.memRanges = (MemRange[])vector.toArray(new MemRange[0]);
    }

    public final void seek(long l) throws IOException {
        this.currentOffset = (int)l;
    }

    public final int readInt(long l) throws IOException {
        int n;
        int n2 = (int)l;
        int n3 = n2 & 0xFFFFF000;
        int n4 = this.addresses.indexOf(n3);
        if (n4 == -1) {
            throw new IOException("cannot read " + Integer.toHexString(n2));
        }
        int[] nArray = (int[])this.blockTable.get(new Integer(n4));
        if (nArray == null) {
            n = this.blocks.get(n4);
            this.dump.seek(n + 64);
            nArray = this.dump.readBlock();
            this.blockTable.put(new Integer(n4), nArray);
            ++cacheMisses;
        }
        n = (n2 & 0xFFF) >> 2;
        int n5 = 0;
        switch (n2 & 3) {
            case 0: {
                n5 = nArray[n];
                break;
            }
            case 1: {
                n5 = nArray[n] << 8 | this.readInt((n2 & 0xFFFFFFFC) + 4) >>> 24;
                break;
            }
            case 2: {
                n5 = nArray[n] << 16 | this.readInt((n2 & 0xFFFFFFFC) + 4) >>> 16;
                break;
            }
            case 3: {
                n5 = nArray[n] << 24 | this.readInt((n2 & 0xFFFFFFFC) + 4) >>> 8;
            }
        }
        return n5;
    }

    public final int readInt() throws IOException {
        int n = this.readInt(this.currentOffset);
        this.currentOffset += 4;
        return n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.readInt(this.currentOffset) >>> 24;
        ++this.currentOffset;
        return n;
    }

    public final int readUnsignedByte(long l) throws IOException {
        return this.readInt(l) >>> 24;
    }

    public final byte readByte(long l) throws IOException {
        return (byte)this.readUnsignedByte(l);
    }

    public final byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public int readShort(int n) throws IOException {
        return this.readInt(n) >>> 16;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.id);
        objectOutputStream.writeObject(this.addresses);
        objectOutputStream.writeObject(this.blocks);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = objectInputStream.readInt();
        this.addresses = (IntegerArray)objectInputStream.readObject();
        this.blocks = (IntegerArray)objectInputStream.readObject();
        this.traceTable = new Hashtable();
        this.blockTable = new WeakHashMap();
        this.tcbMap = new HashMap();
    }

    public int pointerSize() {
        return 4;
    }
}

