/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.LittleEnd;
import com.ibm.jvm.dump.sdff.SDFFAddressSpace;
import com.ibm.jvm.dump.sdff.SDFFRas;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import com.ibm.jvm.dump.sdff.SdffStd;
import com.ibm.jvm.dump.sdff.WordLength;
import com.ibm.jvm.dump.sdff.WordType;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class SDFFDump
extends DvDump {
    public static RandomAccessFile theRAF;
    public static long prthOffset;
    public static long prthLength;
    public static long mmapOffset;
    public static long mmapLength;
    public static long memOffset;
    public static long memLength;
    public static long rasOffset;
    public static long rasLength;
    public static long sizeOfFile;
    public static String nameOfFile;
    public Vector as_offsets = new Vector();
    public SDFFAddressSpace[] theASArray;
    public SDFFRas ras;
    public static int system;
    public static int architecture;
    public static int subsystem;
    public static int processor;
    public static int processorSubtype;
    public static int numProcessors;
    public static int currentProcessor;

    public DvRas getRas() {
        if (this.ras == null) {
            if (rasOffset == -1L) {
                return null;
            }
            this.ras = SDFFRas.loadFromFile(rasOffset, rasLength, theRAF);
        }
        return this.ras;
    }

    public byte[] getCTypedefs() {
        if (this.ras == null) {
            this.getRas();
        }
        if (this.ras == null) {
            return null;
        }
        if (this.theASArray == null || this.theASArray.length == 0) {
            return null;
        }
        return this.theASArray[0].readBytes(new DvAddress(this.ras.typedefs), this.ras.typedefsLen);
    }

    public DvAddressSpace[] getAddressSpaces() {
        if (null == this.theASArray) {
            if (prthOffset == -1L) {
                return null;
            }
            int n = SDFFAddressSpace.countThem(prthOffset, theRAF);
            if (0 == n) {
                return null;
            }
            this.theASArray = new SDFFAddressSpace[n];
            int n2 = 0;
            while (n2 < n) {
                this.theASArray = SDFFAddressSpace.loadFromFile(prthOffset, prthLength, mmapOffset, mmapLength, theRAF);
                ++n2;
            }
        }
        return this.theASArray;
    }

    public int getArchitecture() {
        return architecture;
    }

    public void setArchitecture(WordLength wordLength, WordType wordType) {
        architecture = 0;
        if (wordLength.size == 4) {
            ++architecture;
        } else if (wordLength.size == 8) {
            architecture += 2;
        }
        architecture = wordType instanceof LittleEnd ? (architecture += 8) : (architecture += 4);
    }

    public int getSystemType() {
        return system;
    }

    public int getSubSystemType() {
        return subsystem;
    }

    public int getProcessor() {
        return -1;
    }

    public static Boolean isSupportedSource(String string) {
        SdffStd sdffStd;
        DvUtils.trace("Entry to SDFFDump:isSupportedSource(" + string + ")", 0, false);
        File file = null;
        Boolean bl = Boolean.FALSE;
        try {
            file = new File(string);
            theRAF = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[32];
            theRAF.read(byArray, 0, 32);
            sdffStd = new SdffStd(byArray);
            String string2 = new String(sdffStd.sectionEye);
            if (!string2.equals(SdffConstants.SEGMENT_Eye_SdffHead)) {
                DvUtils.writetoTrace("  SDFFHEAD eyecatcher not detected");
                DvUtils.trace("Exit from SDFFDump:isSupportedSource(false)", 0, false);
                return bl;
            }
            DvUtils.writetoTrace("  SDFFHEAD eyecatcher detected - its an SDFF dump");
            theRAF.seek(32L);
            system = theRAF.readInt();
            architecture = theRAF.readInt();
            subsystem = theRAF.readInt();
            processor = theRAF.readInt();
            if (!sdffStd.checkMatch()) {
                DvUtils.output("Looks like SDFF format Error");
                DvUtils.trace("Exit from SDFFDump:isSupportedSource(false)", 3, false);
                return bl;
            }
        }
        catch (IOException iOException) {
            DvUtils.output("\nIOException captured in SDFFDump for " + file);
            DvUtils.output("This may be fine if dump is not a file " + file);
            DvUtils.trace("Exit from SDFFDump:isSupportedSource(false)", 1, false);
            return new Boolean(false);
        }
        DvUtils.output("Dump recognised as SDFF dump");
        SDFFDump.reset();
        sizeOfFile = file.length();
        nameOfFile = string;
        boolean bl2 = false;
        long l = sdffStd.sectionLen;
        while (!bl2) {
            try {
                theRAF.seek(l);
                byte[] byArray = new byte[32];
                int n = theRAF.read(byArray, 0, 32);
                sdffStd = new SdffStd(byArray);
                if (!sdffStd.checkMatch()) {
                    DvUtils.output(" checkMatch came back false");
                    bl2 = true;
                    continue;
                }
                if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_SdffHead) {
                    DvUtils.output("Two Sdffheads - not nice");
                    bl2 = true;
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_SdffRas) {
                    if (rasOffset == -1L) {
                        rasOffset = l;
                        rasLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two SdffRas sections - not nice");
                        bl2 = true;
                    }
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_Sdffprth) {
                    if (prthOffset == -1L) {
                        prthOffset = l;
                        prthLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two Sdffprths - not nice");
                        bl2 = true;
                    }
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_Sdffmmap) {
                    if (mmapOffset == -1L) {
                        mmapOffset = l;
                        mmapLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two Sdffmmaps - not nice");
                        bl2 = true;
                    }
                } else if (sdffStd.sectionType == (long)SdffConstants.SEGMENT_Sdffmem) {
                    if (memOffset == -1L) {
                        memOffset = l;
                        memLength = sdffStd.sectionLen;
                    } else {
                        DvUtils.output("Two Sdffmems - not nice");
                        bl2 = true;
                    }
                }
                l += sdffStd.sectionLen;
            }
            catch (IOException iOException) {
                bl2 = true;
            }
        }
        if (-1L == prthOffset) {
            DvUtils.trace("\n*** Error in dump format\nPrth offset/length is " + prthOffset + ":" + prthLength, 2, true);
        }
        if (-1L == mmapOffset) {
            DvUtils.trace("\n*** Error in dump format\nMmap offset/length is " + mmapOffset + ":" + mmapLength, 2, true);
        }
        if (-1L == memOffset) {
            DvUtils.trace("\n*** Error in dump format\nMem  offset/length is " + memOffset + ":" + memLength, 2, true);
        }
        if (-1L == rasOffset) {
            DvUtils.trace("\n*** Error in dump format\nRas  offset/length is " + rasOffset + ":" + rasLength, 2, true);
        }
        bl = Boolean.TRUE;
        DvUtils.trace("Exit from SDFFDump:isSupportedSource(true)", 2, false);
        return bl;
    }

    public int getProcessorSubType() {
        return processorSubtype;
    }

    public int getCurrentProcessor() {
        return currentProcessor;
    }

    public int getProcessorCount() {
        return numProcessors;
    }

    public DvAddressSpace getCurrentAddressSpace() {
        int n = DvConsole.getCurrentAsIndex();
        SDFFAddressSpace sDFFAddressSpace = this.theASArray[n];
        return sDFFAddressSpace;
    }

    public static void reset() {
        prthOffset = -1L;
        prthLength = -1L;
        mmapOffset = -1L;
        mmapLength = -1L;
        memOffset = -1L;
        memLength = -1L;
        rasOffset = -1L;
        rasLength = -1L;
        sizeOfFile = -1L;
    }

    public void printSdff(Sdff sdff) throws IOException {
        long l = sdff.getFilePointer();
        SdffStd sdffStd = new SdffStd(SdffConstants.SEGMENT_SdffHead, SdffConstants.VERSION1_0_0);
        sdffStd.printSdff(sdff);
        sdff.writeInt(system);
        sdff.writeInt(architecture);
        sdff.writeInt(subsystem);
        sdff.writeInt(processor);
        sdff.writeInt(processorSubtype);
        sdff.writeInt(numProcessors);
        sdff.writeInt(currentProcessor);
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }

    static {
        prthOffset = -1L;
        prthLength = -1L;
        mmapOffset = -1L;
        mmapLength = -1L;
        memOffset = -1L;
        memLength = -1L;
        rasOffset = -1L;
        rasLength = -1L;
        sizeOfFile = -1L;
        system = -1;
        architecture = -1;
        subsystem = -1;
        processor = -1;
        processorSubtype = -1;
        numProcessors = -1;
        currentProcessor = -1;
    }
}

