/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.SDFFAddress;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.SDFFMemRanges;
import com.ibm.jvm.dump.sdff.SDFFMemoryMap;
import com.ibm.jvm.dump.sdff.SDFFProcess;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import com.ibm.jvm.dump.sdff.SdffStd;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class SDFFAddressSpace
extends DvAddressSpace {
    private long mmapOffset;
    private long mmapLength;
    private SDFFMemRanges[] theMemRanges = null;
    private RandomAccessFile theRAF;
    private Vector processes = new Vector();
    private Vector process_offsets = new Vector();
    private long id;
    private long processCount;
    private SDFFDump owningDump;

    public SDFFAddressSpace(long l, long l2, long l3, long l4, RandomAccessFile randomAccessFile) {
        this.id = l;
        this.processCount = l2;
        this.mmapOffset = l3;
        this.mmapLength = l4;
        this.theRAF = randomAccessFile;
    }

    public byte[] readBytes(DvAddress dvAddress, long l) {
        int n;
        byte[] byArray = null;
        long l2 = dvAddress.getAddressAsLong();
        if (null != this.theMemRanges && -1 != (n = this.findAddressRangeIndex(dvAddress))) {
            long l3 = this.theMemRanges[n].addressStart().getAddressAsLong();
            long l4 = l2 - l3;
            try {
                long l5 = this.theMemRanges[n].getOffset() + l4;
                int n2 = (int)l;
                long l6 = this.theMemRanges[n].length() - l4;
                if (l > l6) {
                    n2 = (int)l6;
                }
                byArray = new byte[n2];
                this.theRAF.seek(l5);
                this.theRAF.read(byArray, 0, n2);
            }
            catch (IOException iOException) {
                System.out.println("\nSDFFAddressSpace:readBytes got IOException!!!");
            }
        }
        return byArray;
    }

    public DvMemRanges[] getMemRanges() {
        if (null == this.theMemRanges && this.mmapOffset != -1L) {
            int n = SDFFMemRanges.countThem(this.mmapOffset, this.mmapLength, this.theRAF);
            this.theMemRanges = new SDFFMemRanges[n];
            int n2 = 0;
            while (n2 < n) {
                this.theMemRanges[n2] = new SDFFMemRanges();
                this.theMemRanges[n2].loadFromFile(this.mmapOffset, this.mmapLength, this.theRAF, n2);
                ++n2;
            }
        }
        return this.theMemRanges;
    }

    public DvAddress createAddress(long l) {
        SDFFAddress sDFFAddress = new SDFFAddress();
        sDFFAddress.setAddress(l);
        return sDFFAddress;
    }

    public static SDFFAddressSpace[] loadFromFile(long l, long l2, long l3, long l4, RandomAccessFile randomAccessFile) {
        long l5 = l + SdffStd.getSize();
        boolean bl = false;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[256];
        SDFFAddressSpace[] sDFFAddressSpaceArray = null;
        Object var33_12 = null;
        try {
            randomAccessFile.seek(l5);
            long l6 = randomAccessFile.readLong();
            DvUtils.trace("Count of address spaces is: " + l6, 0, false);
            sDFFAddressSpaceArray = new SDFFAddressSpace[(int)l6];
            int n = 0;
            while ((long)n < l6) {
                long l7 = randomAccessFile.readLong();
                DvUtils.trace("Length of address space (index " + n + ") is: " + l7, 0, false);
                DvUtils.trace("Checking ADDRSPC eyecatcher @ offset " + randomAccessFile.getFilePointer(), 0, false);
                randomAccessFile.readFully(byArray);
                String string = new String(byArray);
                if (string.equals(SdffConstants.SEGMENT_Eye_SdffAs)) {
                    DvUtils.trace("ADDRSPC eyecatcher appears valid", 0, false);
                } else {
                    DvUtils.errorMsg("ADDRSPC eyecatcher invalid\nFurther failures expected", 0);
                    bl = true;
                }
                if (!bl) {
                    long l8 = randomAccessFile.readLong();
                    DvUtils.trace("ADDRSPC id is: " + l8, 0, false);
                    long l9 = randomAccessFile.readLong();
                    long l10 = randomAccessFile.getFilePointer();
                    long l11 = randomAccessFile.readLong();
                    if (randomAccessFile.readByte() != 80) {
                        randomAccessFile.seek(l10);
                        int n2 = randomAccessFile.readInt();
                        DvUtils.trace("There appear to be " + l9 + " processes and current process index is " + n2, 0, false);
                        byte[] byArray5 = new byte[60];
                        randomAccessFile.read(byArray5);
                    } else {
                        DvUtils.trace("There appear to be " + l9 + " processes ", 0, false);
                        randomAccessFile.seek(l10);
                    }
                    sDFFAddressSpaceArray[n] = new SDFFAddressSpace(l8, l9, l3, l4, randomAccessFile);
                    long l12 = randomAccessFile.getFilePointer();
                    bl = SDFFAddressSpace.loadProcesses(l12, randomAccessFile, l9, sDFFAddressSpaceArray, n);
                    if (bl && (bl = SDFFAddressSpace.loadProcesses(l12 + 64L, randomAccessFile, l9, sDFFAddressSpaceArray, n))) {
                        DvUtils.errorMsg("PROCESSS eyecatcher invalid\nFurther failures expected", 0);
                    }
                    l5 += l7;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("\nIOException caught in SDFFAddressSpace:loadFromFile");
        }
        return sDFFAddressSpaceArray;
    }

    public static int countThem(long l, RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[8];
        int n = 0;
        long l2 = l + SdffStd.getSize();
        try {
            randomAccessFile.seek(l2);
            n = (int)randomAccessFile.readLong();
            long l3 = randomAccessFile.readLong();
            randomAccessFile.readFully(byArray);
            String string = new String(byArray);
            if (!string.equals(SdffConstants.SEGMENT_Eye_SdffAs)) {
                DvUtils.errorMsg("ADDRSPC eyecatcher invalid", 0);
                n = 0;
            }
        }
        catch (IOException iOException) {
            System.out.println("\nIOException caught in SDFFAddressSpace:countThem");
            n = 0;
        }
        return n;
    }

    public DvProcess[] getProcesses() {
        DvProcess[] dvProcessArray = null;
        if (this.processes.size() != 0) {
            dvProcessArray = new DvProcess[this.processes.size()];
            int n = 0;
            while (n < this.processes.size()) {
                dvProcessArray[n] = (DvProcess)this.processes.elementAt(n);
                ++n;
            }
        }
        return dvProcessArray;
    }

    public String id() {
        return Long.toString(this.id);
    }

    public byte readByte(DvAddress dvAddress) throws DvAddressException {
        byte[] byArray = this.readBytes(dvAddress, 1L);
        if (null == byArray) {
            throw new DvAddressException("No range containing this address");
        }
        byte by = byArray[0];
        return by;
    }

    public int readInt(DvAddress dvAddress) throws DvAddressException {
        int n;
        block6: {
            n = 0;
            try {
                long l = dvAddress.getAddressAsLong();
                int n2 = this.findAddressRangeIndex(dvAddress);
                if (-1 != n2) {
                    long l2 = this.theMemRanges[n2].addressStart().getAddressAsLong();
                    long l3 = l - l2;
                    long l4 = this.theMemRanges[n2].getOffset() + l3;
                    this.theRAF.seek(l4);
                    DvDump dvDump = DvConsole.getCurrentDump();
                    if (!DvUtils.isBigEndian(dvDump.getArchitecture())) {
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < 32) {
                            n3 |= (this.theRAF.readByte() & 0xFF) << n4;
                            n4 += 8;
                        }
                        n = n3;
                    } else {
                        n = this.theRAF.readInt();
                    }
                    break block6;
                }
                throw new DvAddressException("No range containing this address");
            }
            catch (IOException iOException) {
                throw new DvAddressException("IOException behind this");
            }
        }
        return n;
    }

    public short readShort(DvAddress dvAddress) throws DvAddressException {
        short s;
        block6: {
            s = 0;
            try {
                long l = dvAddress.getAddressAsLong();
                int n = this.findAddressRangeIndex(dvAddress);
                if (-1 != n) {
                    long l2 = this.theMemRanges[n].addressStart().getAddressAsLong();
                    long l3 = l - l2;
                    long l4 = this.theMemRanges[n].getOffset() + l3;
                    this.theRAF.seek(l4);
                    DvDump dvDump = DvConsole.getCurrentDump();
                    if (!DvUtils.isBigEndian(dvDump.getArchitecture())) {
                        short s2 = 0;
                        int n2 = 0;
                        while (n2 < 16) {
                            s2 = (short)(s2 | (this.theRAF.readByte() & 0xFF) << n2);
                            n2 += 8;
                        }
                        s = s2;
                    } else {
                        s = this.theRAF.readShort();
                    }
                    break block6;
                }
                throw new DvAddressException("No range containing this address");
            }
            catch (IOException iOException) {
                throw new DvAddressException("IOException behind this");
            }
        }
        return s;
    }

    public DvAddress readPointer(DvAddress dvAddress) {
        DvAddress dvAddress2 = null;
        DvDump dvDump = DvConsole.getCurrentDump();
        try {
            long l;
            if (DvUtils.is64BitSystem(dvDump.getArchitecture())) {
                l = this.readLong(dvAddress);
            } else {
                l = this.readInt(dvAddress);
                l &= 0xFFFFFFFFL;
            }
            dvAddress2 = this.createAddress(l);
        }
        catch (DvAddressException dvAddressException) {
            // empty catch block
        }
        return dvAddress2;
    }

    public long readLong(DvAddress dvAddress) throws DvAddressException {
        long l;
        block6: {
            l = 0L;
            try {
                long l2 = dvAddress.getAddressAsLong();
                int n = this.findAddressRangeIndex(dvAddress);
                if (-1 != n) {
                    long l3 = this.theMemRanges[n].addressStart().getAddressAsLong();
                    long l4 = l2 - l3;
                    long l5 = this.theMemRanges[n].getOffset() + l4;
                    this.theRAF.seek(l5);
                    DvDump dvDump = DvConsole.getCurrentDump();
                    if (!DvUtils.isBigEndian(dvDump.getArchitecture())) {
                        long l6 = 0L;
                        int n2 = 0;
                        while (n2 < 64) {
                            l6 |= (long)(this.theRAF.readByte() & 0xFF) << n2;
                            n2 += 8;
                        }
                        l = l6;
                    } else {
                        l = this.theRAF.readLong();
                    }
                    break block6;
                }
                throw new DvAddressException("Address not found in an address range");
            }
            catch (IOException iOException) {
                throw new DvAddressException("IOException behind this");
            }
        }
        return l;
    }

    public DvProcess getCurrentProcess() {
        int n = DvConsole.getCurrentProcessIndex();
        return (DvProcess)this.processes.get(n);
    }

    private int findAddressRangeIndex(DvAddress dvAddress) {
        long l = 0L;
        int n = -1;
        long l2 = dvAddress.getAddressAsLong();
        if (null != this.theMemRanges) {
            int n2 = 0;
            while (n2 < this.theMemRanges.length && n == -1) {
                l = this.theMemRanges[n2].addressStart().getAddressAsLong();
                if (l2 >= l && l2 < l + this.theMemRanges[n2].length()) {
                    n = n2;
                }
                ++n2;
            }
        }
        return n;
    }

    private static boolean loadProcesses(long l, RandomAccessFile randomAccessFile, long l2, SDFFAddressSpace[] sDFFAddressSpaceArray, int n) {
        boolean bl = false;
        long l3 = l;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[256];
        SDFFProcess sDFFProcess = null;
        try {
            randomAccessFile.seek(l3);
            int n2 = 0;
            while ((long)n2 < l2) {
                DvUtils.trace("Checking PROCESS with index " + n2, 0, false);
                sDFFAddressSpaceArray[n].processes.clear();
                long l4 = randomAccessFile.readLong();
                DvUtils.trace("Process length is " + l4, 0, false);
                DvUtils.trace("Checking PROCESS eyecatcher @ offset " + randomAccessFile.getFilePointer(), 0, false);
                randomAccessFile.readFully(byArray);
                String string = new String(byArray);
                if (string.equals(SdffConstants.SEGMENT_Eye_SdffProc)) {
                    DvUtils.trace("PROCESS eyecatcher is valid", 0, false);
                } else {
                    bl = true;
                    n2 = (int)l2;
                }
                if (!bl) {
                    long l5 = randomAccessFile.readLong();
                    long l6 = randomAccessFile.readLong();
                    long l7 = randomAccessFile.readLong();
                    long l8 = randomAccessFile.readLong();
                    randomAccessFile.readFully(byArray2);
                    String string2 = new String(byArray2, "ASCII");
                    randomAccessFile.readFully(byArray3);
                    long l9 = randomAccessFile.readLong();
                    sDFFProcess = new SDFFProcess(l5, l6, l7, l8, string2, "command_line", l3, l4, randomAccessFile, sDFFAddressSpaceArray[n]);
                    sDFFAddressSpaceArray[n].processes.add(sDFFProcess);
                    l3 += l4;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.err.println("\nIOException caught in SDFFAddressSpace:loadProcesses");
            bl = true;
        }
        return bl;
    }

    public void printSdff(Sdff sdff, SDFFMemoryMap sDFFMemoryMap) throws IOException {
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes("ADDRSPC ");
        sdff.writeLong(this.id);
        sdff.writeLong(this.processes.size());
        Enumeration enumeration = this.processes.elements();
        while (enumeration.hasMoreElements()) {
            SDFFProcess sDFFProcess = (SDFFProcess)enumeration.nextElement();
            sDFFProcess.printSdff(sdff, sDFFMemoryMap);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }

    public int pointerSize() {
        DvDump dvDump = DvConsole.getCurrentDump();
        if (dvDump != null && DvUtils.is64BitSystem(dvDump.getArchitecture())) {
            return 8;
        }
        return 4;
    }
}

