/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvXeCommands
extends CommandPlugin {
    private static Vector theOutput = new Vector();
    private static String[] commandsSupported = new String[]{"DISPLAY,DIS,JAVASTACK,js,displayJavaStack", "DISPLAY,DIS,NATIVESTACK,ns,displayNativeStack", "DISPLAY,DIS,JITMETHODS,jitm,displayJitMethods"};
    private static DvAddressSpace as;
    private Vector filter;

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String pluginName() {
        return "XE commands Plugin";
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvXeCommands.properties");
        return vector;
    }

    public String help() {
        return null;
    }

    public void displayJavaStack() {
        Vector vector = new Vector();
        DvAddressSpace[] dvAddressSpaceArray = this.theDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(this.theDump, "T");
            this.showJavaStack(dvThread, vector);
        } else {
            int n = 0;
            while (n < dvAddressSpaceArray.length) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[n].getProcesses();
                int n2 = 0;
                while (n2 < dvProcessArray.length) {
                    DvThread[] dvThreadArray = dvProcessArray[n2].getThreads();
                    int n3 = 0;
                    while (n3 < dvThreadArray.length) {
                        if (DvUtils.filtrate(dvThreadArray[n3].id(), vector2)) {
                            this.showJavaStack(dvThreadArray[n3], vector);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void showJavaStack(DvThread dvThread, Vector vector) {
        if (this.theDump != null && dvThread != null && dvThread.getJavaStack() != null) {
            vector.add("\n Java stack for thread " + dvThread.id() + "\n ==========================\n");
            int n = 0;
            while ((long)n < dvThread.getJavaStack().getNumFrames()) {
                if (!dvThread.getJavaStack().getFrame(n).isPseudo()) {
                    vector.add("\tat " + dvThread.getJavaStack().getFrame(n).toString());
                }
                ++n;
            }
        } else {
            vector.add("No java stack.");
        }
    }

    public void displayNativeStack() {
        Vector vector = new Vector();
        DvAddressSpace[] dvAddressSpaceArray = this.theDump.getAddressSpaces();
        Vector vector2 = this.parseParams(this.paramString);
        if (this.paramString == null) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(this.theDump, "T");
            this.showNativeStack(dvThread, vector);
        } else {
            int n = 0;
            while (n < dvAddressSpaceArray.length) {
                DvProcess[] dvProcessArray = dvAddressSpaceArray[n].getProcesses();
                int n2 = 0;
                while (n2 < dvProcessArray.length) {
                    DvThread[] dvThreadArray = dvProcessArray[n2].getThreads();
                    int n3 = 0;
                    while (n3 < dvThreadArray.length) {
                        if (DvUtils.filtrate(dvThreadArray[n3].id(), vector2)) {
                            this.showNativeStack(dvThreadArray[n3], vector);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void showNativeStack(DvThread dvThread, Vector vector) {
        if (this.theDump != null && dvThread != null && dvThread.getNativeStack() != null) {
            vector.add("\n Native stack for thread " + dvThread.id() + "\n ============================\n");
            int n = 0;
            while ((long)n < dvThread.getNativeStack().getNumFrames()) {
                DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
                DvNativeFrame dvNativeFrame = dvThread.getNativeStack().getFrame(n);
                if (dvAddressSpace.pointerSize() == 4) {
                    vector.add("\tat " + Integer.toHexString((int)dvNativeFrame.getPc()) + " in " + dvNativeFrame.toString());
                } else {
                    vector.add("\tat " + Long.toHexString(dvNativeFrame.getPc()) + " in " + dvNativeFrame.toString());
                }
                ++n;
            }
        } else {
            vector.add("Native stack not available.");
        }
    }

    private CTypeObject findAvlTreeRoot(DvAddressSpace dvAddressSpace, DvDump dvDump) {
        try {
            DvRas dvRas = dvDump.getRas();
            CTypeObject cTypeObject = new CTypeObject("jvm_ras_t", dvRas.jvmRas, dvAddressSpace);
            DvAddress dvAddress = new DvAddress(cTypeObject.getField("ras.data.jitRas").getValue());
            CTypeObject cTypeObject2 = new CTypeObject("jit_ras_t", dvAddressSpace.readPointer(dvAddress), dvAddressSpace);
            DvAddress dvAddress2 = new DvAddress(cTypeObject2.getField("ras.data.avl_tree_root").getValue());
            CTypeObject cTypeObject3 = new CTypeObject("committed_code", dvAddressSpace.readPointer(dvAddress2), dvAddressSpace);
            return cTypeObject3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void displayJitMethods() {
        Vector vector = new Vector();
        this.filter = this.parseParams(this.paramString);
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
            CTypeObject cTypeObject = this.findAvlTreeRoot(dvAddressSpace, this.theDump);
            this.displayCC(cTypeObject, dvAddressSpace, vector);
        }
        catch (Exception exception) {
            vector.add("No jitted methods.");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private String getMethodName(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) throws DvAddressException {
        String string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject.getField("member.name").getValue(), 1024L));
        CTypeObject cTypeObject2 = cTypeObject.getField("member.clazz").deReference();
        String string2 = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(cTypeObject2.getField("obj.name").getValue(), 1024L));
        return string2 + "/" + string;
    }

    private void displayCC(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace, Vector vector) {
        if (cTypeObject == null) {
            return;
        }
        try {
            CTypeObject cTypeObject2 = cTypeObject.getField("mb").deReference();
            String string = this.getMethodName(cTypeObject2, dvAddressSpace);
            if (DvUtils.filtrate(string, this.filter)) {
                vector.add(string + " : (" + Long.toHexString(cTypeObject.getField("start").getValue()) + " - " + Long.toHexString(cTypeObject.getField("end").getValue()) + ")");
            }
            this.displayCC(cTypeObject.getField("left").deReference(), dvAddressSpace, vector);
            this.displayCC(cTypeObject.getField("right").deReference(), dvAddressSpace, vector);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CTypeObject findJitMethod(CTypeObject cTypeObject, long l) throws DvAddressException {
        if (cTypeObject == null) {
            return null;
        }
        DvAddress dvAddress = new DvAddress(cTypeObject.getField("start").getValue());
        DvAddress dvAddress2 = new DvAddress(cTypeObject.getField("end").getValue());
        DvAddress dvAddress3 = new DvAddress(l);
        if (dvAddress3.compare(dvAddress) <= 0 && dvAddress3.compare(dvAddress2) >= 0) {
            return cTypeObject;
        }
        CTypeObject cTypeObject2 = this.findJitMethod(cTypeObject.getField("left").deReference(), l);
        if (cTypeObject2 != null) {
            return cTypeObject2;
        }
        cTypeObject2 = this.findJitMethod(cTypeObject.getField("right").deReference(), l);
        if (cTypeObject2 != null) {
            return cTypeObject2;
        }
        return null;
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            CTypeObject cTypeObject = this.findAvlTreeRoot(dvAddressSpace, dvDump);
            CTypeObject cTypeObject2 = this.findJitMethod(cTypeObject, dvAddress.getAddressAsLong());
            if (cTypeObject2 != null) {
                CTypeObject cTypeObject3 = cTypeObject2.getField("mb").deReference();
                String string2 = this.getMethodName(cTypeObject3, dvAddressSpace);
                return "Address is in JITed code for method " + string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Vector parseParams(String string) {
        this.filter = new Vector();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.filter.add(string2);
            }
        } else {
            this.filter.add("*");
        }
        return this.filter;
    }

    public String[] guiPopupSyntax() {
        return null;
    }
}

