/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressIndexFile;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvNamesIndexFile;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvObjectsCommands
extends CommandPlugin {
    private static Vector theOutput = new Vector();
    private static final String oSeperator = "\n============================================";
    private static boolean heapsTraversed = false;
    private static boolean unknownSystem = false;
    private static int totalObjectCount;
    private static int totalLockedObjectCount;
    private static long[][] rangeArray;
    private static int middlewareH;
    private static int transientH;
    private static int systemH;
    private static int acsH;
    static int threadLocalH;
    private static int ptrLength;
    private static boolean is64bit;
    private static boolean isBigEndian;
    private static long allocBitsAddress;
    private static final byte[] allocBitsTestBytes;
    private static boolean verboseTLH;
    private static DvAddressIndexFile addressIndexFile;
    private static DvNamesIndexFile namesIndexFile;
    private static boolean address_index_built;
    private static boolean names_index_built;
    private int javaThreadsWithoutTLH;
    private int javaThreadsWithTLH;
    private int javaThreadsWithoutTHTLH;
    private int javaThreadsWithTHTLH;
    private static byte[] extendedAllocBits;
    private static byte[] lockedAllocBits;
    private static long startOfMHeap;
    private static long endOfMHeap;
    private static long startOfTransHeap;
    private static long endOfTransHeap;
    private static HashSet systemHeapHashByAddr;
    private static HashSet acsHeapHashByAddr;
    private static Vector lockedObjects;
    public static DvObjectsCommands that;
    private static String[] commandsSupported;
    private static DvAddressSpace as;

    public DvObjectsCommands() {
        that = this;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String pluginName() {
        return "Object commands Plugin";
    }

    public void reset() {
        DvUtils.trace("Entry:DvObjectsCommands.reset", 0, false);
        this.cpr.output(theOutput);
        theOutput.clear();
        heapsTraversed = false;
        unknownSystem = false;
        rangeArray = null;
        allocBitsAddress = 0L;
        extendedAllocBits = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        systemHeapHashByAddr.clear();
        acsHeapHashByAddr.clear();
        lockedObjects.clear();
        totalObjectCount = 0;
        totalLockedObjectCount = 0;
        middlewareH = 0;
        transientH = 0;
        systemH = 0;
        acsH = 0;
        threadLocalH = 0;
        ptrLength = 0;
        DvUtils.trace("Exit:1 DvObjectsCommands.reset", 0, false);
    }

    public void displayObjects() {
        String string;
        Object object;
        DvUtils.trace("Entry:DvObjectsCommands.displayObjects", 0, false);
        boolean bl = false;
        Vector vector = new Vector();
        if (null == this.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.displayObjects", 0, false);
            return;
        }
        this.initPtrLength();
        is64bit = DvUtils.is64BitSystem(this.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(this.theDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (null == this.paramString) {
            this.displayObjectSummary();
            this.returnControl();
            DvUtils.trace("Exit:2 DvObjectsCommands.displayObjects", 0, false);
            return;
        }
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.trace("Exit: 3DvObjectsCommands.displayObjects", 0, false);
                        return;
                    }
                    if (!heapsTraversed) {
                        this.traverseAllHeaps();
                    }
                    if (this.checkForKnownObject(l - (long)ptrLength)) {
                        ObjectDetails objectDetails = this.getObjectDetails(l - (long)ptrLength);
                        this.showObjects(objectDetails);
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.trace("Exit:4 DvObjectsCommands.displayObjects", 0, false);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.returnControl();
                DvUtils.trace("Exit:5 DvObjectsCommands.displayObjects The address is not valid hex", 0, false);
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.returnControl();
                DvUtils.trace("Exit:6 DvObjectsCommands.displayObjects noStringIndexOutOfBoundsException:The address is not valid", 0, false);
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                this.returnControl();
                DvUtils.trace("Exit:7 DvObjectsCommands.displayObjects Object names must start with letter", 0, false);
                return;
            }
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        if (vector.size() > 0 && !bl) {
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.get(n);
                long[] lArray = namesIndexFile.getInstancesForClass(string);
                if (null != lArray) {
                    int n2 = 0;
                    while (n2 < lArray.length) {
                        ObjectDetails objectDetails = this.getObjectDetails(lArray[n2]);
                        this.showObjects(objectDetails);
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            int n = 0;
            while (n < ((Vector)object).size()) {
                long[] lArray;
                String string2 = (String)((Vector)object).get(n);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (bl2 && null != (lArray = namesIndexFile.getInstancesForClass(string2))) {
                    int n3 = 0;
                    while (n3 < lArray.length) {
                        ObjectDetails objectDetails = this.getObjectDetails(lArray[n3]);
                        this.showObjects(objectDetails);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.trace("Exit:8 DvObjectsCommands.displayObjects", 0, false);
    }

    public void displayObjectSummary() {
        DvUtils.trace("Entry:DvObjectsCommands.displayObjectSummary", 0, false);
        boolean bl = false;
        Vector vector = new Vector();
        if (null == this.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.displayObjectSummary no Dump opened yet", 0, false);
            return;
        }
        this.initPtrLength();
        is64bit = DvUtils.is64BitSystem(this.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(this.theDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        theOutput.add("\n objects Summary\n ===============\n");
        theOutput.add(" Number of objects found via Thread Local Heap   = " + threadLocalH);
        theOutput.add(" Number of objects found via Middleware Heap     = " + middlewareH);
        theOutput.add(" Number of objects found via Transient Heap      = " + transientH);
        theOutput.add(" Number of objects found via System Heap         = " + systemH);
        theOutput.add(" Number of objects found via ACS Classes Heap    = " + acsH + "\n\n");
        theOutput.add(" Total number of objects found via all Heaps     = " + totalObjectCount + "\n\n");
        theOutput.add(namesIndexFile.summary());
        theOutput.add("\n Number of Locked objects  = " + totalLockedObjectCount + "\n");
        this.returnControl();
        DvUtils.trace("Exit:2 DvObjectsCommands.displayObjectSummary", 0, false);
    }

    public void displayLocks() {
        String string;
        Object object;
        DvUtils.trace("Entry:DvObjectsCommands.displayLocks", 0, false);
        boolean bl = false;
        Vector vector = new Vector();
        if (null == this.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.displayLocks", 0, false);
            return;
        }
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.trace("Exit:2 DvObjectsCommands.displayLocks", 0, false);
                        return;
                    }
                    if (!heapsTraversed) {
                        this.traverseAllHeaps();
                    }
                    if (this.checkForKnownObject(l - (long)ptrLength)) {
                        ObjectDetails objectDetails = this.getObjectDetails(l - (long)ptrLength);
                        this.showObjects(objectDetails);
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.trace("Exit:3 DvObjectsCommands.displayLocks", 0, false);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.returnControl();
                DvUtils.trace("Exit:4 DvObjectsCommands.displayLocks The address is not valid hex", 0, false);
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.returnControl();
                DvUtils.trace("Exit:5 DvObjectsCommands.displayLocks StringIndexOutOfBoundsException:The address is not valid", 0, false);
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                this.returnControl();
                DvUtils.trace("Exit:6 DvObjectsCommands.displayLocks Object names must start with letter", 0, false);
                return;
            }
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        if (vector.size() > 0 && !bl) {
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.get(n);
                long[] lArray = namesIndexFile.getInstancesForClass(string);
                if (null != lArray) {
                    int n2 = 0;
                    while (n2 < lArray.length) {
                        ObjectDetails objectDetails = this.getObjectDetails(lArray[n2]);
                        this.showLocks(objectDetails);
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            int n = 0;
            while (n < ((Vector)object).size()) {
                long[] lArray;
                String string2 = (String)((Vector)object).get(n);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (bl2 && null != (lArray = namesIndexFile.getInstancesForClass(string2))) {
                    int n3 = 0;
                    while (n3 < lArray.length) {
                        ObjectDetails objectDetails = this.getObjectDetails(lArray[n3]);
                        this.showLocks(objectDetails);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.trace("Exit:7 DvObjectsCommands.displayLocks", 0, false);
    }

    public void displayLockSummary() {
        DvUtils.trace("Entry:DvObjectsCommands.displayLockSummary", 0, false);
        if (null == this.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.displayLockSummary", 0, false);
            return;
        }
        this.initPtrLength();
        is64bit = DvUtils.is64BitSystem(this.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(this.theDump.getArchitecture());
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        theOutput.add("");
        theOutput.add("");
        theOutput.add("LOCKING INFORMATION:");
        theOutput.add("");
        if (1 == this.checkLKGLOBALPTR()) {
            long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
            theOutput.add("To view the locking global data:");
            theOutput.add("format 0x" + Long.toHexString(l) + " as _lkgldata");
            theOutput.add("");
        } else {
            DvUtils.trace("Continue:1 DvObjectsCommands.displayLockSummary No locking global pointer displayMonitorPoolDump(\"dis ls\")", 0, false);
        }
        this.displayMonitorPoolInfo("dis ls");
        if (1 == this.checkLKGLOBALPTR()) {
            this.displayMonitorPoolDump("dis ls");
        } else {
            DvUtils.trace("Continue:2 DvObjectsCommands.displayLockSummary No locking global pointer displayMonitorPoolDump(\"dis ls\")", 0, false);
        }
        if (1 == this.checkLKGLOBALPTR()) {
            this.displaySysMonitorDump("dis ls");
        } else {
            DvUtils.trace("Continue:3 DvObjectsCommands.displayLockSummary No locking global pointer displaySysMonitorDump(\"dis ls\")", 0, false);
        }
        this.displayThreadIdent("dis ls");
        this.displayJavaObjMonDump("dis ls");
        this.returnControl();
        DvUtils.trace("Exit:2 DvObjectsCommands.displayLockSummary", 0, false);
    }

    private int checkLKGLOBALPTR() {
        DvUtils.trace("Entry:DvObjectsCommands.checkLKGLOBALPTR", 0, false);
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        long l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            DvUtils.trace("Exit:1 DvObjectsCommands.checkLKGLOBALPTR", 0, false);
            return 0;
        }
        DvUtils.trace("Exit:2 DvObjectsCommands.checkLKGLOBALPTR", 0, false);
        return 1;
    }

    private Vector displayMonitorPoolInfo(String string) {
        DvUtils.trace("Entry:DvObjectsCommands.displayMonitorPoolInfo", 0, false);
        Vector vector = new Vector();
        boolean bl = false;
        if (string.equals(new String("javacore"))) {
            bl = true;
        }
        if (bl) {
            vector.addElement("1LKPOOLINFO");
            vector.addElement("Monitor pool info:");
            vector.addElement("2LKPOOLINIT");
            vector.addElement("  Initial monitor count: 32");
            vector.addElement("2LKPOOLEXPNUM");
            vector.addElement("  Minumum number of free moniors before expansion: 5");
            vector.addElement("2LKPOOLEXPBY");
            vector.addElement("  Pool will next be expanded by: <unknown>");
            vector.addElement("2LKPOOLTOTAL");
            vector.addElement("  Current total number of free monitors: <unknown>");
            vector.addElement("2LKPOOLFREE");
            vector.addElement("  Current number of free monitors: <unknown>");
            vector.addElement("NULL");
            vector.addElement("");
        } else {
            theOutput.add("");
            theOutput.add("Monitor pool info:");
            theOutput.add("  Initial monitor count: 32");
            theOutput.add("  Minumum number of free moniors before expansion: 5");
            theOutput.add("  Pool will next be expanded by: <unknown>");
            theOutput.add("  Current total number of free monitors: <unknown>");
            theOutput.add("  Current number of free monitors: <unknown>");
            theOutput.add("");
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.displayMonitorPoolInfo", 0, false);
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    private Vector displayMonitorPoolDump(String var1_1) {
        DvUtils.trace("Entry:DvObjectsCommands.displayMonitorPoolDump", 0, false);
        var2_2 = new Vector();
        var3_3 = false;
        if (var1_1.equals(new String("javacore"))) {
            var3_3 = true;
        }
        if (var3_3) {
            var2_2.addElement("1LKMONPOOLDUMP");
            var2_2.addElement("Monitor Pool Dump (flat & inflated object-monitors):");
        } else {
            DvObjectsCommands.theOutput.add("");
            DvObjectsCommands.theOutput.add("Monitor Pool Dump (flat & inflated object-monitors):");
        }
        DvObjectsCommands.as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        var4_4 = Long.parseLong(DvUtils.getJVMHint(DvObjectsCommands.as, "LKGLOBALPTR"), 16);
        var6_5 = null;
        var7_6 = this.getControlBlockField("_lkgldata", "micb", var4_4, DvObjectsCommands.as);
        var9_7 = this.getControlBlockField("monitor_index_cb_t", "table", var7_6, DvObjectsCommands.as);
        if (!var3_3) {
            DvObjectsCommands.theOutput.add(" Information is from a table of inflated monitors:");
            DvObjectsCommands.theOutput.add(" format 0x" + Long.toHexString(var7_6) + " as monitor_index_cb_t");
            DvObjectsCommands.theOutput.add("");
        }
        var11_8 = this.getControlBlockField("monitor_index_cb_t", "count", var7_6, DvObjectsCommands.as);
        var13_9 = 0L;
        var15_10 = 1;
        if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
            try {
                var13_9 = DvObjectsCommands.as.readLong(DvObjectsCommands.as.createAddress(var9_7));
            }
            catch (DvAddressException var16_11) {
                DvUtils.trace("Continue:1 displayMonitorPoolDump(String) DvAddressException", 0, false);
            }
            var9_7 += 8L;
        } else {
            try {
                var13_9 = DvObjectsCommands.as.readInt(DvObjectsCommands.as.createAddress(var9_7));
            }
            catch (DvAddressException var16_12) {
                DvUtils.trace("Continue:2 displayMonitorPoolDump(String) DvAddressException", 0, false);
            }
            var9_7 += 4L;
        }
        if (0L == var13_9) ** GOTO lbl111
        if (var3_3) {
            var2_2.addElement("");
            var2_2.addElement("Monitor Pool Dump Error The first element in the infl_mon table is not 0x00000000");
        } else {
            DvObjectsCommands.theOutput.add("Monitor Pool Dump Error The first element in the infl_mon table is not 0x00000000");
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.displayMonitorPoolDump", 0, false);
        return var2_2;
lbl-1000:
        // 1 sources

        {
            if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
                try {
                    var13_9 = DvObjectsCommands.as.readLong(DvObjectsCommands.as.createAddress(var9_7));
                }
                catch (DvAddressException var16_14) {
                    DvUtils.trace("Continue:3 displayMonitorPoolDump(String) DvAddressException", 0, false);
                }
                ++var15_10;
                var9_7 += 8L;
            } else {
                try {
                    var13_9 = DvObjectsCommands.as.readInt(DvObjectsCommands.as.createAddress(var9_7));
                }
                catch (DvAddressException var16_15) {
                    DvUtils.trace("Continue:4 displayMonitorPoolDump(String) DvAddressException", 0, false);
                }
                ++var15_10;
                var9_7 += 4L;
            }
            var16_16 = this.getControlBlockField("infl_mon", "_sysmon", var13_9, DvObjectsCommands.as);
            var18_17 = this.theDump.getSystemType();
            switch (var18_17) {
                case -1: {
                    if (DvObjectsCommands.unknownSystem) continue block13;
                    DvObjectsCommands.unknownSystem = true;
                    if (var3_3) {
                        var2_2.addElement("NULL");
                        var2_2.addElement("Error SYSTEM IS UNKNOWN (" + var18_17 + ")");
                        break;
                    }
                    DvObjectsCommands.theOutput.add("Error SYSTEM IS UNKNOWN (" + var18_17 + ")");
                    break;
                }
                case 1: {
                    var19_18 = this.getControlBlockField("sys_mon", "atomic_count", var16_16, DvObjectsCommands.as);
                    var21_19 = this.getControlBlockField("sys_mon", "waiter_count", var16_16, DvObjectsCommands.as);
                    var23_20 = this.getControlBlockField("sys_mon", "monitor_owner", var16_16, DvObjectsCommands.as);
                    var25_21 = this.getControlBlockField("sys_mon", "monitor_waiter", var16_16, DvObjectsCommands.as);
                    if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
                        if (var19_18 == -1L && var21_19 == 0L && var23_20 == 0L && var25_21 == 0L) continue block13;
                        var2_2.addAll(this.monitorDumpInfo(var1_1, var13_9, var16_16, var23_20, var25_21));
                        break;
                    }
                    if ((int)var19_18 == -1 && var21_19 == 0L && var23_20 == 0L && var25_21 == 0L) continue block13;
                    var2_2.addAll(this.monitorDumpInfo(var1_1, var13_9, var16_16, var23_20, var25_21));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    var19_18 = this.getControlBlockField("sys_mon", "monitor_owner", var16_16, DvObjectsCommands.as);
                    var21_19 = this.getControlBlockField("sys_mon", "mwait_queue", "count", var16_16, DvObjectsCommands.as);
                    if (var19_18 == 0L && var21_19 == 0L) continue block13;
                    var2_2.addAll(this.monitorDumpInfo(var1_1, var13_9, var16_16, var19_18, var21_19));
                    break;
                }
                default: {
                    if (DvObjectsCommands.unknownSystem) continue block13;
                    DvObjectsCommands.unknownSystem = true;
                    if (var3_3) {
                        var2_2.addElement("NULL");
                        var2_2.addElement("Error SYSTEM IS UNKNOWN (" + var18_17 + ")");
                        break;
                    }
                    DvObjectsCommands.theOutput.add("Error SYSTEM IS UNKNOWN (" + var18_17 + ")");
                }
            }
lbl111:
            // 13 sources

            ** while (var11_8 - (long)var15_10 > 0L)
        }
lbl112:
        // 1 sources

        if (var3_3) {
            var2_2.addElement("NULL");
            var2_2.addElement("");
        } else {
            DvObjectsCommands.theOutput.add("");
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.displayMonitorPoolDump", 0, false);
        return var2_2;
    }

    private Vector monitorDumpInfo(String string, long l, long l2, long l3, long l4) {
        DvUtils.trace("Entry:DvObjectsCommands.monitorDumpInfo(String,long,long,long,long)", 0, false);
        Vector vector = new Vector();
        boolean bl = false;
        if (string.equals(new String("javacore"))) {
            bl = true;
        }
        if (bl) {
            vector.addElement("2LKMONINUSE");
            vector.addElement("  sys_mon_t:0x" + Long.toHexString(l2) + " infl_mon_t: 0x" + Long.toHexString(l));
        } else {
            theOutput.add("  sys_mon_t:0x" + Long.toHexString(l2) + " infl_mon_t: 0x" + Long.toHexString(l));
        }
        long l5 = this.getControlBlockField("infl_mon", "object", l, as);
        if (this.checkForKnownObject(l5 - (long)ptrLength)) {
            long l6;
            CTypeObject cTypeObject;
            int n;
            Vector vector2;
            boolean bl2;
            ObjectDetails objectDetails = this.getObjectDetails(l5 - (long)ptrLength);
            String string2 = "    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L) + ":";
            if (DvUtils.checkAddressInDump(as.createAddress(l3), as) && 0L != l3) {
                string2 = string2 + " owner ";
                bl2 = false;
                vector2 = this.getThreads();
                n = 0;
                while (n < vector2.size()) {
                    CTypeObject cTypeObject2 = new CTypeObject("execenv", ((DvThread)vector2.elementAt(n)).eeAddress(), as);
                    cTypeObject = cTypeObject2.getField("sys_thr");
                    l6 = cTypeObject.getAddr();
                    if (l3 == l6) {
                        bl2 = true;
                        try {
                            string2 = string2 + "\"" + this.getThreadName((DvThread)vector2.elementAt(n), as) + "\" (0x" + Long.toHexString(l3) + ") ";
                        }
                        catch (DvAddressException dvAddressException) {
                            DvUtils.trace("Continue:1 DvObjectsCommands.monitorDumpInfo(String,long,long,long,long) DvAddressException when getting Thread Name", 0, false);
                        }
                    }
                    ++n;
                }
                if (!bl2) {
                    string2 = string2 + "<unknown thread> (0x" + Long.toHexString(l3) + ")";
                }
                long l7 = this.getControlBlockField("sys_mon", "entry_count", l2, as);
                string2 = string2 + "entry count " + l7;
            } else {
                string2 = objectDetails.lock && 0L == objectDetails.shapeBit ? string2 + " flat locked by thread ident " + objectDetails.threadId + ", entry count " + objectDetails.entryCount + " " : string2 + " <unowned>";
            }
            if (bl) {
                vector.addElement("3LKMONOBJECT");
                vector.addElement(string2);
            } else {
                theOutput.add(string2);
            }
            string2 = "";
            if (DvUtils.checkAddressInDump(as.createAddress(l4), as) && 0L != l4) {
                if (bl) {
                    vector.addElement("3LKNOTIFYQ");
                    vector.addElement("       Waiting to be notified:");
                } else {
                    theOutput.add("                 Waiting to be notified:");
                }
                bl2 = false;
                vector2 = this.getThreads();
                n = 0;
                while (n < vector2.size()) {
                    CTypeObject cTypeObject3 = new CTypeObject("execenv", ((DvThread)vector2.elementAt(n)).eeAddress(), as);
                    cTypeObject = cTypeObject3.getField("sys_thr");
                    l6 = cTypeObject.getAddr();
                    if (l4 == l6) {
                        bl2 = true;
                        try {
                            if (bl) {
                                vector.addElement("3LKWAITNOTIFY");
                                vector.addElement("          \"" + this.getThreadName((DvThread)vector2.elementAt(n), as) + "\" (0x" + Long.toHexString(l6) + ")");
                            } else {
                                theOutput.add("                    \"" + this.getThreadName((DvThread)vector2.elementAt(n), as) + "\" (0x" + Long.toHexString(l6) + ")");
                            }
                        }
                        catch (DvAddressException dvAddressException) {
                            DvUtils.trace("Continue:2 DvObjectsCommands.monitorDumpInfo(String,long,long,long,long) DvAddressException when getting Thread Name", 0, false);
                        }
                    }
                    ++n;
                }
                if (!bl2) {
                    if (bl) {
                        vector.addElement("3LKWAITNOTIFY");
                        vector.addElement("                 <unknown thread> (0x" + Long.toHexString(l2) + ")");
                    } else {
                        theOutput.add("                 <unknown thread> (0x" + Long.toHexString(l2) + ")");
                    }
                }
            }
        } else if (bl) {
            vector.addElement("3LKWAITNOTIFY");
            vector.addElement("    unknown object at: 0x" + (l5 - (long)ptrLength));
        } else {
            theOutput.add("    unknown object at: 0x" + (l5 - (long)ptrLength));
        }
        if (!bl) {
            theOutput.add("");
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.monitorDumpInfo(String,long,long,long,long)", 0, false);
        return vector;
    }

    private Vector displaySysMonitorDump(String string) {
        long l;
        long l2;
        DvUtils.trace("Entry:DvObjectsCommands.displaySysMonitorDump", 0, false);
        Vector vector = new Vector();
        boolean bl = false;
        if (string.equals(new String("javacore"))) {
            bl = true;
        }
        long l3 = 0L;
        String string2 = "";
        String string3 = "";
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        try {
            long l4 = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
            l2 = this.getControlBlockField("_lkgldata", "reg", l4, as);
            l = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? as.readLong(as.createAddress(l2)) : (long)as.readInt(as.createAddress(l2));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("Exit:1 DvObjectsCommands.displaySysMonitorDump DvAddressException in displaySysMonitorDump Unable to get the first reg_mon", 0, false);
            return vector;
        }
        if (bl) {
            vector.addElement("1LKREGMONDUMP");
            vector.addElement("JVM System Monitor Dump (registered monitors): ");
        } else {
            theOutput.add("");
            theOutput.add("JVM System Monitor Dump (registered monitors): ");
        }
        if (!bl) {
            theOutput.add(" Pointer to first registry monitor (0x" + Long.toHexString(l2) + " remember Endianness!!");
            theOutput.add(" display memory(0x" + Long.toHexString(l2) + ")");
            theOutput.add("");
            theOutput.add(" First registry monitor at:");
        }
        while (DvUtils.checkAddressInDump(as.createAddress(l), as)) {
            String string4 = "";
            long l5 = this.getControlBlockField("reg_mon", "name", l, as);
            try {
                string2 = DvUtils.getStringFromBytes(as.readBytes(as.createAddress(l5), 256L));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Exit:2 DvObjectsCommands.displaySysMonitorDump DvAddressException nameValue", 0, false);
            }
            string4 = string4 + "    " + string2;
            long l6 = this.getControlBlockField("reg_mon", "mid", l, as);
            long l7 = this.getControlBlockField("sys_mon", "monitor_owner", l6, as);
            long l8 = 0L;
            int n = this.theDump.getSystemType();
            switch (n) {
                case -1: {
                    if (unknownSystem) break;
                    unknownSystem = true;
                    if (bl) {
                        vector.addElement("NULL");
                        vector.addElement("Error SYSTEM IS UNKNOWN (" + n + ")");
                        break;
                    }
                    theOutput.add("Error SYSTEM IS UNKNOWN (" + n + ")");
                    break;
                }
                case 1: {
                    l8 = this.getControlBlockField("sys_mon", "monitor_waiter", l6, as);
                    break;
                }
                case 4: {
                    l8 = this.getControlBlockField("sys_mon", "mwait_queue", "head", l6, as);
                    break;
                }
                case 2: {
                    l8 = this.getControlBlockField("sys_mon", "mwait_queue", "head", l6, as);
                    break;
                }
                case 3: {
                    l8 = this.getControlBlockField("sys_mon", "mwait_queue", "head", l6, as);
                    break;
                }
                default: {
                    if (unknownSystem) break;
                    unknownSystem = true;
                    if (bl) {
                        vector.addElement("NULL");
                        vector.addElement("Error SYSTEM IS UNKNOWN (" + n + ")");
                        break;
                    }
                    theOutput.add("Error SYSTEM IS UNKNOWN (" + n + ")");
                }
            }
            if (DvUtils.checkAddressInDump(as.createAddress(l7), as) && 0L != l7) {
                long l9;
                boolean bl2 = false;
                Vector vector2 = this.getThreads();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    CTypeObject cTypeObject = new CTypeObject("execenv", ((DvThread)vector2.elementAt(n2)).eeAddress(), as);
                    CTypeObject cTypeObject2 = cTypeObject.getField("sys_thr");
                    long l10 = cTypeObject2.getAddr();
                    if (l7 == l10) {
                        bl2 = true;
                        try {
                            string4 = string4 + ":owner \"" + this.getThreadName((DvThread)vector2.elementAt(n2), as) + "\" (0x" + Long.toHexString(l6) + ")";
                        }
                        catch (DvAddressException dvAddressException) {
                            DvUtils.trace("Continue:1 DvObjectsCommands.displaySysMonitorDump(String) DvAddressException getThreadName", 0, false);
                        }
                    }
                    ++n2;
                }
                if (!bl2) {
                    string4 = string4 + "<unknown thread> (0x" + Long.toHexString(l6) + ")";
                }
                if (DvUtils.checkAddressInDump(as.createAddress(l9 = this.getControlBlockField("sys_mon", "entry_count", l6, as)), as)) {
                    try {
                        l3 = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? as.readLong(as.createAddress(l9)) : (long)as.readInt(as.createAddress(l9));
                    }
                    catch (DvAddressException dvAddressException) {
                        DvUtils.trace("Exit:3 DvObjectsCommands.displaySysMonitorDump DvAddressException entryCountValue", 0, false);
                    }
                }
                if (bl) {
                    vector.addElement("2LKREGMON");
                    vector.addElement(string4 + ", entry count " + l3);
                } else {
                    theOutput.add(string4 + ", entry count " + l3);
                    theOutput.add("  format 0x" + Long.toHexString(l) + " as reg_mon");
                    theOutput.add("");
                }
                string4 = "";
            } else if (bl) {
                vector.addElement("2LKREGMON");
                vector.addElement("    " + string2 + ": <unowned>");
            } else {
                theOutput.add("    " + string2 + ": <unowned>");
                theOutput.add("  format 0x" + Long.toHexString(l) + " as reg_mon");
                theOutput.add("");
            }
            if (DvUtils.checkAddressInDump(as.createAddress(l8), as)) {
                if (bl) {
                    vector.addElement("3LKNOTIFYQ");
                    vector.addElement("       Waiting to be notified:");
                } else {
                    theOutput.add("                 Waiting to be notified:");
                }
                Vector vector3 = this.getThreads();
                while (0L != l8) {
                    int n3 = 0;
                    while (n3 < vector3.size()) {
                        CTypeObject cTypeObject = new CTypeObject("execenv", ((DvThread)vector3.elementAt(n3)).eeAddress(), as);
                        CTypeObject cTypeObject3 = cTypeObject.getField("sys_thr");
                        long l11 = cTypeObject3.getAddr();
                        if (l8 == l11) {
                            try {
                                if (bl) {
                                    vector.addElement("3LKWAITNOTIFY");
                                    vector.addElement("          \"" + this.getThreadName((DvThread)vector3.elementAt(n3), as) + "\" (0x" + Long.toHexString(l11) + ")");
                                } else {
                                    theOutput.add("                    \"" + this.getThreadName((DvThread)vector3.elementAt(n3), as) + "\" (0x" + Long.toHexString(l11) + ")");
                                }
                            }
                            catch (DvAddressException dvAddressException) {
                                DvUtils.trace("Exit:4 DvObjectsCommands.displaySysMonitorDump DvAddressException getThreadName", 0, false);
                            }
                        }
                        ++n3;
                    }
                    l8 = this.getControlBlockField("sys_thread", "next_waiter", l8, as);
                }
            }
            if (!bl) {
                theOutput.add("");
            }
            l = this.getControlBlockField("reg_mon", "next", l, as);
        }
        if (bl) {
            vector.addElement("NULL");
            vector.addElement("");
        } else {
            theOutput.add("");
        }
        DvUtils.trace("Exit:5 DvObjectsCommands.displaySysMonitorDump", 0, false);
        return vector;
    }

    private Vector displayThreadIdent(String string) {
        DvUtils.trace("Entry:DvObjectsCommands.displayThreadIdent", 0, false);
        Vector vector = new Vector();
        boolean bl = false;
        if (string.equals(new String("javacore"))) {
            bl = true;
        }
        if (bl) {
            vector.addElement("1LKFLATMONDUMP");
            vector.addElement("Thread identifiers (as used in flat monitors)");
        } else {
            theOutput.add("");
            theOutput.add("Thread identifiers (as used in flat monitors)");
            theOutput.add("");
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        DvAddress dvAddress = null;
        DvProcess[] dvProcessArray = as.getProcesses();
        int n = 0;
        while (n < dvProcessArray.length) {
            DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
            int n2 = 0;
            while (n2 < dvThreadArray.length) {
                if (dvThreadArray[n2].isJava()) {
                    CTypeObject cTypeObject = new CTypeObject("execenv", dvThreadArray[n2].eeAddress(), as);
                    if (cTypeObject == null || as == null || dvThreadArray[n2] == null) {
                        DvUtils.trace("Exit:1 DvObjectsCommands.displayThreadIdent unexpected NULL variable", 0, false);
                        return vector;
                    }
                    if (dvThreadArray[n2].eeAddress().getAddressAsLong() == 0L) {
                        DvUtils.trace("Exit:2 DvObjectsCommands.displayThreadIdent", 0, false);
                        return vector;
                    }
                    CTypeObject cTypeObject2 = null;
                    cTypeObject2 = cTypeObject.getField("lk_thread_local.lk.flc");
                    CTypeObject cTypeObject3 = cTypeObject2.getField("thread_ident");
                    if (cTypeObject3 == null) {
                        DvUtils.trace("Continue:1 DvObjectsCommands.displayThreadIdent unexpected NULL variable", 0, false);
                    } else {
                        try {
                            dvAddress = as.readPointer(as.createAddress(cTypeObject3.getAddr()));
                        }
                        catch (DvAddressException dvAddressException) {
                            DvUtils.trace("Continue:2 DvObjectsCommands.displayThreadIdent(String) DvAddressException getThreadName", 0, false);
                        }
                        long l = dvAddress.getAddressAsLong();
                        if (l != 0L) {
                            String string2 = "";
                            try {
                                string2 = this.getThreadName(dvThreadArray[n2], as);
                            }
                            catch (DvAddressException dvAddressException) {
                                DvUtils.trace("Continue:3 DvObjectsCommands.displayThreadIdent(String) DvAddressException getThreadName", 0, false);
                            }
                            CTypeObject cTypeObject4 = cTypeObject.getField("sys_thr");
                            if (bl) {
                                vector.addElement("2LKFLATMON");
                                vector.addElement("    ident 0x" + Long.toHexString(l >> 16) + " \"" + string2 + "\" (0x" + Long.toHexString(cTypeObject4.getAddr()) + ") " + "ee 0x" + Long.toHexString(cTypeObject.getAddr()));
                            } else {
                                theOutput.add("    ident 0x" + Long.toHexString(l >> 16) + " \"" + string2 + "\"");
                                theOutput.add("        format 0x" + Long.toHexString(cTypeObject4.getAddr()) + " as sys_thr" + "\t\tformat 0x" + Long.toHexString(cTypeObject.getAddr()) + " as execenv");
                                theOutput.add("");
                            }
                        }
                    }
                } else {
                    DvUtils.trace("Continue:4 DvObjectsCommands.displayThreadIdent non-Java thread", 0, false);
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            vector.addElement("NULL");
            vector.addElement("");
        } else {
            theOutput.add("");
        }
        this.returnControl();
        DvUtils.trace("Exit:3 DvObjectsCommands.displayThreadIdent unexpected exception", 0, false);
        return vector;
    }

    private Vector displayJavaObjMonDump(String string) {
        DvUtils.trace("Entry:DvObjectsCommands.displayJavaObjMonDump(String)", 0, false);
        Vector vector = new Vector();
        boolean bl = false;
        if (string.equals(new String("javacore"))) {
            bl = true;
        }
        if (bl) {
            vector.addElement("1LKOBJMONDUMP");
            vector.addElement("Java Object Monitor Dump (flat & inflated object-monitors):");
        } else {
            theOutput.add("");
            theOutput.add("Java Object Monitor Dump (flat & inflated object-monitors):");
        }
        int n = lockedObjects.size();
        int n2 = 0;
        while (n2 < n) {
            long l = (Long)lockedObjects.get(n2);
            ObjectDetails objectDetails = this.getObjectDetails(l);
            if (0L == objectDetails.shapeBit) {
                if (bl) {
                    vector.addElement("2LKINFLATEDMON");
                    vector.addElement("    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L));
                } else {
                    theOutput.add("    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L));
                }
                if (bl) {
                    vector.addElement("3LKINFLDETAILS");
                    vector.addElement("        locknflags " + Long.toHexString(objectDetails.locknflags) + " flat locked by thread ident " + objectDetails.threadId + ", entry count " + objectDetails.entryCount);
                } else {
                    theOutput.add("        locknflags " + Long.toHexString(objectDetails.locknflags) + " flat locked by thread ident " + objectDetails.threadId + ", entry count " + objectDetails.entryCount);
                    theOutput.add("");
                }
            } else if (bl) {
                vector.addElement("2LKINFLATEDMON");
                vector.addElement("    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L));
                vector.addElement("3LKINFLDETAILS");
                vector.addElement("        locknflags " + Long.toHexString(objectDetails.locknflags) + " Monitor inflated infl_mon 0x" + Long.toHexString(objectDetails.inflMon));
            } else {
                theOutput.add("    " + objectDetails.objectName + "@" + Long.toHexString(objectDetails.address) + "/" + Long.toHexString(objectDetails.address + 8L));
                theOutput.add("        locknflags " + Long.toHexString(objectDetails.locknflags) + " Monitor inflated infl_mon 0x" + Long.toHexString(objectDetails.inflMon));
                theOutput.add("");
            }
            ++n2;
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.displayJavaObjMonDump(String)", 0, false);
        return vector;
    }

    private Vector getThreads() {
        DvUtils.trace("Entry:DvObjectsCommands.getThreads", 0, false);
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        Vector vector = new Vector();
        Object var3_3 = null;
        try {
            DvProcess[] dvProcessArray = as.getProcesses();
            int n = 0;
            while (n < dvProcessArray.length) {
                DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
                int n2 = 0;
                while (n2 < dvThreadArray.length) {
                    if (dvThreadArray[n2].isJava()) {
                        vector.addElement(dvThreadArray[n2]);
                    } else {
                        DvUtils.trace("Continue:1 DvObjectsCommands.getThreads non-Java thread", 0, false);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DvUtils.trace("Exit:1 DvObjectsCommands.getThreads unexpected exception", 0, false);
        }
        DvUtils.trace("Exit:2 DvObjectsCommands.getThreads", 0, false);
        return vector;
    }

    private String getThreadName(DvThread dvThread, DvAddressSpace dvAddressSpace) throws DvAddressException {
        DvUtils.trace("Entry:DvObjectsCommands.getThreadName(DvThread, DvAddressSpace)", 0, false);
        long l = this.getControlBlockField("execenv", "thread", dvThread.eeAddress().getAddressAsLong(), dvAddressSpace);
        String string = "";
        try {
            string = this.getThreadName(l, dvAddressSpace);
        }
        catch (DvAddressException dvAddressException) {
            throw new DvAddressException("DvAddressException in getThreadName");
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.getThreadName(DvThread, DvAddressSpace)", 0, false);
        return string;
    }

    private String getThreadName(long l, DvAddressSpace dvAddressSpace) throws DvAddressException {
        DvUtils.trace("Entry:DvObjectsCommands.getThreadName(long, DvAddressSpace)", 0, false);
        long l2 = this.getControlBlockField("Hjava_lang_Thread", "obj", "name", l, dvAddressSpace);
        CTypeObject cTypeObject = new CTypeObject("Hjava_lang_Object", dvAddressSpace.createAddress(l2), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField("obj");
        CTypeObject cTypeObject3 = cTypeObject.getField("methods");
        long l3 = 0L;
        try {
            l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("Exit:1 DvObjectsCommands.getThreadName(long, DvAddressSpace) throw(DvAddressException in getThreadName)", 0, false);
            throw new DvAddressException("DvAddressException in getThreadName");
        }
        String string = "";
        if (l3 > 0L) {
            byte[] byArray = null;
            try {
                byArray = dvAddressSpace.readBytes(dvAddressSpace.createAddress(cTypeObject2.getAddr()), l3 * 2L);
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Exit:2 DvObjectsCommands.getThreadName(long, DvAddressSpace) throw(DvAddressException in getThreadName)", 0, false);
                throw new DvAddressException("DvAddressException in getThreadName");
            }
            byte[] byArray2 = new byte[byArray.length / 2];
            int n = 0;
            while (n < byArray2.length) {
                byArray2[n] = false == DvUtils.isBigEndian(this.theDump.getArchitecture()) ? byArray[2 * n] : byArray[2 * n + 1];
                ++n;
            }
            try {
                string = new String(byArray2, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                DvUtils.writetoTrace("DvObjectsCommands:getThreadName - UnsupportedEncodingException");
            }
        } else {
            DvUtils.trace("Exit:3 DvObjectsCommands.getThreadName(long, DvAddressSpace) throw(DvAddressException in getThreadName)", 0, false);
            throw new DvAddressException("DvAddressException in getThreadName");
        }
        DvUtils.trace("Exit:4 DvObjectsCommands.getThreadName(long, DvAddressSpace)", 0, false);
        return string;
    }

    private long getControlBlockField(String string, String string2, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.trace("Entry:DvObjectsCommands.getControlBlockField", 0, false);
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField(string2);
        DvAddress dvAddress = null;
        try {
            dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject2.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in getControlBlockField");
            DvUtils.trace("Exit:1 DvObjectsCommands.getControlBlockField", 0, false);
            this.returnControl();
        }
        DvUtils.trace("Exit:2 DvObjectsCommands.getControlBlockField", 0, false);
        return dvAddress.getAddressAsLong();
    }

    private long getControlBlockField(String string, String string2, String string3, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.trace("Entry:DvObjectsCommands.getControlBlockField", 0, false);
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField(string2);
        CTypeObject cTypeObject3 = cTypeObject2.getField(string3);
        DvAddress dvAddress = null;
        try {
            dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in getControlBlockField");
            DvUtils.trace("Exit:1 DvObjectsCommands.getControlBlockField", 0, false);
            this.returnControl();
        }
        DvUtils.trace("Exit:2 DvObjectsCommands.getControlBlockField", 0, false);
        return dvAddress.getAddressAsLong();
    }

    public boolean displayObject(long l) throws DvAddressException {
        DvUtils.trace("Entry:DvObjectsCommands.displayObject(long)", 0, false);
        if (null == this.theDump) {
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.displayObject(long) throw(Unable to comply as no Dump opened yet)", 0, false);
            throw new DvAddressException("Unable to comply as no Dump opened yet");
        }
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
            this.returnControl();
            DvUtils.trace("Exit:2 DvObjectsCommands.displayObject(long) throw(Unable to comply as not a valid address)", 0, false);
            throw new DvAddressException("Unable to comply as not a valid address");
        }
        if (this.checkForKnownObject(l - (long)ptrLength)) {
            ObjectDetails objectDetails = this.getObjectDetails(l - (long)ptrLength);
            this.showObjects(objectDetails);
        } else {
            theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
        }
        this.returnControl();
        DvUtils.trace("Exit:3 DvObjectsCommands.displayObject(long)", 0, false);
        return false;
    }

    public boolean displayObject(String string) throws DvAddressException {
        long[] lArray;
        DvUtils.trace("Entry:DvObjectsCommands.displayObject(String)", 0, false);
        if (null == this.theDump) {
            this.returnControl();
            throw new DvAddressException("Unable to comply as no Dump opened yet");
        }
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        if (null != (lArray = namesIndexFile.getInstancesForClass(string))) {
            int n = 0;
            if (n < lArray.length) {
                ObjectDetails objectDetails = this.getObjectDetails(lArray[n]);
                this.showObjects(objectDetails);
                this.returnControl();
                DvUtils.trace("Exit:1 DvObjectsCommands.displayObject(String)", 0, false);
                return true;
            }
        }
        this.returnControl();
        DvUtils.trace("Exit:2 DvObjectsCommands.displayObject(String)", 0, false);
        return false;
    }

    public void displayLockedObjects() {
        String string;
        Object object;
        DvUtils.trace("Entry:DvObjectsCommands.displayLockedObjects()", 0, false);
        boolean bl = false;
        Vector vector = new Vector();
        if (null == this.theDump) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.displayLockedObjects()", 0, false);
            return;
        }
        this.initPtrLength();
        is64bit = DvUtils.is64BitSystem(this.theDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(this.theDump.getArchitecture());
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (null != this.paramString) {
            try {
                if (this.paramString.charAt(0) == '0' && (this.paramString.charAt(1) == 'x' || this.paramString.charAt(1) == 'X')) {
                    long l = Long.parseLong(this.paramString.substring(2), 16);
                    if (!DvUtils.checkAddressInDump(as.createAddress(l), as)) {
                        theOutput.add("Not a valid address");
                        this.returnControl();
                        DvUtils.trace("Exit:2 DvObjectsCommands.displayLockedObjects()", 0, false);
                        return;
                    }
                    if (!heapsTraversed) {
                        this.traverseAllHeaps();
                    }
                    if (this.checkForKnownObject(l - (long)ptrLength)) {
                        ObjectDetails objectDetails = this.getObjectDetails(l - (long)ptrLength);
                        if (objectDetails.lock) {
                            this.showLocks(objectDetails);
                        } else {
                            theOutput.add("Object is not locked");
                        }
                    } else {
                        theOutput.add("@ 0x" + Long.toHexString(l) + " not the start of an object in the heap");
                    }
                    this.returnControl();
                    DvUtils.trace("Exit:3 DvObjectsCommands.displayLockedObjects()", 0, false);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                theOutput.add("The address is not valid hex");
                this.returnControl();
                DvUtils.trace("Exit:4 DvObjectsCommands.displayLockedObjects() the address is not valid hex", 0, false);
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                theOutput.add("The address is not valid          StringIndexOutOfBoundsException:");
                this.returnControl();
                DvUtils.trace("Exit:5 DvObjectsCommands.displayLockedObjects() StringIndexOutOfBoundsException: The address is not valid", 0, false);
                return;
            }
            if (Character.isDigit(this.paramString.charAt(0))) {
                theOutput.add("Object names must start with letter");
                this.returnControl();
                DvUtils.trace("Exit:6 DvObjectsCommands.displayLockedObjects() Object names must start with letter", 0, false);
                return;
            }
            object = new StringTokenizer(this.paramString, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("*") || string.endsWith("*") || string.startsWith("!")) {
                    bl = true;
                }
                vector.add(string);
            }
        }
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (!heapsTraversed) {
            this.traverseAllHeaps();
        }
        if (vector.size() > 0 && !bl) {
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.get(n);
                int n2 = 0;
                while (n2 < lockedObjects.size()) {
                    long l = (Long)lockedObjects.get(n2);
                    ObjectDetails objectDetails = this.getObjectDetails(l);
                    if (string.equals(objectDetails.objectName)) {
                        this.showLocks(objectDetails);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            object = namesIndexFile.getAllClassNames();
            int n = 0;
            while (n < ((Vector)object).size()) {
                String string2 = (String)((Vector)object).get(n);
                boolean bl2 = true;
                if (0 != vector.size()) {
                    bl2 = DvUtils.filtrate(string2, vector);
                }
                if (bl2) {
                    int n3 = 0;
                    while (n3 < lockedObjects.size()) {
                        long l = (Long)lockedObjects.get(n3);
                        ObjectDetails objectDetails = this.getObjectDetails(l);
                        if (string2.equals(objectDetails.objectName)) {
                            this.showLocks(objectDetails);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
        this.returnControl();
        DvUtils.trace("Exit:7 DvObjectsCommands.displayLockedObjects()", 0, false);
    }

    public static Vector lkDumpRoutine() {
        DvUtils.trace("Entry:DvObjectsCommands.lkDumpRoutine()", 0, false);
        Vector vector = new Vector();
        DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
        vector.addAll(dvObjectsCommands.displayMonitorPoolInfo("javacore"));
        if (1 == dvObjectsCommands.checkLKGLOBALPTR()) {
            vector.addAll(dvObjectsCommands.displayMonitorPoolDump("javacore"));
        } else {
            DvUtils.trace("Continue:1 DvObjectsCommands.lkDumpRoutine() No locking global pointer displayMonitorPoolDump(\"dis ls\")", 0, false);
        }
        if (1 == dvObjectsCommands.checkLKGLOBALPTR()) {
            vector.addAll(dvObjectsCommands.displaySysMonitorDump("javacore"));
        } else {
            DvUtils.trace("Continue:2 DvObjectsCommands.lkDumpRoutine() No locking global pointer displaySysMonitorDump(\"dis ls\")", 0, false);
        }
        vector.addAll(dvObjectsCommands.displayThreadIdent("javacore"));
        vector.addAll(dvObjectsCommands.displayJavaObjMonDump("javacore"));
        DvUtils.trace("Exit:1 DvObjectsCommands.lkDumpRoutine()", 0, false);
        return vector;
    }

    private void showObjects(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.showObjects(ObjectDetails)", 0, false);
        theOutput.add(oSeperator);
        theOutput.add(objectDetails);
        if (null != objectDetails) {
            theOutput.add(DvClassCommands.getInstanceValues(objectDetails.address, objectDetails.objectName, this.theDump, theOutput));
        } else {
            theOutput.add(" ---- Null or invalid object ---- ");
        }
        this.cpr.output(theOutput);
        theOutput.clear();
        DvUtils.trace("Exit:1 DvObjectsCommands.showObjects(ObjectDetails)", 0, false);
    }

    private void showLocks(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.showLocks(ObjectDetails)", 0, false);
        String string = "";
        if (null != objectDetails.className) {
            string = objectDetails.className;
        }
        if (objectDetails.lock) {
            if (0L == objectDetails.shapeBit) {
                theOutput.add("\n" + objectDetails.objectName + " @ 0x" + Long.toHexString(objectDetails.address) + " \n" + string + "          type:" + objectDetails.type + " (Flat) Entry Count: " + objectDetails.entryCount + " Thread Id: " + objectDetails.threadId);
            } else {
                theOutput.add("\n" + objectDetails.objectName + " @ 0x" + Long.toHexString(objectDetails.address) + " \n" + string + "          type:" + objectDetails.type + " (Inflated) Monitor Index: " + objectDetails.monitorIndex);
                this.showMonitor(objectDetails);
            }
        } else {
            theOutput.add("@ 0x" + Long.toHexString(objectDetails.address) + " (" + objectDetails.objectName + ") " + string + "          type:" + objectDetails.type);
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.showLocks(ObjectDetails)", 0, false);
    }

    private void showMonitor(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.showMonitor(ObjectDetails)", 0, false);
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        long l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        long l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.showMonitor(ObjectDetails) no lk dataP in facade", 0, false);
            return;
        }
        try {
            CTypeObject cTypeObject = DvUtils.formatAddrAsType(as, as.createAddress(objectDetails.inflMon), "infl_mon");
            theOutput.add(cTypeObject);
            long l3 = this.getControlBlockField("infl_mon", "_sysmon", objectDetails.inflMon, as);
            CTypeObject cTypeObject2 = DvUtils.formatAddrAsType(as, as.createAddress(l3), "sys_mon");
            theOutput.add("_sysmon");
            theOutput.add(cTypeObject2);
        }
        catch (NumberFormatException numberFormatException) {
            this.returnControl();
            DvUtils.trace("Exit:2 DvObjectsCommands.showMonitor(ObjectDetails) Possible problem with hints", 0, false);
            return;
        }
    }

    private void traverseAllHeaps() {
        DvUtils.trace("Entry:DvObjectsCommands.traverseAllHeaps()", 0, false);
        if (null == namesIndexFile) {
            this.openNamesIndexFile();
        }
        totalObjectCount = 0;
        totalLockedObjectCount = 0;
        this.traverseEveryTLH();
        this.traverseMiddlewareHeap();
        this.traverseTransientHeap();
        this.traverseSystemHeaps();
        this.traverseACSHeap();
        heapsTraversed = true;
        names_index_built = true;
        address_index_built = true;
        DvUtils.trace("Exit:1 DvObjectsCommands.traverseAllHeaps()", 0, false);
    }

    private void traverseMiddlewareHeap() {
        DvUtils.trace("Entry:DvObjectsCommands.traverseMiddlewareHeap()", 0, false);
        int n = 0;
        theOutput.add("Traversing the Middleware heap\n");
        this.cpr.output(theOutput);
        theOutput.clear();
        startOfMHeap = Long.parseLong(DvUtils.getJVMHint(as, "CURHEAPMIN"), 16);
        endOfMHeap = Long.parseLong(DvUtils.getJVMHint(as, "CURHEAPMAX"), 16);
        middlewareH = n = this.traverseHeap(startOfMHeap, endOfMHeap, Long.parseLong(DvUtils.getJVMHint(as, "MH_HEAPBASE"), 16), "Mid", (short)-1);
        DvUtils.trace("Exit:1 DvObjectsCommands.traverseMiddlewareHeap()", 0, false);
    }

    private void traverseTransientHeap() {
        DvUtils.trace("Entry:DvObjectsCommands.traverseTransientHeap()", 0, false);
        int n = 0;
        theOutput.add("Traversing the transient heap \n");
        this.cpr.output(theOutput);
        theOutput.clear();
        startOfTransHeap = DvUtils.hexToLong(DvUtils.getJVMHint(as, "TH_HEAPBASE"));
        endOfTransHeap = DvUtils.hexToLong(DvUtils.getJVMHint(as, "TH_HEAPLIMIT"));
        transientH = n = this.traverseHeap(startOfTransHeap, endOfTransHeap, DvUtils.hexToLong(DvUtils.getJVMHint(as, "MH_HEAPBASE")), "Tra", (short)-3);
        DvUtils.trace("Exit:1 DvObjectsCommands.traverseTransientHeap()", 0, false);
    }

    private void traverseSystemHeaps() {
        Object object;
        long l;
        long l2;
        DvUtils.trace("Entry:DvObjectsCommands.traverseSystemHeaps()", 0, false);
        int n = 0;
        int n2 = 0;
        theOutput.add("Traversing the system heaps \n");
        this.cpr.output(theOutput);
        theOutput.clear();
        Vector vector = new Vector();
        int n3 = 0;
        if (null != rangeArray) {
            n3 = rangeArray.length;
            int n4 = 0;
            while (n4 < rangeArray.length) {
                vector.add(new Range(rangeArray[n4][0], rangeArray[n4][1], rangeArray[n4][2]));
                ++n4;
            }
        }
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        DvAddress dvAddress = dvAddressSpace.createAddress(DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "STGLOBALPTR")));
        DvAddress dvAddress2 = dvAddressSpace.createAddress(0L);
        long l3 = DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPBASE"));
        long l4 = this.getControlBlockField("STGlobal", "st_jab", dvAddress.getAddressAsLong(), dvAddressSpace);
        dvAddress2 = dvAddressSpace.createAddress(this.getControlBlockField("StorageJab", "system_heap_this_extent", l4, dvAddressSpace));
        if (DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            l2 = this.getControlBlockField("heap_extent_info", "base", dvAddress2.getAddressAsLong(), dvAddressSpace);
            l = this.getControlBlockField("StorageJab", "system_heap_next", l4, dvAddressSpace);
            object = new Range(l2, l, -1L);
            vector.add(object);
            n += this.traverseHeap(l2, l, l3, "Sys " + n2, (short)(-4 - n2));
            ++n2;
        }
        dvAddress2 = dvAddressSpace.createAddress(this.getControlBlockField("heap_extent_info", "prev", dvAddress2.getAddressAsLong(), dvAddressSpace));
        while (DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            l2 = this.getControlBlockField("heap_extent_info", "base", dvAddress2.getAddressAsLong(), dvAddressSpace);
            l = this.getControlBlockField("heap_extent_info", "limit", dvAddress2.getAddressAsLong(), dvAddressSpace);
            object = new Range(l2, l, -1L);
            vector.add(object);
            n += this.traverseHeap(l2, l, l3, "Sys " + n2, (short)(-4 - n2));
            ++n2;
            dvAddress2 = dvAddressSpace.createAddress(this.getControlBlockField("heap_extent_info", "prev", dvAddress2.getAddressAsLong(), dvAddressSpace));
        }
        object = this.sortRanges(vector);
        if (null != object) {
            int n5 = vector.size();
            rangeArray = new long[n5][3];
            int n6 = 0;
            while (n6 < n5) {
                Range range = (Range)vector.get(object[n6]);
                DvObjectsCommands.rangeArray[n6][0] = range.start;
                DvObjectsCommands.rangeArray[n6][1] = range.end;
                DvObjectsCommands.rangeArray[n6][2] = range.index;
                ++n6;
            }
        }
        systemH = n;
        DvUtils.trace("Exit:1 DvObjectsCommands.traverseSystemHeaps()", 0, false);
    }

    private void traverseACSHeap() {
        DvUtils.trace("Entry:DvObjectsCommands.traverseACSHeap()", 0, false);
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        DvThread dvThread = (DvThread)DvUtils.getAPT(this.theDump, "T");
        int n = 0;
        int n2 = 0;
        theOutput.add("Traversing the ACS heaps \n");
        this.cpr.output(theOutput);
        theOutput.clear();
        DvAddress dvAddress = dvAddressSpace.createAddress(DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "LOADEDACSCLASSES")));
        if (0L == dvAddress.getAddressAsLong()) {
            theOutput.add("No ACSClasses");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.traverseACSHeap() No ACSClasses", 0, false);
            return;
        }
        theOutput.add("The ACS Classes Traverser has not been fully tested and may break after this point");
        DvAddress dvAddress2 = dvAddress;
        while (DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            int n3 = this.theDump.getArchitecture();
            DvAddressSpace dvAddressSpace2 = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = dvAddress2.getAddressAsLong();
            try {
                if (is64bit) {
                    l2 = dvAddressSpace2.readLong(dvAddressSpace2.createAddress(l6));
                    l2 &= 0x3FFFFFFFFFFFFFF8L;
                } else {
                    l2 = dvAddressSpace2.readInt(dvAddressSpace2.createAddress(l6));
                    l2 &= 0x3FFFFFF8L;
                }
            }
            catch (DvAddressException dvAddressException) {
                this.returnControl();
                DvUtils.trace("Exit:2 DvObjectsCommands.traverseACSHeap() DvAddressException", 0, false);
                return;
            }
            this.processFoundObject(l6, false, (short)-2, l2);
            if (++n2 >= n + 5000) {
                this.cpr.output("\t" + DvUtils.getTime() + " " + n2 + " objects processed...");
                n = n2;
            }
            try {
                long l7;
                long l8;
                long l9 = DvUtils.getFieldAddress(dvAddress2.getAddressAsLong(), new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                long l10 = this.getControlBlockField("Classjava_lang_Class", "shared_class_id", l9, dvAddressSpace);
                if (0L == l10) {
                    l8 = this.getControlBlockField("Classjava_lang_Class", "mirrored_data", l9, dvAddressSpace);
                    l7 = this.getControlBlockField("Classjava_lang_Class", "mirrored_table", l8, dvAddressSpace);
                    dvAddress2 = dvAddressSpace2.createAddress(l7);
                    continue;
                }
                if (null != dvThread) {
                    l8 = DvUtils.getFieldAddress(dvThread.eeAddress().getAddressAsLong(), new String[]{"execenv", "cl_thread_local"}, dvAddressSpace);
                    l7 = this.getControlBlockField("ClThreadLocalData", "class_mirrors", l8, dvAddressSpace);
                    long l11 = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? l7 + l10 * 8L : l7 + l10 * 4L;
                    l9 = DvUtils.getFieldAddress(l11, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                    long l12 = this.getControlBlockField("Classjava_lang_Class", "mirrored_data", l9, dvAddressSpace);
                    long l13 = this.getControlBlockField("Classjava_lang_Class", "memory_table", l12, dvAddressSpace);
                    dvAddress2 = dvAddressSpace2.createAddress(l13);
                    continue;
                }
                theOutput.add("thread is null");
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Continue:1 DvObjectsCommands.traverseACSHeap() DvAddressException", 0, false);
            }
        }
        acsH = n2;
        DvUtils.trace("Exit:3 DvObjectsCommands.traverseACSHeap()", 0, false);
    }

    private int traverseHeap(long l, long l2, long l3, String string, short s) {
        DvUtils.trace("Entry:DvObjectsCommands.traverseHeap()", 0, false);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (null == this.theDump) {
            theOutput.add("Unable to comply - no dump accessed");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.traverseHeap() no dump accessed", 0, false);
            return n;
        }
        int n3 = this.theDump.getArchitecture();
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l), dvAddressSpace) || l == l2) {
            theOutput.add("Event traverseHeap min value not in dump");
            this.returnControl();
            DvUtils.trace("Exit:2 DvObjectsCommands.traverseHeap() error with min=" + Long.toHexString(l) + " max=" + Long.toHexString(l2) + " value", 0, false);
            return n;
        }
        if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l2), dvAddressSpace)) {
            DvUtils.trace("Continue:1 DvObjectsCommands.traverseHeap() max=" + Long.toHexString(l2) + " value not in heap", 0, false);
        }
        long l4 = l;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        if (0 == string.compareToIgnoreCase("MIDDLEWARE") || 0 == string.compareToIgnoreCase("TRANSIENT") || 0 == string.compareToIgnoreCase("MID") || 0 == string.compareToIgnoreCase("TRA")) {
            bl = true;
        }
        l4 = l;
        while (l4 < l2) {
            long l10 = l4;
            try {
                if (is64bit) {
                    l6 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l10));
                    l6 &= 0x3FFFFFFFFFFFFFF8L;
                } else {
                    l6 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l10));
                    l6 &= 0x3FFFFFF8L;
                }
            }
            catch (DvAddressException dvAddressException) {
                theOutput.add("DvAddressException in traverseHeap");
                this.returnControl();
                DvUtils.trace("Exit:3 DvObjectsCommands.traverseHeap() DvAddressException", 0, false);
                return n;
            }
            if (!bl || this.checkAllocbit(l4 - l3, dvAddressSpace)) {
                this.processFoundObject(l4, bl, s, l6);
                ++n;
            }
            if (n >= n2 + 5000) {
                this.cpr.output("\t" + DvUtils.getTime() + " " + n + " objects processed...");
                n2 = n;
            }
            l4 += l6;
        }
        this.cpr.output(theOutput);
        theOutput.clear();
        this.cpr.output("\t" + string + " traversal finished - " + n + " objects");
        this.returnControl();
        DvUtils.trace("Exit:4 DvObjectsCommands.traverseHeap()", 0, false);
        return n;
    }

    private void traverseEveryTLH() {
        Object object;
        int n;
        DvUtils.trace("Entry:DvObjectsCommands.traverseEveryTLH()", 0, false);
        int n2 = 0;
        this.javaThreadsWithoutTLH = 0;
        this.javaThreadsWithTLH = 0;
        this.javaThreadsWithoutTHTLH = 0;
        this.javaThreadsWithTHTLH = 0;
        if (this.theDump == null) {
            theOutput.add("Unable to comply as no Dump opened yet\n");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.traverseEveryTLH()", 0, false);
            return;
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        theOutput.add("\nTraversing Thread Local Heaps \n");
        this.cpr.output(theOutput);
        theOutput.clear();
        Vector vector = new Vector();
        try {
            DvProcess[] dvProcessArray = as.getProcesses();
            n = 0;
            while (n < dvProcessArray.length) {
                object = dvProcessArray[n].getThreads();
                int n3 = 0;
                while (n3 < ((DvThread[])object).length) {
                    if (object[n3].isJava()) {
                        n2 += this.traverseOneTLH(object[n3], n3, vector);
                    } else if (verboseTLH) {
                        theOutput.add("        " + object[n3] + " non-Java thread");
                    }
                    ++n3;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            theOutput.add("*** Exception received while traversing TLH - " + exception.getMessage());
            this.cpr.output(theOutput);
            theOutput.clear();
            exception.printStackTrace();
        }
        int n4 = vector.size();
        if (n4 != 0) {
            rangeArray = new long[n4][3];
            n = 0;
            while (n < n4) {
                object = (Range)vector.get(n);
                DvObjectsCommands.rangeArray[n][0] = object.start;
                DvObjectsCommands.rangeArray[n][1] = object.end;
                DvObjectsCommands.rangeArray[n][2] = object.index;
                ++n;
            }
        }
        theOutput.add("        " + this.javaThreadsWithoutTLH + " of " + (this.javaThreadsWithTLH + this.javaThreadsWithoutTLH) + " java threads did not have TLH cache blocks");
        theOutput.add("        " + this.javaThreadsWithoutTHTLH + " of " + (this.javaThreadsWithTHTLH + this.javaThreadsWithoutTHTLH) + " java threads did not have TH-TLH cache blocks");
        theOutput.add("        TLH finished - " + n2 + " objects\n");
        this.cpr.output(theOutput);
        theOutput.clear();
        threadLocalH = n2;
        DvUtils.trace("Exit:2 DvObjectsCommands.traverseEveryTLH()", 0, false);
    }

    private int traverseOneTLH(DvThread dvThread, int n, Vector vector) {
        DvUtils.trace("Entry:DvObjectsCommands.traverseOneTLH()", 0, false);
        int n2 = 0;
        DvAddress dvAddress = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        int n4 = 1;
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), as);
        if (cTypeObject == null || as == null || dvThread == null) {
            theOutput.add("        *** Warning: Unable to process TLH for thread - unexpected NULL variable");
            this.cpr.output(theOutput);
            theOutput.clear();
            DvUtils.trace("Exit:1 DvObjectsCommands.traverseOneTLH(DvThread, int, Vector)", 0, false);
            return 0;
        }
        if (dvThread.eeAddress().getAddressAsLong() == 0L) {
            DvUtils.trace("Exit:2 DvObjectsCommands.traverseOneTLH(DvThread, int, Vector) Warning: ee address is ZERO - thread ignored.", 0, false);
            return 0;
        }
        int n5 = n3;
        while (n5 <= n4) {
            block22: {
                CTypeObject cTypeObject2 = null;
                String string = "";
                if (n5 == n3) {
                    cTypeObject2 = cTypeObject.getField("alloc_cache.c.tc");
                    string = "";
                } else {
                    cTypeObject2 = cTypeObject.getField("TH_alloc_cache.c.tc");
                    string = "TH-";
                }
                if (cTypeObject2 == null) {
                    theOutput.add("*** Error: Unable to get tc in DvObjectsCommands.traverseOneTLH()");
                    this.cpr.output(theOutput);
                    theOutput.clear();
                } else {
                    CTypeObject cTypeObject3 = cTypeObject2.getField("cache_block");
                    CTypeObject cTypeObject4 = cTypeObject2.getField("cache_size");
                    CTypeObject cTypeObject5 = cTypeObject2.getField("cache_orig_size");
                    if (cTypeObject3 == null || cTypeObject4 == null || cTypeObject5 == null) {
                        theOutput.add("*** Error: Unexpected NULL variable in DvObjectsCommands.traverseOneTLH()");
                        this.cpr.output(theOutput);
                        theOutput.clear();
                    } else {
                        try {
                            dvAddress = as.readPointer(as.createAddress(cTypeObject3.getAddr()));
                            l = dvAddress.getAddressAsLong();
                            if (l == 0L) {
                                if (n5 == n3) {
                                    ++this.javaThreadsWithoutTLH;
                                } else {
                                    ++this.javaThreadsWithoutTHTLH;
                                }
                                break block22;
                            }
                            theOutput.add("        " + string + "TLH cache block located for thread with execenv=0x" + Long.toHexString(cTypeObject.getAddr()));
                            if (n5 == n3) {
                                ++this.javaThreadsWithTLH;
                            } else {
                                ++this.javaThreadsWithTHTLH;
                            }
                            l2 = as.readInt(as.createAddress(cTypeObject4.getAddr()));
                            l3 = as.readInt(as.createAddress(cTypeObject5.getAddr()));
                            Range range = new Range(l, l + l3, n);
                            vector.add(range);
                        }
                        catch (DvAddressException dvAddressException) {
                            theOutput.add("*** Unexpected exception while getting cache block for " + string + "TLH");
                            this.cpr.output(theOutput);
                            theOutput.clear();
                            dvAddressException.printStackTrace();
                        }
                        catch (Exception exception) {
                            theOutput.add("*** Unexpected other exception while getting cache block for " + string + "TLH");
                            theOutput.add("    Exception type = " + exception.getMessage());
                            this.cpr.output(theOutput);
                            theOutput.clear();
                            exception.printStackTrace();
                        }
                        if (l3 == l2) {
                            if (verboseTLH) {
                                theOutput.add("        Nothing in " + string + "TLH for Thread (" + dvThread + ")");
                            }
                        } else {
                            if (verboseTLH) {
                                theOutput.add("        Objects in " + string + "TLH for Thread (" + dvThread + ")");
                            }
                            long l4 = l + l2;
                            if (verboseTLH) {
                                theOutput.add("        " + string + "TLH objects begin at : 0x" + Long.toHexString(l4));
                            }
                            n2 += this.traverseOneTLHCacheBlock(dvThread, l4, l + l3, string);
                        }
                    }
                }
            }
            ++n5;
        }
        DvUtils.trace("Exit:3 DvObjectsCommands.traverseOneTLH(DvThread, int, Vector)", 0, false);
        return n2;
    }

    private int traverseOneTLHCacheBlock(DvThread dvThread, long l, long l2, String string) {
        DvUtils.trace("Entry:DvObjectsCommands.traverseOneTLHCacheBlock(DvThread,long,long,String)", 0, false);
        int n = 0;
        DvAddress dvAddress = null;
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        long l3 = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? 0x3FFFFFFFFFFFFFF8L : 0x3FFFFFF8L;
        try {
            while (l < l2) {
                Object object;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                long l7 = 0L;
                CTypeObject cTypeObject = null;
                try {
                    dvAddress = as.readPointer(as.createAddress(l));
                    l7 = dvAddress.getAddressAsLong();
                    l7 &= l3;
                    cTypeObject = new CTypeObject("Hjava_lang_Object", as.createAddress(l + (long)ptrLength), as);
                    CTypeObject cTypeObject2 = cTypeObject.getField("locknflags");
                    dvAddress = as.readPointer(as.createAddress(cTypeObject2.getAddr()));
                    l4 = dvAddress.getAddressAsLong();
                    object = cTypeObject.getField("methods");
                    dvAddress = as.readPointer(as.createAddress(((CTypeObject)object).getAddr()));
                    l5 = dvAddress.getAddressAsLong();
                    CTypeObject cTypeObject3 = cTypeObject.getField("obj");
                    dvAddress = as.readPointer(as.createAddress(cTypeObject3.getAddr()));
                    l6 = dvAddress.getAddressAsLong();
                }
                catch (DvAddressException dvAddressException) {
                    theOutput.add("*** Unexpected exception processing an object in " + string + "TLH");
                    theOutput.add("    objPointer=" + l);
                    this.cpr.output(theOutput);
                    theOutput.clear();
                    dvAddressException.printStackTrace();
                }
                boolean bl = false;
                if ((l4 & 2L) != 0L) {
                    bl = true;
                }
                object = new ObjectDetails();
                ((ObjectDetails)object).methods = l5;
                ((ObjectDetails)object).obj = l6;
                ((ObjectDetails)object).heapName = string + "TLH:0x" + Long.toHexString(dvThread.eeAddress().getAddressAsLong());
                ((ObjectDetails)object).length = l7;
                ((ObjectDetails)object).address = cTypeObject.getAddr();
                ((ObjectDetails)object).locknflags = l4;
                object = this.processData((ObjectDetails)object);
                if (verboseTLH) {
                    if (bl) {
                        theOutput.add("            Array  @ 0x" + Long.toHexString(l + (long)ptrLength) + " (length=0x" + Long.toHexString(l7) + ") - " + ((ObjectDetails)object).type + "[" + l5 + "]");
                    } else {
                        theOutput.add("            Object @ 0x" + Long.toHexString(l + (long)ptrLength) + " (length=0x" + Long.toHexString(l7) + ") - " + ((ObjectDetails)object).type);
                    }
                }
                if (verboseTLH) {
                    theOutput.add("            *** putting: " + Long.toHexString(l + (long)ptrLength) + ", " + totalObjectCount);
                }
                this.processFoundObject(l, true, (short)0, l7);
                ++n;
                l += l7;
            }
        }
        catch (Exception exception) {
            theOutput.add("*** Unexpected exception recieved while examining items on " + string + "TLH");
            theOutput.add("  Thread=" + dvThread + ", objectPointer=" + l + ", endOfCacheBlock=" + l2);
            this.cpr.output(theOutput);
            theOutput.clear();
            exception.printStackTrace();
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.traverseOneTLHCacheBlock(DvThread,long,long,String)", 0, false);
        return n;
    }

    private ObjectDetails processData(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processData(ObjectDetails)", 0, false);
        objectDetails.type = this.processTypes(objectDetails);
        objectDetails.lock = false;
        if (0L != objectDetails.locknflags) {
            objectDetails.shapeBit = this.processShapeBit(objectDetails);
            if (0L == objectDetails.shapeBit) {
                objectDetails.entryCount = this.processEntryCount(objectDetails);
                objectDetails.threadId = this.processThreadId(objectDetails);
            } else {
                objectDetails.monitorIndex = this.processMonitorIndex(objectDetails);
                objectDetails.inflMon = this.processInflMon(objectDetails);
            }
            if (0L != objectDetails.threadId || 0L != objectDetails.entryCount || 0L != objectDetails.monitorIndex) {
                objectDetails.lock = true;
            }
        } else {
            objectDetails.entryCount = 0L;
            objectDetails.threadId = 0L;
            objectDetails.monitorIndex = 0L;
            objectDetails.inflMon = 0L;
            objectDetails.lock = false;
        }
        objectDetails.objectName = this.processObjectName(objectDetails);
        objectDetails.className = this.processClassName(objectDetails);
        DvUtils.trace("Exit:1 DvObjectsCommands.processData(ObjectDetails)", 0, false);
        return objectDetails;
    }

    private long processShapeBit(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processShapeBit(ObjectDetails)", 0, false);
        if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
            long l = objectDetails.locknflags >> 62 & 2L;
            DvUtils.trace("Exit:1 DvObjectsCommands.processShapeBit(ObjectDetails) 64bit", 0, false);
            return l;
        }
        long l = objectDetails.locknflags >> 31 & 1L;
        DvUtils.trace("Exit:2 DvObjectsCommands.processShapeBit(ObjectDetails) 32bit", 0, false);
        return l;
    }

    private long processEntryCount(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processEntryCount(ObjectDetails)", 0, false);
        if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
            long l = objectDetails.locknflags >> 16 & 0x7FFFL;
            DvUtils.trace("Exit:1 DvObjectsCommands.processEntryCount(ObjectDetails)", 0, false);
            return l;
        }
        long l = objectDetails.locknflags >> 8 & 0xFFL;
        DvUtils.trace("Exit:2 DvObjectsCommands.processEntryCount(ObjectDetails)", 0, false);
        return l;
    }

    private long processThreadId(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processThreadId(ObjectDetails)", 0, false);
        if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
            long l = objectDetails.locknflags >> 32 & Integer.MAX_VALUE;
            DvUtils.trace("Exit:1 DvObjectsCommands.processThreadId(ObjectDetails)", 0, false);
            return l;
        }
        long l = objectDetails.locknflags >> 16 & 0x7FFFL;
        DvUtils.trace("Exit:2 DvObjectsCommands.processThreadId(ObjectDetails)", 0, false);
        return l;
    }

    private long processMonitorIndex(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processMonitorIndex(ObjectDetails)", 0, false);
        if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
            long l = objectDetails.locknflags >> 16 & 0x7FFFFFFFFFFFL;
            DvUtils.trace("Exit:1 DvObjectsCommands.processMonitorIndex(ObjectDetails)", 0, false);
            return l;
        }
        long l = objectDetails.locknflags >> 8 & 0x7FFFFFL;
        DvUtils.trace("Exit:2 DvObjectsCommands.processMonitorIndex(ObjectDetails)", 0, false);
        return l;
    }

    private long processInflMon(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processInflMon(ObjectDetails)", 0, false);
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        long l = 0L;
        long l2 = 0L;
        l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.processInflMon(ObjectDetails) lk:dataP==dg:dataP", 0, false);
            return 0L;
        }
        long l3 = objectDetails.address;
        long l4 = 0L;
        try {
            Object var12_6 = null;
            long l5 = this.getControlBlockField("_lkgldata", "micb", l, as);
            long l6 = this.getControlBlockField("monitor_index_cb_t", "count", l5, as);
            long l7 = this.getControlBlockField("monitor_index_cb_t", "size", l5, as);
            long l8 = this.getControlBlockField("monitor_index_cb_t", "table", l5, as);
            long l9 = l8 + 4L * objectDetails.monitorIndex;
            l4 = as.readPointer(as.createAddress(l9)).getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in processInflMon");
            this.returnControl();
            DvUtils.trace("Contine:1 DvObjectsCommands.processInflMon(ObjectDetails) DvAddressException", 0, false);
        }
        catch (NumberFormatException numberFormatException) {
            theOutput.add("DvNumberFormatException in processInflMon");
            theOutput.add("Possible cause by not having hints setup properly");
            DvUtils.trace("Contine:2 DvObjectsCommands.processInflMon(ObjectDetails) NumberFormatException", 0, false);
            this.returnControl();
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.processInflMon(ObjectDetails)", 0, false);
        return l4;
    }

    private boolean processLock(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processLocks(ObjectDetails)", 0, false);
        if (0L != objectDetails.threadId || 0L != objectDetails.entryCount || 0L != objectDetails.monitorIndex) {
            DvUtils.trace("Exit:1 DvObjectsCommands.processLocks(ObjectDetails)", 0, false);
            return true;
        }
        DvUtils.trace("Exit:2 DvObjectsCommands.processLocks(ObjectDetails)", 0, false);
        return false;
    }

    private String processObjectName(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processObjectName(ObjectDetails)", 0, false);
        String string = "";
        long l = objectDetails.address;
        DvUtils.trace("Exit:1 DvObjectsCommands.processObjectName(ObjectDetails)", 0, false);
        return this.processObjectName(l, (DvAddressSpace)DvUtils.getAPT(this.theDump, "A"));
    }

    private String processObjectName(long l, DvAddressSpace dvAddressSpace) {
        long l2;
        DvUtils.trace("Entry:DvObjectsCommands.processObjectName(long, DvAddressSpace)", 0, false);
        String string = "";
        boolean bl = true;
        long l3 = 0L;
        try {
            l3 = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? as.readLong(as.createAddress(l + 8L)) : (long)as.readInt(as.createAddress(l + 4L));
        }
        catch (DvAddressException dvAddressException) {
            theOutput.add("DvAddressException in processObjectName ");
            this.returnControl();
            DvUtils.trace("Exit:1 DvObjectsCommands.processObjectName(long, DvAddressSpace) DvAddressException", 0, false);
            return string;
        }
        if ((l3 >> 3 & 0x1FL) == 0L && (l3 >> 1 & 1L) == 0L) {
            try {
                long l4;
                l2 = l4 = this.getControlBlockField("Hjava_lang_Object", "methods", l, dvAddressSpace);
                long l5 = this.getControlBlockField("methodtable", "classdescriptor", l4, dvAddressSpace);
                long l6 = DvUtils.getFieldAddress(l5, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                long l7 = this.getControlBlockField("Classjava_lang_Class", "name", l6, dvAddressSpace);
                string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l7), 256L));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Continue:1 DvObjectsCommands.processObjectName(long, DvAddressSpace) DvAddressException", 0, false);
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            l2 = l3 >> 3 & 0x1FL;
            string = this.processTypes(l3);
        }
        DvUtils.trace("Exit:2 DvObjectsCommands.processObjectName(long, DvAddressSpace)", 0, false);
        return string;
    }

    private String processClassName(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processClassName(ObjectDetails)", 0, false);
        if (0 != objectDetails.objectName.compareToIgnoreCase("java/lang/Class")) {
            return null;
        }
        long l = objectDetails.address;
        String string = null;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        try {
            long l2 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
            long l3 = this.getControlBlockField("Classjava_lang_Class", "name", l2, dvAddressSpace);
            string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l3), 256L));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("Continue:1 DvObjectsCommands.processClassName(ObjectDetails) DvAddressException", 0, false);
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.processClassName(ObjectDetails)", 0, false);
        return string;
    }

    private String processTypes(ObjectDetails objectDetails) {
        DvUtils.trace("Entry:DvObjectsCommands.processTypes(ObjectDetails)", 0, false);
        long l = objectDetails.locknflags;
        DvUtils.trace("Exit:1 DvObjectsCommands.processTypes(ObjectDetails)", 0, false);
        return this.processTypes(l);
    }

    private String processTypes(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.processTypes(long)", 0, false);
        String string = "";
        switch ((int)l & 7) {
            case 4: {
                string = string + "hashedAndMoved ";
                break;
            }
            case 2: {
                string = string + "array ";
                break;
            }
            case 1: {
                string = string + "hashed ";
            }
        }
        switch ((int)(l >> 3) & 0x1F) {
            case 5: {
                string = string + "char";
                break;
            }
            case 4: {
                string = string + "boolean";
                break;
            }
            case 6: {
                string = string + "float";
                break;
            }
            case 7: {
                string = string + "double";
                break;
            }
            case 8: {
                string = string + "byte";
                break;
            }
            case 9: {
                string = string + "short";
                break;
            }
            case 10: {
                string = string + "int";
                break;
            }
            case 12: {
                string = string + "uintpointer";
                break;
            }
            case 11: {
                string = string + "long";
                break;
            }
            case 2: {
                string = string + "class";
                break;
            }
            case 0: {
                string = string + "normal_object";
            }
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.processTypes(long)", 0, false);
        return string;
    }

    private boolean checkAllocbit(long l, DvAddressSpace dvAddressSpace) {
        DvUtils.trace("Entry:DvObjects.checkAllocbit  (0x" + Long.toHexString(l) + ")", 0, false);
        boolean bl = false;
        int n = 0;
        long l2 = 0L;
        byte by = 0;
        long l3 = l / 64L;
        if (0L == allocBitsAddress) {
            allocBitsAddress = DvUtils.hexToLong(DvUtils.getJVMHint(as, "ALLOCBITS"));
        }
        if (0L != allocBitsAddress) {
            try {
                by = as.readByte(dvAddressSpace.createAddress(allocBitsAddress + l3));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Continue:1 DvObjects.checkAllocbit \n !!!!!!!!!!!!!!!!!!!!!!\n DvAddressException trying to read AllocBits\n Address = 0x" + Long.toHexString(allocBitsAddress + l3) + "\n Address: " + "\n !!!!!!!!!!!!!!!!!!!!!!", 0, true);
            }
        } else {
            DvUtils.trace("Continue:2 DvObjects.checkAllocbit \n !!!!!!!!!!!!!!!!!!!!!!\n ALLOCBITS hint was 0 - suggests an error in control\n block structure or wrong types file information\n !!!!!!!!!!!!!!!!!!!!!!", 0, true);
        }
        n = (int)(l % 64L) / 8;
        if (!DvUtils.isBigEndian(this.theDump.getArchitecture())) {
            n = 7 - n;
        }
        if (0 != (by & allocBitsTestBytes[n])) {
            bl = true;
        }
        DvUtils.trace("Exit:1 DvObjects.checkAllocbit (" + (bl ? "true)" : "false)"), 0, false);
        return bl;
    }

    protected static DvObjectsCommands getCurrentInstance() {
        DvUtils.trace("Entry/Exit:DvObjectsCommands.getCurrentInstance()", 0, false);
        return that;
    }

    protected static boolean heapsAlreadyTraversed() {
        DvUtils.trace("Entry/Exit:DvObjectsCommands.heapsAlreadyTraversed()", 0, false);
        return heapsTraversed;
    }

    protected String getObjectNameAtAddress(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.getObjectNameAtAddress(long)", 0, false);
        if (!heapsTraversed) {
            theOutput.add("Traversing Heaps!");
            this.cpr.output(theOutput);
            theOutput.clear();
            this.traverseAllHeaps();
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.getObjectNameAtAddress(long)", 0, false);
        return this.processObjectName(l, as);
    }

    protected String getClassNameAtAddress(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.getClassNameAtAddress(long)", 0, false);
        if (!heapsTraversed) {
            theOutput.add("Traversing Heaps!");
            this.cpr.output(theOutput);
            theOutput.clear();
            this.traverseAllHeaps();
        }
        ObjectDetails objectDetails = new ObjectDetails();
        objectDetails.address = l;
        objectDetails.objectName = "java/lang/Class";
        DvUtils.trace("Exit:1 DvObjectsCommands.getClassNameAtAddress(long)", 0, false);
        return this.processClassName(objectDetails);
    }

    private void returnControl() {
        this.cpr.output(theOutput);
        theOutput.clear();
        unknownSystem = false;
        this.forcedEnd = true;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static Object getGenericHelp() {
        DvUtils.trace("Entry:DvObjectCommands.getGenericHelp", 0, false);
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvObjectsCommands.properties");
        DvUtils.trace("Exit:1 DvObjectCommands.getGenericHelp", 0, false);
        return vector;
    }

    private ObjectDetails getObjectDetails(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.getObjectDetails(long)", 0, false);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        ObjectDetails objectDetails = new ObjectDetails();
        try {
            long l6;
            if (is64bit) {
                l2 = as.readLong(as.createAddress(l));
                l2 &= 0x3FFFFFFFFFFFFFF8L;
                l6 = l += 8L;
                l3 = as.readLong(as.createAddress(l));
                l4 = as.readLong(as.createAddress(l += 8L));
                l5 = as.readLong(as.createAddress(l += 8L));
            } else {
                l2 = as.readInt(as.createAddress(l));
                l2 &= 0x3FFFFFF8L;
                l6 = l += 4L;
                l3 = as.readInt(as.createAddress(l));
                l4 = as.readInt(as.createAddress(l += 4L));
                l4 &= 0xFFFFFFFFL;
                l5 = as.readInt(as.createAddress(l += 4L));
            }
            objectDetails.methods = l3;
            objectDetails.obj = l5;
            objectDetails.heapName = this.establishHeapName(l6);
            if (null == objectDetails.heapName) {
                objectDetails.heapName = "??????";
            }
            objectDetails.length = l2;
            objectDetails.address = l6;
            objectDetails.locknflags = l4;
            objectDetails = this.processData(objectDetails);
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("Continue:1 DvObjectsCommands.getObjectDetails(long)", 0, false);
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.getObjectDetails(long)", 0, false);
        return objectDetails;
    }

    private void openNamesIndexFile() {
        DvUtils.trace("Entry:DvObjectsCommands.openNamesIndexFile()", 0, false);
        String string = DvUtils.getValue("Dump") + ".nidx";
        String string2 = DvUtils.getValue("WorkDir");
        if (null != string2) {
            string = DvUtils.stripToFileName(string);
            string = string2 + string;
        }
        try {
            namesIndexFile = new DvNamesIndexFile(string, "r", 0, 0, 0, 123456L);
            names_index_built = true;
        }
        catch (IOException iOException) {
            theOutput.add("Invalid or non-existant class names index file\nDump will be scanned and index created");
            this.cpr.output(theOutput);
            theOutput.clear();
            try {
                namesIndexFile = new DvNamesIndexFile(string, "rw", 1024, 100, 100, 123456L);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.openNamesIndexFile()", 0, false);
    }

    private void openAddrIndexFile() {
        DvUtils.trace("Entry:DvObjectsCommands.openAddrIndexFile()", 0, false);
        String string = DvUtils.getValue("Dump") + ".aidx";
        String string2 = DvUtils.getValue("WorkDir");
        if (null != string2) {
            string = DvUtils.stripToFileName(string);
            string = string2 + string;
        }
        try {
            addressIndexFile = new DvAddressIndexFile(string, "r", 0, 0, 0, 123456L);
            address_index_built = true;
        }
        catch (IOException iOException) {
            theOutput.add("Invalid or non-existant addressindex file\nDump will be scanned and index created");
            this.cpr.output(theOutput);
            theOutput.clear();
            try {
                addressIndexFile = new DvAddressIndexFile(string, "rw", 32768, 100, 100, 123456L);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.openAddrIndexFile()", 0, false);
    }

    private void initPtrLength() {
        DvUtils.trace("Entry:DvObjectsCommands.initPtrLength()", 0, false);
        ptrLength = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? 8 : 4;
        DvUtils.trace("Exit:1 DvObjectsCommands.initPtrLength()", 0, false);
    }

    public void objectAnalyze() {
        DvUtils.trace("Entry:DvObjectsCommands.objectAnalyze()", 0, false);
        DvUtils.trace("Exit:1 DvObjectsCommands.objectAnalyze()", 0, false);
    }

    public void createEAB(DvAddressSpace dvAddressSpace) {
        DvUtils.trace("Entry:DvObjectsCommands.createEAB(DvAddressSpace)", 0, false);
        String string = DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPBASE");
        String string2 = DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPLIMIT");
        startOfMHeap = Long.parseLong(string, 16);
        endOfMHeap = Long.parseLong(string2, 16);
        int n = (int)((endOfMHeap - startOfMHeap) / 64L);
        extendedAllocBits = new byte[n];
        DvUtils.trace("Exit:1 DvObjectsCommands.createEAB(DvAddressSpace) Allocated " + n + " bytes for extendedAllocBits", 0, false);
    }

    public void flipEAB(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.flipEAB(long)", 0, false);
        if (extendedAllocBits == null) {
            this.createEAB(as);
        }
        long l2 = l;
        long l3 = l2 - startOfMHeap;
        l2 = l3 / 64L;
        int n = (int)(l3 % 64L) / 8;
        try {
            if (0 == (extendedAllocBits[(int)l2] & allocBitsTestBytes[n])) {
                int n2 = (int)l2;
                extendedAllocBits[n2] = (byte)(extendedAllocBits[n2] | allocBitsTestBytes[n]);
                int n3 = extendedAllocBits[(int)l2];
                if (n3 < 0) {
                    n3 += 256;
                }
            } else {
                DvUtils.trace("Continue:2 DvObjectsCommands.flipEAB(long) Found extendedAllocBits inconsistency \n !!! for: 0x" + Long.toHexString(l) + " bit already on !", 0, true);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            DvUtils.trace("Continue:2 DvObjectsCommands.flipEAB(long) Trying to flip bit outside of array for 0x" + Long.toHexString(l), 0, true);
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.flipEAB(long)", 0, false);
    }

    public boolean checkForKnownObject(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.checkForKnownObject(long)", 0, false);
        boolean bl = false;
        if (0L == (l + (long)ptrLength) % 8L) {
            if (l >= startOfMHeap && l <= endOfMHeap) {
                long l2 = l;
                long l3 = l2 - startOfMHeap;
                int n = (int)(l3 % 64L) / 8;
                if (0 != (extendedAllocBits[(int)(l2 = l3 / 64L)] & allocBitsTestBytes[n])) {
                    bl = true;
                }
            } else {
                Long l4 = new Long(l);
                if (systemHeapHashByAddr.contains(l4) || acsHeapHashByAddr.contains(l4)) {
                    bl = true;
                }
            }
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.checkForKnownObject(long)", 0, false);
        return bl;
    }

    private void processFoundObject(long l, boolean bl, short s, long l2) {
        DvUtils.trace("Entry:DvObjectsCommands.processFoundObject(long,boolean,short,long)", 0, false);
        if (!names_index_built) {
            String string = this.processObjectName(l + (long)ptrLength, as);
            namesIndexFile.write(string, l, s, l2);
        }
        if (bl) {
            this.flipEAB(l);
        } else if (s == -4) {
            systemHeapHashByAddr.add(new Long(l));
        } else {
            acsHeapHashByAddr.add(new Long(l));
        }
        long l3 = 0L;
        try {
            l3 = is64bit ? as.readLong(as.createAddress(l + 16L)) : (long)as.readInt(as.createAddress(l + 8L));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("Continue:1 DvObjectsCommands.processFoundObject(long,boolean,short,long) DvAddressException", 0, false);
        }
        if (l3 != 0L && (l3 &= 0xFFFFFFFFFFFFF800L) != 0L) {
            lockedObjects.add(new Long(l));
            ++totalLockedObjectCount;
        }
        ++totalObjectCount;
        DvUtils.trace("Exit:1 DvObjectsCommands.processFoundObject(long,boolean,short,long)", 0, false);
    }

    private int[] sortRanges(Vector vector) {
        DvUtils.trace("Entry:DvObjectsCommands.sortRanges()", 0, false);
        int[] nArray = null;
        if (0 != vector.size()) {
            nArray = new int[vector.size()];
            long[] lArray = new long[vector.size()];
            int n = 0;
            while (n < nArray.length) {
                Range range = (Range)vector.get(n);
                if (0 == n) {
                    nArray[0] = 0;
                    lArray[0] = range.start;
                } else {
                    int n2 = n - 1;
                    while (n2 > -1) {
                        if (range.start <= lArray[n2]) {
                            nArray[n2 + 1] = nArray[n2];
                            lArray[n2 + 1] = lArray[n2];
                            nArray[n2] = n;
                            lArray[n2] = range.start;
                        } else {
                            nArray[n2 + 1] = n;
                            lArray[n2 + 1] = range.start;
                            n2 = -1;
                        }
                        --n2;
                    }
                }
                ++n;
            }
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.sortRanges()", 0, false);
        return nArray;
    }

    private String establishHeapName(long l) {
        DvUtils.trace("Entry:DvObjectsCommands.establishHeapName(long)", 0, false);
        Object var3_2 = null;
        int n = 0;
        while (n < rangeArray.length) {
            if (l >= rangeArray[n][0] && l <= rangeArray[n][1]) {
                if (rangeArray[n][2] == -1L) {
                    DvUtils.trace("Exit:1 DvObjectsCommands.establishHeapName(long)", 0, false);
                    return "System";
                }
                DvProcess dvProcess = (DvProcess)DvUtils.getAPT(this.theDump, "P");
                DvThread[] dvThreadArray = dvProcess.getThreads();
                DvUtils.trace("Exit:2 DvObjectsCommands.establishHeapName(long)", 0, false);
                return "TLH for thread " + dvThreadArray[(int)rangeArray[n][2]].id();
            }
            if (l < rangeArray[n][0]) {
                n = rangeArray.length;
            }
            ++n;
        }
        if (l >= startOfTransHeap && l < endOfTransHeap) {
            DvUtils.trace("Exit:3 DvObjectsCommands.establishHeapName(long)", 0, false);
            return "Transient";
        }
        if (l >= startOfMHeap && l < endOfMHeap) {
            DvUtils.trace("Exit:4 DvObjectsCommands.establishHeapName(long)", 0, false);
            return "MiddleWare";
        }
        DvUtils.trace("Exit:5 DvObjectsCommands.establishHeapName(long)", 0, false);
        return "TBD";
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        DvUtils.trace("Entry:DvObjectsCommands.whatIs(DvAddress, String, DvDump)", 0, false);
        String string2 = null;
        if (null != dvAddress) {
            if (!heapsTraversed) {
                string2 = "  DvObjectsCommands: Unable to establish if " + string + " is an object in a heap ...\n" + "    as heaps not yet traversed (run dis os and retry)";
            } else {
                int n;
                int n2;
                boolean bl = false;
                string2 = "";
                long l = dvAddress.getAddressAsLong();
                if (l >= startOfMHeap && l <= endOfMHeap && l != 0L) {
                    string2 = string2 + "  \"" + string + "\" is in the middleware heap range";
                    bl = true;
                }
                if (l >= startOfTransHeap && l <= endOfTransHeap && l != 0L) {
                    string2 = string2 + "  \"" + string + "\" is in the transient heap range";
                    bl = true;
                }
                if (null != rangeArray) {
                    n2 = rangeArray.length;
                    n = 0;
                    while (n < n2) {
                        if (l >= rangeArray[n][0] && l <= rangeArray[n][1] && l != 0L) {
                            bl = true;
                            if (-1L == rangeArray[n][2]) {
                                string2 = string2 + "\n Its a System Heap";
                            } else {
                                DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
                                DvThread[] dvThreadArray = dvProcess.getThreads();
                                string2 = string2 + "\n Its in TLH for thread " + dvThreadArray[(int)rangeArray[n][2]].id();
                            }
                        }
                        ++n;
                    }
                }
                if (bl) {
                    n2 = 0;
                    n = 0;
                    boolean bl2 = false;
                    if (0L == l % 8L) {
                        if (this.checkForKnownObject(l - (long)ptrLength)) {
                            string2 = string2 + "\n Its a known object (use \"dis obj " + string + "\" to view it)";
                            n2 = 1;
                        }
                        if (this.checkForKnownObject(l)) {
                            string2 = string2 + "\n It addresses length field of known object (use \"dis obj " + string + ptrLength + "\" to view it)";
                            n = 1;
                        }
                    } else if (0L == l % 4L && !DvUtils.is64BitSystem(dvDump.getArchitecture()) && this.checkForKnownObject(l + 4L - (long)ptrLength)) {
                        string2 = string2 + "\n It addresses length field of known object (use \"dis obj  0x" + Long.toHexString(l + 4L) + "\" to view it)";
                        n = 1;
                    }
                    if (0 == n && 0 == n2) {
                        long l2 = l - l % 8L;
                        boolean bl3 = false;
                        int n3 = 0;
                        while (n3 < 4096 && !bl3) {
                            if (this.checkForKnownObject(l2 - (long)ptrLength)) {
                                bl3 = true;
                            } else {
                                l2 -= 8L;
                            }
                            ++n3;
                        }
                        if (bl3) {
                            this.theDump = dvDump;
                            ObjectDetails objectDetails = this.getObjectDetails(l2 - (long)ptrLength);
                            string2 = l2 - (long)ptrLength + objectDetails.length >= l ? string2 + "\n found object (" + objectDetails.objectName + ") at " + Long.toHexString(l2) + " (length:" + objectDetails.length + ")" + "\n\t....that covers this address (offset 0x" + Long.toHexString(l - l2) + ")" : string2 + "\n nearest object (" + objectDetails.objectName + ") at " + Long.toHexString(l2) + " (length:" + objectDetails.length + ")" + "\n\t....but it does not cover this address";
                        } else {
                            string2 = string2 + "\n Couldn't find an object covering \"" + string + "\"";
                        }
                    }
                }
            }
        }
        DvUtils.trace("Exit:1 DvObjectsCommands.whatIs(DvAddress, String, DvDump)", 0, false);
        return string2;
    }

    static {
        allocBitsAddress = 0L;
        allocBitsTestBytes = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        verboseTLH = false;
        address_index_built = false;
        names_index_built = false;
        extendedAllocBits = null;
        lockedAllocBits = null;
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        systemHeapHashByAddr = new HashSet();
        acsHeapHashByAddr = new HashSet();
        lockedObjects = new Vector();
        commandsSupported = new String[]{"DISPLAY,DIS,OBJECT,obj,displayObjects", "DISPLAY,DIS,LOCK,loc,displayLocks", "DISPLAY,DIS,LOCKSUMMARY,ls,displayLockSummary", "DISPLAY,DIS,LOCKEDOBJECTS,lo,displayLockedObjects", "DISPLAY,DIS,OBJECTSUMMARY,os,displayObjectSummary"};
    }

    private static class ObjectDetails {
        protected long address;
        protected long methods;
        protected long locknflags;
        protected long obj;
        protected String objectName;
        protected String className;
        protected String heapName;
        protected String type;
        protected boolean lock;
        protected long shapeBit;
        protected long entryCount;
        protected long threadId;
        protected long monitorIndex;
        protected long inflMon;
        protected long length;

        private ObjectDetails() {
        }

        public String toString() {
            if (null == this.className) {
                return "\n @ 0x" + Long.toHexString(this.address) + " (" + this.objectName + ") " + "  (heap: " + this.heapName + ")";
            }
            return "\n @ 0x" + Long.toHexString(this.address) + " (" + this.objectName + ") " + this.className + "  (heap: " + this.heapName + ")";
        }
    }

    private static class Range {
        protected long start;
        protected long end;
        protected long index;

        protected Range(long l, long l2, long l3) {
            this.start = l;
            this.end = l2;
            this.index = l3;
        }
    }
}

