/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DvJavacorePlugin
extends CommandPlugin {
    protected static Vector output = new Vector();
    protected static DvAddressSpace as = null;
    private static boolean tags = true;
    private static boolean verbose = false;
    private static boolean DEBUG = false;
    private static boolean staticsInitialised = false;
    private static DvThread myThread = null;
    private static CTypeObject ee = null;
    private static CTypeObject jvm = null;
    private static CTypeObject dgData = null;
    private static CTypeObject xeData = null;
    private static CTypeObject stData = null;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final long DG_TRC_BUFFER_ACTIVE = 0x80000000L;
    private static String[] commandsSupported = new String[]{"JAVACORE,*,HELP,*,CMD_JavacoreHelp", "JAVACORE,*,TAGS,TAG,CMD_JavacoreTags", "JAVACORE,*,VERBOSE,*,CMD_JavacoreVerbose", "JAVACORE,*,SECTION,*,CMD_JavacoreSection", "JAVACORE,*,*,*,CMD_Javacore", "JAVADUMP,*,HELP,*,CMD_JavacoreHelp", "JAVADUMP,*,TAGS,TAG,CMD_JavacoreTags", "JAVADUMP,*,VERBOSE,*,CMD_JavacoreVerbose", "JAVADUMP,*,SECTION,*,CMD_JavacoreSection", "JAVADUMP,*,*,*,CMD_Javacore"};

    public void CMD_JavacoreHelp() {
        output.add("\nHELP FOR USING JAVACORE\n=======================\n");
        output.add("These are the currently supported commands:\n");
        output.add("JAVACORE HELP               - this information.");
        output.add("JAVACORE TAGS true|false    - turn the tags ON or OFF.");
        output.add("JAVACORE                    - produce a Javacore.");
        output.add("JAVACORE SECTION xx         - produce Javacore for named section.");
        output.add("JAVACORE VERBOSE true|false - set verbose mode on|off");
        output.add("JAVACORE SECTION xx         - produce Javacore for named section.");
        output.add(" ");
        output.add("NB - all commands may also be entered as JAVADUMP...");
        output.add(" ");
        this.returnControl();
    }

    public void CMD_JavacoreTags() {
        String string = "Usage error:\n   Javacore tags true|false";
        if (this.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (this.paramString == null) {
            output.add(string);
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("TRUE")) {
            tags = true;
            output.add("\nJavacore tags have been turned ON\n");
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("FALSE")) {
            tags = false;
            output.add("\nJavacore tags have been turned OFF\n");
            this.returnControl();
            return;
        }
        output.add(string);
        this.returnControl();
    }

    public void CMD_JavacoreVerbose() {
        String string = "Usage error:\n   Javacore verbose true|false";
        if (this.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (this.paramString == null) {
            output.add(string);
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("TRUE")) {
            verbose = true;
            output.add("\nJavacore verbose mode has been turned ON\n");
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("FALSE")) {
            verbose = false;
            output.add("\nJavacore verbose mode has been turned OFF\n");
            this.returnControl();
            return;
        }
        output.add(string);
        this.returnControl();
    }

    public void CMD_JavacoreSection() {
        if (this.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (!staticsInitialised) {
            this.initStatics();
        }
        if (jvm == null) {
            output.add("*** Error: unable to locate jvm structure");
            this.returnControl();
            return;
        }
        if (this.theDump.getSystemType() == 4) {
            output.add(" ");
            output.add("-------------------------------------------------------------------------------");
            output.add("In this version of the dump formatter, Javacore/Javadump commands are not");
            output.add("supported when working with z/OS dumps.");
            output.add("-------------------------------------------------------------------------------");
            output.add(" ");
            this.returnControl();
            this.outputFlush();
            return;
        }
        if (this.paramString == null) {
            output.add("Usage Error: No javacore section specified, expected:");
            output.add("   Javacore section TITLE|XHPI|CI|DC|DG|ST|XE|LK|XM|CL|END");
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("TITLE")) {
            this.doTITLESection();
        } else if (this.paramString.toUpperCase().equals("XHPI")) {
            this.doXHPISection();
        } else if (this.paramString.toUpperCase().equals("CI")) {
            this.doCISection();
        } else if (this.paramString.toUpperCase().equals("DC")) {
            this.doDCSection();
        } else if (this.paramString.toUpperCase().equals("DG")) {
            this.doDGSection();
        } else if (this.paramString.toUpperCase().equals("ST")) {
            this.doSTSection();
        } else if (this.paramString.toUpperCase().equals("XE")) {
            this.doXESection();
        } else if (this.paramString.toUpperCase().equals("LK")) {
            this.ensureHeapsTraversed();
            this.doLKSection();
        } else if (this.paramString.toUpperCase().equals("XM")) {
            this.doXMSection();
        } else if (this.paramString.toUpperCase().equals("CL")) {
            this.ensureHeapsTraversed();
            this.doCLSection();
        } else if (this.paramString.toUpperCase().equals("END")) {
            this.doENDSection();
        } else {
            output.add("Usage Error: Javacore section \"" + this.paramString + "\" not recognised, expecting:");
            output.add("   Javacore section TITLE|XHPI|CI|DC|DG|ST|XE|LK|XM|CL|END");
            this.returnControl();
            return;
        }
        this.printWithTag("NULL", "---------------------------------------------------------------");
        this.returnControl();
    }

    public void CMD_Javacore() {
        output.add("\nProduce a Javacore...\n");
        if (this.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (!staticsInitialised) {
            this.initStatics();
        }
        if (jvm == null) {
            output.add("*** Error: unable to locate jvm structure");
            this.returnControl();
            return;
        }
        if (this.theDump.getSystemType() == 4) {
            output.add(" ");
            output.add("-------------------------------------------------------------------------------");
            output.add("In this version of the dump formatter, Javacore/Javadump commands are not");
            output.add("supported when working with z/OS dumps.");
            output.add("-------------------------------------------------------------------------------");
            output.add(" ");
            this.outputFlush();
            this.returnControl();
            return;
        }
        this.ensureHeapsTraversed();
        this.doTITLESection();
        this.doXHPISection();
        this.doCISection();
        this.doDCSection();
        this.doDGSection();
        this.doSTSection();
        this.doXESection();
        this.doLKSection();
        this.doXMSection();
        this.doCLSection();
        this.doENDSection();
        this.returnControl();
    }

    private void initStatics() {
        if (this.noDumpAccessed()) {
            return;
        }
        staticsInitialised = true;
        as = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
        myThread = (DvThread)DvUtils.getAPT(this.theDump, "T");
        ee = new CTypeObject("execenv", myThread.eeAddress(), as);
        jvm = ee.getField("jvmP").deReference();
        dgData = jvm.getField("facade.dg.dataP").deReference("DgData");
        xeData = jvm.getField("facade.xe.dataP").deReference("XeData");
        stData = jvm.getField("facade.st.dataP").deReference("STGlobal");
        if (dgData == null) {
            output.add("*** dgData is NULL ***");
        }
        if (xeData == null) {
            output.add("*** xeData is NULL ***");
        }
        if (stData == null) {
            output.add("*** stData is NULL ***");
        }
        this.outputFlush();
    }

    private void ensureHeapsTraversed() {
        if (!DvObjectsCommands.heapsAlreadyTraversed()) {
            output.add("\nJavacore is traversing heaps... please wait");
            output.add("(This is because you had not yet run display objects.)\n");
            this.outputFlush();
            String[] stringArray = DvConsole.execValidCmdToArray("dis os");
        }
    }

    private long getLoaderFromClass(long l) {
        CTypeObject cTypeObject;
        long l2 = -1L;
        CTypeObject cTypeObject2 = null;
        DvAddress dvAddress = as.createAddress(l);
        String string = "Hjava_lang_Class";
        if (DvUtils.checkAddressInDump(dvAddress, as) && (cTypeObject2 = DvUtils.formatAddrAsType(as, dvAddress, string)) != null && (cTypeObject = cTypeObject2.getField("obj.mirrored_data.loader")) != null) {
            l2 = this.readPtrAsLong(cTypeObject);
        }
        return l2;
    }

    private void doTITLESection() {
        try {
            this.newSection("TITLE");
            String string = null;
            try {
                int n = this.readAnInt(dgData.getField("signalNumber"));
                string = "signal " + n + " received";
                if (n == 0) {
                    string = "signal received not available in dump";
                }
            }
            catch (Exception exception) {
                string = "signal received not available in dump";
            }
            this.printWithTag("1TISIGINFO", string);
            String string2 = null;
            try {
                CTypeObject cTypeObject = dgData.getField("signalTime");
                string2 = this.getCStringFromPtr(cTypeObject);
                if (string2.equals("")) {
                    string2 = "<not available in dump>";
                }
            }
            catch (Exception exception) {
                string2 = "<not available in dump>";
            }
            this.printWithTag("1TIDATETIME", "Date:                 " + string2);
            this.printWithTag("1TIFILENAME", "Javacore filename:    <simulated javadump>");
        }
        catch (Exception exception) {
            output.add("*** Unexpected exception received in doTITLESection ");
            output.add("    " + exception.getMessage());
            this.outputFlush();
            exception.printStackTrace();
        }
        this.outputFlush();
    }

    private void doXHPISection() {
        this.newSection("XHPI");
        this.printWithTag("NULL", " ");
        this.printWithTag("2HXENVVARS", "Environment Variables");
        this.printWithTag("NULL", "---------------------");
        String[] stringArray = this.getEnvVarsFromDump();
        if (stringArray == null) {
            this.printWithTag("3HXNOENVVARS", "UNSUPPORTED: No environment variables in this dump");
        } else if (stringArray[0].indexOf("No loaded information for this process") != -1) {
            this.printWithTag("3HXNOENVVARS", "UNSUPPORTED: No environment variables in this dump");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                this.printWithTag("3HXENVVAR", stringArray[n]);
                ++n;
            }
        }
        this.printWithTag("NULL", " ");
        this.printWithTag("1XHLOADEDLIBS", "Loaded Libraries (sizes in bytes)");
        this.printWithTag("NULL", "----------------");
        DvLoaded dvLoaded = null;
        DvProcess[] dvProcessArray = as.getProcesses();
        int n = 0;
        while (n < dvProcessArray.length) {
            try {
                boolean bl = false;
                try {
                    dvLoaded = dvProcessArray[n].getLoaded();
                }
                catch (Error error) {
                    bl = true;
                }
                if (bl) {
                    this.printWithTag("2XHNOLIBS", "UNSUPPORTED: Unsupported function DvProcess.getLoaded()");
                } else if (dvLoaded == null) {
                    this.printWithTag("2XHNOLIBS", "No loaded information for process " + dvProcessArray[n].id());
                } else {
                    DvModule[] dvModuleArray = dvLoaded.getModules();
                    int n2 = 0;
                    while (n2 < dvModuleArray.length) {
                        String string = this.truncateAtIllegalChar(dvModuleArray[n2].name());
                        this.printWithTag("2XHLIBNAME", string);
                        if (dvModuleArray[n2].moduleSize == 0L) {
                            this.printWithTag("3XHNOLIBINFO", "    filesize    : unknown");
                        } else {
                            this.printWithTag("3XHLIBSIZE", "    filesize    : " + dvModuleArray[n2].size());
                        }
                        this.printWithTag("3XHLIBSTART", "    start addr  : 0x" + Long.toHexString(dvModuleArray[n2].address().getAddressAsLong()));
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                output.add("*** Error: Unexpected exception in doXHPISection()");
                this.outputFlush();
                exception.printStackTrace();
            }
            ++n;
        }
        this.printWithTag("NULL", " ");
        this.outputFlush();
    }

    private void doCISection() {
        this.newSection("CI");
        DvEnvData dvEnvData = null;
        DvProcess dvProcess = null;
        try {
            dvProcess = as.getCurrentProcess();
        }
        catch (Error error) {
            this.printWithTag("NULL", "UNSUPPORTED: Unsupported function DvAddressSpace.getCurrentProcess()");
            this.outputFlush();
            dvProcess = null;
        }
        try {
            String string;
            String string2;
            String[] stringArray;
            block32: {
                if (dvProcess != null) {
                    dvEnvData = dvProcess.getEnvData();
                }
                stringArray = this.getEnvVarsFromDump();
                CTypeObject cTypeObject = jvm.getField("fullVersion");
                string2 = null;
                try {
                    string2 = this.getCStringFromPtr(cTypeObject);
                }
                catch (DvAddressException dvAddressException) {
                    string2 = dvEnvData.javaVersion().trim();
                    if (string2 != null && !string2.equals("")) break block32;
                    string2 = "<version not available>";
                }
            }
            this.printWithTag("1CIJAVAVERSION", string2);
            String string3 = "";
            int n = 0;
            int n2 = 1;
            int n3 = 2;
            int n4 = this.readAnInt(jvm.getField("mode"));
            if (n4 == n) {
                string3 = "standalone";
            } else if (n4 == n2) {
                string3 = "master";
            } else if (n4 == n3) {
                string3 = "worker";
            }
            this.printWithTag("1CIRUNNINGAS", "Running as a " + string3 + " JVM");
            if (dvProcess != null) {
                if (stringArray != null) {
                    string = null;
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        if (stringArray[n5].startsWith("IBM_JAVA_COMMAND_LINE=")) {
                            string = stringArray[n5].substring(22);
                        }
                        ++n5;
                    }
                    if (string != null) {
                        this.printWithTag("1CICMDLINE", string);
                    } else {
                        this.printWithTag("1CICMDLINE", "<not present in dump>");
                    }
                } else {
                    this.printWithTag("1CICMDLINE", "<not supported in dump>");
                }
            } else {
                this.printWithTag("NULL", "UNSUPPORTED: Unable to display Java commandline");
            }
            if (dvProcess != null) {
                string = dvEnvData.javaHomeDir().trim();
                this.outputFlush();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    this.printWithTag("1CIJAVAHOMEDIR", "Java Home Dir:   <not present in dump>");
                } else {
                    this.printWithTag("1CIJAVAHOMEDIR", "Java Home Dir:   " + string);
                }
            } else {
                this.printWithTag("NULL", "UNSUPPORTED: Unable to display Java Home");
            }
            if (dvProcess != null) {
                string = dvEnvData.javaDllDir().trim();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    this.printWithTag("1CIJAVADLLDIR", "Java DLL Dir:    <not present in dump>");
                } else {
                    this.printWithTag("1CIJAVADLLDIR", "Java DLL Dir:    " + string);
                }
            } else {
                this.printWithTag("NULL", "UNSUPPORTED: Unable to display Java DLL directory");
            }
            this.printWithTag("1CISYSCP", "Sys Classpath:   <not yet available>");
            if (dvProcess != null) {
                string = dvEnvData.classpath().trim();
                if (string == null || string.startsWith("<<<<") || string.equals("Not available")) {
                    this.printWithTag("1CIUSRCP", "User Classpath:  <not present in dump>");
                } else {
                    this.printWithTag("1CIUSRCP", "User Classpath:  " + string);
                }
            } else {
                this.printWithTag("NULL", "UNSUPPORTED: Unable to display User Classpath");
            }
            this.printWithTag("1CIUSERARGS", "UserArgs:");
            this.printWithTag("2CIUSERARG", "          <not yet available>");
            this.printWithTag("NULL", "");
            this.printWithTag("1CIJVMMI", "JVM Monitoring Interface (JVMMI)");
            this.printWithTag("NULL", "------------------------");
            this.printWithTag("NULL", "<not yet available>");
            this.printWithTag("NULL", "");
            this.outputFlush();
        }
        catch (Exception exception) {
            output.add("*** Error: unexpected exception received in doCISection");
            this.outputFlush();
            exception.printStackTrace();
        }
    }

    private void doDCSection() {
        this.newSection("DC");
        this.printWithTag("1DCNOTANAL", "DC dump routine analysis not complete.");
        this.printWithTag("NULL", " ");
        CTypeObject cTypeObject = jvm.getField("facade.dc");
        CTypeObject cTypeObject2 = cTypeObject.getField("header");
        CTypeObject cTypeObject3 = cTypeObject2.getField("length");
        int n = 0;
        n = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? 8 : 4;
        long l = cTypeObject.getAddr();
        int n2 = this.readAnInt(cTypeObject3);
        try {
            long l2 = l + (long)n2 - (long)n;
            long l3 = as.readInt(as.createAddress(l2));
            CTypeObject cTypeObject4 = new CTypeObject("JvmDataHeader", as.createAddress(l3), as);
            CTypeObject cTypeObject5 = cTypeObject4.getField("eyecatcher");
            CTypeObject cTypeObject6 = cTypeObject4.getField("length");
            CTypeObject cTypeObject7 = cTypeObject4.getField("version");
            CTypeObject cTypeObject8 = cTypeObject4.getField("modification");
            int n3 = this.readAnInt(cTypeObject5);
            int n4 = this.readAnInt(cTypeObject6);
            int n5 = this.readAnInt(cTypeObject7);
            int n6 = this.readAnInt(cTypeObject8);
            byte[] byArray = new byte[]{(byte)(n3 & 0xFF), (byte)((n3 & 0xFF00) >> 8), (byte)((n3 & 0xFF0000) >> 16), (byte)((n3 & 0xFF000000) >> 24), 0};
            if (DvUtils.isBigEndian(this.theDump.getArchitecture())) {
                byte by = byArray[0];
                byArray[0] = byArray[3];
                byArray[3] = by;
                by = byArray[1];
                byArray[1] = byArray[2];
                byArray[2] = by;
            }
            String string = new String(byArray, "US-ASCII");
            this.printWithTag("1DCHEADEREYE", "Header eye catcher  " + string);
            this.printWithTag("1DCHEADERLEN", "Header length       " + n4);
            this.printWithTag("1DCHEADERVER", "Header version      " + n5);
            this.printWithTag("1DCHEADERMOD", "Header modification " + n6);
            this.printWithTag("1DCINTERFACE", "<not yet available>");
            this.printWithTag("1DCARRAYINFO", "<not yet available>");
        }
        catch (Exception exception) {
            this.outputFlush();
            System.out.println("*** Unxpected Exception in doDCSection()");
            exception.printStackTrace();
        }
        this.outputFlush();
    }

    private void doDGSection() {
        this.newSection("DG");
        boolean bl = verbose;
        boolean bl2 = false;
        try {
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7 = "Trace Enabled: " + this.boolFieldToString(dgData.getField("traceEnabled"), "Yes", "No");
            this.printWithTag("1DGTRCENABLED", string7);
            if (string7.equals("Yes")) {
                bl2 = true;
            }
            if ((string6 = "  " + this.boolFieldToString(dgData.getField("traceActive"), "Trace activated", "[Trace NOT activated]")).indexOf("[") == -1 || bl) {
                this.printWithTag("2DGTRCACTIVATE", string6);
            }
            if (string6.indexOf("[") == -1) {
                bl2 = true;
            }
            if ((string5 = "  " + this.boolFieldToString(dgData.getField("traceTerminate"), "Trace terminated", "[Trace NOT terminated]")).indexOf("[") == -1 || bl) {
                this.printWithTag("2DGTRCTERMINATE", string5);
            }
            int n = this.readAnInt(dgData.getField("traceSuspend"));
            String string8 = null;
            if (n == -1) {
                this.printWithTag("2DGTRCSUSPEND", "  ***Error reading Trace suspend flags***");
            } else if (n == 0 && bl) {
                string8 = "  Trace suspend flags:0x" + Long.toHexString(n);
                this.printWithTag("2DGTRCSUSPEND", string8);
            } else if (bl) {
                this.printWithTag("2DGTRCSUSPEND", "  [Trace suspend flags: ZERO]");
            }
            String string9 = "  " + this.boolFieldToString(dgData.getField("traceInitSpec"), "Initialization traced", "[Initialization NOT traced]");
            if (string9.indexOf("[") == -1 || bl) {
                this.printWithTag("2DGTRCJVMINIT", string9);
            }
            if (bl2 || bl) {
                string4 = "  Trace: " + this.boolFieldToString(dgData.getField("externalTrace"), "Ex", "In") + "ternal";
                this.printWithTag("2DGTRCTYPE", string4);
            }
            if (this.getCStringFromPtr(dgData.getField("traceFilename")) != null) {
                string4 = "  Filename: " + this.getCStringFromPtr(dgData.getField("traceFilename"));
                this.printWithTag("2DGTRCFILE", string4);
            } else if (bl) {
                this.printWithTag("2DGTRCFILE", "  [Filename: null]");
            }
            int n2 = this.readAnInt(dgData.getField("lostRecords"));
            if (n2 != 0) {
                String string10 = "  Number of lost trace records: " + n2;
                this.printWithTag("2DGTRCLOST", string10);
            } else if (bl) {
                this.printWithTag("2DGTRCLOST", "  [Number of lost trace records: 0]");
            }
            int n3 = this.readAnInt(dgData.getField("traceWrap"));
            if (n3 != 0) {
                string3 = "  Maximum file size: " + n3;
                this.printWithTag("2DGTRCFILEWRAP", string3);
            } else if (bl) {
                this.printWithTag("2DGTRCFILEWRAP", "  [Maximum file size: 0]");
            }
            string3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            int n4 = this.readAnInt(dgData.getField("traceGenerations"));
            int n5 = this.readAnInt(dgData.getField("nextGeneration"));
            String string11 = string3.substring(n5, n5 + 1);
            if (n4 != 0) {
                string2 = "  Number of trace generations: " + n4;
                this.printWithTag("2DGTRCGENERATE", string2);
                String string12 = "  Next trace generation: " + string11;
                this.printWithTag("2DGTRCNEXTGEN", string12);
            } else if (bl) {
                this.printWithTag("2DGTRCGENERATE", "  [Number of trace generations: 0]");
                this.printWithTag("2DGTRCNEXTGEN", "  [Next trace generation: " + string11 + "]");
            }
            if (this.getCStringFromPtr(dgData.getField("traceFileSpec")) != null) {
                string2 = this.getCStringFromPtr(dgData.getField("traceFileSpec"));
                string2 = "  Property filename: " + string2;
                this.printWithTag("2DGTRCPROPS", string2);
            } else if (bl) {
                this.printWithTag("2DGTRCPROPS", "  [Property filename: null]");
            }
            long l = this.readPtrAsLong(dgData.getField("traceBufferSpec"));
            if (l != 0L) {
                object3 = "  Buffer specification: " + this.getCStringFromPtr(dgData.getField("traceBufferSpec"));
                this.printWithTag("2DGTRCBUFFERS", (String)object3);
            } else if (bl) {
                this.printWithTag("2DGTRCBUFFERS", "  [Buffer specification: null]");
            }
            object3 = dgData.getField("traceGlobal");
            if (this.readPtrAsLong((CTypeObject)object3) != 0L) {
                int n6 = 0;
                int n7 = 0;
                while (this.readPtrAsLong((CTypeObject)object3) != 0L) {
                    ++n6;
                    object2 = ((CTypeObject)object3).deReference("DgTraceBuffer").getField("flags");
                    long l2 = this.readAnInt((CTypeObject)object2);
                    if ((l2 & 0x80000000L) != 0L) {
                        ++n7;
                    }
                    object3 = ((CTypeObject)object3).deReference("DgTraceBuffer").getField("globalNext");
                }
                object2 = "  Buffers allocated: " + n6;
                this.printWithTag("2DGTRCBUFALLOC", (String)object2);
                string = "  Buffers in use:    " + n7;
                this.printWithTag("2DGTRCBUFUSED", string);
            } else if (bl) {
                this.printWithTag("2DGTRCBUFALLOC", "  [Buffers allocated: 0]");
                this.printWithTag("2DGTRCBUFUSED", "  [Buffers in use:    0]");
            }
            if (this.getCStringFromPtr(dgData.getField("exceptFilename")) != null) {
                String string13 = "  Exception filename: " + this.getCStringFromPtr(dgData.getField("exceptFilename"));
                this.printWithTag("2DGTRCEXCEPTFN", string13);
            } else if (bl) {
                this.printWithTag("2DGTRCEXCEPTFN", "  [Exception filename: null]");
            }
            int n8 = this.readAnInt(dgData.getField("exceptTraceWrap"));
            if (n8 != 0) {
                String string14 = "  Maximum exception file size: " + n8;
                this.printWithTag("2DGTRCEXCPTMAX", string14);
            } else if (bl) {
                this.printWithTag("2DGTRCEXCPTMAX", "  [Maximum exception file size: 0]");
            }
            if (this.getCStringFromPtr(dgData.getField("stateFilename")) != null) {
                String string15 = "  State filename: " + this.getCStringFromPtr(dgData.getField("stateFilename"));
                this.printWithTag("2DGTRCSTATEFN", string15);
            } else if (bl) {
                this.printWithTag("2DGTRCSTATEFN", "  [State filename: null]");
            }
            int n9 = this.readAnInt(dgData.getField("stateTraceWrap"));
            if (n9 != 0) {
                object2 = "  Maximum state file size: " + n9;
                this.printWithTag("2DGTRCSTATEMAX", (String)object2);
            } else if (bl) {
                this.printWithTag("2DGTRCSTATEMAX", "  [Maximum state file size: 0]");
            }
            object2 = dgData.getField("traceApplids");
            if (this.readPtrAsLong((CTypeObject)object2) != 0L) {
                this.printWithTag("2DGTRCAPPLTRC", "  Application trace enabled");
                this.printWithTag("3DGTRCAPPLID", "    ***IBM.WRITEME***");
            } else if (bl) {
                this.printWithTag("2DGTRCAPPLTRC", "  [Application trace NOT enabled]");
                this.printWithTag("3DGTRCAPPLID", "    [***IBM.WRITEME***]");
            }
            if (this.getCStringFromPtr(dgData.getField("traceMethodSpec")) != null) {
                string = "  Method trace specification: " + this.getCStringFromPtr(dgData.getField("traceMethodSpec"));
                this.printWithTag("2DGTRCMETHODS", string);
            } else if (bl) {
                this.printWithTag("2DGTRCMETHODS", "  [Method trace specification: n/a]");
            }
            if (this.readPtrAsLong(dgData.getField("traceListeners")) != 0L) {
                string = "  Trace listener routines:";
                this.printWithTag("2DGTRCLISTEN", string);
                boolean bl3 = false;
                CTypeObject cTypeObject = null;
                if (this.readPtrAsLong(dgData.getField("traceListeners")) == 0L) {
                    bl3 = true;
                } else {
                    cTypeObject = dgData.getField("traceListeners").deReference("DgTraceListener");
                }
                while (!bl3) {
                    object = Long.toHexString(this.readPtrAsLong(cTypeObject.getField("Trace")));
                    this.printWithTag("3DGTRCLISTENR", "    Listener: 0x" + (String)object);
                    if (this.readPtrAsLong(cTypeObject.getField("next")) == 0L) {
                        bl3 = true;
                        continue;
                    }
                    cTypeObject = cTypeObject.getField("next").deReference("DgTraceListener");
                }
            } else if (bl) {
                this.printWithTag("2DGTRCLISTEN", "  Trace listener routines: NONE");
            }
            string = this.boolFieldToString(dgData.getField("check_ras_plugin"), "RAS plug-in is in control", "[RAS plug-in is NOT in control]");
            if (string.indexOf("[") == -1 || bl) {
                this.printWithTag("1DGRASPLUGINACT", string);
            }
            if (this.readPtrAsLong(dgData.getField("dumpExits")) != 0L) {
                String string16 = "Dump exit routines:";
                this.printWithTag("1DGDMPEXIT", string16);
                boolean bl4 = false;
                object = null;
                if (this.readPtrAsLong(dgData.getField("dumpExits")) == 0L) {
                    bl4 = true;
                } else {
                    object = dgData.getField("dumpExits").deReference("DgDumpExit");
                }
                while (!bl4) {
                    String string17 = Long.toHexString(this.readPtrAsLong(((CTypeObject)object).getField("exit")));
                    this.printWithTag("2DGTRCLISTENR", "  Exit: 0x" + string17);
                    if (this.readPtrAsLong(((CTypeObject)object).getField("next")) == 0L) {
                        bl4 = true;
                        continue;
                    }
                    object = ((CTypeObject)object).getField("next").deReference("DgDumpExit");
                }
            } else if (bl) {
                this.printWithTag("1DGDMPEXIT", "[Dump exit routines: NONE]");
            }
            String string18 = "Javadump buffer size (allocated): " + this.readAnInt(dgData.getField("printBufferSize"));
            this.printWithTag("1DGJDUMPBUFF", string18);
        }
        catch (Exception exception) {
            output.add("*** Exception thrown in doDGSection while processing DG Dump Rotuine.");
            output.add("    " + exception.getMessage());
            this.outputFlush();
            exception.printStackTrace();
        }
        this.outputFlush();
    }

    private void doSTSection() {
        this.newSection("ST");
        String string = "<dummy>";
        try {
            int n;
            CTypeObject cTypeObject;
            long l;
            CTypeObject cTypeObject2;
            CTypeObject cTypeObject3 = stData.getField("st_jab").deReference("StorageJab");
            if (cTypeObject3 == null) {
                System.out.println("*** Error: storage JAB is null!");
                throw new RuntimeException("Storage JAB is null");
            }
            CTypeObject cTypeObject4 = jvm.getField("jab").deReference("JvmSetAnchorBlock");
            CTypeObject cTypeObject5 = cTypeObject4.getField("xm.resettable");
            String string2 = this.boolFieldToString(cTypeObject5, "Yes", "No");
            this.printWithTag("1STGCMODES", "Resettable GC: " + string2);
            CTypeObject cTypeObject6 = stData.getField("concurrent_execution_mode");
            int n2 = this.readAnInt(cTypeObject6);
            int n3 = 1;
            String string3 = null;
            string3 = n2 != n3 ? "Yes" : "No";
            this.printWithTag("1STGCMODES", "Concurrent GC: " + string3);
            CTypeObject cTypeObject7 = stData.getField("curHeapMin");
            long l2 = this.readPtrAsLong(cTypeObject7);
            this.printWithTag("1STCURHBASE", "Current Heap Base: " + Long.toHexString(l2));
            CTypeObject cTypeObject8 = stData.getField("curHeapMax");
            long l3 = this.readPtrAsLong(cTypeObject8);
            this.printWithTag("1STCURHLIM", "Current Heap Limit: " + Long.toHexString(l3));
            CTypeObject cTypeObject9 = stData.getField("MH_heapbase");
            long l4 = this.readPtrAsLong(cTypeObject9);
            this.printWithTag("1STMWHBASE", "Middleware Heap Base: " + Long.toHexString(l4));
            CTypeObject cTypeObject10 = stData.getField("MH_heaplimit");
            long l5 = this.readPtrAsLong(cTypeObject10);
            this.printWithTag("1STMWHLIM", "Middleware Heap Limit: " + Long.toHexString(l5));
            if (string2.equals("Yes")) {
                cTypeObject2 = stData.getField("TH_heapbase");
                l = this.readPtrAsLong(cTypeObject2);
                this.printWithTag("1STTHBASE", "Transient Heap Base: " + Long.toHexString(l));
            }
            if (string2.equals("Yes")) {
                cTypeObject2 = stData.getField("TH_heaplimit");
                l = this.readPtrAsLong(cTypeObject2);
                this.printWithTag("1STTHLIM", "Transient Heap Limit: " + Long.toHexString(l));
            }
            cTypeObject2 = stData.getField("gcHelpersTarget");
            int n4 = this.readAnInt(cTypeObject2);
            this.printWithTag("1STGCHELPERS", "Number of GC Helper Threads: " + n4);
            CTypeObject cTypeObject11 = cTypeObject3.getField("alloc_2_trace_rate");
            int n5 = this.readAnInt(cTypeObject11);
            this.printWithTag("1STJVMOPTS", "-Xconcurrentlevel: " + n5);
            CTypeObject cTypeObject12 = cTypeObject3.getField("gcConcurrentBKHelpers");
            int n6 = this.readAnInt(cTypeObject12);
            this.printWithTag("1STJVMOPTS", "-Xconcurrentbackground: " + n6);
            if (string3.equals("Yes")) {
                cTypeObject = stData.getField("conctr");
                n = this.readAnInt(cTypeObject);
                this.printWithTag("1STCONCTR", "Concurrent Counter: " + n);
            }
            cTypeObject = stData.getField("gcctr");
            n = this.readAnInt(cTypeObject);
            this.printWithTag("1STGCCTR", "GC Counter: " + n);
            CTypeObject cTypeObject13 = stData.getField("afctr");
            int n7 = this.readAnInt(cTypeObject13);
            this.printWithTag("1STAFCTR", "AF Counter: " + n7);
            CTypeObject cTypeObject14 = stData.getField("FreeObjectCtr");
            int n8 = this.readAnInt(cTypeObject14);
            this.printWithTag("1STHEAPFREE", "Bytes of Heap Space Free: " + n8);
            CTypeObject cTypeObject15 = stData.getField("TotalObjectCtr");
            int n9 = this.readAnInt(cTypeObject15);
            this.printWithTag("1STHEAPALLOC", "Bytes of Heap Space Allocated: " + n9);
            CTypeObject cTypeObject16 = cTypeObject3.getField("SM_base");
            long l6 = this.readPtrAsLong(cTypeObject16);
            this.printWithTag("1STSMBASE", "SM Base: " + Long.toHexString(l6));
            CTypeObject cTypeObject17 = cTypeObject3.getField("SM_end");
            long l7 = this.readPtrAsLong(cTypeObject17);
            this.printWithTag("1STSMEND", "SM End: " + Long.toHexString(l7));
            CTypeObject cTypeObject18 = cTypeObject3.getField("PAM_start");
            long l8 = this.readPtrAsLong(cTypeObject18);
            this.printWithTag("1STSMEND", "PAM Start: " + Long.toHexString(l8));
            CTypeObject cTypeObject19 = cTypeObject3.getField("PAM_end");
            long l9 = this.readPtrAsLong(cTypeObject19);
            this.printWithTag("1STSMEND", "PAM End: " + Long.toHexString(l9));
            CTypeObject cTypeObject20 = stData.getField("compact_action");
            int n10 = this.readAnInt(cTypeObject20);
            this.printWithTag("1STCOMACTION", "Compact Action: " + n10);
        }
        catch (Exception exception) {
            output.add("*** Unexpected exception recived during stDumpRoutine processing.");
            output.add(exception.getMessage());
            this.outputFlush();
            exception.printStackTrace();
        }
        this.outputFlush();
    }

    private void doXESection() {
        this.newSection("XE");
        try {
            CTypeObject cTypeObject = xeData.getField("common");
            CTypeObject cTypeObject2 = cTypeObject.getField("before_compile_java");
            int n = this.readAnInt(cTypeObject2);
            this.printWithTag("1XETHRESHOLD", "MMI threshold for java methods is set to " + n);
            CTypeObject cTypeObject3 = cTypeObject.getField("compiler_initialized");
            String string = this.boolFieldToString(cTypeObject3, "Yes", "No");
            if (string.equals("Yes")) {
                this.printWithTag("1XEJITINIT", "JIT is initialized");
            } else {
                this.printWithTag("1XEJITNINIT", "JIT is not initialized");
            }
            CTypeObject cTypeObject4 = cTypeObject.getField("do_jvmpi_instruction_events");
            String string2 = this.boolFieldToString(cTypeObject4, "Yes", "No");
            if (string2.equals("Yes")) {
                this.printWithTag("1XEJVMPION", "JVMPI is activated");
            } else {
                this.printWithTag("1XEJVMPIOFF", "JVMPI is not activated");
            }
            CTypeObject cTypeObject5 = xeData.getField("mmi");
            CTypeObject cTypeObject6 = cTypeObject5.getField("before_compile_jni");
            int n2 = this.readAnInt(cTypeObject6);
            this.printWithTag("1XEJNITHRESH", "MMI threshold for JNI methods is set to " + n2);
            CTypeObject cTypeObject7 = cTypeObject5.getField("history_length");
            int n3 = this.readAnInt(cTypeObject7);
            this.printWithTag("1XETRCHIS", "Trace history length is set to " + n3);
            this.printWithTag("1XEJITDUMP", "JIT dump routine is not yet implemented.");
        }
        catch (Exception exception) {
            this.outputFlush();
            System.out.println("*** unexpected Exception received in doXESection()");
            System.out.println("    " + exception.getMessage());
            exception.printStackTrace();
        }
        this.outputFlush();
    }

    private void doLKSection() {
        this.newSection("LK");
        Vector vector = DvObjectsCommands.lkDumpRoutine();
        int n = 0;
        while (n < vector.size()) {
            this.printWithTag((String)vector.elementAt(n), (String)vector.elementAt(n + 1));
            n += 2;
        }
        this.outputFlush();
    }

    private void doXMSection() {
        DvProcess[] dvProcessArray;
        this.newSection("XM");
        this.printWithTag("NULL", " ");
        this.printWithTag("1XMEXCPINFO", "Exception Info");
        this.printWithTag("NULL", "--------------");
        this.printWithTag("2XMDUMPINFONA", "Not available");
        this.printWithTag("NULL", " ");
        this.printWithTag("1XMTHDINFO", "Thread Info");
        this.printWithTag("NULL", "-----------");
        this.printWithTag("NULL", " ");
        DvProcess dvProcess = null;
        DvEnvData dvEnvData = null;
        try {
            dvProcess = as.getCurrentProcess();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (dvProcess == null) {
            this.printWithTag("2XMFULLTHDDUMP", "Full thread dump Classic VM (<UNSUPPORTED>, native threads)");
        } else {
            String string;
            block29: {
                dvEnvData = dvProcess.getEnvData();
                dvProcessArray = jvm.getField("fullVersion");
                string = null;
                try {
                    string = this.getCStringFromPtr((CTypeObject)dvProcessArray);
                }
                catch (DvAddressException dvAddressException) {
                    string = dvEnvData.javaVersion().trim();
                    if (string != null && !string.equals("")) break block29;
                    string = "<version not available>";
                }
            }
            this.printWithTag("2XMFULLTHDDUMP", "Full thread dump Classic VM (" + string + ", native threads)");
        }
        this.outputFlush();
        try {
            dvProcessArray = as.getProcesses();
            int n = 0;
            while (n < dvProcessArray.length) {
                DvThread[] dvThreadArray = dvProcessArray[n].getThreads();
                int n2 = dvThreadArray.length - 1;
                while (n2 >= 0) {
                    try {
                        Object object;
                        Object object2;
                        DvThread dvThread = dvThreadArray[n2];
                        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), as);
                        long l = -1L;
                        try {
                            object2 = cTypeObject.getField("thread_priority");
                            l = this.readPtrAsLong((CTypeObject)object2);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        object2 = "<unknown>";
                        if (l != -1L) {
                            object2 = new Long(l).toString();
                        }
                        int n3 = -1;
                        n3 = this.theDump.getSystemType() == 4 ? Integer.parseInt(dvThread.id(), 16) : Integer.parseInt(dvThread.id());
                        long l2 = this.readPtrAsLong(cTypeObject.getField("thread"));
                        CTypeObject cTypeObject2 = cTypeObject.getField("sys_thr");
                        long l3 = cTypeObject2.getAddr();
                        String string = this.getThreadName(l2, as);
                        CTypeObject cTypeObject3 = new CTypeObject("sys_thread", l3, as);
                        CTypeObject cTypeObject4 = cTypeObject3.getField("state");
                        int n4 = this.readAnInt(cTypeObject4);
                        String string2 = new String("<" + n4 + ">");
                        this.printWithTag("3XMTHREADINFO", "    \"" + string + "\"" + " (TID:0x" + Long.toHexString(l2) + ", sys_thread_t:0x" + Long.toHexString(l3) + ", state:" + string2 + ", native ID:0x" + Long.toHexString(n3) + ") prio=" + (String)object2);
                        this.outputFlush();
                        try {
                            if (dvThread != null && dvThread.getJavaStack() != null) {
                                int n5 = 0;
                                while ((long)n5 < dvThread.getJavaStack().getNumFrames()) {
                                    object = dvThread.getJavaStack().getFrame(n5).toString();
                                    if (!((String)object).startsWith("pseudo frame")) {
                                        this.printWithTag("4XESTACKTRACE", "        at " + (String)object);
                                    }
                                    ++n5;
                                }
                            } else {
                                this.printWithTag("4??NOJAVASTK", "    no Java stack.");
                            }
                        }
                        catch (Exception exception) {
                            this.printWithTag("4XMJAVASTCKEX", "**** Exception <?> received when dumping Java stack.");
                            this.outputFlush();
                            exception.printStackTrace();
                        }
                        try {
                            if (dvThread != null && dvThread.getNativeStack() != null) {
                                if (dvThread.getNativeStack().getNumFrames() > 0L) {
                                    this.printWithTag("3HPNATIVESTACK", "        Native Stack");
                                    this.printWithTag("NULL", "        ------------");
                                    int n6 = 0;
                                    while ((long)n6 < dvThread.getNativeStack().getNumFrames()) {
                                        object = dvThread.getNativeStack().getFrame(n6);
                                        if (as.pointerSize() == 4) {
                                            this.printWithTag("4HPTRACEBACK", "        at " + Integer.toHexString((int)((DvNativeFrame)object).getPc()) + " in " + ((DvNativeFrame)object).toString());
                                        } else {
                                            this.printWithTag("4HPTRACEBACK", "        at " + Long.toHexString(((DvNativeFrame)object).getPc()) + " in " + ((DvNativeFrame)object).toString());
                                        }
                                        ++n6;
                                    }
                                }
                            } else {
                                this.printWithTag("4??NONATIVESTK", "    no native stack.");
                            }
                        }
                        catch (Exception exception) {
                            this.printWithTag("4XMNATIVESTCKEX", "**** Exception <?> received when dumping native stack.");
                            this.outputFlush();
                            exception.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        output.add("*** Exception received processing a thread\n" + exception.getMessage());
                        this.outputFlush();
                        exception.printStackTrace();
                    }
                    --n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            output.add("*** Exception received while traversing Thread Stacks\n" + exception.getMessage());
            this.outputFlush();
            exception.printStackTrace();
        }
    }

    private void doCLSection() {
        Enumeration enumeration;
        String string;
        Object object;
        Object object2;
        this.newSection("CL");
        Properties properties = new Properties();
        Hashtable hashtable = new Hashtable();
        Properties properties2 = new Properties();
        Hashtable hashtable2 = new Hashtable();
        DvObjectsCommands dvObjectsCommands = DvObjectsCommands.getCurrentInstance();
        this.printWithTag("1CLFLAGOLDJAVA", "Oldjava mode <n/a>");
        this.printWithTag("1CLFLAGBOOTSTRP", "Bootstrapping <n/a>");
        this.printWithTag("1CLFLAGVERBOSE", "Verbose class dependencies <n/a>");
        this.printWithTag("1CLENUMVERIFY", "Class verification <n/a>");
        this.printWithTag("1CLPNTRNAMECLLO", "Namespace to classloader <n/a>");
        this.printWithTag("1CLPNTRCHAINLO", "Start of cache entry pool <n/a>");
        this.printWithTag("1CLPNTRCHFREE", "Start of free cache entries <n/a>");
        this.printWithTag("1CLPNTRMETHODTB", "Location of method table <n/a>");
        this.printWithTag("1CLPNTRANCHRGLN", "Global namespace anchor <n/a>");
        this.printWithTag("1CLPNTRCLSLOADS", "System classloader shadow <n/a>");
        this.printWithTag("1CLPNTRSYSLOADS", "Classloader shadows <n/a>");
        this.printWithTag("1CLPNTRCLSEXT", "Extension loader <n/a>");
        this.outputFlush();
        String[] stringArray = null;
        try {
            String[] stringArray2 = DvConsole.execValidCmdToArray("dis cls");
            int n = 4;
            stringArray = new String[stringArray2.length - n];
            int n2 = n;
            while (n2 < stringArray2.length) {
                object2 = stringArray2[n2];
                if (object2 != null) {
                    object2 = ((String)object2).substring(((String)object2).indexOf("@") + 1, ((String)object2).length());
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(" "));
                    stringArray[n2 - n] = new String((String)object2);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            output.add("*** Error: exception obtaining list of loaded classes (CL section 1)");
            output.add(exception.getMessage());
            this.outputFlush();
            exception.printStackTrace();
        }
        try {
            this.outputFlush();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string2 != null) {
                    long l = this.getLoaderFromClass(Long.parseLong(string2, 16));
                    if (l == -1L) {
                        throw new RuntimeException("getLoaderFromClass returned -1!");
                    }
                    object = "0x" + Long.toHexString(l);
                    if (properties.getProperty((String)object) == null) {
                        try {
                            string = "<UNKNOWN>";
                            string = ((String)object).equals("0x0") ? "*SYSTEM*" : dvObjectsCommands.getObjectNameAtAddress(l);
                            properties.setProperty((String)object, string);
                            properties2.setProperty(string, (String)object);
                            hashtable.put(object, new Vector());
                            hashtable2.put(object, new Integer(0));
                        }
                        catch (Exception exception) {
                            output.add("*** Unexpected exception received in new ClassLoader section");
                            this.outputFlush();
                            exception.printStackTrace();
                        }
                    }
                    this.outputFlush();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.outputFlush();
            System.out.println("*** Error: unexpected exception received in doCLSection()");
            exception.printStackTrace();
        }
        try {
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (string3 != null) {
                    long l = this.getLoaderFromClass(Long.parseLong(string3, 16));
                    if (l == -1L) {
                        throw new RuntimeException("getLoaderFromClass returned -1!");
                    }
                    object = "0x" + Long.toHexString(l);
                    string = "<NOT A VALID CLASS>";
                    long l2 = Long.parseLong(string3, 16);
                    if (dvObjectsCommands.getObjectNameAtAddress(l2).equals("java/lang/Class")) {
                        string = dvObjectsCommands.getClassNameAtAddress(l2) + "(0x" + string3 + ")";
                    } else {
                        output.add("*** Error: address 0x" + string3 + " is not the address of a class!!");
                    }
                    Vector vector = (Vector)hashtable.get(object);
                    vector.add(string);
                    Integer n3 = (Integer)hashtable2.get(object);
                    n3 = new Integer(n3 + 1);
                    hashtable2.put(object, n3);
                    this.outputFlush();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 3");
            exception.printStackTrace();
        }
        try {
            this.printWithTag("1CLTEXTCLLOS", "Classloader summaries");
            this.printWithTag("1CLTEXTCLLSS", "        12345678: 1=primordial,2=extension,3=shareable,4=middleware,5=system,6=trusted,7=application,8=delegating");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = properties.getProperty(string4);
                object2 = properties2.getProperty(string5);
                object = (Integer)hashtable2.get(object2);
                if (string5.equals("*SYSTEM*")) {
                    this.printWithTag("2CLTEXTCLLOADER", "        -------- Loader " + string5 + " (" + (String)object2 + ")" + ", Shadow 0x00000000");
                } else {
                    this.printWithTag("2CLTEXTCLLOADER", "        -------- Loader " + string5 + " (" + (String)object2 + ")" + ", Shadow 0x<n/a>, " + "[Parent <n/a>(0x<n/a>)]");
                }
                this.printWithTag("3CLNMBRLOADEDCL", "                Number of loaded classes " + object);
                this.printWithTag("3CLNMBRCACHECLS", "                Number of cached classes <n/a>");
                this.printWithTag("3CLHEXDALLOCTIO", "                Allocation used for loaded classes <n/a>");
                if (string5.equals("*SYSTEM*")) {
                    this.printWithTag("3CLHEXDPCKGEOWN", "                Package owner 0x00000000");
                } else {
                    this.printWithTag("3CLHEXDPCKGEOWN", "                Package owner 0x<n/a>");
                }
                this.outputFlush();
            }
        }
        catch (Exception exception) {
            this.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 4");
            exception.printStackTrace();
        }
        try {
            this.printWithTag("1CLTEXTCLLOD", "ClassLoader loaded classes");
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                String string7 = properties.getProperty(string6);
                this.printWithTag("2CLTEXTCLLOAD", "        Loader " + string7 + "(" + string6 + ")");
                object2 = (Vector)hashtable.get(string6);
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    this.printWithTag("3CLTEXTCLASS", "                " + string);
                }
            }
        }
        catch (Exception exception) {
            this.outputFlush();
            System.out.println("*** Error: exception received in doCLSection() section 5");
            exception.printStackTrace();
        }
        this.outputFlush();
    }

    private void doENDSection() {
        this.printWithTag("NULL", "---------------------------------------------------------------");
        this.printWithTag("0SECTION", "Javadump End section");
        this.printWithTag("1DGJDUMP", "Javadump Buffer Usage Information");
        this.printWithTag("NULL", "=================================");
        CTypeObject cTypeObject = dgData.getField("printBufferSize");
        if (cTypeObject != null) {
            int n = this.readAnInt(cTypeObject);
            if (n != -1) {
                this.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): " + n);
            } else {
                this.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): <ERROR2>");
            }
        } else {
            this.printWithTag("2DGJDUMPALLOC", "Javadump buffer size (allocated): <ERROR1>");
        }
        CTypeObject cTypeObject2 = dgData.getField("printBufferP");
        CTypeObject cTypeObject3 = dgData.getField("printBuffer");
        if (cTypeObject2 == null || cTypeObject3 == null) {
            this.printWithTag("2DGJDUMPUSED", "Javadump buffer size (used)     : <ERROR3>");
        } else {
            long l = this.readPtrAsLong(cTypeObject2);
            long l2 = this.readPtrAsLong(cTypeObject3);
            long l3 = l - l2;
            this.printWithTag("2DGJDUMPUSED", "Javadump buffer size (used)     : " + l3);
        }
        this.printWithTag("NULL", "------------------ END OF DUMP --------------------------------");
        this.outputFlush();
    }

    private void newSection(String string) {
        String string2 = string + " subcomponent dump routine";
        String string3 = "";
        int n = 0;
        while (n < string2.length()) {
            string3 = string3.concat("=");
            ++n;
        }
        this.printWithTag("NULL", "---------------------------------------------------------------");
        this.printWithTag("0SECTION", string2);
        this.printWithTag("NULL", string3);
    }

    private void printWithTag(String string, String string2) {
        String string3 = "               ";
        String string4 = string.concat(string3);
        string4 = string4.substring(0, 15);
        string4 = string4.concat(" ");
        string4 = string4.concat(string2);
        if (tags) {
            output.add(string4);
        } else {
            output.add(string2);
        }
    }

    private boolean noDumpAccessed() {
        if (this.theDump == null) {
            output.add("Unable to comply as no dump accessed yet.");
            return true;
        }
        return false;
    }

    private String getEnvVar(String string) {
        String string2 = "NULL";
        try {
            string2 = DvUtils.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = "NULL";
        }
        return string2;
    }

    private String[] getEnvVarsFromDump() {
        boolean bl = false;
        int n = 0;
        String[] stringArray = DvConsole.execValidCmdToArray("DIS PROC");
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                if (stringArray[n2].toUpperCase().indexOf("LOADED DATA") != -1) {
                    bl = false;
                }
                if (bl) {
                    vector.add(stringArray[n2]);
                    ++n;
                }
                if (stringArray[n2].indexOf("Environment Variables") != -1) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        vector.trimToSize();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        if (((String)objectArray[0]).indexOf("No loaded information for this process") != -1) {
            return null;
        }
        return objectArray;
    }

    private String restOfLineAfter(String[] stringArray, String string) {
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toUpperCase().indexOf(string.toUpperCase()) != -1) {
                string2 = stringArray[n];
                string2 = string2.substring(string2.toUpperCase().indexOf(string.toUpperCase()), string2.length());
                string2 = string2.substring(string.length(), string2.length());
                int n2 = 0;
                while (n2 < string2.length()) {
                    char c = string2.charAt(n2);
                    if (!Character.isLetterOrDigit(c) && " \u00ac`!\u00a3$%^&*()_+-={}[]:@~;'#<>?,./|\\".indexOf(c) == -1) break;
                    ++n2;
                }
                if (n2 == 0) {
                    return "*** Error: ZERO length string";
                }
                return string2.substring(0, n2);
            }
            ++n;
        }
        return null;
    }

    private long readPtrAsLong(CTypeObject cTypeObject) {
        long l = 0L;
        try {
            DvAddress dvAddress = as.readPointer(as.createAddress(cTypeObject.getAddr()));
            l = dvAddress.getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            output.add("Exception while trying to read pointer from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            output.add(dvAddressException.toString());
            this.outputFlush();
        }
        return l;
    }

    private int readAnInt(CTypeObject cTypeObject) {
        int n = -1;
        try {
            long l = cTypeObject.getAddr();
            DvAddress dvAddress = as.createAddress(l);
            n = as.readInt(dvAddress);
        }
        catch (DvAddressException dvAddressException) {
            output.add("Exception while trying to read field from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            output.add(dvAddressException.toString());
            this.outputFlush();
        }
        return n;
    }

    private byte readAByte(CTypeObject cTypeObject) {
        byte by = 0;
        try {
            long l = cTypeObject.getAddr();
            DvAddress dvAddress = as.createAddress(l);
            by = as.readByte(dvAddress);
        }
        catch (DvAddressException dvAddressException) {
            output.add("Exception while trying to read byte from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            output.add(dvAddressException.toString());
            this.outputFlush();
        }
        return by;
    }

    private String boolFieldToString(CTypeObject cTypeObject, String string, String string2) throws Exception {
        String string3 = "*** Dunno ***";
        int n = this.readAnInt(cTypeObject);
        string3 = n == 0 ? string2 : string;
        return string3;
    }

    private String getCStringFromPtr(CTypeObject cTypeObject) throws DvAddressException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        long l = cTypeObject.getAddr();
        DvAddress dvAddress = as.readPointer(as.createAddress(cTypeObject.getAddr()));
        if (dvAddress.getAddressAsLong() != 0L) {
            int n = 0;
            byte by = as.readByte(dvAddress);
            while (by != 0 && n < 128) {
                stringBuffer.append((char)by);
                dvAddress = as.createAddress(dvAddress.getAddressAsLong() + 1L);
                by = as.readByte(dvAddress);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getThreadName(long l, DvAddressSpace dvAddressSpace) throws DvAddressException {
        byte[] byArray;
        CTypeObject cTypeObject = new CTypeObject("Hjava_lang_Thread", dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField("obj");
        CTypeObject cTypeObject3 = cTypeObject2.getField("name");
        DvAddress dvAddress = null;
        try {
            dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            output.add("*** Error: DvAddressException in getThreadName (1)");
            this.returnControl();
        }
        CTypeObject cTypeObject4 = new CTypeObject("Hjava_lang_Object", dvAddressSpace.createAddress(dvAddress.getAddressAsLong()), dvAddressSpace);
        CTypeObject cTypeObject5 = cTypeObject4.getField("obj");
        CTypeObject cTypeObject6 = cTypeObject4.getField("methods");
        long l2 = 0L;
        try {
            l2 = dvAddressSpace.readInt(dvAddressSpace.createAddress(cTypeObject6.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            throw new DvAddressException("DvAddressException in getThreadName (2)");
        }
        String string = "";
        if (l2 > 0L) {
            byte[] byArray2 = null;
            try {
                byArray2 = dvAddressSpace.readBytes(dvAddressSpace.createAddress(cTypeObject5.getAddr()), l2 * 2L);
            }
            catch (DvAddressException dvAddressException) {
                throw new DvAddressException("DvAddressException in getThreadName (3)");
            }
            byArray = new byte[byArray2.length / 2];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = false == DvUtils.isBigEndian(this.theDump.getArchitecture()) ? byArray2[2 * n] : byArray2[2 * n + 1];
                ++n;
            }
        } else {
            throw new DvAddressException("DvAddressException in getThreadName (4)");
        }
        string = new String(byArray);
        return string;
    }

    private String truncateAtIllegalChar(String string) {
        String string2 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ |\\,./<>?;'#:@~[]{}`\u00ac\u00a6!\u00a3$%^&*()_+-=\"0123456789";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.substring(n, n + 1)) == -1) {
                if (n == 0) {
                    return new String("<ERROR>");
                }
                return string.substring(0, n);
            }
            ++n;
        }
        return string;
    }

    private String xSpaces(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string.concat(" ");
            ++n2;
        }
        return string;
    }

    private void outputFlush() {
        this.cpr.output(output);
        output.clear();
    }

    private void returnControl() {
        this.outputFlush();
        this.forcedEnd = true;
    }

    public static Object getGenericHelp() {
        return new Object();
    }

    public String pluginName() {
        return "Javacore plugin (DvJavacorePlugin)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiMenuSyntax() {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }
}

