/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

public class DvBaseFmtCmds
extends CommandPlugin {
    private static String[] commandsSupported = new String[]{"FORMAT,FOR, , ,showFormatInfo", "FORMAT,FOR,execenv,ee,formatEE", "FORMAT,FOR,jvm,jvm,formatJVM", "FORMAT,FOR,stglobal,stg,formatSTGlobal", "FORMAT,FOR,*,*,doFormat", "DISPLAY,DIS,hints,hints,displayHints", "HELP,?, , ,displayHelp", "HELP,?,*, ,displayHelp"};

    public String pluginName() {
        return "Base format commands (DvBaseFmtCmds)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvBaseFmtCmds.properties");
        return vector;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiMenuSyntax() {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void showFormatInfo() {
        Vector vector = new Vector();
        String string = "DvFormat.txt";
        vector.add("  Format information");
        vector.add("  ==================\n");
        File file = DvUtils.searchForFile(string);
        if (null == file || !file.canRead()) {
            vector.add("  " + string + " not found!!!!");
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[5000];
                fileInputStream.read(byArray);
                String string2 = new String(byArray);
                string2 = string2.trim();
                vector.add(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                vector.add(" IOError for " + string);
            }
        }
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void doFormat() {
        Vector vector = new Vector();
        if (null != this.theDump) {
            vector.add(DvBaseFmtCmds.doFormatEx(this.paramString, this.theDump, this.verbModifier));
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public static Vector doFormatEx(String string, DvDump dvDump, String string2) {
        DvUtils.trace(" Entry to DvBaseFmtCmds:doFormatEx (" + string2 + " " + string + ")", 0, false);
        Vector vector = new Vector();
        if (null == string) {
            vector.add(" paramString is null !!!!");
        } else {
            Vector vector2 = DvUtils.splitIntoPieces(string, " ");
            String string3 = (String)vector2.get(0);
            if (string3.toUpperCase().equals("AS")) {
                if (vector2.size() != 2) {
                    vector.add(" Invalid request");
                } else {
                    long l = 0L;
                    try {
                        String string4 = DvUtils.getValue("ASID");
                        DvAddressSpace dvAddressSpace = DvUtils.findAsid(dvDump, string4);
                        string2 = DvUtils.remove0x(string2);
                        l = DvUtils.hexToLong(string2);
                        String string5 = (String)vector2.get(1);
                        if (null != CType.find(string5)) {
                            if (null != dvAddressSpace) {
                                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, string5);
                                    if (null != cTypeObject) {
                                        vector.add(cTypeObject);
                                        vector.add("\n " + string + " finished");
                                    } else {
                                        vector.add(" Format failed!!!!");
                                    }
                                } else {
                                    vector.add(" Address " + string2 + " not in dump");
                                }
                            } else {
                                vector.add(" Unable to find address space: " + string4);
                            }
                        } else {
                            vector.add(" Unsupported structure \"" + string5 + "\" (case is relevent).");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.add(" Invalid hex: " + string2);
                    }
                }
            }
        }
        DvUtils.trace(" Exit from DvBaseFmtCmds:doFormatEx", 0, false);
        return vector;
    }

    public void formatEE() {
        Vector vector = new Vector();
        if (null != this.theDump) {
            String string;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(this.theDump, "P");
            DvThread dvThread = (DvThread)DvUtils.getAPT(this.theDump, "T");
            if (null == this.paramString) {
                string = DvUtils.getValue("THREAD");
            } else {
                string = this.paramString;
                if (dvAddressSpace != null && dvProcess != null) {
                    dvThread = DvUtils.findThread(this.theDump, string, dvAddressSpace, dvProcess);
                }
            }
            vector.add("\n execenv for thread " + string + "\n ==========================\n");
            if (null != dvAddressSpace && null != dvProcess && null != dvThread) {
                DvAddress dvAddress = dvAddressSpace.createAddress(dvThread.eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
                    if (null != cTypeObject) {
                        vector.add(cTypeObject);
                        vector.add("\n Format of execenv finished");
                    } else {
                        vector.add(" Format of execenv failed!!!!");
                    }
                } else {
                    vector.add(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
                }
            } else {
                vector.add(" ASID/Process/Thread invalid");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void formatJVM() {
        DvUtils.trace(" Entry to DvBaseFmtCmds:formatJVM", 0, false);
        Vector vector = new Vector();
        if (null != this.theDump) {
            String string;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(this.theDump, "P");
            DvThread dvThread = (DvThread)DvUtils.getAPT(this.theDump, "T");
            if (null == this.paramString) {
                string = DvUtils.getValue("THREAD");
            } else {
                string = this.paramString;
                if (dvAddressSpace != null && dvProcess != null) {
                    dvThread = DvUtils.findThread(this.theDump, string, dvAddressSpace, dvProcess);
                }
            }
            vector.add("\n Jvm via thread " + string + "\n ==========================\n");
            if (null != dvAddressSpace && null != dvProcess && null != dvThread) {
                DvAddress dvAddress = dvAddressSpace.createAddress(dvThread.eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
                    if (null != cTypeObject) {
                        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
                        if (null != cTypeObject2) {
                            String string2 = cTypeObject2.toString();
                            if (string2.startsWith("null ")) {
                                string2 = string2.substring(5);
                            }
                            if (string2.startsWith("(null) ")) {
                                string2 = string2.substring(7);
                            }
                            string2 = DvUtils.removeAtSign(string2);
                            string2 = DvUtils.remove0x(string2);
                            DvAddress dvAddress2 = null;
                            DvAddress dvAddress3 = dvAddressSpace.createAddress(DvUtils.hexToLong(string2));
                            try {
                                dvAddress2 = dvAddressSpace.readPointer(dvAddress3);
                            }
                            catch (DvAddressException dvAddressException) {
                                vector.add("\n jvmP addressing failure");
                            }
                            CTypeObject cTypeObject3 = null;
                            if (null != dvAddress2) {
                                cTypeObject3 = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress2, "Jvm");
                            }
                            if (null != cTypeObject3) {
                                DvUtils.setupJVMHints(cTypeObject3, dvAddressSpace);
                                vector.add(cTypeObject3);
                                vector.add("\n Format of Jvm finished");
                            } else {
                                vector.add(" Unable to format Jvm!");
                            }
                        } else {
                            vector.add(" Unable to get jvmP!");
                        }
                    } else {
                        vector.add(" obtaining execenv failure!!!!");
                    }
                } else {
                    vector.add(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
                }
            } else {
                vector.add(" ASID/Process/Thread invalid");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
        DvUtils.trace(" Exit from DvBaseFmtCmds:formatJVM", 0, false);
    }

    public void formatSTGlobal() {
        Vector vector = new Vector();
        if (null != this.theDump) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
            if (null != dvAddressSpace) {
                String string = DvUtils.getJVMHint(dvAddressSpace, "STGLOBALPTR");
                if (null != string) {
                    this.verbModifier = string;
                    this.paramString = "as STGlobal";
                    this.doFormat();
                    return;
                }
                vector.add(" Unable to comply - no hint found for STGLOBALPTR");
            } else {
                vector.add(" Unable to comply as no valid address space found");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayHints() {
        Vector vector = new Vector();
        if (null != this.theDump) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(this.theDump, "A");
            if (null != dvAddressSpace) {
                vector.add("\n Jvm Hints for AddressSpace " + dvAddressSpace.id() + "\n ==============================\n");
                vector.add(DvUtils.getAllJVMHints(dvAddressSpace));
            } else {
                vector.add("No current addressSpace establishable");
            }
        } else {
            vector.add(" No dump established yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void reset() {
    }
}

