/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvLoaded;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvModule;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.format.DvRegister;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmds;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvBaseCommands
extends CommandPlugin {
    private static String prevVerb = null;
    private static String prevModifier = null;
    private static String prevParms = null;
    private static String prevSeperator = null;
    private static String[] commandsSupported = new String[]{"SET,SET, , ,showSettings", "SET,SET,*,*,setValue", "DISPLAY,DIS,SYSTEM,SYS,displaySystem", "DISPLAY,DIS,MMAP,MMAP,displayMMAP", "DISPLAY,DIS,MEMORY,MEM,displayMemory", "DISPLAY,DIS,THREAD,T,displayThread", "DISPLAY,DIS,INT,I,displayInt", "DISPLAY,DIS,LONG,L,displayLong", "DISPLAY,DIS,POINTER,P,displayPtr", "DISPLAY,DIS,PROCESS,PROC,displayProcess", "HELP,?, , ,displayHelp", "HELP,?,*,*,displayHelp", "FINDNEXT,FN, , ,findNext", "FINDPTR,FP,*,*,findPointer", "FIND,FIND,*,*,findInMemory", "WHATIS,W,*,*,whatIs"};

    public String pluginName() {
        return "Base Support commands Plugin";
    }

    private void setDump(String string, Vector vector) {
        DvDump dvDump = DvUtils.findDumpPlugin(string);
        if (dvDump != null) {
            this.cpr.output("Dump successfully opened\n\n");
            DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
            DvConsole.setTheDump(dvDump, vector, string);
            DvUtils.setValue("DUMP", string);
        } else {
            this.cpr.output("Dump open failure!!!!");
        }
    }

    private void setOutput(String string) {
        if (string.trim().equals("*")) {
            PrintStream printStream = DvConsole.getOriginal_output();
            System.setOut(printStream);
            this.cpr.output(" Output stream redirected to original (System.out)");
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                PrintStream printStream = new PrintStream(fileOutputStream, true);
                System.setOut(printStream);
                this.cpr.output(" Output stream: " + string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cpr.output(" Invalid output stream: " + string);
            }
            catch (SecurityException securityException) {
                this.cpr.output(" Unable to write to: " + string);
            }
        }
    }

    private void setError(String string) {
        if (string.trim().equals("*")) {
            PrintStream printStream = DvConsole.getOriginal_error();
            System.setErr(printStream);
            this.cpr.output(" Error stream redirected to original (System.err)");
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                PrintStream printStream = new PrintStream(fileOutputStream, true);
                System.setErr(printStream);
                this.cpr.output(" Error stream: " + string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cpr.output(" Invalid error stream: " + string);
            }
            catch (SecurityException securityException) {
                this.cpr.output(" Unable to write to: " + string);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void displayMMAP() {
        String string = null;
        if (null == this.theDump) {
            this.cpr.output("Unable to comply as no Dump opened yet");
            this.forcedEnd = true;
            return;
        }
        DvMemRanges[] dvMemRangesArray = this.theDump.getAddressSpaces()[0].getMemRanges();
        if (null == dvMemRangesArray) {
            this.cpr.output("!!! Error finding memory map array");
            this.forcedEnd = true;
            return;
        }
        String[] stringArray = new String[dvMemRangesArray.length];
        String string2 = null;
        long[] lArray = new long[dvMemRangesArray.length];
        string = "\nMemory Map Table\n================";
        int n = 0;
        while (n < dvMemRangesArray.length) {
            string2 = dvMemRangesArray[n].addressStart().convertToHex();
            string = string + "\nAddress:" + dvMemRangesArray[n].addressStart().convertToHex() + "   " + "Length :" + dvMemRangesArray[n].length();
            ++n;
        }
        this.cpr.output(string);
        this.forcedEnd = true;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public void displayProcess() {
        Vector vector = new Vector();
        String string = null;
        Vector vector2 = new Vector();
        vector.add("\nProcess Information\n===================");
        try {
            string = this.paramString.toUpperCase().trim();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (null == this.theDump) {
            this.cpr.output(" No dump identified yet");
            this.forcedEnd = true;
            return;
        }
        int n = this.theDump.getArchitecture();
        try {
            vector.add("Architecture: " + DvDump.ARCHITECTURE_DESCRIPTION[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            vector.add("Architecture: Unexpected architecture value(" + n + ")");
        }
        DvAddressSpace[] dvAddressSpaceArray = this.theDump.getAddressSpaces();
        String string2 = DvUtils.getValue("PID");
        int n2 = 0;
        while (n2 < dvAddressSpaceArray.length) {
            DvProcess[] dvProcessArray = dvAddressSpaceArray[n2].getProcesses();
            int n3 = 0;
            while (n3 < dvProcessArray.length) {
                if (null != string && string.equals("*") || null == string && dvProcessArray[n3].id().equals(string2)) {
                    vector.add("\n\nAddressSpace: " + dvAddressSpaceArray[n2].id() + "   Process: " + dvProcessArray[n3].id());
                    vector.add("Signal      : " + dvProcessArray[n3].getSignal() + "............\n");
                    DvThread[] dvThreadArray = dvProcessArray[n3].getThreads();
                    int n4 = 0;
                    while (n4 < dvThreadArray.length) {
                        if (!dvThreadArray[n4].isJava()) {
                            vector.add("Thread: " + dvThreadArray[n4].id() + "  Not a java thread");
                        } else {
                            vector.add("Thread: " + dvThreadArray[n4].id() + "  ExecEnv: " + dvThreadArray[n4].eeAddress().convertToHex());
                        }
                        ++n4;
                    }
                    this.addEnvironment(this.theDump, dvAddressSpaceArray[n2], vector);
                    DvLoaded dvLoaded = null;
                    try {
                        dvLoaded = dvProcessArray[n3].getLoaded();
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                    if (null != dvLoaded) {
                        vector.add(dvLoaded);
                    } else {
                        vector.add(" ===================================================\n --- No loaded information for this process ---\n ===================================================");
                    }
                }
                ++n3;
            }
            ++n2;
        }
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void addEnvironment(DvDump dvDump, DvAddressSpace dvAddressSpace, Vector vector) {
        try {
            DvRas dvRas = dvDump.getRas();
            vector.add("\nEnvironment Variables\n=====================\n");
            CTypeObject cTypeObject = new CTypeObject("jvm_ras_t", dvRas.jvmRas, dvAddressSpace);
            DvAddress dvAddress = new DvAddress(cTypeObject.getField("ras.data.envPtr").getValue());
            DvAddress dvAddress2 = dvAddressSpace.readPointer(dvAddress);
            while (dvAddress2 != null && dvAddress2.getAddressAsLong() != 0L) {
                String string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddress2, 1024L));
                dvAddress.offsetBy(dvAddressSpace.pointerSize());
                vector.add(string);
                dvAddress2 = dvAddressSpace.readPointer(dvAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void displaySystem() {
        Vector vector = new Vector();
        if (null != this.theDump) {
            vector.add("\n   System Summary\n   ==============\n");
            int n = this.theDump.getArchitecture();
            try {
                vector.add("  " + DvDump.ARCHITECTURE_DESCRIPTION[n]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                vector.add("  " + DvDump.ARCHITECTURE_DESCRIPTION[0] + " (" + n + ")");
            }
            DvAddressSpace[] dvAddressSpaceArray = this.theDump.getAddressSpaces();
            int n2 = dvAddressSpaceArray.length;
            vector.add("  Number of Address Spaces: " + n2);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                n3 += dvAddressSpaceArray[n4].getProcesses().length;
                ++n4;
            }
            vector.add("  Number of Processes     : " + n3);
            int n5 = this.theDump.getSystemType();
            try {
                vector.add("  System                  : " + DvDump.SYSTEM_DESCRIPTION[n5]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                vector.add("  System                  : " + DvDump.SYSTEM_DESCRIPTION[0] + " (" + n5 + ")");
            }
            int n6 = this.theDump.getSubSystemType();
            try {
                vector.add("  SubSystem               : " + DvDump.SUBSYS_DESCRIPTION[n6]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                vector.add("  SubSystem               : " + DvDump.SUBSYS_DESCRIPTION[0] + " (" + n6 + ")");
            }
            vector.add("  Processor (number)      : ?(?)");
            vector.add("  Processor subtype       : ?");
            vector.add("  Current process id      : ?");
        } else {
            vector.add("\n Unable to comply - no Dump yet accessed\n");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void displayMemory() {
        Integer n;
        long l;
        byte[] byArray;
        DvAddress dvAddress;
        String string;
        String string2;
        block46: {
            DvUtils.trace(" Entry: displayMemory (" + this.paramString + ")", 0, false);
            string2 = null;
            String string3 = null;
            Vector vector = new Vector();
            try {
                string3 = this.paramString.toUpperCase().trim();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (!this.validateDisDump(string3)) {
                this.forcedEnd = true;
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            string = null;
            if (stringTokenizer.countTokens() != 0) {
                string = stringTokenizer.nextToken();
            }
            if (null != string) {
                vector.add(string);
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
            }
            if (vector.size() == 1) {
                vector.add("256");
            }
            if (vector.size() == 3) {
                string2 = (String)vector.elementAt(2);
            }
            if ('@' == string.charAt(0)) {
                byte[] byArray2;
                String string4 = string.substring(1);
                long l2 = 0L;
                try {
                    l2 = DvUtils.hexToLong(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    this.cpr.output("Invalid Address Specified");
                    this.forcedEnd = true;
                    return;
                }
                dvAddress = this.theDump.getAddressSpaces()[0].createAddress(l2);
                byArray = null;
                if (DvUtils.is64BitSystem(this.theDump.getArchitecture())) {
                    try {
                        byArray = this.theDump.getAddressSpaces()[0].readBytes(dvAddress, 8L);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    if (byArray != null && 8 == byArray.length && !DvUtils.isBigEndian(this.theDump.getArchitecture())) {
                        byArray2 = DvUtils.convertToBigEndian(byArray);
                        string = DvUtils.bytesToHexString(byArray2);
                    }
                } else {
                    try {
                        byArray = this.theDump.getAddressSpaces()[0].readBytes(dvAddress, 4L);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    if (byArray != null && 4 == byArray.length && !DvUtils.isBigEndian(this.theDump.getArchitecture())) {
                        byArray2 = DvUtils.convertToBigEndian(byArray);
                        string = DvUtils.bytesToHexString(byArray2);
                    }
                }
                if (byArray == null) {
                    this.cpr.output("Not a viewable address following @");
                    this.forcedEnd = true;
                    return;
                }
            }
            string = DvUtils.remove0x(string);
            try {
                l = DvUtils.hexToLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.cpr.output("Invalid Address Specified");
                this.forcedEnd = true;
                return;
            }
            try {
                n = new Integer((String)vector.elementAt(1));
            }
            catch (Exception exception) {
                n = new Integer(256);
            }
            dvAddress = this.theDump.getAddressSpaces()[0].createAddress(l);
            byArray = null;
            try {
                byArray = this.theDump.getAddressSpaces()[0].readBytes(dvAddress, (long)n.intValue());
                if (byArray == null) {
                    this.cpr.output("Not a viewable address");
                    this.forcedEnd = true;
                    return;
                }
                if (byArray.length >= n) break block46;
                boolean bl = false;
                int n2 = n - byArray.length;
                while (!bl) {
                    byte[] byArray3 = null;
                    try {
                        byArray3 = this.theDump.getAddressSpaces()[0].readBytes(new DvAddress(l + (long)byArray.length), (long)n2);
                    }
                    catch (DvAddressException dvAddressException) {
                        bl = true;
                    }
                    if (null != byArray3) {
                        byte[] byArray4 = new byte[byArray.length + byArray3.length];
                        int n3 = 0;
                        while (n3 < byArray.length) {
                            byArray4[n3] = byArray[n3];
                            ++n3;
                        }
                        int n4 = 0;
                        while (n4 < byArray3.length) {
                            byArray4[n4 + byArray.length] = byArray3[n4];
                            ++n4;
                        }
                        byArray = byArray4;
                        n2 = n - byArray.length;
                        if (n2 > 0) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
            }
            catch (DvAddressException dvAddressException) {
                // empty catch block
            }
        }
        if (byArray == null) {
            this.cpr.output("Not a viewable address");
            this.forcedEnd = true;
            return;
        }
        DvConsole.setLastDisMem(string, n);
        if (string2 == null) {
            Vector vector = this.formatMemory(l, byArray, 4 == this.theDump.getSystemType());
            if (null != vector) {
                this.cpr.output(vector);
            }
        } else {
            if (string2.equals("I")) {
                int n5 = 0;
                try {
                    n5 = this.theDump.getAddressSpaces()[0].readInt(dvAddress);
                }
                catch (DvAddressException dvAddressException) {
                    // empty catch block
                }
                this.cpr.output(" Memory as Integer: " + n5);
            }
            if (string2.equals("L")) {
                long l3 = 0L;
                try {
                    l3 = this.theDump.getAddressSpaces()[0].readLong(dvAddress);
                }
                catch (DvAddressException dvAddressException) {
                    // empty catch block
                }
                this.cpr.output(" Memory as Long: " + l3);
            }
            if (string2.equals("P")) {
                try {
                    long l4 = true == DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? this.theDump.getAddressSpaces()[0].readLong(dvAddress) : (long)this.theDump.getAddressSpaces()[0].readInt(dvAddress);
                    this.cpr.output(" Memory as Pointer: " + Long.toHexString(l4));
                }
                catch (DvAddressException dvAddressException) {
                    // empty catch block
                }
            }
        }
        this.forcedEnd = true;
        DvUtils.trace(" Exit: displayMemory (" + this.paramString + ")", 0, false);
    }

    public void displayInt() {
        String string = this.paramString;
        this.setParamString(this.paramString + ",4,I");
        this.displayMemory();
        this.setParamString(string);
    }

    public void displayLong() {
        String string = this.paramString;
        this.setParamString(this.paramString + ",8,L");
        this.displayMemory();
        this.setParamString(string);
    }

    public void displayPtr() {
        String string = this.paramString;
        this.setParamString(this.paramString + ",8,P");
        this.displayMemory();
        this.setParamString(string);
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void displayHelp() {
        Vector vector = new Vector();
        String string = null == this.verbModifier ? "GeneralHelp" : this.verbModifier.toUpperCase() + "Help";
        vector.add(DvUtils.getMultiplePropertyValues(string, "DvBaseCommands.properties"));
        if (null == this.verbModifier) {
            vector.add(DvBaseFmtCmds.getGenericHelp());
            vector.add(DvClassCommands.getGenericHelp());
            vector.add(DvObjectsCommands.getGenericHelp());
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void setValue() {
        Vector vector = new Vector();
        if (null == this.paramString) {
            if (null != this.seperator && this.seperator.equals("=")) {
                DvUtils.setValue(this.verbModifier, "");
            } else if (null == this.seperator || this.seperator.equals(" ")) {
                vector.add(" " + this.verbModifier + "=" + DvUtils.getValue(this.verbModifier));
            } else {
                vector.add("\n *** ERROR ***\nInvalid seperator between verb and modifier (" + this.seperator + ")\n" + " *** ERROR ***\n\n");
            }
        } else {
            if (this.verbModifier.toUpperCase().equals("DUMP")) {
                this.setDump(this.paramString, vector);
            }
            if (this.verbModifier.toUpperCase().equals("OUTPUT") || this.verbModifier.toUpperCase().equals("OUT")) {
                this.setOutput(this.paramString);
            }
            if (this.verbModifier.toUpperCase().equals("ERROR") || this.verbModifier.toUpperCase().equals("ERR")) {
                this.setError(this.paramString);
            }
            DvUtils.setValue(this.verbModifier, this.paramString);
            if (this.verbModifier.toUpperCase().equals("FORMATFILE")) {
                DvUtils.loadFormatFile(vector);
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void showSettings() {
        String string = null;
        String string2 = "\nCurrent Settings\n================";
        Enumeration enumeration = DvUtils.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = string2 + "\n" + string + " = " + DvUtils.getValue(string);
        }
        this.cpr.output(string2);
        this.forcedEnd = true;
    }

    public void displayThread() {
        Vector vector = new Vector();
        if (null == this.theDump) {
            vector.add("\nUnable to comply as no dump open yet\n");
        } else {
            String string = DvUtils.getValue("THREAD");
            String string2 = DvUtils.getValue("ASID");
            String string3 = DvUtils.getValue("PID");
            if (null == this.paramString) {
                if (null == string || string.equals("-1") || string.equals("")) {
                    vector.add(" THREAD value not good (use SET THREAD=)");
                } else {
                    this.displayThread(string2, string3, string);
                }
            } else {
                this.displayThread(string2, string3, this.paramString);
            }
        }
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void displayThread(String string, String string2, String string3) {
        Vector vector = new Vector();
        if (!string3.equals("*")) {
            vector.add("\nInfo for thread - " + string3);
            vector.add("==========================");
        }
        if (null == string || null == string2 || string.equals("-1") || string2.equals("-1") || string.equals("") || string2.equals("")) {
            vector.add(" ASID/PID values not good (use SET ASID/PID=)");
        } else {
            DvProcess dvProcess = null;
            DvThread dvThread = null;
            DvAddressSpace dvAddressSpace = DvUtils.findAsid(this.theDump, string);
            if (null != dvAddressSpace && null != (dvProcess = DvUtils.findProc(this.theDump, string2, dvAddressSpace))) {
                if (string3.equals("*")) {
                    DvThread[] dvThreadArray = dvProcess.getThreads();
                    if (null != dvThreadArray) {
                        int n = 0;
                        while (n < dvThreadArray.length) {
                            this.displayThread(string, string2, dvThreadArray[n].id());
                            ++n;
                        }
                    }
                } else {
                    dvThread = DvUtils.findThread(this.theDump, string3, dvAddressSpace, dvProcess);
                    if (null != dvThread) {
                        vector.add("  Id     : " + dvThread.id());
                        vector.add("  ExecEnv: " + dvThread.eeAddress().convertToHex());
                        DvRegister[] dvRegisterArray = null;
                        try {
                            dvRegisterArray = dvThread.getRegisters();
                        }
                        catch (Error error) {
                            // empty catch block
                        }
                        if (null == dvRegisterArray) {
                            vector.add("\n  --- No register data for this thread --- \n");
                        } else {
                            int n = 0;
                            while (n < dvRegisterArray.length) {
                                vector.add(dvRegisterArray[n].getStringValue());
                                ++n;
                            }
                        }
                        byte[] byArray = dvThread.getMetadata();
                        if (null != byArray) {
                            String string4 = new String(byArray);
                            vector.add("\n\tMetadata: " + string4 + "\n");
                        }
                    } else {
                        vector.add(" ASID/PROC/THREAD combination invalid. (" + string + " : " + string2 + " : " + string3 + " )");
                    }
                }
            }
        }
        this.cpr.output(vector);
    }

    private boolean validateDisDump(String string) {
        boolean bl = false;
        if (null == this.theDump) {
            this.cpr.output("Cannot display memory if no dump identified");
        } else if (string == null) {
            this.cpr.output("No parameters passed");
        } else {
            Vector vector = new Vector();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = null;
            if (stringTokenizer.countTokens() != 0) {
                string2 = stringTokenizer.nextToken();
            }
            if (null != string2) {
                vector.add(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
            }
            if (vector.size() < 1 || vector.size() > 3) {
                this.cpr.output("Too few or too many parameters");
            } else if (vector.size() == 3) {
                String string3 = (String)vector.elementAt(2);
                if (string3.toUpperCase().equals("P") || string3.toUpperCase().equals("L") || string3.toUpperCase().equals("I")) {
                    bl = true;
                } else {
                    this.cpr.output("\nLast parameter is not P(ointer),L(ong) or I(nteger)\n");
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private Vector formatMemory(long l, byte[] byArray, boolean bl) {
        DvUtils.trace(" Entry: formatMemory", 0, false);
        boolean bl2 = false;
        boolean bl3 = false;
        String string = DvUtils.getValue("FORMATAS");
        if (null != string) {
            if ((string = string.toUpperCase()).startsWith("E")) {
                bl2 = true;
            }
            if (string.startsWith("A")) {
                bl3 = true;
            }
        }
        String string2 = "| ";
        Vector vector = new Vector();
        String string3 = new String("\n" + Long.toHexString(l) + ": ");
        int n = 120;
        int n2 = Integer.MAX_VALUE;
        boolean bl4 = DvUtils.isConsoleOutput();
        if (bl4) {
            n = DvUtils.getPropertyInt("WIDTH");
            n2 = DvUtils.getPropertyInt("LINES");
        }
        int n3 = 16;
        if (n > 140) {
            n3 = 32;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        while (n6 < byArray.length) {
            n4 = byArray[n6];
            if (n4 < 0) {
                n4 += 256;
            }
            string3 = string3 + DvUtils.byteToHex.substring(2 * n4, 2 * n4 + 2);
            string2 = false == bl && false == bl2 || true == bl3 ? string2 + DvUtils.byteToAscii.substring(n4, n4 + 1) : string2 + DvUtils.byteToEbcdic.substring(n4, n4 + 1);
            if (0 == n7 % 4) {
                string3 = string3 + " ";
            }
            if (n3 == n7) {
                string3 = string3 + string2;
                string2 = "| ";
                n7 = 0;
                vector.add(string3);
                ++n5;
                string3 = new String(Long.toHexString(l += (long)n3) + ": ");
            }
            if (n5 == n2) {
                this.cpr.output(vector);
                n5 = 0;
                vector.clear();
                if (this.forcedEnd) {
                    return null;
                }
            }
            ++n6;
            ++n7;
        }
        if (!vector.isEmpty() && bl4) {
            this.cpr.output(vector);
        }
        DvUtils.trace(" Entry: formatMemory", 0, false);
        if (bl4) {
            return null;
        }
        return vector;
    }

    public void findInMemory() {
        this.findInMemory(false);
    }

    public void findInMemory(boolean bl) {
        long l = 0L;
        long l2 = -1L;
        boolean bl2 = false;
        int n = 256;
        int n2 = 1;
        boolean bl3 = false;
        int n3 = 1;
        boolean bl4 = false;
        Vector vector = new Vector();
        if (null == this.theDump || null == this.verbModifier) {
            bl4 = true;
            if (null == this.theDump) {
                vector.add("\nFind not useful until memory accessed\n");
            } else {
                this.doFindHelp(vector);
            }
        } else {
            int n4;
            int n5;
            int n6;
            int n7;
            boolean bl5 = false;
            if (4 == this.theDump.getSystemType()) {
                bl5 = true;
            }
            DvAddressSpace dvAddressSpace = DvUtils.findAsid(this.theDump, DvUtils.getValue("ASID"));
            String string = null;
            if (null != this.paramString) {
                this.verbModifier = this.verbModifierForFind;
            }
            String string2 = new String(this.verbModifier);
            if (null == this.verbModifier) {
                this.doFindHelp(vector);
            } else if (this.verbModifier.startsWith("\"")) {
                n7 = this.verbModifier.lastIndexOf("\"");
                if (0 == n7) {
                    vector.add("\nInvalid command structure: missing end quote\n");
                    bl4 = true;
                } else {
                    if (n7 + 1 != this.verbModifier.length()) {
                        string = string2.substring(n7 + 1);
                    }
                    string2 = string2.substring(1, n7);
                }
            } else {
                n7 = this.verbModifier.indexOf(",");
                if (-1 != n7) {
                    string = string2.substring(n7);
                    string2 = string2.substring(0, n7);
                }
            }
            if (!bl4 && string2.toUpperCase().startsWith("0X")) {
                if (2 < string2.length()) {
                    bl3 = true;
                    string2 = DvUtils.remove0x(string2);
                    string2.trim();
                    if (1 == string2.length() % 2) {
                        string2 = "0" + string2;
                    }
                    n7 = 0;
                    while (n7 < string2.length()) {
                        n6 = DvUtils.hexValue(string2.charAt(n7));
                        if (n6 == -1) {
                            bl4 = true;
                        }
                        ++n7;
                    }
                    if (bl4) {
                        vector.add("\nInvalid hex value: 0x" + string2 + "\n");
                    }
                } else {
                    vector.add("\nInvalid command structure:" + string2 + "\n");
                    bl4 = true;
                }
            }
            if (!bl4 && bl) {
                bl3 = true;
                n7 = 0;
                while (n7 < string2.length()) {
                    n6 = DvUtils.hexValue(string2.charAt(n7));
                    if (n6 == -1) {
                        bl4 = true;
                    }
                    ++n7;
                }
                if (bl4) {
                    vector.add("\nInvalid hex value: 0x" + string2 + "\n");
                }
            }
            if (!bl4 && bl) {
                int n8;
                n7 = DvUtils.is64BitSystem(this.theDump.getArchitecture()) ? 1 : 0;
                n6 = DvUtils.isBigEndian(this.theDump.getArchitecture());
                n5 = string2.length();
                if (n7 != 0) {
                    if (n5 > 16) {
                        bl4 = true;
                    }
                    if (n5 < 16) {
                        n8 = 0;
                        while (n8 < 16 - n5) {
                            string2 = "0" + string2;
                            ++n8;
                        }
                    }
                } else {
                    if (n5 > 8) {
                        bl4 = true;
                    }
                    if (n5 < 8) {
                        n8 = 0;
                        while (n8 < 8 - n5) {
                            string2 = "0" + string2;
                            ++n8;
                        }
                    }
                }
                if (bl4) {
                    vector.add("\nAddress is too long: " + string2 + "\n");
                }
                if (!bl4 && 0 == n6) {
                    if (n7 != 0) {
                        String[] stringArray = new String[8];
                        n4 = 0;
                        while (n4 < 8) {
                            stringArray[n4] = string2.substring(n4 * 2, (n4 + 1) * 2);
                            ++n4;
                        }
                        string2 = stringArray[7] + stringArray[6] + stringArray[5] + stringArray[4] + stringArray[3] + stringArray[2] + stringArray[1] + stringArray[0];
                    } else {
                        String[] stringArray = new String[4];
                        n4 = 0;
                        while (n4 < 4) {
                            stringArray[n4] = string2.substring(n4 * 2, (n4 + 1) * 2);
                            ++n4;
                        }
                        string2 = stringArray[3] + stringArray[2] + stringArray[1] + stringArray[0];
                    }
                }
            }
            Vector vector2 = new Vector();
            if (!bl4 && null != string) {
                n6 = 0;
                while (0 == n6) {
                    n5 = string.indexOf(",,");
                    if (-1 == n5) {
                        n6 = 1;
                        continue;
                    }
                    string = string.substring(0, n5 + 1) + " " + string.substring(n5 + 1);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n9 = stringTokenizer.countTokens();
                if (0 != n9) {
                    n4 = 0;
                    while (n4 < n9) {
                        vector2.add(stringTokenizer.nextToken().trim());
                        ++n4;
                    }
                }
                if (n9 > 5) {
                    vector.add("\nInvalid command structure: too many parameters\n");
                    bl4 = true;
                }
            }
            if (!bl4 && 0 != vector2.size()) {
                String string3;
                String string4;
                String string5;
                String string6;
                String string7 = (String)vector2.get(0);
                if (0 != string7.length()) {
                    try {
                        l = DvUtils.hexToLong(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + string7);
                    }
                }
                if (1 < vector2.size() && 0 != (string6 = (String)vector2.get(1)).length()) {
                    try {
                        l2 = DvUtils.hexToLong(string6);
                        DvAddress dvAddress = dvAddressSpace.createAddress(l);
                        DvAddress dvAddress2 = dvAddressSpace.createAddress(l2);
                        if (1 == dvAddress2.compare(dvAddress)) {
                            bl4 = true;
                            vector.add("End address:" + string6 + " is lower than start address:" + string7);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + string6);
                    }
                }
                if (2 < vector2.size() && (string5 = (String)vector2.get(2)).length() != 0) {
                    try {
                        n2 = Integer.parseInt(string5);
                        if (1 > n2 || 256 < n2) {
                            bl4 = true;
                            vector.add("Invalid boundary parameter (between 1 and 256 are valid) :" + string5);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid boundary parameter:" + string5);
                    }
                }
                if (3 < vector2.size() && (string4 = (String)vector2.get(3)).length() != 0) {
                    try {
                        n = Integer.parseInt(string4);
                        if (16 > n) {
                            bl4 = true;
                            vector.add("Invalid print length parameter (less than 16) :" + string4);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid print length parameter:" + string4);
                    }
                }
                if (4 < vector2.size() && (string3 = (String)vector2.get(4)).length() != 0) {
                    try {
                        n3 = Integer.parseInt(string3);
                        if (n3 > 100 || n3 < 1) {
                            bl4 = true;
                            vector.add("Invalid find limit (>100 or <1) :" + string3);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid find limit:" + string3);
                    }
                }
            }
            if (!bl4) {
                Object object;
                byte[] byArray;
                if (bl3) {
                    byArray = new byte[string2.length() / 2];
                    n5 = 0;
                    while (n5 < byArray.length) {
                        String string8 = string2.substring(n5 * 2, n5 * 2 + 2);
                        int n10 = Integer.parseInt(string8, 16);
                        if (n10 > 127) {
                            n10 -= 256;
                        }
                        string8 = String.valueOf(n10);
                        byArray[n5] = Byte.parseByte(string8);
                        ++n5;
                    }
                } else {
                    byArray = new byte[string2.length()];
                    n5 = 0;
                    boolean bl6 = false;
                    String string9 = DvUtils.getValue("FORMATAS");
                    if (null != string9) {
                        if ((string9 = string9.toUpperCase()).startsWith("E")) {
                            n5 = 1;
                        }
                        if (string9.startsWith("A")) {
                            bl6 = true;
                        }
                    }
                    if (bl5 && !bl6 || 1 == n5) {
                        try {
                            byArray = string2.getBytes("Cp1047");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            DvUtils.trace("Its an unsuported encodingCp1047", 0, true);
                        }
                    } else {
                        byArray = string2.getBytes();
                    }
                }
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                DvAddress dvAddress3 = dvAddressSpace.createAddress(l2);
                Vector vector3 = DvUtils.findInMemory(this.theDump, byArray, dvAddress, dvAddress3, n2, n3, bl2);
                if (vector3.size() == n3) {
                    vector.add("  Note: your search result limit was " + n3 + " ... there may be more results\n");
                }
                if (1 < vector3.size()) {
                    int n11 = 0;
                    while (n11 < vector3.size()) {
                        object = (DvAddress)vector3.elementAt(n11);
                        vector.add("#" + n11 + ": " + ((DvAddress)object).convertToHex());
                        ++n11;
                    }
                }
                if (0 != vector3.size()) {
                    DvAddress dvAddress4 = (DvAddress)vector3.elementAt(0);
                    object = string2;
                    if (bl3) {
                        object = "0x" + (String)object;
                    }
                    DvAddress dvAddress5 = dvAddressSpace.createAddress(dvAddress4.getAddressAsLong());
                    try {
                        dvAddress5.offsetBy(n2);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    object = (String)object + "," + dvAddress5.convertToHex() + ",";
                    object = (String)object + dvAddress3.convertToHex() + "," + n2 + ",";
                    object = (String)object + n + ",1";
                    DvUtils.setValue("FINDNEXT", (String)object);
                    byte[] byArray2 = null;
                    try {
                        byArray2 = dvAddressSpace.readBytes(dvAddress4, (long)n);
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    Vector vector4 = this.formatMemory(dvAddress4.getAddressAsLong(), byArray2, bl5);
                    if (null != vector4) {
                        vector.add(vector4);
                    }
                    vector.add("  Tip: Use FINDNEXT (FN) command to progress through them\n");
                } else {
                    vector.add(" \n No occurrence of search string found.");
                    vector.add(" \n Note: Check case. \"SET FORMATAS=A\" can be used to");
                    vector.add("  force ASCII search on EBCDIC dump (and vice versa)");
                }
                vector.add(" Find finished...\n");
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void doFindHelp(Vector vector) {
        Vector vector2 = DvUtils.getMultiplePropertyValues("FINDHelp", "DvBaseCommands.properties");
        if (vector2.size() != 0) {
            vector.add(vector2);
        }
    }

    public void findNext() {
        String string;
        this.verbModifier = string = DvUtils.getValue("FINDNEXT");
        this.verbModifierForFind = string;
        this.findInMemory();
    }

    public void findPointer() {
        this.findInMemory(true);
    }

    public void reset() {
        prevVerb = null;
        prevModifier = null;
        prevParms = null;
        prevSeperator = null;
    }

    public void whatIs() {
        Vector vector = new Vector();
        DvAddress dvAddress = null;
        if (null == this.verbModifier) {
            Vector vector2 = DvUtils.getMultiplePropertyValues("WhatIs", "DvBaseCommands.properties");
            vector.add(vector2);
        } else {
            String string = this.verbModifier.toUpperCase();
            boolean bl = false;
            long l = 0L;
            if (this.verbModifier.toUpperCase().startsWith("0X")) {
                string = DvUtils.remove0x(string);
            }
            try {
                l = Long.parseLong(string, 16);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bl) {
                vector.add(" Its an address");
                dvAddress = new DvAddress(l);
            }
            Vector vector3 = DvConsole.getCommandPluginVector();
            int n = 0;
            while (n < vector3.size()) {
                CommandPlugin commandPlugin = (CommandPlugin)vector3.get(n);
                String string2 = commandPlugin.whatIs(dvAddress, this.verbModifier, this.theDump);
                if (null != string2) {
                    vector.add(string2);
                }
                ++n;
            }
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        String string2 = null;
        if (null != dvAddress) {
            if (dvDump != null) {
                DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    DvModule[] dvModuleArray;
                    DvLoaded dvLoaded;
                    string2 = " Address \"" + string + "\" is present in this dump";
                    DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
                    if (null != dvProcess && null != (dvLoaded = dvProcess.getLoaded()) && null != (dvModuleArray = dvLoaded.getModules())) {
                        long l = dvAddress.getAddressAsLong();
                        int n = 0;
                        while (n < dvModuleArray.length) {
                            long l2 = dvModuleArray[n].address().getAddressAsLong();
                            long l3 = dvModuleArray[n].size();
                            if (l >= l2 && l <= l2 + l3) {
                                string2 = string2 + "\n\tand is offset 0x" + Long.toHexString(l - l2) + " within module " + dvModuleArray[n].name();
                                n = dvModuleArray.length;
                            }
                            ++n;
                        }
                    }
                } else {
                    string2 = " Address \"" + string + "\" is not an address present in this dump";
                }
            } else {
                string2 = " Cannot check address \"" + string + "\" as no dump identified yet";
            }
        } else {
            string2 = " Its a key - unimplemented function ";
        }
        return string2;
    }
}

