/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DvMemoryScroller
implements ActionListener {
    long current;
    Dvifm theIFM = DvUtils.getTheIFM();
    JInternalFrame jif;
    DvConsole dvConsole;
    DvAddress currentAddr;
    long startMemoryAddr;
    long memorySize;
    JTextArea jtext;
    JTextField jtext1;
    String memoryAsString;
    Font thisFont;
    JPanel panel;
    JPanel upButtonPanel;
    JPanel downButtonPanel;
    JButton oneLineUpBtn;
    JButton halfPageUpBtn;
    JButton onePageUpBtn;
    JButton oneLineDownBtn;
    JButton halfPageDownBtn;
    JButton onePageDownBtn;
    JButton goButton;
    public static final int ONE_LINE = 16;
    public static final int HALF_PAGE = 128;
    public static final int ONE_PAGE = 256;

    public DvMemoryScroller(JInternalFrame jInternalFrame, DvConsole dvConsole) {
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.startMemoryAddr = 0L;
        this.currentAddr = new DvAddress(0L);
        this.memorySize = 512L;
        this.constructWindow(this.startMemoryAddr);
        if (this.getMemoryDetails(this.currentAddr)) {
            this.displayMemory();
        } else {
            DvUtils.writetoTrace(" Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
            this.jtext1.setText("Enter address");
        }
    }

    public DvMemoryScroller(JInternalFrame jInternalFrame, DvConsole dvConsole, DvAddress dvAddress, long l) {
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.currentAddr = dvAddress;
        this.startMemoryAddr = dvAddress.getAddressAsLong();
        this.memorySize = l;
        this.constructWindow(this.startMemoryAddr);
        if (this.getMemoryDetails(this.currentAddr)) {
            this.displayMemory();
        } else {
            DvUtils.writetoTrace(" Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
        }
    }

    private void constructWindow(long l) {
        this.thisFont = new Font("Monospaced", 0, 12);
        this.jtext = new JTextArea("", 8, 25);
        this.jtext.setEditable(false);
        this.jtext.setFont(this.thisFont);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.theIFM.addContentToFrame(this.jif, this.jtext, this.panel);
        this.upButtonPanel = new JPanel();
        this.downButtonPanel = new JPanel();
        JPanel jPanel = new JPanel();
        this.jtext1 = new JTextField(Long.toHexString(l), 16);
        this.jtext1.setFont(this.thisFont);
        this.goButton = new JButton("GO!");
        this.goButton.setToolTipText("Press this to go to address specified.");
        this.oneLineUpBtn = new JButton("<");
        this.halfPageUpBtn = new JButton("<<");
        this.onePageUpBtn = new JButton("<<<");
        this.oneLineDownBtn = new JButton(">");
        this.halfPageDownBtn = new JButton(">>");
        this.onePageDownBtn = new JButton(">>>");
        this.oneLineUpBtn.setToolTipText("Click to move one line back in memory.");
        this.halfPageUpBtn.setToolTipText("Click to move half a page back in memory.");
        this.onePageUpBtn.setToolTipText("Click to move one page back in memory.");
        this.oneLineDownBtn.setToolTipText("Click to move one line forward in memory.");
        this.halfPageDownBtn.setToolTipText("Click to move half a page forward in memory.");
        this.onePageDownBtn.setToolTipText("Click to move one a page forward in memory.");
        this.oneLineUpBtn.addActionListener(this);
        this.halfPageUpBtn.addActionListener(this);
        this.onePageUpBtn.addActionListener(this);
        this.oneLineDownBtn.addActionListener(this);
        this.halfPageDownBtn.addActionListener(this);
        this.onePageDownBtn.addActionListener(this);
        this.upButtonPanel.add(this.oneLineUpBtn);
        this.upButtonPanel.add(this.halfPageUpBtn);
        this.upButtonPanel.add(this.onePageUpBtn);
        this.downButtonPanel.add(this.onePageDownBtn);
        this.downButtonPanel.add(this.halfPageDownBtn);
        this.downButtonPanel.add(this.oneLineDownBtn);
        jPanel.add(this.jtext1);
        jPanel.add(this.goButton);
        this.goButton.addActionListener(this);
        this.panel.add((Component)this.upButtonPanel, "West");
        this.panel.add((Component)this.downButtonPanel, "East");
        this.panel.add((Component)jPanel, "South");
    }

    private boolean getMemoryDetails(DvAddress dvAddress) {
        boolean bl = true;
        this.memoryAsString = "";
        String string = "DIS MEM(" + dvAddress.convertToHex() + "," + 256 + ")";
        Dumpviewer.waitingOnConsoleCommand = true;
        DvUtils.writetoTrace("Command issued: " + string);
        this.dvConsole.execValidCommand(string);
        while (Dumpviewer.waitingOnConsoleCommand) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        Vector vector = null;
        try {
            vector = (Vector)Dumpviewer.savedConsoleOutput;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (null != vector) {
            int n = 0;
            while (n < vector.size()) {
                this.memoryAsString = this.memoryAsString + vector.get(n) + "\n";
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer(this.memoryAsString);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.deleteCharAt(0);
            this.memoryAsString = stringBuffer.toString();
        } else {
            bl = false;
        }
        return bl;
    }

    private void displayMemory() {
        String string = "Memory Scroller " + this.currentAddr.convertToHex();
        DvUtils.writetoTrace(" Into displayMemory (" + string + ")");
        this.jif.setTitle(string);
        this.jtext.setText(this.memoryAsString);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        long l = 0L;
        boolean bl = false;
        if (actionEvent.getSource() == this.oneLineUpBtn) {
            DvUtils.writetoTrace("OneLineUpBtn pressed in Memory Scroller");
            l -= 16L;
        } else if (actionEvent.getSource() == this.halfPageUpBtn) {
            DvUtils.writetoTrace("halfPageUpBtn pressed in Memory Scroller");
            l -= 128L;
        } else if (actionEvent.getSource() == this.onePageUpBtn) {
            DvUtils.writetoTrace("onePageUpBtn pressed in Memory Scroller");
            l -= 256L;
        } else if (actionEvent.getSource() == this.oneLineDownBtn) {
            DvUtils.writetoTrace("oneLineDownBtn pressed in Memory Scroller");
            l += 16L;
        } else if (actionEvent.getSource() == this.halfPageDownBtn) {
            DvUtils.writetoTrace("halfPageDownBtn pressed in Memory Scroller");
            l += 128L;
        } else if (actionEvent.getSource() == this.onePageDownBtn) {
            DvUtils.writetoTrace("onePageDownBtn pressed in Memory Scroller");
            l += 256L;
        } else if (actionEvent.getSource() == this.goButton) {
            DvUtils.writetoTrace("goButton pressed in Memory Scroller (" + this.jtext1.getText());
            string = this.jtext1.getText();
            DvUtils.writetoTrace("goButton pressed in Memory Scroller (" + string + ")");
            bl = true;
            l = 256L;
        } else {
            DvUtils.writetoTrace("Non Button action in Memory Scroller");
            return;
        }
        if (!bl) {
            long l2 = this.currentAddr.getAddressAsLong();
            long l3 = l2 + l;
            try {
                this.currentAddr.offsetBy(l);
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace("Address out of Range");
            }
            DvUtils.writetoTrace("Memory Start = " + this.currentAddr.convertToHex());
            if (this.getMemoryDetails(this.currentAddr)) {
                this.displayMemory();
            } else {
                DvUtils.writetoTrace(" Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
                try {
                    this.currentAddr.offsetBy(-l);
                }
                catch (DvAddressException dvAddressException) {}
            }
        } else {
            string = this.jtext1.getText();
            try {
                string = DvUtils.remove0x(string);
                long l4 = Long.parseLong(string, 16);
                DvAddress dvAddress = new DvAddress(l4);
                if (this.getMemoryDetails(dvAddress)) {
                    this.currentAddr = dvAddress;
                    this.startMemoryAddr = l4;
                    this.displayMemory();
                } else {
                    DvUtils.writetoTrace(" Unable to getMemoryDetails for 0x" + Long.toHexString(this.currentAddr.getAddressAsLong()));
                    this.jtext1.setText("ERROR:" + string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.jtext1.setText("ERROR:" + string);
                long l5 = this.currentAddr.getAddressAsLong();
            }
        }
    }
}

